/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.ui.client.showcase.cases;

import java.util.ArrayList;
import java.util.List;

import org.exoplatform.gwtframework.ui.client.ShowCaseImageBundle;
import org.exoplatform.gwtframework.ui.client.component.command.Control;
import org.exoplatform.gwtframework.ui.client.component.command.LoaderControl;
import org.exoplatform.gwtframework.ui.client.component.command.StatusTextControl;
import org.exoplatform.gwtframework.ui.client.component.command.builder.StatusTextCommandBuilder;
import org.exoplatform.gwtframework.ui.client.component.statusbar.GWTStatusBarForm;
import org.exoplatform.gwtframework.ui.client.component.statusbar.event.UpdateStatusBarEvent;
import org.exoplatform.gwtframework.ui.client.showcase.cases.toolbar_text_input.event.TestLoaderClickedEvent;
import org.exoplatform.gwtframework.ui.client.showcase.cases.toolbar_text_input.event.TestLoaderClickedHandler;
import org.exoplatform.gwtframework.ui.client.showcase.event.ShowcaseEvent;
import org.exoplatform.gwtframework.ui.client.showcase.event.ShowcaseHandler;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.VerticalPanel;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class StatusBarCase extends Composite implements TestLoaderClickedHandler, ShowcaseHandler
{

   private FlowPanel panel;

   private HandlerManager eventBus = new HandlerManager(null);

   private Grid grid;

   public StatusBarCase()
   {
      panel = new FlowPanel();
      initWidget(panel);

      DOM.setStyleAttribute(panel.getElement(), "background", "#FFFFFF");
      DOM.setStyleAttribute(panel.getElement(), "width", "100%");
      DOM.setStyleAttribute(panel.getElement(), "height", "100%");

      grid = new Grid(2, 1);
      grid.setCellPadding(0);
      grid.setCellSpacing(0);
      grid.setBorderWidth(0);

      DOM.setStyleAttribute(grid.getElement(), "borderCollapse", "collapse");

      DOM.setStyleAttribute(grid.getElement(), "width", "100%");
      DOM.setStyleAttribute(grid.getElement(), "height", "100%");

      grid.setHTML(0, 0, "Some content");
      DOM.setStyleAttribute(grid.getCellFormatter().getElement(0, 0), "textAlign", "center");

      GWTStatusBarForm statusBar = new GWTStatusBarForm(eventBus);
      grid.setWidget(1, 0, statusBar);
      DOM.setStyleAttribute(grid.getRowFormatter().getElement(1), "height", "30px");

      panel.add(grid);

      updateStatusBar();
      createButtons();

   }

   private LoaderControl loader;

   private List<Control> commands;

   private List<String> statusBarItems;

   private StatusTextControl statusTextCommand;

   private void createLoaderControl()
   {
      loader = new LoaderControl("loader1");
      loader.setPrompt("Simple Loader");

      //loader.setIcon(ShowCaseImages.OK);

      loader.setNormalImage(ShowCaseImageBundle.INSTANCE.ok());
      loader.setDisabledImage(ShowCaseImageBundle.INSTANCE.okDisabled());

      loader.setVisible(true);
      loader.setEnabled(true);
      loader.setEvent(new TestLoaderClickedEvent());
   }

   private void updateStatusBar()
   {
      statusTextCommand = StatusTextCommandBuilder.newCommand("status1").show().text("simple text")
         .event(new ShowcaseEvent("statusControl"))
         .fireEventOnSingleClick(false).create();

      createLoaderControl();

      commands = new ArrayList<Control>();
      commands.add(statusTextCommand);
      commands.add(loader);

      statusBarItems = new ArrayList<String>();
      statusBarItems.add(statusTextCommand.getId());
      statusBarItems.add(loader.getId());

      eventBus.fireEvent(new UpdateStatusBarEvent(statusBarItems, commands));
      eventBus.addHandler(TestLoaderClickedEvent.TYPE, this);
      eventBus.addHandler(ShowcaseEvent.TYPE, this);
   }

   private Button showHideButton;

   private Button addRemoveButton;

   private Button changeIconButton;

   private Button changeStatusButton;

   private CheckBox fireEventCheckBox;

   private CheckBox clickStatusBox;

   private void createButtons()
   {
      Grid buttonsGrid = new Grid(1, 2);
      DOM.setStyleAttribute(buttonsGrid.getElement(), "width", "100%");

      DOM.setStyleAttribute(buttonsGrid.getCellFormatter().getElement(0, 0), "width", "50%");
      DOM.setStyleAttribute(buttonsGrid.getCellFormatter().getElement(0, 1), "width", "50%");

      VerticalPanel statusControlPanel = new VerticalPanel();

      fireEventCheckBox = new CheckBox("Event enabled");
      fireEventCheckBox.setValue(true);
      statusControlPanel.add(fireEventCheckBox);
      fireEventCheckBox.addClickHandler(new ClickHandler()
      {
         public void onClick(ClickEvent event)
         {
            if (fireEventCheckBox.getValue())
            {
               statusTextCommand.setEvent(new ShowcaseEvent("statusControl"));
            }
            else
            {
               statusTextCommand.setEvent(null);
            }
         }
      });

      clickStatusBox = new CheckBox("Fire event on single click");
      statusControlPanel.add(clickStatusBox);
      clickStatusBox.addClickHandler(new ClickHandler()
      {
         public void onClick(ClickEvent event)
         {
            statusTextCommand.setFireEventOnSingleClick(clickStatusBox.getValue());
         }
      });

      buttonsGrid.setWidget(0, 0, statusControlPanel);

      VerticalPanel buttonsPanel = new VerticalPanel();

      addRemoveButton = new Button("Remove");
      addRemoveButton.setWidth("150px");
      addRemoveButton.addClickHandler(addRemoveButtonClickHandler);

      showHideButton = new Button("Hide");
      showHideButton.setWidth("150px");
      showHideButton.addClickHandler(showHideButtonClickHandler);

      changeIconButton = new Button("Change icon");
      changeIconButton.addClickHandler(changeIconButtonClickHandler);

      changeStatusButton = new Button("Change Status");
      changeStatusButton.addClickHandler(changeStatusButtonClickHandler);

      buttonsPanel.add(addRemoveButton);
      buttonsPanel.add(new HTML("<br>"));
      buttonsPanel.add(showHideButton);
      buttonsPanel.add(new HTML("<br>"));
      buttonsPanel.add(changeIconButton);
      buttonsPanel.add(new HTML("<br>"));
      buttonsPanel.add(changeStatusButton);

      buttonsGrid.setWidget(0, 1, buttonsPanel);

      grid.setWidget(0, 0, buttonsGrid);
   }

   private ClickHandler addRemoveButtonClickHandler = new ClickHandler()
   {
      public void onClick(ClickEvent arg0)
      {
         if (loader != null)
         {
            commands.remove(loader);
            statusBarItems.remove(loader.getId());
            addRemoveButton.setText("Add");
            addRemoveButton.setWidth("150px");
            loader = null;

            eventBus.fireEvent(new UpdateStatusBarEvent(statusBarItems, commands));

            showHideButton.setText("Hide");
            showHideButton.setWidth("150px");
         }
         else
         {
            createLoaderControl();

            commands.add(loader);
            statusBarItems.add(loader.getId());
            addRemoveButton.setText("Remove");
            addRemoveButton.setWidth("150px");

            eventBus.fireEvent(new UpdateStatusBarEvent(statusBarItems, commands));
         }
      }
   };

   private ClickHandler showHideButtonClickHandler = new ClickHandler()
   {
      public void onClick(ClickEvent arg0)
      {
         if (loader == null)
         {
            return;
         }

         if (loader.isVisible())
         {
            loader.setVisible(false);
            showHideButton.setText("Show");
            showHideButton.setWidth("150px");
         }
         else
         {
            loader.setVisible(true);
            showHideButton.setText("Hide");
            showHideButton.setWidth("150px");
         }
      }
   };

   private ClickHandler changeIconButtonClickHandler = new ClickHandler()
   {
      public void onClick(ClickEvent arg0)
      {
         if (loader == null)
         {
            return;
         }

         if (loader.getNormalImage() == null || loader.getNormalImage() == ShowCaseImageBundle.INSTANCE.ok())
         {
            loader.setImages(ShowCaseImageBundle.INSTANCE.cancel(), ShowCaseImageBundle.INSTANCE.cancelDisabled());
            //loader.setIcon(ShowCaseImages.CANCEL);
         }
         else
         {
            //loader.setIcon(ShowCaseImages.OK);
            loader.setImages(ShowCaseImageBundle.INSTANCE.ok(), ShowCaseImageBundle.INSTANCE.okDisabled());
         }

      }
   };

   private ClickHandler changeStatusButtonClickHandler = new ClickHandler()
   {
      public void onClick(ClickEvent arg0)
      {
         if (statusTextCommand.getText().equals("simple text"))
         {
            statusTextCommand.setText("--------------------------------------");
         }
         else
         {
            statusTextCommand.setText("simple text");
         }
      }
   };

   public void onTestLoaderClicked(TestLoaderClickedEvent event)
   {
      Window.alert("Loader button clicked!");
   }

   public void onShowcaseEvent(ShowcaseEvent event)
   {
      Window.alert("Status text clicked!");
   }

}
