/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.ui.client.showcase.cases.toolbar;

import java.util.ArrayList;
import java.util.List;

import org.exoplatform.gwtframework.commons.component.Handlers;
import org.exoplatform.gwtframework.ui.client.ShowCaseImageBundle;
import org.exoplatform.gwtframework.ui.client.component.command.Control;
import org.exoplatform.gwtframework.ui.client.component.command.SimpleControl;
import org.exoplatform.gwtframework.ui.client.component.command.builder.SimpleCommandBuilder;
import org.exoplatform.gwtframework.ui.client.component.toolbar.GWTToolbarForm;
import org.exoplatform.gwtframework.ui.client.component.toolbar.ToolbarItemType;
import org.exoplatform.gwtframework.ui.client.component.toolbar.event.UpdateToolbarEvent;
import org.exoplatform.gwtframework.ui.client.showcase.ShowCaseImages;
import org.exoplatform.gwtframework.ui.client.showcase.event.ShowcaseEvent;
import org.exoplatform.gwtframework.ui.client.showcase.event.ShowcaseHandler;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Grid;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class ToolbarButtonsCase extends Composite implements ShowcaseHandler
{

   private FlowPanel panel;

   private HandlerManager eventBus;

   private Handlers handlers;

   private GWTToolbarForm toolbar;

   private SimpleControl showHidePopupButtonCommand1;

   private SimpleControl searchButtonControl;

   private SimpleControl enableDisableToolbarButtonCommand1;
   
   private SimpleControl changeImageButton;

   private CheckBox selectDeselectCheckBox;

   public ToolbarButtonsCase()
   {
      panel = new FlowPanel();
      initWidget(panel);

      DOM.setStyleAttribute(panel.getElement(), "border", "#aaaaaa 1px solid");

      DOM.setStyleAttribute(panel.getElement(), "background", "#efefef");
      DOM.setStyleAttribute(panel.getElement(), "width", "100%");
      DOM.setStyleAttribute(panel.getElement(), "height", "100%");

      eventBus = new HandlerManager(null);
      handlers = new Handlers(eventBus);
      handlers.addHandler(ShowcaseEvent.TYPE, this);

      createButtons();

      createToolbar();

      Grid grid = new Grid(1, 1);
      grid.setWidth("100%");
      panel.add(grid);

      selectDeselectCheckBox = new CheckBox("Search Selected");
      selectDeselectCheckBox.setValue(false);
      grid.setWidget(0, 0, selectDeselectCheckBox);

      selectDeselectCheckBox.addClickHandler(new ClickHandler()
      {
         public void onClick(ClickEvent arg0)
         {
            changeButtonSelection();
         }
      });
   }
   
   private void createButtons()
   {
      enableDisableToolbarButtonCommand1 =
         SimpleCommandBuilder.newCommand("enabledisable1").title("Disable Search Button").prompt(
            "Disable Search Button").images(ShowCaseImageBundle.INSTANCE.cancel(),
            ShowCaseImageBundle.INSTANCE.cancelDisabled()).enable().show().event(new ShowcaseEvent("enable/disable"))
            .create();

      showHidePopupButtonCommand1 =
         SimpleCommandBuilder.newCommand("showhide1").title("Hide Search Button").prompt("Hide Search Button").images(
            ShowCaseImageBundle.INSTANCE.remove(), ShowCaseImageBundle.INSTANCE.removeDisabled()).enable().show()
            .event(new ShowcaseEvent("show/hide")).create();

      searchButtonControl =
         SimpleCommandBuilder.newCommand("button1").title("Button").prompt("Button").images(
            ShowCaseImageBundle.INSTANCE.search(), ShowCaseImageBundle.INSTANCE.searchDisabled()).enable().show()
            .event(new ShowcaseEvent("search")).create();
      searchButtonControl.setCanBeSelected(true);
      
      changeImageButton = new SimpleControl("changeImage");
      changeImageButton.setPrompt("Change Icon");
      changeImageButton.setEnabled(true);
      changeImageButton.setVisible(true);
      changeImageButton.setIcon(ShowCaseImages.OK);
      changeImageButton.setEvent(new ShowcaseEvent("set_cancel_icon"));
   }

   private void createToolbar()
   {
      toolbar = new GWTToolbarForm(eventBus);
      panel.add(toolbar);

      List<Control> commands = new ArrayList<Control>();
      commands.add(showHidePopupButtonCommand1);
      commands.add(searchButtonControl);
      commands.add(enableDisableToolbarButtonCommand1);
      commands.add(changeImageButton);

      List<String> toolbarItems = new ArrayList<String>();
      toolbarItems.add(enableDisableToolbarButtonCommand1.getId());
      toolbarItems.add(showHidePopupButtonCommand1.getId());
      toolbarItems.add(ToolbarItemType.DELIMITER);
      toolbarItems.add(searchButtonControl.getId());

      toolbarItems.add(ToolbarItemType.SPACER);
      
      toolbarItems.add(changeImageButton.getId());

      eventBus.fireEvent(new UpdateToolbarEvent(toolbarItems, commands));
   }

   public void onShowcaseEvent(ShowcaseEvent event)
   {
      if (!(event.getObject() instanceof String))
      {
         return;
      }

      String value = (String)event.getObject();

      if ("enable/disable".equals(value))
      {
         if (searchButtonControl.isEnabled())
         {
            searchButtonControl.setEnabled(false);
            enableDisableToolbarButtonCommand1.setImages(ShowCaseImageBundle.INSTANCE.ok(),
               ShowCaseImageBundle.INSTANCE.okDisabled());
            enableDisableToolbarButtonCommand1.setPrompt("Enable Search Button");
         }
         else
         {
            searchButtonControl.setEnabled(true);
            enableDisableToolbarButtonCommand1.setImages(ShowCaseImageBundle.INSTANCE.cancel(),
               ShowCaseImageBundle.INSTANCE.cancel());
            enableDisableToolbarButtonCommand1.setPrompt("Disable Search Button");
         }

         return;
      }

      if ("show/hide".equals(value))
      {
         if (searchButtonControl.isVisible())
         {
            searchButtonControl.setVisible(false);
            showHidePopupButtonCommand1.setImages(ShowCaseImageBundle.INSTANCE.add(), ShowCaseImageBundle.INSTANCE
               .addDisabled());
            showHidePopupButtonCommand1.setPrompt("Show Search Button");
         }
         else
         {
            searchButtonControl.setVisible(true);
            showHidePopupButtonCommand1.setImages(ShowCaseImageBundle.INSTANCE.remove(), ShowCaseImageBundle.INSTANCE
               .removeDisabled());
            showHidePopupButtonCommand1.setPrompt("Hide Search Button");
         }
         return;
      }

      if ("search".equals(value))
      {
         selectDeselectCheckBox.setValue(searchButtonControl.isSelected());
         return;
      }
      
      if ("set_cancel_icon".equals(value))
      {
         changeImageButton.setIcon(ShowCaseImages.CANCEL);
         changeImageButton.setEvent(new ShowcaseEvent("set_ok_icon"));
         return;
      }

      if ("set_ok_icon".equals(value))
      {
         changeImageButton.setIcon(ShowCaseImages.OK);
         changeImageButton.setEvent(new ShowcaseEvent("set_cancel_icon"));
         return;
      }

   }

   protected void changeButtonSelection()
   {
      searchButtonControl.setSelected(selectDeselectCheckBox.getValue());
   }

}
