/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */

package org.exoplatform.gwtframework.ui.client.smartgwt.component;

import org.exoplatform.gwtframework.ui.client.api.TreeGridItem;
import org.exoplatform.gwtframework.ui.client.smartgwt.component.data.FolderOpenedHandlerImpl;
import org.exoplatform.gwtframework.ui.client.smartgwt.component.data.SelectionHandlerImpl;
import org.exoplatform.gwtframework.ui.client.smartgwt.component.event.ClickHandlerImpl;
import org.exoplatform.gwtframework.ui.client.smartgwt.component.event.DoubleClickHandlerImpl;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.DoubleClickHandler;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public abstract class TreeGrid<T> extends com.smartgwt.client.widgets.tree.TreeGrid implements TreeGridItem<T>
{

   private String valuePropertyName = getClass().getName();

   /* (non-Javadoc)
    * @see com.smartgwt.client.widgets.Canvas#addClickHandler(com.smartgwt.client.widgets.events.ClickHandler)
    */
   public HandlerRegistration addClickHandler(ClickHandler clickHandler)
   {
      return super.addClickHandler(new ClickHandlerImpl(clickHandler));
   }

   /* (non-Javadoc)
    * @see com.smartgwt.client.widgets.Canvas#addDoubleClickHandler(com.smartgwt.client.widgets.events.DoubleClickHandler)
    */
   public HandlerRegistration addDoubleClickHandler(DoubleClickHandler doubleClickHandler)
   {
      return super.addDoubleClickHandler(new DoubleClickHandlerImpl(doubleClickHandler));
   }

   private T value;

   /* (non-Javadoc)
    * @see com.google.gwt.user.client.ui.HasValue#getValue()
    */
   public T getValue()
   {
      return value;
   }

   /* (non-Javadoc)
    * @see com.google.gwt.user.client.ui.HasValue#setValue(java.lang.Object)
    */
   public void setValue(T value)
   {
      this.value = value;
      doUpdateValue();
   }

   /* (non-Javadoc)
    * @see com.google.gwt.user.client.ui.HasValue#setValue(java.lang.Object, boolean)
    */
   public void setValue(T value, boolean fireEvents)
   {
      setValue(value);
   }

   /* (non-Javadoc)
    * @see com.google.gwt.event.logical.shared.HasValueChangeHandlers#addValueChangeHandler(com.google.gwt.event.logical.shared.ValueChangeHandler)
    */
   public HandlerRegistration addValueChangeHandler(ValueChangeHandler<T> valueChangeHandler)
   {
      return null;
   }

   /* (non-Javadoc)
    * @see com.google.gwt.event.logical.shared.HasSelectionHandlers#addSelectionHandler(com.google.gwt.event.logical.shared.SelectionHandler)
    */
   public HandlerRegistration addSelectionHandler(SelectionHandler<T> selectionHandler)
   {
      return super.addSelectionChangedHandler(new SelectionHandlerImpl<T>(selectionHandler, getValuePropertyName()));
   }

   /**
    * 
    */
   protected abstract void doUpdateValue();

   /**
    * @return
    */
   protected String getValuePropertyName()
   {
      return valuePropertyName;
   }
   
   public HandlerRegistration addOpenHandler(OpenHandler<T> openHandler)
   {
      FolderOpenedHandlerImpl<T> openedHandler = new FolderOpenedHandlerImpl<T>(openHandler, getValuePropertyName());
      return addFolderOpenedHandler(openedHandler);
   }   

}
