/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.ui.client.smartgwt.dialogs;

import org.exoplatform.gwtframework.commons.dialogs.Dialogs;
import org.exoplatform.gwtframework.commons.dialogs.callback.BooleanValueReceivedCallback;
import org.exoplatform.gwtframework.commons.dialogs.callback.StringValueReceivedCallback;
import org.exoplatform.gwtframework.ui.client.smartgwt.dialogs.DialogInfo.Type;


/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class SmartGWTDialogs extends Dialogs
{

   /*
    * INFO
    */

   public void showInfo(String message)
   {
      showInfo("Info", message, null);
   }
   
   public void showInfo(String title, String message)
   {
      showInfo(title, message, null);
   }
   
   public void showInfo(String title, String message, BooleanValueReceivedCallback callback)
   {
      DialogInfo dialogInfo = new DialogInfo(title, message + "<br>&nbsp;", Type.INFO, callback);
      DialogManager.showDialog(dialogInfo);
   }
   
   /*
    * WARNING
    */

   public void showError(String message)
   {
      showError("Error", message, null);
   }

   public void showError(String title, String message)
   {
      showError(title, message, null);
   }

   public void showError(String title, String message, BooleanValueReceivedCallback callback)
   {
      DialogInfo dialogInfo = new DialogInfo(title, message + "<br>&nbsp;", Type.WARNING, callback);
      DialogManager.showDialog(dialogInfo);
   }
   
   /*
    * BOOLEAN ASKING
    */

   public void ask(String title, String message, BooleanValueReceivedCallback callback)
   {
      DialogInfo dialogInfo = new DialogInfo(title, message + "<br>&nbsp;", Type.ASK, callback);
      DialogManager.showDialog(dialogInfo);
   }

   /*
    * VALUE ASKING
    */

   public void askForValue(String title, String message, String defaultValue,
      StringValueReceivedCallback callback)
   {
      DialogInfo dialogInfo = new DialogInfo(title, message + "<br>&nbsp;", Type.ASKVALUE, defaultValue, callback);
      DialogManager.showDialog(dialogInfo);
   }
   
}
