/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.binding;

import java.util.Hashtable;
import org.exolab.castor.builder.binding.Binding;
import org.exolab.castor.builder.binding.ComponentBindingType;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Structure;

public class ExtendedBinding
extends Binding {
    protected static final String PATH_SEPARATOR = "/";
    protected static final String ATTRIBUTE_PREFIX = "@";
    protected static final String COMPLEXTYPE_ID = "complexType:";
    protected static final String GROUP_ID = "group:";
    private static final short ATTRIBUTE = 10;
    private static final short ELEMENT = 11;
    private static final short COMPLEXTYPE = 12;
    private static final short GROUP = 13;
    private Hashtable _componentBindings = new Hashtable();
    private boolean _bindingProcessed = false;

    public ComponentBindingType getComponentBindingType(Annotated annotated) {
        String xPath;
        ComponentBindingType result;
        if (annotated == null) {
            return null;
        }
        if (annotated.getStructureType() == 10) {
            return null;
        }
        if (!this._bindingProcessed) {
            this.processBindingComponents();
        }
        if ((result = this.lookupComponentBindingType(xPath = this.getSchemaLocation(annotated))) == null) {
            switch (annotated.getStructureType()) {
                case 8: {
                    if (result != null) break;
                    ElementDecl element = (ElementDecl)annotated;
                    if (element.isReference()) {
                        xPath = this.getSchemaLocation(element.getReference());
                        result = this.lookupComponentBindingType(xPath);
                    }
                    element = null;
                    break;
                }
                case 3: {
                    if (result != null) break;
                    AttributeDecl attribute = (AttributeDecl)annotated;
                    if (attribute.isReference()) {
                        xPath = this.getSchemaLocation(attribute.getReference());
                        result = this.lookupComponentBindingType(xPath);
                    }
                    attribute = null;
                    break;
                }
            }
        }
        return result;
    }

    private ComponentBindingType lookupComponentBindingType(String xPath) {
        if (xPath == null) {
            return null;
        }
        return (ComponentBindingType)this._componentBindings.get(xPath);
    }

    private void processBindingComponents() {
        ComponentBindingType temp;
        ComponentBindingType[] tempBindings = this.getAttributeBinding();
        int i = 0;
        while (i < tempBindings.length) {
            temp = tempBindings[i];
            this.handleComponent(temp, null, 10);
            ++i;
        }
        tempBindings = this.getComplexTypeBinding();
        int i2 = 0;
        while (i2 < tempBindings.length) {
            temp = tempBindings[i2];
            this.handleComponent(temp, null, 12);
            ++i2;
        }
        tempBindings = this.getElementBinding();
        int i3 = 0;
        while (i3 < tempBindings.length) {
            temp = tempBindings[i3];
            this.handleComponent(temp, null, 11);
            ++i3;
        }
        tempBindings = this.getGroupBinding();
        int i4 = 0;
        while (i4 < tempBindings.length) {
            temp = tempBindings[i4];
            this.handleComponent(temp, null, 13);
            ++i4;
        }
        temp = null;
        tempBindings = null;
        this._bindingProcessed = true;
    }

    private void handleComponent(ComponentBindingType binding, String xPath, int type) {
        ComponentBindingType temp;
        String name;
        if (binding == null) {
            return;
        }
        if (xPath == null) {
            xPath = new String();
        }
        boolean xpathUsed = (name = binding.getName()).indexOf(PATH_SEPARATOR) != -1;
        switch (type) {
            case 10: {
                if (!xpathUsed) {
                    xPath = xPath + PATH_SEPARATOR + ATTRIBUTE_PREFIX;
                }
                xPath = xPath + name;
                this._componentBindings.put(xPath, binding);
                break;
            }
            case 12: {
                if (!xpathUsed) {
                    xPath = xPath + COMPLEXTYPE_ID;
                }
                xPath = xPath + name;
                this._componentBindings.put(xPath, binding);
                break;
            }
            case 11: {
                if (!xpathUsed) {
                    xPath = xPath + PATH_SEPARATOR;
                }
                xPath = xPath + name;
                this._componentBindings.put(xPath, binding);
                break;
            }
            case 13: {
                if (!xpathUsed) {
                    xPath = xPath + GROUP_ID;
                }
                xPath = xPath + name;
                this._componentBindings.put(xPath, binding);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid ComponentBindingType: the type (attribute, element, complextype or group) is unknown");
            }
        }
        ComponentBindingType[] tempBindings = binding.getAttributeBinding();
        int i = 0;
        while (i < tempBindings.length) {
            temp = tempBindings[i];
            this.handleComponent(temp, xPath, 10);
            ++i;
        }
        tempBindings = binding.getComplexTypeBinding();
        int i2 = 0;
        while (i2 < tempBindings.length) {
            temp = tempBindings[i2];
            this.handleComponent(temp, xPath, 12);
            ++i2;
        }
        tempBindings = binding.getElementBinding();
        int i3 = 0;
        while (i3 < tempBindings.length) {
            temp = tempBindings[i3];
            this.handleComponent(temp, xPath, 11);
            ++i3;
        }
        tempBindings = binding.getGroupBinding();
        int i4 = 0;
        while (i4 < tempBindings.length) {
            temp = tempBindings[i4];
            this.handleComponent(temp, xPath, 13);
            ++i4;
        }
        temp = null;
        tempBindings = null;
    }

    private String getSchemaLocation(Structure structure) {
        if (structure == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(30);
        this.getSchemaLocation(structure, buffer);
        return buffer.toString();
    }

    private void getSchemaLocation(Structure structure, StringBuffer location) {
        if (structure == null) {
            throw new IllegalArgumentException("Structure cannot be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("location cannot be null");
        }
        Structure parent = null;
        switch (structure.getStructureType()) {
            case 8: {
                parent = ((ElementDecl)structure).getParent();
                if (parent.getStructureType() != 19) {
                    this.getSchemaLocation(parent, location);
                }
                location.append(PATH_SEPARATOR);
                location.append(((ElementDecl)structure).getName());
                break;
            }
            case 6: {
                ComplexType complexType = (ComplexType)structure;
                parent = complexType.getParent();
                if (parent.getStructureType() != 19) {
                    this.getSchemaLocation(parent, location);
                }
                if (complexType.getName() == null) break;
                location.append(COMPLEXTYPE_ID);
                location.append(((ComplexType)structure).getName());
                break;
            }
            case 16: {
                ModelGroup group = (ModelGroup)structure;
                parent = group.getParent();
                if (parent.getStructureType() != 19) {
                    this.getSchemaLocation(parent, location);
                }
                if (group.getName() == null) break;
                location.append(GROUP_ID);
                location.append(group.getName());
                break;
            }
            case 3: {
                parent = ((AttributeDecl)structure).getParent();
                if (parent.getStructureType() != 19) {
                    this.getSchemaLocation(parent, location);
                }
                location.append(PATH_SEPARATOR);
                location.append(ATTRIBUTE_PREFIX);
                location.append(((AttributeDecl)structure).getName());
                break;
            }
            case 10: {
                this.getSchemaLocation(((Group)structure).getParent(), location);
                break;
            }
        }
    }
}

