/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.common.ParseException;
import com.echomine.jabber.JabberContentHandler;
import com.echomine.jabber.JabberErrorHandler;
import com.echomine.jabber.JabberMessage;
import com.echomine.jabber.JabberSAXParser;
import com.echomine.jabber.MessageRequestQueue;
import com.echomine.net.SocketHandler;
import com.echomine.util.IOUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.Socket;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class JabberProtocol
implements SocketHandler {
    public static final String DEFAULT_PARSER = "com.echomine.jabber.parser.JabberCrimsonParser";
    protected static final int SOCKETBUF = 8192;
    private boolean shutdown = false;
    protected MessageRequestQueue queue;
    protected JabberErrorHandler errorHandler;
    protected JabberContentHandler contentHandler;
    protected SAXReaderThread reader;
    protected Socket socket;

    public JabberProtocol(JabberContentHandler contentHandler, MessageRequestQueue queue) {
        this.queue = queue;
        this.contentHandler = contentHandler;
        this.errorHandler = new _1(this);
    }

    public void handle(Socket socket) throws IOException {
        BufferedWriter bw;
        BufferedReader br;
        block6: {
            this.socket = socket;
            br = null;
            bw = null;
            try {
                socket.setKeepAlive(true);
                br = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF8"), 8192);
                bw = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF8"), 8192);
                this.reader = new SAXReaderThread(this, br);
                this.reader.start();
                while (!this.shutdown) {
                    JabberMessage msg = this.queue.waitForMessage();
                    if (msg != null) {
                        try {
                            bw.write(msg.encode());
                            bw.flush();
                        }
                        catch (ParseException ex) {
                            System.out.println(ex.getMessage());
                        }
                    }
                    Thread.currentThread();
                    Thread.yield();
                }
                if (!this.shutdown) break block6;
                bw.write("</stream:stream>");
                bw.flush();
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                this.shutdown();
                IOUtil.closeStream(bw);
                IOUtil.closeStream(br);
                throw throwable;
            }
        }
        Object var8_6 = null;
        this.shutdown();
        IOUtil.closeStream(bw);
        IOUtil.closeStream(br);
    }

    public void shutdown() {
        this.shutdown = true;
        this.queue.shutdown();
        IOUtil.closeSocket(this.socket);
    }

    public void start() {
        this.shutdown = false;
        this.queue.clear();
        this.queue.start();
    }

    public void send(JabberMessage msg) {
        this.queue.addMessage(msg);
    }

    class _1
    extends JabberErrorHandler {
        private final JabberProtocol this$JabberProtocol;

        public void error(SAXParseException ex) {
            super.error(ex);
            this.this$JabberProtocol.shutdown();
        }

        public void fatalError(SAXParseException ex) {
            super.fatalError(ex);
            this.this$JabberProtocol.shutdown();
        }

        _1(JabberProtocol enclosing$instance) {
            this.this$JabberProtocol = enclosing$instance;
        }
    }

    public class SAXReaderThread
    extends Thread {
        private final JabberProtocol this$JabberProtocol;
        private Reader reader;

        public SAXReaderThread(JabberProtocol enclosing$instance, Reader reader) {
            super("Jabber SAX Reader");
            this.this$JabberProtocol = enclosing$instance;
            this.reader = reader;
        }

        public void run() {
            String parserName = System.getProperty("com.echomine.jabber.SAXParser", JabberProtocol.DEFAULT_PARSER);
            try {
                try {
                    Class<?> cls = Class.forName(parserName);
                    JabberSAXParser parser = (JabberSAXParser)cls.newInstance();
                    parser.parse(false, true, this.this$JabberProtocol.contentHandler, this.this$JabberProtocol.errorHandler, new InputSource(this.reader));
                }
                catch (ClassNotFoundException ex) {
                    System.out.println("Parser class " + parserName + " not found");
                }
                catch (ClassCastException ex) {
                    System.out.println("Parser is not of type JabberSAXParser");
                }
                catch (InstantiationException ex) {
                    System.out.println("Parser cannot be initialized to check for validity: " + ex.getMessage());
                }
                catch (IllegalAccessException ex) {
                    System.out.println("Illegal access while checking for validity: " + ex.getMessage());
                }
                Object var10_8 = null;
                this.this$JabberProtocol.shutdown();
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                this.this$JabberProtocol.shutdown();
                throw throwable;
            }
        }
    }
}

