/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.animation.client.Animation;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.HasAnimation;
import com.google.gwt.user.client.ui.InsertPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;

public class DeckPanel
extends ComplexPanel
implements HasAnimation,
InsertPanel.ForIsWidget {
    private static final int ANIMATION_DURATION = 350;
    private static SlideAnimation slideAnimation;
    private boolean isAnimationEnabled = false;
    private Widget visibleWidget;

    private static Element getContainer(Widget w) {
        return DOM.getParent(w.getElement());
    }

    public DeckPanel() {
        this.setElement(DOM.createDiv());
    }

    public void add(Widget w) {
        Element container = this.createWidgetContainer();
        DOM.appendChild(this.getElement(), container);
        super.add(w, container);
        this.finishWidgetInitialization(container, w);
    }

    public int getVisibleWidget() {
        return this.getWidgetIndex(this.visibleWidget);
    }

    public void insert(IsWidget w, int beforeIndex) {
        this.insert(DeckPanel.asWidgetOrNull(w), beforeIndex);
    }

    public void insert(Widget w, int beforeIndex) {
        Element container = this.createWidgetContainer();
        DOM.insertChild(this.getElement(), container, beforeIndex);
        this.insert(w, container, beforeIndex, true);
        this.finishWidgetInitialization(container, w);
    }

    public boolean isAnimationEnabled() {
        return this.isAnimationEnabled;
    }

    public boolean remove(Widget w) {
        Element container = DeckPanel.getContainer(w);
        boolean removed = super.remove(w);
        if (removed) {
            this.resetChildWidget(w);
            DOM.removeChild(this.getElement(), container);
            if (this.visibleWidget == w) {
                this.visibleWidget = null;
            }
        }
        return removed;
    }

    public void setAnimationEnabled(boolean enable) {
        this.isAnimationEnabled = enable;
    }

    public void showWidget(int index) {
        this.checkIndexBoundsForAccess(index);
        Widget oldWidget = this.visibleWidget;
        this.visibleWidget = this.getWidget(index);
        if (this.visibleWidget != oldWidget) {
            if (slideAnimation == null) {
                slideAnimation = new SlideAnimation();
            }
            slideAnimation.showWidget(oldWidget, this.visibleWidget, this.isAnimationEnabled && this.isAttached());
        }
    }

    private Element createWidgetContainer() {
        Element container = DOM.createDiv();
        DOM.setStyleAttribute(container, "width", "100%");
        DOM.setStyleAttribute(container, "height", "0px");
        DOM.setStyleAttribute(container, "padding", "0px");
        DOM.setStyleAttribute(container, "margin", "0px");
        return container;
    }

    private void finishWidgetInitialization(Element container, Widget w) {
        UIObject.setVisible(container, false);
        DOM.setStyleAttribute(container, "height", "100%");
        Element element = w.getElement();
        if (DOM.getStyleAttribute(element, "width").equals("")) {
            w.setWidth("100%");
        }
        if (DOM.getStyleAttribute(element, "height").equals("")) {
            w.setHeight("100%");
        }
        w.setVisible(false);
    }

    private void resetChildWidget(Widget w) {
        w.setSize("", "");
        w.setVisible(true);
    }

    private static class SlideAnimation
    extends Animation {
        private Element container1 = null;
        private Element container2 = null;
        private boolean growing = false;
        private int fixedHeight = -1;
        private Widget oldWidget = null;

        private SlideAnimation() {
        }

        public void showWidget(Widget oldWidget, Widget newWidget, boolean animate) {
            this.cancel();
            Element newContainer = DeckPanel.getContainer(newWidget);
            int newIndex = DOM.getChildIndex(DOM.getParent(newContainer), newContainer);
            if (oldWidget == null) {
                UIObject.setVisible(newContainer, true);
                newWidget.setVisible(true);
                return;
            }
            this.oldWidget = oldWidget;
            Element oldContainer = DeckPanel.getContainer(oldWidget);
            int oldIndex = DOM.getChildIndex(DOM.getParent(oldContainer), oldContainer);
            if (newIndex > oldIndex) {
                this.container1 = oldContainer;
                this.container2 = newContainer;
                this.growing = false;
            } else {
                this.container1 = newContainer;
                this.container2 = oldContainer;
                this.growing = true;
            }
            if (animate) {
                this.run(350);
            } else {
                this.onInstantaneousRun();
            }
            newWidget.setVisible(true);
        }

        protected void onComplete() {
            if (this.growing) {
                DOM.setStyleAttribute(this.container1, "height", "100%");
                UIObject.setVisible(this.container1, true);
                UIObject.setVisible(this.container2, false);
                DOM.setStyleAttribute(this.container2, "height", "100%");
            } else {
                UIObject.setVisible(this.container1, false);
                DOM.setStyleAttribute(this.container1, "height", "100%");
                DOM.setStyleAttribute(this.container2, "height", "100%");
                UIObject.setVisible(this.container2, true);
            }
            DOM.setStyleAttribute(this.container1, "overflow", "visible");
            DOM.setStyleAttribute(this.container2, "overflow", "visible");
            this.container1 = null;
            this.container2 = null;
            this.hideOldWidget();
        }

        protected void onStart() {
            com.google.gwt.dom.client.Element deckElem = this.container1.getParentElement();
            int deckHeight = deckElem.getOffsetHeight();
            if (this.growing) {
                this.fixedHeight = this.container2.getOffsetHeight();
                this.container2.getStyle().setPropertyPx("height", Math.max(1, this.fixedHeight - 1));
            } else {
                this.fixedHeight = this.container1.getOffsetHeight();
                this.container1.getStyle().setPropertyPx("height", Math.max(1, this.fixedHeight - 1));
            }
            if (deckElem.getOffsetHeight() != deckHeight) {
                this.fixedHeight = -1;
            }
            DOM.setStyleAttribute(this.container1, "overflow", "hidden");
            DOM.setStyleAttribute(this.container2, "overflow", "hidden");
            this.onUpdate(0.0);
            UIObject.setVisible(this.container1, true);
            UIObject.setVisible(this.container2, true);
        }

        protected void onUpdate(double progress) {
            int height2;
            int height1;
            if (!this.growing) {
                progress = 1.0 - progress;
            }
            if (this.fixedHeight == -1) {
                height1 = (int)(progress * (double)DOM.getElementPropertyInt(this.container1, "scrollHeight"));
                height2 = (int)((1.0 - progress) * (double)DOM.getElementPropertyInt(this.container2, "scrollHeight"));
            } else {
                height1 = (int)(progress * (double)this.fixedHeight);
                height2 = this.fixedHeight - height1;
            }
            if (height1 == 0) {
                height1 = 1;
                height2 = Math.max(1, height2 - 1);
            } else if (height2 == 0) {
                height2 = 1;
                height1 = Math.max(1, height1 - 1);
            }
            DOM.setStyleAttribute(this.container1, "height", height1 + "px");
            DOM.setStyleAttribute(this.container2, "height", height2 + "px");
        }

        private void hideOldWidget() {
            this.oldWidget.setVisible(false);
            this.oldWidget = null;
        }

        private void onInstantaneousRun() {
            UIObject.setVisible(this.container1, this.growing);
            UIObject.setVisible(this.container2, !this.growing);
            this.container1 = null;
            this.container2 = null;
            this.hideOldWidget();
        }
    }
}

