/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.net.junit;

import com.echomine.net.ConnectionEvent;
import com.echomine.net.ConnectionListener;
import com.echomine.net.ConnectionModel;
import com.echomine.net.ConnectionVetoException;
import com.echomine.net.SocketAcceptor;
import com.echomine.net.SocketHandler;
import com.echomine.util.IOUtil;
import java.io.IOException;
import java.net.Socket;
import junit.framework.TestCase;

public class SocketAcceptorTest
extends TestCase {
    ConnectionModel model;
    SocketAcceptor acceptor;
    SocketHandler handler;

    public SocketAcceptorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.model = new ConnectionModel("127.0.0.1", 7000);
        this.acceptor = new SocketAcceptor(this.model);
        this.handler = new _1(this);
    }

    protected void tearDown() throws Exception {
        this.acceptor.close();
    }

    public void testSocketAcceptorNormalAsync() throws Exception {
        this.acceptor.aaccept(this.handler);
        Socket socket = new Socket("127.0.0.1", 7000);
        byte[] data = new byte[10];
        int bytesRead = socket.getInputStream().read(data);
        if (bytesRead == -1) {
            SocketAcceptorTest.fail((String)"Unable to read any bytes");
        }
        String result = new String(data, 0, bytesRead);
        SocketAcceptorTest.assertEquals((Object)"Success", (Object)result);
        IOUtil.closeSocket(socket);
    }

    public void testSocketAcceptorNormalSync() throws Exception {
        _2 thread = new _2(this);
        thread.start();
        Socket socket = new Socket("127.0.0.1", 7000);
        byte[] data = new byte[10];
        int bytesRead = socket.getInputStream().read(data);
        if (bytesRead == -1) {
            SocketAcceptorTest.fail((String)"Unable to read any bytes");
        }
        String result = new String(data, 0, bytesRead);
        SocketAcceptorTest.assertEquals((Object)"Success", (Object)result);
        IOUtil.closeSocket(socket);
    }

    public void testAcceptorConnectionListener() throws Exception {
        AcceptorConnectionListener l = new AcceptorConnectionListener(this);
        this.acceptor.aaccept(this.handler);
        this.acceptor.addConnectionListener(l);
        Socket socket = new Socket("127.0.0.1", 7000);
        Thread.currentThread();
        Thread.sleep(500L);
        IOUtil.closeSocket(socket);
        SocketAcceptorTest.assertTrue((l.starting ? 1 : 0) != 0);
        SocketAcceptorTest.assertTrue((l.established ? 1 : 0) != 0);
        SocketAcceptorTest.assertTrue((l.closed ? 1 : 0) != 0);
    }

    public void testAcceptorVetoedConnectionListener() throws Exception {
        VetoedConnectionListener l = new VetoedConnectionListener(this);
        this.acceptor.aaccept(this.handler);
        this.acceptor.addConnectionListener(l);
        Socket socket = new Socket("127.0.0.1", 7000);
        Thread.currentThread();
        Thread.sleep(500L);
        IOUtil.closeSocket(socket);
        SocketAcceptorTest.assertTrue((l.starting ? 1 : 0) != 0);
        SocketAcceptorTest.assertTrue((!l.established ? 1 : 0) != 0);
        SocketAcceptorTest.assertTrue((l.closed ? 1 : 0) != 0);
    }

    class _1
    implements SocketHandler {
        private final SocketAcceptorTest this$SocketAcceptorTest;

        public void handle(Socket socket) throws IOException {
            socket.getOutputStream().write("Success".getBytes());
        }

        public void shutdown() {
        }

        public void start() {
        }

        _1(SocketAcceptorTest enclosing$instance) {
            this.this$SocketAcceptorTest = enclosing$instance;
        }
    }

    class _2
    extends Thread {
        private final SocketAcceptorTest this$SocketAcceptorTest;

        public void run() {
            this.this$SocketAcceptorTest.acceptor.accept(this.this$SocketAcceptorTest.handler);
        }

        _2(SocketAcceptorTest enclosing$instance) {
            this.this$SocketAcceptorTest = enclosing$instance;
        }
    }

    class AcceptorConnectionListener
    implements ConnectionListener {
        private final SocketAcceptorTest this$SocketAcceptorTest;
        boolean starting;
        boolean established;
        boolean closed;

        public void connectionStarting(ConnectionEvent e) throws ConnectionVetoException {
            this.starting = true;
        }

        public void connectionEstablished(ConnectionEvent e) {
            this.established = true;
        }

        public void connectionClosed(ConnectionEvent e) {
            this.closed = true;
        }

        AcceptorConnectionListener(SocketAcceptorTest enclosing$instance) {
            this.this$SocketAcceptorTest = enclosing$instance;
            this.starting = false;
            this.established = false;
            this.closed = false;
        }
    }

    class VetoedConnectionListener
    extends AcceptorConnectionListener {
        private final SocketAcceptorTest this$SocketAcceptorTest;

        public void connectionStarting(ConnectionEvent e) throws ConnectionVetoException {
            super.connectionStarting(e);
            throw new ConnectionVetoException("Vetoed");
        }

        VetoedConnectionListener(SocketAcceptorTest enclosing$instance) {
            super(enclosing$instance);
            this.this$SocketAcceptorTest = enclosing$instance;
        }
    }
}

