/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */

package org.exoplatform.gwtframework.commons.rest;

import org.exoplatform.gwtframework.commons.loader.EmptyLoader;
import org.exoplatform.gwtframework.commons.rest.AsyncRequest;
import org.exoplatform.gwtframework.commons.rest.AsyncRequestCallback;
import org.exoplatform.gwtframework.commons.rest.Marshallable;
import org.exoplatform.gwtframework.commons.rest.Unmarshallable;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.Response;

/**
 * Created by The eXo Platform SAS        .
 * @version $Id: $
 */

public class ServiceClientExample
{

   public ServiceClientExample()
   {

      // prepare application's event bus and register event handlers (once per-app)
      HandlerManager eventBus = new HandlerManager(null);
      eventBus.addHandler(SampleEvent.TYPE, new SampleHandlerImpl());

      // instantiate service (once per-app)
      SomeService service = new SomeService(eventBus);

      // Actually the request...

      // get an object to be passed to the service
      RequestBody req = new RequestBody("test");

      // create a response object to be used by service's method callback 
      ResponseBody resp = new ResponseBody();

      // actually call the necessary method with a new event object to be called after 
      // retrieving a response  
      service.callMethod1(req, resp, new SampleEvent(resp));

   }

   public class SomeService
   {

      // Service usually knows:
      //  - HandlerManager
      //  - Loader (if any)
      private HandlerManager eventBus;

      public SomeService(HandlerManager eventBus)
      {
         this.eventBus = eventBus;
      }

      public void callMethod1(RequestBody requestObj, ResponseBody responseObj, GwtEvent<?> postEvent)
      {

         //Request usually knows:      
         // - method type
         // - URL
         // - headers (if any)
         // - postEvent (if any)

         EmptyLoader loader = new EmptyLoader();

         AsyncRequest.build(RequestBuilder.POST, "/some/url", loader).data(requestObj).header("header", "param").send(
            new AsyncRequestCallback(eventBus, responseObj, postEvent));

      }

   }

   public class RequestBody implements Marshallable
   {

      private String param;

      public RequestBody(String param)
      {
         this.param = param;
      }

      public String marshal()
      {
         // compose body
         return param;
      }

   }

   public class ResponseBody implements Unmarshallable
   {

      private String param;

      public void unmarshal(Response response)
      {
         // parse body
         this.param = response.getText();
      }

      public final String getParam()
      {
         return param;
      }

   }

   public static class SampleEvent extends GwtEvent<SampleHandler>
   {

      public static final GwtEvent.Type<SampleHandler> TYPE = new GwtEvent.Type<SampleHandler>();

      private ResponseBody body;

      public SampleEvent(ResponseBody body)
      {
         this.body = body;
      }

      @Override
      protected void dispatch(SampleHandler handler)
      {
         handler.onFired(this);
      }

      @Override
      public GwtEvent.Type<SampleHandler> getAssociatedType()
      {
         return TYPE;
      }

      public final ResponseBody getBody()
      {
         return body;
      }

   }

   public interface SampleHandler extends EventHandler
   {

      void onFired(SampleEvent event);

   }

   public class SampleHandlerImpl implements SampleHandler
   {

      public void onFired(SampleEvent event)
      {

      }

   }

}
