/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.ui.client.testcase.cases;

import org.exoplatform.gwtframework.ui.client.testcase.TestCase;
import org.exoplatform.gwtframework.ui.client.tree.Tree;
import org.exoplatform.gwtframework.ui.client.tree.TreeNode;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Button;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class TreeShowcase extends TestCase
{

   private AbsolutePanel panel;

   private Tree gwtTree;

   @Override
   public void draw()
   {
      panel = new AbsolutePanel();
      DOM.setStyleAttribute(panel.getElement(), "background", "#efefef");
      DOM.setStyleAttribute(panel.getElement(), "width", "100%");
      DOM.setStyleAttribute(panel.getElement(), "height", "100%");
      testCasePanel().add(panel);

      createButtons();
   }

   private Button createTreeButton;

   private void createButtons()
   {
      createTreeButton = new Button("Create Tree");
      createTreeButton.setWidth("170px");
      createTreeButton.addClickHandler(new ClickHandler()
      {
         public void onClick(ClickEvent arg0)
         {
            createTreeButton.setEnabled(false);
            createTree();
            fillTree();
         }
      });
      panel.add(createTreeButton, 10, 10);
   }

   public void createTree()
   {
      gwtTree = new Tree();
      panel.add(gwtTree);
      gwtTree.setAllowMultiSelect(true);

      gwtTree.setWidth("300px");
      gwtTree.setHeight("400px");

      DOM.setStyleAttribute(gwtTree.getElement(), "position", "absolute");
      DOM.setStyleAttribute(gwtTree.getElement(), "left", "10px");
      DOM.setStyleAttribute(gwtTree.getElement(), "top", "50px");
   }

   protected void fillTree()
   {
      if (gwtTree == null)
      {
         return;
      }

      TreeNode root = new TreeNode("rest");

      TreeNode n2 = new TreeNode("jcr");
      root.getChildren().add(n2);

      TreeNode n3 = new TreeNode("repository");
      n2.getChildren().add(n3);

      TreeNode n4 = new TreeNode("production");
      n3.getChildren().add(n4);

      TreeNode n5 = new TreeNode("my test folder");
      n4.getChildren().add(n5);

      for (int i = 0; i < 20; i++)
      {
         TreeNode n6 = new TreeNode("my test sub folder " + i);

         for (int j = 0; j < 30; j++)
         {
            n6.getChildren().add(new TreeNode("subfolder with very long name - " + j));
         }

         n5.getChildren().add(n6);
      }

      gwtTree.setRoot(root);
   }

}
