/*
 * Copyright (C) 2003-2012 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 */
package org.exoplatform.wiki.util;

import java.util.Map;

/**
 * Utility class for handling MacroMaps
 */
public final class MacroMap {

  //Utility class
  private MacroMap() {
  }

  public static void addMacro(Map<String, Integer> macroMap, String... macros) {
    for (String macro : macros) {
      addMacro(macroMap, macro, 1);
    }
  }

  public static boolean addMacro(Map<String, Integer> macroMap, String macro, int count) {
    boolean newMacro = false;

    if (macroMap == null) {
      return false;
    }

    Integer currentCount = macroMap.get(macro);
    if (currentCount == null) {
      currentCount = count;
      newMacro = true;
    } else {
      currentCount += count;
    }
    macroMap.put(macro, currentCount);

    return newMacro;
  }

  public static void mergeMaps(Map<String, Integer> sourceMap, Map<String, Integer> targetMap) {
    for (String macro : sourceMap.keySet()) {
      Integer count = sourceMap.get(macro);
      addMacro(targetMap, macro, count);
    }
  }

  public static int getCount(Map<String, Integer> targetMap, String key) {
    Integer value = targetMap.get(key);
    return value != null ? value : 0;
  }
}