/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */

package org.exoplatform.gwtframework.ui.client.handler;

import org.exoplatform.gwtframework.commons.dialogs.Dialogs;
import org.exoplatform.gwtframework.commons.exception.ExceptionThrownEvent;
import org.exoplatform.gwtframework.commons.exception.ExceptionThrownHandler;
import org.exoplatform.gwtframework.commons.exception.ServerException;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class ExceptionThrownHandlerImpl implements ExceptionThrownHandler
{

   /* 
    * Handler of any errors which throws by application
    * 
    * (non-Javadoc)
    * @see org.exoplatform.gwt.commons.exceptions.ExceptionThrownHandler#onError(org.exoplatform.gwt.commons.exceptions.ExceptionThrownEvent)
    */
   public void onError(ExceptionThrownEvent event)
   {
      Throwable error = event.getError();

      if (error instanceof ServerException)
      {
         ServerException serverException = (ServerException)error;

         if (serverException.isErrorMessageProvided())
         {
            String html =
               "" + serverException.getHTTPStatus() + "&nbsp;" + serverException.getStatusText() + "<br><br><hr><br>"
                  + serverException.getMessage();
            Dialogs.getInstance().showError(html);
            //            Dialogs.showError(serverException.getHTTPStatus(), serverException.getStatusText(), serverException
            //               .getMessage());            
         }
         else
         {
            String html = "" + serverException.getHTTPStatus() + "&nbsp;" + serverException.getStatusText();
            //Dialogs.showError(serverException.getHTTPStatus(), serverException.getStatusText());            
            Dialogs.getInstance().showError(html);
         }
      }
      else
      {
         Dialogs.getInstance().showError(error.getMessage());
      }
   }

}
