/*
 * Copyright (C) 2010 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.exoplatform.gwtframework.ui.client.smartgwt.component;

import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;

import org.exoplatform.gwtframework.ui.client.api.TextFieldItem;
import org.exoplatform.gwtframework.ui.client.smartgwt.component.event.ChangedHandlerImpl;
import org.exoplatform.gwtframework.ui.client.smartgwt.component.event.KeyPressHandlerImpl;

import com.smartgwt.client.widgets.form.fields.PasswordItem;

/**
 * Field to enter password (when entered letters are not seen).
 * 
 * @author <a href="mailto:zhulevaanna@gmail.com">Ann Zhuleva</a>
 * @version $Id: Nov 30, 2010 $
 *
 */
public class PasswordField extends PasswordItem implements TextFieldItem
{

   /**
    * Default constructor.
    */
   public PasswordField()
   {
   }

   /**
    * @param name field name
    */
   public PasswordField(String name)
   {
      super(name);
   }

   /**
    * @param name field name
    * @param title field title
    */
   public PasswordField(String name, String title)
   {
      super(name, title);
   }

   /**
    * @see com.smartgwt.client.widgets.form.fields.FormItem#getValue()
    */
   public String getValue()
   {
      return (super.getValue() == null) ? "" : "" + super.getValue();
   }

   /**
    * @see com.google.gwt.user.client.ui.HasValue#setValue(java.lang.Object, boolean)
    */
   public void setValue(String value, boolean fireEvents)
   {
      super.setValue(value);
   }

   /**
    * @see com.smartgwt.client.widgets.form.fields.FormItem#setValue(java.lang.String)
    */
   public void setValue(String value)
   {
      super.setValue(value);
   }

   /**
    * @see com.google.gwt.event.logical.shared.HasValueChangeHandlers#addValueChangeHandler(com.google.gwt.event.logical.shared.ValueChangeHandler)
    */
   public HandlerRegistration addValueChangeHandler(ValueChangeHandler<String> valueChangeHandler)
   {
      return super.addChangedHandler(new ChangedHandlerImpl(valueChangeHandler));
   }

   /**
    * @see com.google.gwt.event.dom.client.HasKeyPressHandlers#addKeyPressHandler(com.google.gwt.event.dom.client.KeyPressHandler)
    */
   public HandlerRegistration addKeyPressHandler(KeyPressHandler keyPressedHandler)
   {
      return super.addKeyPressHandler(new KeyPressHandlerImpl(keyPressedHandler));
   }

}
