/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.ui.client.smartgwteditor;

import java.util.List;

import org.exoplatform.gwtframework.editor.api.GWTTextEditor;
import org.exoplatform.gwtframework.editor.api.TextEditor;
import org.exoplatform.gwtframework.editor.api.Token;
import org.exoplatform.gwtframework.ui.client.smartgwt.SmartGWTLockableCanvas;

import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.smartgwt.client.types.Overflow;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class SmartGWTTextEditor extends SmartGWTLockableCanvas implements TextEditor
{

   private GWTTextEditor textEditor;

   public SmartGWTTextEditor(HandlerManager eventBus, GWTTextEditor textEditor)
   {
      super(eventBus);
      this.textEditor = textEditor;

      addChild(textEditor);
      textEditor.setWidth("100%");
      textEditor.setHeight("100%");

      setOverflow(Overflow.HIDDEN);

      redraw();
   }

   @Override
   protected void onResized()
   {
      int w = getWidth();
      int h = getHeight();

      if (h < 0)
      {
         h = 0;
      }

      if (w < 0)
      {
         w = 0;
      }

      textEditor.setWidth("" + w + "px");
      textEditor.setHeight("" + h + "px");

      hack3Parent();
   }

   private void hack3Parent()
   {
      try
      {
         Element el = textEditor.editorPanel().getElement();
         Element p1 = DOM.getParent(el);
         Element p2 = DOM.getParent(p1);
         Element p3 = DOM.getParent(p2);
         DOM.setStyleAttribute(p3, "overflow", "visible");
      }
      catch (Exception e)
      {
         //e.printStackTrace();
      }
   }

   public boolean canFormatSource()
   {
      return textEditor.canFormatSource();
   }

   public boolean canSetLineNumbers()
   {
      return textEditor.canSetLineNumbers();
   }

   public boolean canCreateTokenList()
   {
      return textEditor.canCreateTokenList();
   }

   public void formatSource()
   {
      textEditor.formatSource();
   }

   public String getEditorId()
   {
      return textEditor.getEditorId();
   }

   public String getText()
   {
      return textEditor.getText();
   }

   public boolean hasRedoChanges()
   {
      return textEditor.hasRedoChanges();
   }

   public boolean hasUndoChanges()
   {
      return textEditor.hasUndoChanges();
   }

   public void redo()
   {
      textEditor.redo();
   }

   public void setFocus()
   {
      textEditor.setFocus();
   }

   public void setLineNumbers(boolean showLineNumbers)
   {
      textEditor.setLineNumbers(showLineNumbers);
   }

   public void setText(String text)
   {
      textEditor.setText(text);
   }

   public void undo()
   {
      textEditor.undo();
   }

   public boolean isReadOnly()
   {
      return textEditor.isReadOnly();
   }

   public boolean canDeleteCurrentLine()
   {
      return textEditor.canDeleteCurrentLine();
   }

   public boolean canFindAndReplace()
   {
      return textEditor.canFindAndReplace();
   }

   public boolean canGoToLine()
   {
      return textEditor.canGoToLine();
   }

   public boolean canGoToLine(int lineNumber)
   {
      return textEditor.canGoToLine(lineNumber);
   }

   public void deleteCurrentLine()
   {
      textEditor.deleteCurrentLine();
   }

   /**
    * Find text, select and return true
    * @param find text to find and select
    * @param caseSensitive <b>true</b> means case sensitive search 
    * @return <b>true</b> if something is found, or <b>false</b>  if the end of document is reached. 
    */
   public boolean findAndSelect(String find, boolean caseSensitive)
   {
      return textEditor.findAndSelect(find, caseSensitive);
   }

   /**
    * Replace selected text on "replace" parameter if it equals to "find" parameter
    * @param find text to find 
    * @param replace text to replace
    * @param caseSensitive <b>true</b> means case sensitive search 
    * @return 
    */
   public void replaceFoundedText(String find, String replace, boolean caseSensitive)
   {
      textEditor.replaceFoundedText(find, replace, caseSensitive);
   }

   public void goToLine(int lineNumber)
   {
      textEditor.goToLine(lineNumber);
   }

   /**
    * 
    * @see org.exoplatform.gwtframework.editor.api.TextEditor#goToPosition(int, int)
    */
   public void goToPosition(int row, int column)
   {
      textEditor.goToPosition(row, column);
   }

   public int getCursorRow()
   {
      return textEditor.getCursorRow();
   }

   public int getCursorCol()
   {
      return textEditor.getCursorCol();
   }

   public void setHotKeyList(List<String> hotKeyList)
   {
      textEditor.setHotKeyList(hotKeyList);
   }

   public List<Token> getTokenList()
   {
      return textEditor.getTokenList();
   }

   /**
    * @return the textEditor
    */
   public GWTTextEditor getTextEditor()
   {
      return textEditor;
   }

}
