/**
 * Copyright (C) 2010 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */

package org.exoplatform.gwtframework.ui.client.api;

import com.google.gwt.event.dom.client.HasClickHandlers;

/**
 * 
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public interface ButtonItem extends HasClickHandlers
{
   
   /**
    * Sets button's new text.
    * 
    * @param text
    */
   void setText(String text);
   
   /**
    * Get button's text
    * 
    * @return
    */
   String getText();
   
   /**
   * Sets the title associated with this button. The title is the 'tool-tip'
   * displayed to users when they hover over the object.
    * 
    * @param title new title
    */
   void setTitle(String title);
   
   /**
    * Get title associated with this button.
    * 
    * @return
    */
   String getTitle();

   /**
    *  Determines whether or not this button is visible.
    * 
    * @return true if button is visible
    */
   boolean isVisible();
   
   /**
    * Sets is this button visible.
    * 
    * @param isVisible
    */
   void setVisible(boolean isVisible);
   
   /**
    * Returns true if this button enabled.
    * 
    * @return true if this button enabled
    */
   boolean isEnabled();
   
   /**
    * Makes the button enabled or disabled.
    * 
    * @param isEnabled
    */
   void setEnabled(boolean isEnabled);

}
