/**
 * Copyright (C) 2010 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */

package org.exoplatform.gwtframework.ui.client.button;

import org.exoplatform.gwtframework.ui.client.api.ButtonItem;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Label;

/**
 * 
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class LinkButton extends Label implements ButtonItem
{

   /**
    *
    */
   private class LinkButtonClickHandler implements ClickHandler
   {

      private LinkButton button;

      private ClickHandler originalClickHandler;

      public LinkButtonClickHandler(LinkButton button, ClickHandler originalClickHandler)
      {
         this.button = button;
         this.originalClickHandler = originalClickHandler;
      }

      public void onClick(ClickEvent event)
      {
         if (button.isEnabled())
         {
            originalClickHandler.onClick(event);
         }
      }

   }

   /**
    * Is button enabled.
    */
   private boolean enabled;

   /**
    * Create Link Button.
    * 
    * @param text Button's text
    */
   public LinkButton(String text)
   {
      super(text);
      DOM.setStyleAttribute(getElement(), "textDecoration", "underline");
   }

   /**
    * @see com.google.gwt.user.client.ui.Label#addClickHandler(com.google.gwt.event.dom.client.ClickHandler)
    */
   @Override
   public HandlerRegistration addClickHandler(ClickHandler handler)
   {
      return super.addClickHandler(new LinkButtonClickHandler(this, handler));
   }

   /**
    * @see org.exoplatform.gwtframework.ui.client.api.ButtonItem#isEnabled()
    */
   public boolean isEnabled()
   {
      return enabled;
   }

   /**
    * @see org.exoplatform.gwtframework.ui.client.api.ButtonItem#setEnabled(boolean)
    */
   public void setEnabled(boolean enabled)
   {
      this.enabled = enabled;

      if (enabled)
      {
         DOM.setStyleAttribute(getElement(), "color", "#2222DD");
         DOM.setStyleAttribute(getElement(), "cursor", "pointer");
         DOM.setStyleAttribute(getElement(), "textDecoration", "underline");
      }
      else
      {
         DOM.setStyleAttribute(getElement(), "color", "#CCCCCC");
         DOM.setStyleAttribute(getElement(), "cursor", "default");
         DOM.setStyleAttribute(getElement(), "textDecoration", "none");
      }
   }

}
