/*
 * Copyright (C) 2011 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.exoplatform.gwtframework.ui.client.command.ui;

import org.exoplatform.gwtframework.ui.client.command.ControlStateListener;
import org.exoplatform.gwtframework.ui.client.command.LoaderControl;
import org.exoplatform.gwtframework.ui.client.loader.LoadingIndicator;
import org.exoplatform.gwtframework.ui.client.toolbar.Toolbar;
import org.exoplatform.gwtframework.ui.client.util.ImageHelper;

import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.Command;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class LoaderIndicatorControl extends LoadingIndicator implements ControlStateListener
{

   private HandlerManager eventBus;

   private LoaderControl control;

   private Toolbar toolbar;

   public LoaderIndicatorControl(HandlerManager eventBus, LoaderControl control, Toolbar toolbar)
   {
      this.eventBus = eventBus;
      this.control = control;
      this.toolbar = toolbar;

      setCommand(loaderIndicatorCommand);
      setIcon(getControlIcon());
      setTitle(control.getPrompt());
   }

   @Override
   protected void onAttach()
   {
      super.onAttach();
      getParent().setVisible(control.isVisible());
      control.getStateListeners().add(this);
   }

   @Override
   protected void onDetach()
   {
      super.onDetach();
      control.getStateListeners().remove(this);
   }

   private Command loaderIndicatorCommand = new Command()
   {
      public void execute()
      {
         if (control.getEvent() != null)
         {
            eventBus.fireEvent(control.getEvent());
         }
      }
   };

   protected String getControlIcon()
   {
      String icon = "";
      if (control.getNormalImage() != null)
      {
         icon = ImageHelper.getImageHTML(control.getNormalImage());
      }
      else if (control.getIcon() != null)
      {
         icon = ImageHelper.getImageHTML(control.getIcon());
      }
      else
      {
         icon = null;
      }

      return icon;
   }

   public void updateControlEnabling(boolean enabled)
   {
      setEnabled(enabled);
   }

   public void updateControlVisibility(boolean visible)
   {
      getParent().setVisible(visible);
      toolbar.hideDuplicatedDelimiters();
   }

   public void updateControlPrompt(String prompt)
   {
      setTitle(prompt);
   }

   public void updateControlIcon(String icon)
   {
      setIcon(getControlIcon());
   }

}
