/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.ui.client.smartgwt;

import org.exoplatform.gwtframework.commons.dialogs.Dialogs;

import com.smartgwt.client.util.BooleanCallback;
import com.smartgwt.client.util.ValueCallback;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class SmartGWTDialogs extends Dialogs
{

   private BooleanCallback booleanCallback = new BooleanCallback()
   {
      public void execute(Boolean value)
      {
         if (currentDialog.getBooleanValueReceivedHandler() != null)
         {
            try
            {
               currentDialog.getBooleanValueReceivedHandler().booleanValueReceived(value);
            }
            catch (Throwable exc)
            {
               exc.printStackTrace();
            }
         }

         showQueueDialog();
      }
   };

   private ValueCallback valueCallback = new ValueCallback()
   {
      public void execute(String value)
      {
         if (currentDialog.getStringValueReceivedHandler() != null)
         {
            try
            {
               currentDialog.getStringValueReceivedHandler().stringValueReceived(value);
            }
            catch (Throwable exc)
            {
               exc.printStackTrace();
            }
         }

         showQueueDialog();
      }
   };

   /*
    * VALUE ASKING
    */
   @Override
   protected native void openAskForValueDialog(String title, String message, String defaultValue) /*-{
      var callback = this.@org.exoplatform.gwtframework.ui.client.smartgwt.SmartGWTDialogs::valueCallback;
      
      $wnd.isc.askForValue(message, 
         function(value) {
            if(value === undefined)
               value = null;
            if (callback != null) {
              callback.@com.smartgwt.client.util.ValueCallback::execute(Ljava/lang/String;)(value);
            }
         },
         {
            title:title, 
            width:400,
            defaultValue:defaultValue,
            showShadow:true
         }
      );
   }-*/;

   @Override
   protected native void openAskDialog(String title, String message) /*-{
      var callback = this.@org.exoplatform.gwtframework.ui.client.smartgwt.SmartGWTDialogs::booleanCallback;
   
      $wnd.isc.ask(message,
         function(value) {
            var valueJ = value == null ? null : @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(value);

            if (callback != null) {
               callback.@com.smartgwt.client.util.BooleanCallback::execute(Ljava/lang/Boolean;)(valueJ);
            }
            
         },
         {
            title:title,
            showShadow:true
         }
      );
   }-*/;

   @Override
   protected native void openWarningDialog(String title, String message) /*-{
      var callback = this.@org.exoplatform.gwtframework.ui.client.smartgwt.SmartGWTDialogs::booleanCallback;
      
      $wnd.isc.warn(message,
         function(value) {
            var valueJ = value == null ? null : @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(value);
            if(callback != null) {
               callback.@com.smartgwt.client.util.BooleanCallback::execute(Ljava/lang/Boolean;)(valueJ);
            }
         },
         {
            title:title,
            showShadow:true
         }         
      );      
   }-*/;

   @Override
   protected native void openInfoDialog(String title, String message) /*-{
      var callback = this.@org.exoplatform.gwtframework.ui.client.smartgwt.SmartGWTDialogs::booleanCallback;
      
      $wnd.isc.say(message,
         function(value) {
            var valueJ = value == null ? null : @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(value);
            if (callback != null) {
               callback.@com.smartgwt.client.util.BooleanCallback::execute(Ljava/lang/Boolean;)(valueJ);
            }
            
         },
         {
            title:title,
            showShadow:true
         }
      );
   }-*/;

}
