/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */

package org.exoplatform.gwtframework.ui.client.smartgwt;

import org.exoplatform.gwtframework.commons.loader.Loader;
import org.exoplatform.gwtframework.ui.client.util.UIHelper;

import com.google.gwt.user.client.DOM;
import com.smartgwt.client.types.BkgndRepeat;
import com.smartgwt.client.widgets.ViewLoader;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class SmartGWTLoader extends Loader
{

   public static final String LOADER_BACKGROUND = "loader/loader-background.png";

   public static final String LOADER_BACKIMAGE = "loader/loader-background-element.png";

   //public static final String LOADER_PROGRESSIMAGE = "loader/ajax-loader.gif";

   public static final String LOADER_PROGRESSIMAGE = "loader/ajax-loader-new.gif";

   private ViewLoader loader;

   /**
    * Create SmartGWT loader
    */
   public SmartGWTLoader()
   {
      String loadingMessage = getMessage();

      String message =
         "<div class=\"loader-element\" style=\"background-image: url('" + UIHelper.getGadgetImagesURL()
            + LOADER_BACKIMAGE + "');\">" + "<br>" + "<img src=\"" + UIHelper.getGadgetImagesURL()
            + LOADER_PROGRESSIMAGE + "\">" + "<br><br><span id=\"eXoLoaderMessageElement\">" + loadingMessage
            + "</span></div>";

      loader = new ViewLoader();
      loader.setLoadingMessage(message);
      loader.setBackgroundImage(UIHelper.getGadgetImagesURL() + LOADER_BACKGROUND);
      loader.setBackgroundRepeat(BkgndRepeat.REPEAT);

      loader.setWidth100();
      loader.setHeight100();
   }

   public void show()
   {
      loader.show();
      String message = getMessage();
      DOM.getElementById("eXoLoaderMessageElement").setInnerText(message);
      loader.setZIndex(Integer.MAX_VALUE - 1);
   }

   public void hide()
   {
      loader.hide();
   }

}
