/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.connector;

import com.ibm.icu.text.Transliterator;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/l11n/")
public class LocalizationConnector
implements ResourceContainer {
    private static final String LAST_MODIFIED_PROPERTY = "Last-Modified";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String IF_MODIFIED_SINCE_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";

    @GET
    @Path(value="/cleanName/")
    public Response getCleanName(@QueryParam(value="name") String name) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        try {
            return Response.ok((Object)LocalizationConnector.cleanString(name)).header(CONTENT_TYPE, (Object)"text/html; charset=utf-8").header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
        catch (Exception e) {
            Response.serverError().build();
            return Response.ok().header(CONTENT_TYPE, (Object)"text/html; charset=utf-8").header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
    }

    private static String cleanString(String str) {
        Transliterator accentsconverter = Transliterator.getInstance((String)"Latin; NFD; [:Nonspacing Mark:] Remove; NFC;");
        str = accentsconverter.transliterate(str);
        StringBuffer cleanedStr = new StringBuffer(str.trim());
        for (int i = 0; i < cleanedStr.length(); ++i) {
            char c = cleanedStr.charAt(i);
            if (c == ' ') {
                if (i > 0 && cleanedStr.charAt(i - 1) == '-') {
                    cleanedStr.deleteCharAt(i--);
                    continue;
                }
                c = '-';
                cleanedStr.setCharAt(i, c);
                continue;
            }
            if (i > 0 && !Character.isLetterOrDigit(c) && c != '-') {
                cleanedStr.deleteCharAt(i--);
                continue;
            }
            if (i <= 0 || c != 45 || cleanedStr.charAt(i - 1) != '-') continue;
            cleanedStr.deleteCharAt(i--);
        }
        String clean = cleanedStr.toString().toLowerCase();
        if (clean.endsWith("-")) {
            clean = clean.substring(0, clean.length() - 1);
        }
        return clean;
    }
}

