/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.service.impl;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMultipart;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.Attachment;
import org.exoplatform.mail.service.BufferAttachment;
import org.exoplatform.mail.service.DataStorage;
import org.exoplatform.mail.service.Folder;
import org.exoplatform.mail.service.Info;
import org.exoplatform.mail.service.JCRMessageAttachment;
import org.exoplatform.mail.service.MailSetting;
import org.exoplatform.mail.service.Message;
import org.exoplatform.mail.service.MessageFilter;
import org.exoplatform.mail.service.MessagePageList;
import org.exoplatform.mail.service.MimeMessageParser;
import org.exoplatform.mail.service.SpamFilter;
import org.exoplatform.mail.service.Tag;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.value.JsonValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRDataStorage
implements DataStorage {
    private static final Log logger = ExoLogger.getLogger((String)"cs.mail.service");
    public static final String MAIL_HAS_ATTACHMENT_MIME_TYPE = "multipart/mixed";
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private RepositoryService repoService_;
    private static final String MAIL_SERVICE = "MailApplication";
    private static final String MAIL_DELEGATE = "DelegationAccount";

    public JCRDataStorage(NodeHierarchyCreator nodeHierarchyCreator, RepositoryService repoService) {
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.repoService_ = repoService;
    }

    @Override
    public String getMailHierarchyNode() throws Exception {
        return this.nodeHierarchyCreator_.getJcrPath("usersPath");
    }

    @Override
    public Node getMailHomeNode(SessionProvider sProvider, String username) throws Exception {
        if (sProvider == null) {
            sProvider = this.createSystemProvider();
        }
        Node userApp = this.getNodeByPath(this.nodeHierarchyCreator_.getUserApplicationNode(sProvider, username).getPath(), sProvider);
        Node mailNode = null;
        try {
            mailNode = userApp.getNode(MAIL_SERVICE);
        }
        catch (PathNotFoundException e) {
            mailNode = userApp.addNode(MAIL_SERVICE, Utils.NT_UNSTRUCTURED);
            if (userApp.isNew()) {
                userApp.getSession().save();
            }
            userApp.save();
        }
        return mailNode;
    }

    private Node getDelegationHomeNode() throws Exception {
        SessionProvider sProvider = Utils.createSystemProvider();
        Node publicApp = this.getNodeByPath(this.nodeHierarchyCreator_.getPublicApplicationNode(sProvider).getPath(), sProvider);
        Node node = null;
        try {
            node = publicApp.getNode(MAIL_DELEGATE);
        }
        catch (PathNotFoundException e) {
            node = publicApp.addNode(MAIL_DELEGATE, NT_UNSTRUCTURED);
            publicApp.getSession().save();
        }
        return node;
    }

    @Override
    public void delegateAccount(String username, String reciver, String accountId) throws Exception {
        block11: {
            Node tempNode = null;
            SessionProvider sProvider = this.createSessionProvider();
            try {
                Node accountNode = this.getMailHomeNode(sProvider, username).getNode(accountId);
                Value[] values = new Value[]{};
                if (accountNode.isNodeType(EXO_SHARED_MIXIN)) {
                    values = accountNode.getProperty(EXO_SHARED_ID).getValues();
                }
                ArrayList<Value> valueList = new ArrayList<Value>();
                for (Value v : values) {
                    valueList.add(v);
                }
                try {
                    tempNode = this.getDelegationHomeNode().getNode(reciver);
                }
                catch (PathNotFoundException e) {
                    tempNode = this.getDelegationHomeNode().addNode(reciver, NT_UNSTRUCTURED);
                    if (tempNode.canAddMixin(MIX_REFERENCEABLE)) {
                        tempNode.addMixin(MIX_REFERENCEABLE);
                    }
                    tempNode.getSession().save();
                }
                boolean isExist = false;
                isExist = false;
                for (Value v : values) {
                    Node refNode = tempNode.getSession().getNodeByUUID(v.getString());
                    if (!refNode.getPath().equals(tempNode.getPath())) continue;
                    isExist = true;
                    break;
                }
                if (!isExist) {
                    Value newValue = accountNode.getSession().getValueFactory().createValue(tempNode);
                    valueList.add(newValue);
                }
                if (valueList.size() > 0) {
                    if (!accountNode.isNodeType(EXO_SHARED_MIXIN)) {
                        accountNode.addMixin(EXO_SHARED_MIXIN);
                    }
                    accountNode.setProperty(EXO_SHARED_ID, valueList.toArray(new Value[valueList.size()]));
                    accountNode.getSession().save();
                    this.getDelegationHomeNode().getSession().save();
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block11;
                logger.debug((Object)(" Delegate account error :  " + e.getMessage()));
            }
        }
    }

    @Override
    public List<Account> getDelegateAccounts(String userId) throws Exception {
        ArrayList<Account> accList;
        block4: {
            accList = new ArrayList<Account>();
            if (this.getDelegationHomeNode().hasNode(userId)) {
                SessionProvider sProvider = this.createSessionProvider();
                try {
                    Node tempNode = this.getDelegationHomeNode().getNode(userId);
                    PropertyIterator iter = tempNode.getReferences();
                    while (iter.hasNext()) {
                        Node accountNode = iter.nextProperty().getParent();
                        Account acc = this.getAccount(sProvider, accountNode);
                        acc.setDelegateFrom(accountNode.getParent().getParent().getParent().getName());
                        accList.add(acc);
                    }
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Object)e.getMessage());
                }
            }
        }
        return accList;
    }

    @Override
    public void removeDelegateAccount(String userId, String accountId) throws Exception {
        if (this.getDelegationHomeNode().hasNode(userId)) {
            Node tempNode = this.getDelegationHomeNode().getNode(userId);
            String uuid = tempNode.getProperty(JCR_UUID).getString();
            PropertyIterator iter = tempNode.getReferences();
            while (iter.hasNext()) {
                Value[] values;
                ArrayList<Value> newValues = new ArrayList<Value>();
                Node accountNode = iter.nextProperty().getParent();
                if (!accountNode.getProperty(Utils.EXO_ID).getString().equals(accountId)) continue;
                for (Value value : values = accountNode.getProperty(EXO_SHARED_ID).getValues()) {
                    if (value.getString().equals(uuid)) continue;
                    newValues.add(value);
                }
                accountNode.setProperty(EXO_SHARED_ID, newValues.toArray(new Value[newValues.size()]));
                accountNode.save();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Account getAccountById(String username, String id) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            Node mailHome = this.getMailHomeNode(sProvider, username);
            if (mailHome.hasNode(id)) {
                Account account = this.getAccount(sProvider, mailHome.getNode(id));
                return account;
            }
            Account account = null;
            return account;
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Account> getAccounts(String username) throws Exception {
        SessionProvider sProvider = null;
        ArrayList<Account> accounts = new ArrayList<Account>();
        try {
            sProvider = this.createSessionProvider();
            Node homeNode = this.getMailHomeNode(sProvider, username);
            if (homeNode == null) {
                ArrayList<Account> arrayList = accounts;
                return arrayList;
            }
            NodeIterator it = homeNode.getNodes();
            while (it.hasNext()) {
                Node node = it.nextNode();
                if (!node.isNodeType("exo:account")) continue;
                accounts.add(this.getAccount(sProvider, node));
            }
            ArrayList<Account> arrayList = accounts;
            return arrayList;
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    @Override
    public Account getAccount(SessionProvider sProvider, Node accountNode) throws Exception {
        Account account;
        block37: {
            int index;
            String property;
            int i;
            Value[] properties;
            GregorianCalendar cal;
            account = new Account();
            account.setId(accountNode.getProperty(Utils.EXO_ID).getString());
            try {
                account.setLabel(accountNode.getProperty(Utils.EXO_LABEL).getString());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                account.setUserDisplayName(accountNode.getProperty(Utils.EXO_USERDISPLAYNAME).getString());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                account.setEmailAddress(accountNode.getProperty(Utils.EXO_EMAILADDRESS).getString());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                account.setEmailReplyAddress(accountNode.getProperty(Utils.EXO_REPLYEMAIL).getString());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                account.setSignature(accountNode.getProperty(Utils.EXO_SIGNATURE).getString());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                account.setDescription(accountNode.getProperty(Utils.EXO_DESCRIPTION).getString());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                account.setCheckedAuto(accountNode.getProperty(Utils.EXO_CHECKMAILAUTO).getBoolean());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                account.setIsSavePassword(accountNode.getProperty(Utils.EXO_IS_SAVE_PASSWORD).getBoolean());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                account.setEmptyTrashWhenExit(accountNode.getProperty(Utils.EXO_EMPTYTRASH).getBoolean());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                account.setPlaceSignature(accountNode.getProperty(Utils.EXO_PLACESIGNATURE).getString());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                cal = new GregorianCalendar();
                cal.setTimeInMillis(accountNode.getProperty(Utils.EXO_LAST_CHECKED_TIME).getLong());
                account.setLastCheckedDate(cal.getTime());
            }
            catch (Exception e) {
                account.setLastCheckedDate(null);
            }
            try {
                cal = new GregorianCalendar();
                cal.setTimeInMillis(accountNode.getProperty(Utils.EXO_LAST_START_CHECKING_TIME).getLong());
                account.setLastStartCheckingTime(cal.getTime());
            }
            catch (Exception e) {
                account.setLastStartCheckingTime(null);
            }
            try {
                account.setCheckAll(accountNode.getProperty(Utils.EXO_CHECK_ALL).getBoolean());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                cal = new GregorianCalendar();
                cal.setTimeInMillis(accountNode.getProperty(Utils.EXO_CHECK_FROM_DATE).getLong());
                account.setCheckFromDate(cal.getTime());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                properties = accountNode.getProperty(Utils.EXO_SERVERPROPERTIES).getValues();
                for (i = 0; i < properties.length; ++i) {
                    property = properties[i].getString();
                    index = property.indexOf(61);
                    if (index == -1) continue;
                    account.setServerProperty(property.substring(0, index), property.substring(index + 1));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                properties = accountNode.getProperty(Utils.EXO_SMTPSERVERPROPERTIES).getValues();
                for (i = 0; i < properties.length; ++i) {
                    property = properties[i].getString();
                    index = property.indexOf(61);
                    if (index == -1) continue;
                    account.setSmtpServerProperty(property.substring(0, index), property.substring(index + 1));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                account.setSecureAuthsIncoming(accountNode.getProperty(Utils.EXO_SECURE_AUTHS_INCOMING).getString());
                account.setSecureAuthsOutgoing(accountNode.getProperty(Utils.EXO_SECURE_AUTHS_OUTGOING).getString());
                account.setAuthMechsIncoming(accountNode.getProperty(Utils.EXO_AUTH_MECHS_INCOMING).getString());
                account.setAuthMechsOutgoing(accountNode.getProperty(Utils.EXO_AUTH_MECHS_OUTGOING).getString());
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block37;
                logger.debug((Object)("Not all options of " + account.getLabel() + " get completely."), (Throwable)e);
            }
        }
        if (accountNode.hasProperty(Utils.EXO_PERMISSIONS)) {
            Value[] values = accountNode.getProperty(Utils.EXO_PERMISSIONS).getValues();
            account.setPermissions(this.valuesToMap(values));
        }
        return account;
    }

    private Map<String, String> valuesToMap(Value[] val) throws Exception {
        HashMap<String, String> map;
        block3: {
            map = new HashMap<String, String>();
            try {
                for (Value v : val) {
                    map.put(v.getString().split(":")[0], v.getString().split(":")[1]);
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug((Object)"no permission");
            }
        }
        return map;
    }

    private String[] mapToStrings(Map<String, String> map) throws Exception {
        StringBuilder s;
        block3: {
            s = new StringBuilder();
            try {
                for (String key : map.keySet()) {
                    s.append(key).append(":").append(map.get(key)).append("/");
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug((Object)"permission empty");
            }
        }
        return s.toString().split("/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message getMessageById(String username, String accountId, String msgId) throws Exception {
        SessionProvider sProvider = null;
        try {
            Message msg;
            sProvider = this.createSessionProvider();
            Node accountNode = this.getMailHomeNode(sProvider, username).getNode(accountId);
            StringBuffer queryString = new StringBuffer("/jcr:root" + accountNode.getPath() + "//element(*,exo:message)[@exo:id='").append(msgId).append("']");
            QueryImpl queryImpl = this.createXPathQuery(sProvider, username, accountId, queryString.toString());
            queryImpl.setOffset(0L);
            queryImpl.setLimit(1L);
            QueryResult result = queryImpl.execute();
            NodeIterator it = result.getNodes();
            if (!it.hasNext()) {
                Message message = null;
                return message;
            }
            Message message = msg = this.getMessage(it.nextNode());
            return message;
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    @Override
    public QueryImpl createXPathQuery(SessionProvider sProvider, String username, String accountId, String xpath) throws Exception {
        Session sess = this.getSession(sProvider);
        QueryManager queryManager = sess.getWorkspace().getQueryManager();
        return (QueryImpl)queryManager.createQuery(xpath, "xpath");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MailSetting getMailSetting(String username) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            Node homeNode = this.getMailHomeNode(sProvider, username);
            Node settingNode = null;
            if (homeNode.hasNode(Utils.KEY_MAIL_SETTING)) {
                settingNode = homeNode.getNode(Utils.KEY_MAIL_SETTING);
            }
            MailSetting setting = new MailSetting();
            if (settingNode != null) {
                try {
                    setting.setNumberMsgPerPage(settingNode.getProperty(Utils.EXO_NUMBER_MSG_PER_PAGE).getLong());
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    setting.setPeriodCheckAuto(settingNode.getProperty(Utils.EXO_PERIOD_CHECKMAIL_AUTO).getLong());
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    setting.setDefaultAccount(settingNode.getProperty(Utils.EXO_DEFAULT_ACCOUNT).getString());
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    setting.setUseWysiwyg(settingNode.getProperty(Utils.EXO_USE_WYSIWYG).getBoolean());
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    setting.setFormatAsOriginal(settingNode.getProperty(Utils.EXO_FORMAT_AS_ORIGINAL).getBoolean());
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    setting.setReplyWithAttach(settingNode.getProperty(Utils.EXO_REPLY_WITH_ATTACH).getBoolean());
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    setting.setForwardWithAtt(settingNode.getProperty(Utils.EXO_FORWARD_WITH_ATTACH).getBoolean());
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    setting.setPrefixMessageWith(settingNode.getProperty(Utils.EXO_PREFIX_MESSAGE_WITH).getString());
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    setting.setSaveMessageInSent(settingNode.getProperty(Utils.EXO_SAVE_SENT_MESSAGE).getBoolean());
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    setting.setLayout(settingNode.getProperty(Utils.EXO_LAYOUT).getLong());
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    setting.setSendReturnReceipt(settingNode.getProperty(Utils.EXO_RETURN_RECEIPT).getLong());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            MailSetting mailSetting = setting;
            return mailSetting;
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessagePageList getMessagePageList(String username, MessageFilter filter) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            Node homeMsg = this.getMessageHome(sProvider, username, filter.getAccountId());
            filter.setAccountPath(homeMsg.getPath());
            long pageSize = this.getMailSetting(username).getNumberMsgPerPage();
            MessagePageList messagePageList = new MessagePageList(pageSize, filter.getStatement(), filter.hasStructure());
            return messagePageList;
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Message> getMessages(String username, MessageFilter filter) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            Node homeMsg = this.getMessageHome(sProvider, username, filter.getAccountId());
            if (homeMsg == null) {
                ArrayList<Message> arrayList = new ArrayList<Message>();
                return arrayList;
            }
            filter.setAccountPath(homeMsg.getPath());
            QueryManager qm = this.getSession(sProvider).getWorkspace().getQueryManager();
            String queryString = filter.getStatement();
            Query query = qm.createQuery(queryString, "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ArrayList<Message> strList = new ArrayList<Message>();
            while (iter.hasNext()) {
                Node node = iter.nextNode();
                strList.add(this.getMessage(node));
            }
            ArrayList<Message> arrayList = strList;
            return arrayList;
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    @Override
    public Message getMessage(Node messageNode) throws Exception {
        return Utils.getMessage(messageNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAccount(String username, String accountId) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            Node homeNode = this.getMailHomeNode(sProvider, username);
            if (homeNode.hasNode(accountId)) {
                homeNode.getNode(accountId).remove();
                homeNode.getSession().save();
            }
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMessage(String username, String accountId, Message message) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            Node msgStoreNode = this.getDateStoreNode(sProvider, username, accountId, message.getReceivedDate());
            try {
                Node node = msgStoreNode.getNode(message.getId());
                if (node != null) {
                    node = this.moveReference(accountId, node);
                    NodeType[] nts = node.getMixinNodeTypes();
                    for (int i = 0; i < nts.length; ++i) {
                        node.removeMixin(nts[i].getName());
                    }
                    node.remove();
                    msgStoreNode.save();
                }
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMessages(String username, String accountId, List<Message> messages, boolean moveReference) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            for (Message message : messages) {
                Node msgStoreNode = this.getDateStoreNode(sProvider, username, accountId, message.getReceivedDate());
                try {
                    Node node = msgStoreNode.getNode(message.getId());
                    if (node != null) {
                        if (moveReference) {
                            node = this.moveReference(accountId, node);
                        }
                        NodeType[] nts = node.getMixinNodeTypes();
                        for (int i = 0; i < nts.length; ++i) {
                            node.removeMixin(nts[i].getName());
                        }
                        node.remove();
                    }
                }
                catch (PathNotFoundException e) {
                    // empty catch block
                }
                msgStoreNode.save();
            }
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveMessages(String username, String accountId, List<Message> msgList, String currentFolderId, String destFolderId) throws Exception {
        SessionProvider sProvider = null;
        try {
            Node destFolderNode;
            Node currentFolderNode;
            block33: {
                int deTotalMessage;
                int inTotalMessage;
                block32: {
                    sProvider = this.createSessionProvider();
                    Node messageHome = this.getMessageHome(sProvider, username, accountId);
                    currentFolderNode = this.getFolderNodeById(sProvider, username, accountId, currentFolderId);
                    destFolderNode = this.getFolderNodeById(sProvider, username, accountId, destFolderId);
                    int inUnreadNumber = 0;
                    int deUnreadNumber = 0;
                    inTotalMessage = 0;
                    deTotalMessage = 0;
                    for (Message msg : msgList) {
                        try {
                            Node msgNode = (Node)messageHome.getSession().getItem(msg.getPath());
                            boolean isUnread = msgNode.getProperty(Utils.EXO_ISUNREAD).getBoolean();
                            String sentFolderId = Utils.generateFID(accountId, Utils.FD_SENT, false);
                            Value[] propFolders = msgNode.getProperty(Utils.MSG_FOLDERS).getValues();
                            boolean moveReference = true;
                            String[] folderIds = new String[propFolders.length];
                            if (propFolders.length == 1) {
                                if (destFolderId.equals(sentFolderId)) {
                                    folderIds[0] = sentFolderId;
                                    if (!propFolders[0].getString().equals(sentFolderId)) {
                                        if (isUnread) {
                                            ++inUnreadNumber;
                                            ++deUnreadNumber;
                                        }
                                        ++deTotalMessage;
                                        ++inTotalMessage;
                                    } else {
                                        if (isUnread) {
                                            ++inUnreadNumber;
                                        }
                                        ++inTotalMessage;
                                    }
                                    moveReference = false;
                                } else {
                                    folderIds[0] = destFolderId;
                                    if (propFolders[0].getString().equals(sentFolderId)) {
                                        if (isUnread) {
                                            ++inUnreadNumber;
                                        }
                                        ++inTotalMessage;
                                    } else if (!currentFolderId.equals(destFolderId)) {
                                        if (isUnread) {
                                            ++inUnreadNumber;
                                            ++deUnreadNumber;
                                        }
                                        ++deTotalMessage;
                                        ++inTotalMessage;
                                    }
                                }
                            } else {
                                for (int i = 0; i < propFolders.length; ++i) {
                                    String folderId = propFolders[i].getString();
                                    folderIds[i] = currentFolderId.equals(folderId) ? destFolderId : folderId;
                                }
                                if (isUnread) {
                                    ++inUnreadNumber;
                                    ++deUnreadNumber;
                                }
                                ++deTotalMessage;
                                ++inTotalMessage;
                            }
                            msgNode.setProperty(Utils.MSG_FOLDERS, folderIds);
                            msgNode.setProperty(Utils.EXO_UID, msg.getUID());
                            if (moveReference) {
                                msgNode = this.moveReference(accountId, msgNode);
                            }
                            msgNode.save();
                        }
                        catch (Exception e) {
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Object)"Exception in method moveMessages", (Throwable)e);
                        }
                    }
                    try {
                        if (currentFolderNode != null) {
                            currentFolderNode.setProperty(Utils.EXO_UNREADMESSAGES, currentFolderNode.getProperty(Utils.EXO_UNREADMESSAGES).getLong() - (long)deUnreadNumber);
                        }
                        if (destFolderNode != null) {
                            destFolderNode.setProperty(Utils.EXO_UNREADMESSAGES, destFolderNode.getProperty(Utils.EXO_UNREADMESSAGES).getLong() + (long)inUnreadNumber);
                        }
                    }
                    catch (Exception e) {
                        if (!logger.isDebugEnabled()) break block32;
                        logger.debug((Object)"Exception in method moveMessages", (Throwable)e);
                    }
                }
                try {
                    if (currentFolderNode != null) {
                        currentFolderNode.setProperty(Utils.EXO_TOTALMESSAGE, currentFolderNode.getProperty(Utils.EXO_TOTALMESSAGE).getLong() - (long)deTotalMessage);
                    }
                    if (destFolderNode != null) {
                        destFolderNode.setProperty(Utils.EXO_TOTALMESSAGE, destFolderNode.getProperty(Utils.EXO_TOTALMESSAGE).getLong() + (long)inTotalMessage);
                    }
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block33;
                    logger.debug((Object)"Exception in method moveMessages", (Throwable)e);
                }
            }
            if (currentFolderNode != null) {
                currentFolderNode.save();
            }
            if (destFolderNode != null) {
                destFolderNode.save();
            }
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    @Override
    public void moveMessage(String username, String accountId, Message msg, String currentFolderId, String destFolderId, boolean updateReference) throws Exception {
        ArrayList<Message> msgList = new ArrayList<Message>();
        msgList.add(msg);
        this.moveMessages(username, accountId, msgList, currentFolderId, destFolderId, updateReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveMessages(String username, String accountId, List<Message> msgList, String currentFolderId, String destFolderId, boolean updateReference) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            Node messageHome = this.getMessageHome(sProvider, username, accountId);
            Node currentFolderNode = this.getFolderNodeById(sProvider, username, accountId, currentFolderId);
            Node destFolderNode = this.getFolderNodeById(sProvider, username, accountId, destFolderId);
            int inUnreadNumber = 0;
            int inTotalMessage = 0;
            for (Message msg : msgList) {
                Node msgNode = (Node)messageHome.getSession().getItem(msg.getPath());
                if (updateReference) {
                    msgNode = this.moveReference(accountId, msgNode);
                }
                try {
                    Boolean isUnread = msgNode.getProperty(Utils.EXO_ISUNREAD).getBoolean();
                    Value[] propFolders = msgNode.getProperty(Utils.MSG_FOLDERS).getValues();
                    String[] folderIds = new String[propFolders.length];
                    for (int i = 0; i < propFolders.length; ++i) {
                        String folderId = propFolders[i].getString();
                        folderIds[i] = currentFolderId.equals(folderId) ? destFolderId : folderId;
                    }
                    msgNode.setProperty(Utils.MSG_FOLDERS, folderIds);
                    msgNode.setProperty(Utils.EXO_UID, msg.getUID());
                    if (isUnread.booleanValue()) {
                        ++inUnreadNumber;
                    }
                    ++inTotalMessage;
                    msgNode.save();
                }
                catch (Exception e) {}
            }
            try {
                if (currentFolderNode != null) {
                    currentFolderNode.setProperty(Utils.EXO_UNREADMESSAGES, currentFolderNode.getProperty(Utils.EXO_UNREADMESSAGES).getLong() - (long)inUnreadNumber);
                }
                if (destFolderNode != null) {
                    destFolderNode.setProperty(Utils.EXO_UNREADMESSAGES, destFolderNode.getProperty(Utils.EXO_UNREADMESSAGES).getLong() + (long)inUnreadNumber);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (currentFolderNode != null) {
                    currentFolderNode.setProperty(Utils.EXO_TOTALMESSAGE, currentFolderNode.getProperty(Utils.EXO_TOTALMESSAGE).getLong() - (long)inTotalMessage);
                }
                if (destFolderNode != null) {
                    destFolderNode.setProperty(Utils.EXO_TOTALMESSAGE, destFolderNode.getProperty(Utils.EXO_TOTALMESSAGE).getLong() + (long)inTotalMessage);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (currentFolderNode != null) {
                currentFolderNode.save();
            }
            if (destFolderNode != null) {
                destFolderNode.save();
            }
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveAccount(String username, Account account, boolean isNew) throws Exception {
        SessionProvider sysProvider = null;
        try {
            sysProvider = this.createSessionProvider();
            Node mailHome = this.getMailHomeNode(sysProvider, username);
            Node newAccount = null;
            String accId = account.getId();
            if (isNew) {
                newAccount = mailHome.addNode(accId, Utils.EXO_ACCOUNT);
                mailHome.save();
                newAccount.setProperty(Utils.EXO_ID, accId);
            } else {
                try {
                    newAccount = mailHome.getNode(accId);
                }
                catch (Exception e) {
                    this.closeSessionProvider(sysProvider);
                    return;
                }
            }
            if (newAccount != null) {
                String key;
                newAccount.setProperty(Utils.EXO_LABEL, account.getLabel());
                newAccount.setProperty(Utils.EXO_USERDISPLAYNAME, account.getUserDisplayName());
                newAccount.setProperty(Utils.EXO_EMAILADDRESS, account.getEmailAddress());
                newAccount.setProperty(Utils.EXO_REPLYEMAIL, account.getEmailReplyAddress());
                newAccount.setProperty(Utils.EXO_SIGNATURE, account.getSignature());
                newAccount.setProperty(Utils.EXO_DESCRIPTION, account.getDescription());
                newAccount.setProperty(Utils.EXO_CHECKMAILAUTO, account.checkedAuto());
                newAccount.setProperty(Utils.EXO_IS_SAVE_PASSWORD, account.isSavePassword());
                newAccount.setProperty(Utils.EXO_EMPTYTRASH, account.isEmptyTrashWhenExit());
                newAccount.setProperty(Utils.EXO_PLACESIGNATURE, account.getPlaceSignature());
                if (account.getLastCheckedDate() != null) {
                    newAccount.setProperty(Utils.EXO_LAST_CHECKED_TIME, account.getLastCheckedDate().getTime());
                } else {
                    newAccount.setProperty(Utils.EXO_LAST_CHECKED_TIME, (Value)null);
                }
                if (account.getLastStartCheckingTime() != null) {
                    newAccount.setProperty(Utils.EXO_LAST_START_CHECKING_TIME, account.getLastStartCheckingTime().getTime());
                } else {
                    newAccount.setProperty(Utils.EXO_LAST_START_CHECKING_TIME, (Value)null);
                }
                newAccount.setProperty(Utils.EXO_CHECK_ALL, account.isCheckAll());
                if (account.getCheckFromDate() != null) {
                    newAccount.setProperty(Utils.EXO_CHECK_FROM_DATE, account.getCheckFromDate().getTime());
                } else {
                    newAccount.setProperty(Utils.EXO_CHECK_FROM_DATE, (Value)null);
                }
                Iterator<String> it = account.getServerProperties().keySet().iterator();
                ArrayList<String> values = new ArrayList<String>(account.getServerProperties().size());
                while (it.hasNext()) {
                    key = it.next().toString();
                    values.add(key + "=" + account.getServerProperties().get(key));
                }
                newAccount.setProperty(Utils.EXO_SERVERPROPERTIES, values.toArray(new String[account.getServerProperties().size()]));
                if (account.getSmtpServerProperties() != null) {
                    it = account.getSmtpServerProperties().keySet().iterator();
                    values = new ArrayList(account.getSmtpServerProperties().size());
                    while (it.hasNext()) {
                        key = it.next().toString();
                        values.add(key + "=" + account.getSmtpServerProperties().get(key));
                    }
                    newAccount.setProperty(Utils.EXO_SMTPSERVERPROPERTIES, values.toArray(new String[account.getSmtpServerProperties().size()]));
                }
                if (account.isIncomingSsl()) {
                    newAccount.setProperty(Utils.EXO_SECURE_AUTHS_INCOMING, account.getSecureAuthsIncoming());
                    newAccount.setProperty(Utils.EXO_AUTH_MECHS_INCOMING, account.getAuthMechsIncoming());
                }
                if (account.isOutgoingSsl()) {
                    newAccount.setProperty(Utils.EXO_SECURE_AUTHS_OUTGOING, account.getSecureAuthsOutgoing());
                    newAccount.setProperty(Utils.EXO_AUTH_MECHS_OUTGOING, account.getAuthMechsOutgoing());
                }
                if (account.getPermissions() != null) {
                    newAccount.setProperty(Utils.EXO_PERMISSIONS, this.mapToStrings(account.getPermissions()));
                }
                if (isNew) {
                    mailHome.getSession().save();
                } else {
                    mailHome.save();
                }
            }
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e);
            }
        }
        finally {
            this.closeSessionProvider(sysProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveMailSetting(String username, MailSetting newSetting) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            Node mailHome = this.getMailHomeNode(sProvider, username);
            Node settingNode = null;
            try {
                settingNode = mailHome.getNode(Utils.KEY_MAIL_SETTING);
            }
            catch (PathNotFoundException e) {
                settingNode = mailHome.addNode(Utils.KEY_MAIL_SETTING, Utils.EXO_MAIL_SETTING);
                mailHome.save();
            }
            if (settingNode != null) {
                settingNode.setProperty(Utils.EXO_NUMBER_MSG_PER_PAGE, newSetting.getNumberMsgPerPage());
                settingNode.setProperty(Utils.EXO_PERIOD_CHECKMAIL_AUTO, newSetting.getPeriodCheckAuto());
                settingNode.setProperty(Utils.EXO_DEFAULT_ACCOUNT, newSetting.getDefaultAccount());
                settingNode.setProperty(Utils.EXO_FORMAT_AS_ORIGINAL, newSetting.formatAsOriginal());
                settingNode.setProperty(Utils.EXO_USE_WYSIWYG, newSetting.useWysiwyg());
                settingNode.setProperty(Utils.EXO_REPLY_WITH_ATTACH, newSetting.replyWithAttach());
                settingNode.setProperty(Utils.EXO_FORWARD_WITH_ATTACH, newSetting.forwardWithAtt());
                settingNode.setProperty(Utils.EXO_PREFIX_MESSAGE_WITH, newSetting.getPrefixMessageWith());
                settingNode.setProperty(Utils.EXO_SAVE_SENT_MESSAGE, newSetting.saveMessageInSent());
                settingNode.setProperty(Utils.EXO_LAYOUT, newSetting.getLayout());
                settingNode.setProperty(Utils.EXO_RETURN_RECEIPT, newSetting.getSendReturnReceipt());
                settingNode.save();
            }
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveMessage(String username, String accountId, String targetMsgPath, Message message, boolean isNew) throws Exception {
        Node msgNode = this.saveMessage(username, accountId, message, isNew);
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            if (targetMsgPath != null && !targetMsgPath.equals("")) {
                Node mailHome = this.getMailHomeNode(sProvider, username);
                Node targetNode = (Node)mailHome.getSession().getItem(targetMsgPath);
                this.createReference(msgNode, targetNode);
            }
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node saveMessage(String username, String accountId, Message message, boolean isNew) throws Exception {
        Node nodeMsg;
        block27: {
            SessionProvider sProvider = null;
            nodeMsg = null;
            try {
                sProvider = this.createSessionProvider();
                Node mailHome = this.getMailHomeNode(sProvider, username);
                Node homeMsg = this.getDateStoreNode(sProvider, username, accountId, message.getReceivedDate());
                if (isNew) {
                    nodeMsg = homeMsg.addNode(message.getId(), Utils.EXO_MESSAGE);
                    homeMsg.save();
                } else {
                    nodeMsg = (Node)mailHome.getSession().getItem(message.getPath());
                }
                if (nodeMsg == null) break block27;
                String from = "";
                String to = "";
                String cc = "";
                String bcc = "";
                nodeMsg.setProperty(Utils.EXO_ID, message.getId());
                nodeMsg.setProperty(Utils.EXO_UID, message.getUID());
                nodeMsg.setProperty(Utils.EXO_IN_REPLY_TO_HEADER, message.getInReplyToHeader());
                nodeMsg.setProperty(Utils.EXO_ACCOUNT, accountId);
                nodeMsg.setProperty(Utils.EXO_PATH, message.getPath());
                if (!Utils.isEmptyField(message.getFrom())) {
                    from = message.getFrom().replaceAll("\"", "");
                }
                nodeMsg.setProperty(Utils.EXO_FROM, from);
                if (!Utils.isEmptyField(message.getMessageTo())) {
                    to = message.getMessageTo().replaceAll("\"", "");
                }
                nodeMsg.setProperty(Utils.EXO_TO, to);
                nodeMsg.setProperty(Utils.EXO_SUBJECT, message.getSubject());
                if (!Utils.isEmptyField(message.getMessageCc())) {
                    cc = message.getMessageCc().replaceAll("\"", "");
                }
                nodeMsg.setProperty(Utils.EXO_CC, cc);
                if (!Utils.isEmptyField(message.getMessageBcc())) {
                    bcc = message.getMessageBcc().replaceAll("\"", "");
                }
                nodeMsg.setProperty(Utils.EXO_BCC, bcc);
                nodeMsg.setProperty(Utils.EXO_BODY, message.getMessageBody());
                nodeMsg.setProperty(Utils.EXO_REPLYTO, message.getReplyTo());
                nodeMsg.setProperty(Utils.EXO_SIZE, message.getSize());
                nodeMsg.setProperty(Utils.EXO_STAR, message.hasStar());
                nodeMsg.setProperty(Utils.EXO_PRIORITY, message.getPriority());
                nodeMsg.setProperty(Utils.EXO_ISUNREAD, message.isUnread());
                nodeMsg.setProperty(Utils.EXO_IS_ROOT, message.isRootConversation());
                nodeMsg.setProperty(Utils.EXO_CONTENT_TYPE, message.getContentType());
                nodeMsg.setProperty(Utils.ATT_IS_LOADED_PROPERLY, message.attIsLoadedProperly());
                nodeMsg.setProperty(Utils.IS_RETURN_RECEIPT, message.isReturnReceipt());
                if (message.getSendDate() != null) {
                    nodeMsg.setProperty(Utils.EXO_SENDDATE, message.getSendDate().getTime());
                }
                if (message.getReceivedDate() != null) {
                    nodeMsg.setProperty(Utils.EXO_RECEIVEDDATE, message.getReceivedDate().getTime());
                    nodeMsg.setProperty(Utils.EXO_LAST_UPDATE_TIME, message.getReceivedDate().getTime());
                }
                String[] tags = message.getTags();
                nodeMsg.setProperty(Utils.EXO_TAGS, tags);
                String[] folders = message.getFolders();
                nodeMsg.setProperty(Utils.MSG_FOLDERS, folders);
                Iterator<String> ith = message.getHeaders().keySet().iterator();
                ArrayList<String> values = new ArrayList<String>(message.getHeaders().size());
                while (ith.hasNext()) {
                    String key = ith.next().toString();
                    values.add(key + "=" + message.getHeaders().get(key));
                }
                nodeMsg.setProperty(Utils.MSG_HEADERS, values.toArray(new String[message.getHeaders().size()]));
                Node attHome = null;
                try {
                    attHome = nodeMsg.getNode(Utils.KEY_ATTACHMENT);
                }
                catch (PathNotFoundException pne) {
                    attHome = nodeMsg.addNode(Utils.KEY_ATTACHMENT, Utils.NT_UNSTRUCTURED);
                }
                boolean isMailHasAttachment = false;
                List<Attachment> attachments = message.getAttachments();
                Session session = mailHome.getSession();
                if (attachments != null && attachments.size() > 0) {
                    Map<String, JCRMessageAttachment> attachmentInJcrMap = this.getAttachments(nodeMsg);
                    for (JCRMessageAttachment jcrMessageAttachment : attachmentInJcrMap.values()) {
                        Node attachmentNodeToRemove;
                        boolean isExistInMail = false;
                        for (Attachment attachment : attachments) {
                            if (!jcrMessageAttachment.getId().equals(attachment.getId())) continue;
                            isExistInMail = true;
                            attachments.remove(attachment);
                            break;
                        }
                        if (isExistInMail || (attachmentNodeToRemove = (Node)session.getItem(jcrMessageAttachment.getId())) == null) continue;
                        attachmentNodeToRemove.remove();
                    }
                    Iterator<Attachment> it = attachments.iterator();
                    boolean makeNewAtt = isNew;
                    while (it.hasNext()) {
                        Attachment file = it.next();
                        Node nodeFile = null;
                        try {
                            if (!isNew) {
                                nodeFile = (Node)session.getItem(file.getId());
                            }
                        }
                        catch (Exception e) {
                            makeNewAtt = true;
                        }
                        if (makeNewAtt) {
                            nodeFile = attHome.addNode("Attachment" + IdGenerator.generate(), Utils.EXO_MAIL_ATTACHMENT);
                            nodeFile.setProperty(Utils.EXO_ATT_NAME, file.getName());
                        }
                        Node nodeContent = null;
                        nodeContent = !nodeFile.hasNode(Utils.JCR_CONTENT) ? nodeFile.addNode(Utils.JCR_CONTENT, Utils.NT_RESOURCE) : nodeFile.getNode(Utils.JCR_CONTENT);
                        nodeContent.setProperty(Utils.JCR_MIMETYPE, file.getMimeType());
                        nodeContent.setProperty(Utils.JCR_DATA, file.getInputStream());
                        nodeContent.setProperty(Utils.JCR_LASTMODIFIED, Calendar.getInstance().getTimeInMillis());
                        nodeFile.setProperty(Utils.ATT_IS_SHOWN_IN_BODY, file.isShownInBody());
                        if (file.isShownInBody()) continue;
                        isMailHasAttachment = true;
                    }
                } else {
                    attHome.remove();
                }
                nodeMsg.setProperty(Utils.EXO_HASATTACH, isMailHasAttachment);
                if (nodeMsg.canAddMixin("mix:referenceable")) {
                    nodeMsg.addMixin("mix:referenceable");
                }
                nodeMsg.setProperty(Utils.EXO_SUBJECT, message.getSubject());
                nodeMsg.setProperty(Utils.IS_LOADED, message.isLoaded());
                nodeMsg.save();
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Exception in method saveMessages", (Throwable)e);
                }
            }
            finally {
                this.closeSessionProvider(sProvider);
            }
        }
        return nodeMsg;
    }

    @Override
    public boolean saveMessage(String username, String accId, javax.mail.Message msg, String[] folderIds, List<String> tagList, SpamFilter spamFilter, boolean saveTotal, String currentUserName) throws Exception {
        return this.saveMessage(username, accId, msg, folderIds, tagList, spamFilter, null, null, saveTotal, currentUserName);
    }

    @Override
    public boolean saveMessage(String username, String accId, javax.mail.Message msg, String[] folderIds, List<String> tagList, SpamFilter spamFilter, Info infoObj, ContinuationService continuation, boolean saveTotal, String currentUserName) throws Exception {
        return this.saveMessage(username, accId, null, msg, folderIds, tagList, spamFilter, infoObj, continuation, saveTotal, currentUserName);
    }

    @Override
    public boolean saveMessage(String username, String accId, long msgUID, javax.mail.Message msg, String[] folderIds, List<String> tagList, SpamFilter spamFilter, Info infoObj, ContinuationService continuation, boolean saveTotal, String currentUserName) throws Exception {
        long[] messageUID = new long[]{msgUID};
        return this.saveMessage(username, accId, messageUID, msg, folderIds, tagList, spamFilter, infoObj, continuation, saveTotal, currentUserName);
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean saveMessage(String username, String accId, long[] msgUID, javax.mail.Message msg, String[] folderIds, List<String> tagList, SpamFilter spamFilter, Info infoObj, ContinuationService continuation, boolean saveTotal, String currentUserName) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 17[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveTotalMessage(String username, String accId, String msgId, javax.mail.Message msg, SessionProvider sProvider) throws Exception {
        boolean closeProvider = false;
        try {
            if (sProvider == null) {
                sProvider = this.createSessionProvider();
                closeProvider = true;
            }
            Calendar gc = MimeMessageParser.getReceivedDate(msg);
            Node msgHomeNode = this.getDateStoreNode(sProvider, username, accId, gc.getTime());
            Node node = null;
            try {
                node = msgHomeNode.getNode(msgId);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (node != null) {
                try {
                    if (node.getProperty(Utils.IS_LOADED).getBoolean()) {
                        boolean e = true;
                        return e;
                    }
                }
                catch (PathNotFoundException e) {
                    // empty catch block
                }
            } else {
                boolean bl = false;
                return bl;
            }
            node.setProperty(Utils.IS_LOADED, true);
            node.save();
            boolean bl = true;
            return bl;
        }
        finally {
            if (closeProvider) {
                this.closeSessionProvider(sProvider);
            }
        }
    }

    @Override
    public String getAddresses(javax.mail.Message msg, Message.RecipientType type) throws Exception {
        String recipients = "";
        String t = "To";
        if (type.equals(Message.RecipientType.CC)) {
            t = "Cc";
        } else if (type.equals(Message.RecipientType.BCC)) {
            t = "Bcc";
        }
        try {
            recipients = InternetAddress.toString((Address[])msg.getRecipients(type));
        }
        catch (Exception e) {
            String[] ccs = msg.getHeader(t);
            for (int i = 0; i < ccs.length; ++i) {
                if (Utils.isEmptyField(ccs[i])) continue;
                recipients = recipients + ccs[i].replaceAll("\"", "") + ",";
            }
        }
        return Utils.decodeText(recipients);
    }

    @Override
    public void increaseFolderItem(SessionProvider sProvider, String username, String accId, String folderId, boolean isReadMessage) throws Exception {
        try {
            Node node = this.getFolderNodeById(sProvider, username, accId, folderId);
            if (node != null) {
                if (!isReadMessage) {
                    node.setProperty(Utils.EXO_UNREADMESSAGES, node.getProperty(Utils.EXO_UNREADMESSAGES).getLong() + 1L);
                }
                node.setProperty(Utils.EXO_TOTALMESSAGE, node.getProperty(Utils.EXO_TOTALMESSAGE).getLong() + 1L);
                node.save();
            }
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
    }

    public String getContent(Node node, javax.mail.Message msg) throws Exception {
        StringBuffer strBuffer = new StringBuffer();
        Object obj = msg.getContent();
        if (obj instanceof String) {
            strBuffer.append((String)obj);
        } else if (obj instanceof Multipart) {
            Multipart multipart = (Multipart)obj;
            this.setMultiPart(multipart, node, strBuffer);
        } else if (obj instanceof InputStream) {
            strBuffer.append("JCDDataStorage(getContent)It is InputStream");
        }
        node.setProperty(Utils.EXO_CONTENT_TYPE, msg.getContentType());
        node.setProperty(Utils.EXO_BODY, strBuffer.toString());
        node.save();
        return strBuffer.toString();
    }

    @Override
    public StringBuffer setMultiPart(Multipart multipart, Node node, StringBuffer body) {
        try {
            int i;
            boolean readText = true;
            if (multipart.getContentType().toLowerCase().indexOf("multipart/alternative") > -1) {
                for (i = 0; i < multipart.getCount(); ++i) {
                    BodyPart bodyPart = multipart.getBodyPart(i);
                    if (!bodyPart.isMimeType("text/html") && !bodyPart.isMimeType("multipart/*") && !bodyPart.isMimeType("text/calendar")) continue;
                    body = this.setPart((Part)bodyPart, node, body);
                    readText = false;
                }
            }
            if (readText) {
                int n = multipart.getCount();
                for (i = 0; i < n; ++i) {
                    BodyPart part = multipart.getBodyPart(i);
                    body = this.setPart((Part)part, node, body);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return body;
    }

    @Override
    public StringBuffer setPart(Part part, Node node, StringBuffer body) {
        block34: {
            try {
                String disposition = part.getDisposition();
                String ct = part.getContentType();
                if (disposition == null) {
                    if (part.isMimeType("text/plain") || part.isMimeType("text/html")) {
                        body = this.appendMessageBody(part, node, body);
                    } else if (part.isMimeType("multipart/alternative")) {
                        int i;
                        boolean readText = true;
                        MimeMultipart mimeMultiPart = (MimeMultipart)part.getContent();
                        for (i = 0; i < mimeMultiPart.getCount(); ++i) {
                            BodyPart bodyPart = mimeMultiPart.getBodyPart(i);
                            if (!bodyPart.isMimeType("text/html") && !bodyPart.isMimeType("multipart/*")) continue;
                            body = this.setPart((Part)bodyPart, node, body);
                            readText = false;
                        }
                        if (readText) {
                            for (i = 0; i < mimeMultiPart.getCount(); ++i) {
                                body = this.setPart((Part)mimeMultiPart.getBodyPart(i), node, body);
                            }
                        }
                    } else if (part.isMimeType("multipart/*")) {
                        MimeMultipart mimeMultiPart = (MimeMultipart)part.getContent();
                        for (int i = 0; i < mimeMultiPart.getCount(); ++i) {
                            body = this.setPart((Part)mimeMultiPart.getBodyPart(i), node, body);
                        }
                    } else if (part.isMimeType("message/rfc822")) {
                        body = this.getNestedMessageBody(part, node, body);
                    }
                } else if (disposition.equalsIgnoreCase("inline")) {
                    if (part.isMimeType("text/plain") || part.isMimeType("text/html")) {
                        body = this.appendMessageBody(part, node, body);
                    } else if (part.isMimeType("message/rfc822")) {
                        body = this.getNestedMessageBody(part, node, body);
                    }
                }
                if ((disposition == null || !disposition.equalsIgnoreCase("attachment")) && !part.isMimeType("image/*")) break block34;
                Node attHome = null;
                String attId = "";
                try {
                    attHome = node.getNode(Utils.KEY_ATTACHMENT);
                }
                catch (PathNotFoundException e) {
                    attHome = node.addNode(Utils.KEY_ATTACHMENT, Utils.NT_UNSTRUCTURED);
                }
                if (part.getHeader("X-Attachment-Id") != null) {
                    attId = part.getHeader("X-Attachment-Id")[0].toString();
                } else if (part.getHeader("Content-Id") != null) {
                    attId = part.getHeader("Content-Id")[0].toString();
                    attId = attId.substring(1, attId.length());
                    attId = attId.substring(0, attId.length() - 1);
                } else {
                    attId = "Attachment" + IdGenerator.generate();
                }
                if (attHome.hasNode(attId)) {
                    return body;
                }
                Node nodeFile = attHome.addNode(attId, Utils.EXO_MAIL_ATTACHMENT);
                Node nodeContent = nodeFile.addNode(Utils.JCR_CONTENT, Utils.NT_RESOURCE);
                if (ct.indexOf(";") > 0) {
                    String[] type = ct.split(";");
                    nodeContent.setProperty(Utils.JCR_MIMETYPE, type[0]);
                } else {
                    nodeContent.setProperty(Utils.JCR_MIMETYPE, ct);
                }
                try {
                    if (!Utils.isEmptyField(part.getFileName())) {
                        nodeFile.setProperty(Utils.EXO_ATT_NAME, Utils.decodeText(part.getFileName()));
                    } else {
                        nodeFile.setProperty(Utils.EXO_ATT_NAME, "No name");
                    }
                }
                catch (Exception e) {
                    nodeFile.setProperty(Utils.EXO_ATT_NAME, "Corrupted attachment");
                }
                try {
                    nodeContent.setProperty(Utils.JCR_DATA, part.getInputStream());
                    nodeFile.setProperty(Utils.ATT_IS_LOADED_PROPERLY, true);
                    nodeFile.setProperty(Utils.ATT_IS_SHOWN_IN_BODY, false);
                }
                catch (Exception e) {
                    nodeContent.setProperty(Utils.JCR_DATA, (InputStream)new ByteArrayInputStream("".getBytes()));
                    nodeFile.setProperty(Utils.ATT_IS_LOADED_PROPERLY, false);
                    node.setProperty(Utils.ATT_IS_LOADED_PROPERLY, false);
                }
                nodeContent.setProperty(Utils.JCR_LASTMODIFIED, Calendar.getInstance().getTimeInMillis());
                node.setProperty(Utils.EXO_HASATTACH, true);
            }
            catch (Exception e) {
                logger.warn((Object)e);
            }
        }
        return body;
    }

    @Override
    public StringBuffer getNestedMessageBody(Part part, Node node, StringBuffer body) throws Exception {
        try {
            body = this.setPart((Part)part.getContent(), node, body);
        }
        catch (ClassCastException e) {
            Object obj = part.getContent();
            if (obj instanceof String) {
                body.append(obj);
            }
            if (obj instanceof InputStream) {
                int c;
                StringBuffer sb = new StringBuffer();
                InputStream is = (InputStream)obj;
                while ((c = is.read()) != -1) {
                    sb.append(c);
                }
                body.append(sb);
            }
            if (obj instanceof Multipart) {
                body = this.setMultiPart((Multipart)obj, node, body);
            }
            logger.debug((Object)"This is a unknown type.");
        }
        return body;
    }

    @Override
    public StringBuffer appendMessageBody(Part part, Node node, StringBuffer body) throws Exception {
        String inputLine;
        StringBuffer messageBody = new StringBuffer();
        InputStream is = part.getInputStream();
        String ct = part.getContentType();
        String charset = "UTF-8";
        if (ct != null) {
            String cs = new ContentType(ct).getParameter("charset");
            boolean convertCharset = true;
            for (int i = 0; i < Utils.NOT_SUPPORTED_CHARSETS.length; ++i) {
                if (cs == null || !cs.equalsIgnoreCase(Utils.NOT_SUPPORTED_CHARSETS[i])) continue;
                convertCharset = false;
            }
            if (cs != null && convertCharset) {
                charset = cs;
            }
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, charset));
        String breakLine = "";
        if (part.isMimeType("text/plain")) {
            breakLine = "\n";
        }
        while ((inputLine = reader.readLine()) != null) {
            messageBody.append(inputLine + breakLine);
        }
        if (part.isMimeType("text/plain")) {
            if (body != null && !body.equals("")) {
                body.append("\n").append(Utils.encodeHTML(messageBody.toString()));
            } else {
                body = new StringBuffer(Utils.encodeHTML(messageBody.toString()));
            }
        } else if (part.isMimeType("text/html")) {
            if (body != null && !body.equals("")) {
                body.append("<br>").append(messageBody);
            } else {
                body = messageBody;
            }
        }
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Folder getFolder(String username, String accountId, String folderId) throws Exception {
        SessionProvider sProvider = null;
        Folder folder = null;
        try {
            sProvider = this.createSessionProvider();
            Node node = this.getFolderNodeById(sProvider, username, accountId, folderId);
            if (node != null) {
                folder = this.getFolder(node);
            }
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
        return folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getFolderParentId(String username, String accountId, String folderId) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            Node parentNode = this.getFolderNodeById(sProvider, username, accountId, folderId).getParent();
            try {
                if (parentNode != null) {
                    String string = parentNode.getProperty(Utils.EXO_ID).getString();
                    return string;
                }
                String string = null;
                return string;
            }
            catch (PathNotFoundException e) {
                String string = null;
                return string;
            }
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    @Override
    public Node getFolderNodeById(SessionProvider sProvider, String username, String accountId, String folderId) throws Exception {
        Node accountNode = this.getMailHomeNode(sProvider, username).getNode(accountId);
        Session sess = this.getSession(sProvider);
        QueryManager qm = sess.getWorkspace().getQueryManager();
        StringBuffer queryString = new StringBuffer("/jcr:root" + accountNode.getPath() + "//element(*,exo:folder)[@exo:id='").append(folderId).append("']");
        QueryImpl query = (QueryImpl)qm.createQuery(queryString.toString(), "xpath");
        query.setOffset(0L);
        query.setLimit(1L);
        QueryResult result = query.execute();
        NodeIterator it = result.getNodes();
        Node node = null;
        if (it.hasNext()) {
            node = it.nextNode();
        }
        return node;
    }

    @Override
    public Folder getFolder(Node node) throws Exception {
        GregorianCalendar cal;
        Folder folder = new Folder();
        folder.setId(node.getProperty(Utils.EXO_ID).getString());
        folder.setURLName(node.getProperty(Utils.EXO_LABEL).getString());
        folder.setPath(node.getPath());
        folder.setName(node.getProperty(Utils.EXO_NAME).getString());
        folder.setPersonalFolder(node.getProperty(Utils.EXO_PERSONAL).getBoolean());
        folder.setType(node.getProperty(Utils.EXO_FOLDERTYPE).getLong());
        folder.setNumberOfUnreadMessage(node.getProperty(Utils.EXO_UNREADMESSAGES).getLong());
        folder.setTotalMessage(node.getProperty(Utils.EXO_TOTALMESSAGE).getLong());
        try {
            cal = new GregorianCalendar();
            cal.setTimeInMillis(node.getProperty(Utils.EXO_LAST_CHECKED_TIME).getLong());
            folder.setLastCheckedDate(cal.getTime());
        }
        catch (Exception e) {
            folder.setLastCheckedDate(null);
        }
        try {
            cal = new GregorianCalendar();
            cal.setTimeInMillis(node.getProperty(Utils.EXO_LAST_START_CHECKING_TIME).getLong());
            folder.setLastStartCheckingTime(cal.getTime());
        }
        catch (Exception e) {
            folder.setLastStartCheckingTime(null);
        }
        try {
            cal = new GregorianCalendar();
            cal.setTimeInMillis(node.getProperty(Utils.EXO_CHECK_FROM_DATE).getLong());
            folder.setCheckFromDate(cal.getTime());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Folder> getFolders(String username, String accountId) throws Exception {
        SessionProvider sProvider = null;
        ArrayList<Folder> folders = new ArrayList<Folder>();
        try {
            sProvider = this.createSessionProvider();
            Node folderHomeNode = this.getFolderHome(sProvider, username, accountId);
            NodeIterator iter = folderHomeNode.getNodes();
            while (iter.hasNext()) {
                Node folder = (Node)iter.next();
                folders.add(this.getFolder(username, accountId, folder.getName()));
            }
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
        return folders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveFolder(String username, String accountId, Folder folder) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            Node home = this.getFolderHome(sProvider, username, accountId);
            Node myFolder = null;
            Node node = this.getFolderNodeById(sProvider, username, accountId, folder.getId());
            if (node != null) {
                myFolder = node;
            } else {
                myFolder = home.addNode(folder.getId(), Utils.EXO_FOLDER);
                home.save();
            }
            this.saveFolderNode(myFolder, folder);
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExistFolder(String username, String accountId, String parentId, String folderName) throws Exception {
        SessionProvider sProvider = null;
        boolean isExist = false;
        try {
            sProvider = this.createSessionProvider();
            Node parentNode = parentId != null && parentId.trim().length() > 0 ? this.getFolderNodeById(sProvider, username, accountId, parentId) : this.getFolderHome(sProvider, username, accountId);
            if (parentNode == null) {
                boolean bl = false;
                return bl;
            }
            NodeIterator nit = parentNode.getNodes();
            while (nit.hasNext()) {
                Node node = nit.nextNode();
                String fn = node.getProperty(Utils.EXO_NAME).getString();
                if (!fn.trim().equalsIgnoreCase(folderName)) continue;
                isExist = true;
            }
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
        return isExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveFolder(String username, String accountId, String parentId, Folder folder) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            Node parentNode = this.getFolderNodeById(sProvider, username, accountId, parentId);
            Node myFolder = null;
            if (parentNode.hasNode(folder.getId())) {
                myFolder = parentNode.getNode(folder.getId());
            } else {
                myFolder = parentNode.addNode(folder.getId(), Utils.EXO_FOLDER);
                parentNode.save();
            }
            this.saveFolderNode(myFolder, folder);
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameFolder(String username, String accountId, String newName, Folder folder) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            Node myFolder = this.getFolderNodeById(sProvider, username, accountId, folder.getId());
            if (myFolder != null) {
                myFolder.setProperty(Utils.EXO_NAME, newName);
                myFolder.setProperty(Utils.EXO_LABEL, folder.getURLName());
                myFolder.save();
            }
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    @Override
    public void removeFolderInMessages(SessionProvider sProvider, String username, String accountId, List<Node> msgNodes, String folderId) throws Exception {
        for (Node msgNode : msgNodes) {
            try {
                Value[] propFolders = msgNode.getProperty(Utils.MSG_FOLDERS).getValues();
                String[] oldFolderIds = new String[propFolders.length];
                for (int i = 0; i < propFolders.length; ++i) {
                    oldFolderIds[i] = propFolders[i].getString();
                }
                ArrayList<String> folderList = new ArrayList<String>(Arrays.asList(oldFolderIds));
                folderList.remove(folderId);
                msgNode.setProperty(Utils.MSG_FOLDERS, folderList.toArray(new String[folderList.size()]));
                msgNode.save();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUserFolder(String username, String accountId, String folderId) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            List<Node> msgNodes = this.getMessageNodeByFolder(sProvider, username, accountId, folderId);
            this.removeFolderInMessages(sProvider, username, accountId, msgNodes, folderId);
            Node node = this.getFolderNodeById(sProvider, username, accountId, folderId);
            if (node != null) {
                node.remove();
            }
            node.getSession().save();
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    @Override
    public Node getFilterHome(SessionProvider sProvider, String username, String accountId) throws Exception {
        Node accountHome = this.getMailHomeNode(sProvider, username).getNode(accountId);
        if (accountHome.hasNode(Utils.KEY_FILTER)) {
            return accountHome.getNode(Utils.KEY_FILTER);
        }
        accountHome.addNode(Utils.KEY_FILTER, Utils.NT_UNSTRUCTURED);
        accountHome.save();
        return accountHome.getNode(Utils.KEY_FILTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MessageFilter> getFilters(String username, String accountId) throws Exception {
        SessionProvider sProvider = null;
        ArrayList<MessageFilter> filterList = new ArrayList<MessageFilter>();
        try {
            sProvider = this.createSessionProvider();
            Node filterHomeNode = this.getFilterHome(sProvider, username, accountId);
            NodeIterator iter = filterHomeNode.getNodes();
            while (iter.hasNext()) {
                Node filterNode = (Node)iter.next();
                MessageFilter filter = this.getFilter(filterNode, username, accountId);
                filterList.add(filter);
            }
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
        return filterList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageFilter getFilterById(String username, String accountId, String filterId) throws Exception {
        SessionProvider sProvider = null;
        MessageFilter filter = null;
        try {
            sProvider = this.createSessionProvider();
            Node filterHomeNode = this.getFilterHome(sProvider, username, accountId);
            if (filterHomeNode.hasNode(filterId)) {
                Node filterNode = filterHomeNode.getNode(filterId);
                filter = this.getFilter(filterNode, username, accountId);
            }
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveFilter(String username, String accountId, MessageFilter filter, boolean applyAll) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            Node home = this.getFilterHome(sProvider, username, accountId);
            Node filterNode = null;
            filterNode = home.hasNode(filter.getId()) ? home.getNode(filter.getId()) : home.addNode(filter.getId(), Utils.EXO_FILTER);
            filterNode.setProperty(Utils.EXO_ID, filter.getId());
            filterNode.setProperty(Utils.EXO_NAME, filter.getName());
            filterNode.setProperty(Utils.EXO_FROM, filter.getFrom());
            filterNode.setProperty(Utils.EXO_FROM_CONDITION, (long)filter.getFromCondition());
            filterNode.setProperty(Utils.EXO_TO, filter.getTo());
            filterNode.setProperty(Utils.EXO_TO_CONDITION, (long)filter.getToCondition());
            filterNode.setProperty(Utils.EXO_SUBJECT, filter.getSubject());
            filterNode.setProperty(Utils.EXO_SUBJECT_CONDITION, (long)filter.getSubjectCondition());
            filterNode.setProperty(Utils.EXO_BODY, filter.getBody());
            filterNode.setProperty(Utils.EXO_BODY_CONDITION, (long)filter.getBodyCondition());
            if (!Utils.isEmptyField(filter.getApplyFolder())) {
                filterNode.setProperty(Utils.EXO_APPLY_FOLDER, filter.getApplyFolder());
            } else {
                filterNode.setProperty(Utils.EXO_APPLY_FOLDER, Utils.generateFID(accountId, Utils.FD_INBOX, false));
            }
            filterNode.setProperty(Utils.EXO_APPLY_TAG, filter.getApplyTag());
            filterNode.setProperty(Utils.EXO_KEEP_IN_INBOX, filter.keepInInbox().booleanValue());
            filterNode.setProperty(Utils.EXO_APPLY_FOR_ALL, filter.applyForAll().booleanValue());
            try {
                if (applyAll) {
                    this.runFilter(sProvider, username, accountId, filter);
                }
            }
            catch (Exception e) {
                this.closeSessionProvider(sProvider);
                return;
            }
            home.getSession().save();
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    @Override
    public void runFilter(SessionProvider sProvider, String username, String accountId, MessageFilter filter) throws Exception {
        Tag tag;
        List<Message> msgList = this.getMessagePageList(username, filter).getAll(username);
        String applyFolder = filter.getApplyFolder();
        String applyTag = filter.getApplyTag();
        ArrayList<Tag> tagList = new ArrayList<Tag>();
        for (Message msg : msgList) {
            Folder appFolder;
            Folder folder = this.getFolder(username, accountId, applyFolder);
            if (folder == null || msg.getFolders()[0] == applyFolder || (appFolder = this.getFolder(username, accountId, applyFolder)) == null) continue;
            this.moveMessage(username, accountId, msg, msg.getFolders()[0], applyFolder, true);
        }
        if (!Utils.isEmptyField(applyTag) && (tag = this.getTag(username, accountId, applyTag)) != null) {
            tagList.add(tag);
            this.addTag(username, accountId, msgList, tagList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFilter(String username, String accountId, String filterId) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            Node filterHome = this.getFilterHome(sProvider, username, accountId);
            if (filterHome.hasNode(filterId)) {
                filterHome.getNode(filterId).remove();
            }
            filterHome.getSession().save();
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    @Override
    public Node getMessageHome(SessionProvider sProvider, String username, String accountId) throws Exception {
        sProvider = this.createSessionProvider();
        Node mailHomeNote = this.getMailHomeNode(sProvider, username);
        if (mailHomeNote == null) {
            return null;
        }
        Node accountHome = mailHomeNote.getNode(accountId);
        Node msgHome = null;
        try {
            msgHome = accountHome.getNode(Utils.KEY_MESSAGE);
        }
        catch (PathNotFoundException e) {
            msgHome = accountHome.addNode(Utils.KEY_MESSAGE, Utils.NT_UNSTRUCTURED);
            accountHome.save();
        }
        return msgHome;
    }

    @Override
    public Node getFolderHome(SessionProvider sProvider, String username, String accountId) throws Exception {
        Node accountHome = this.getMailHomeNode(sProvider, username).getNode(accountId);
        Node folderHome = null;
        try {
            folderHome = accountHome.getNode(Utils.KEY_FOLDERS);
        }
        catch (PathNotFoundException e) {
            folderHome = accountHome.addNode(Utils.KEY_FOLDERS, Utils.NT_UNSTRUCTURED);
            accountHome.save();
        }
        return folderHome;
    }

    @Override
    public Node getTagHome(SessionProvider sProvider, String username, String accountId) throws Exception {
        Node accountHome = this.getMailHomeNode(sProvider, username).getNode(accountId);
        Node tagHome = null;
        try {
            tagHome = accountHome.getNode(Utils.KEY_TAGS);
        }
        catch (PathNotFoundException e) {
            tagHome = accountHome.addNode(Utils.KEY_TAGS, Utils.NT_UNSTRUCTURED);
            accountHome.save();
        }
        return tagHome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTag(String username, String accountId, Tag tag) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            Node tagHome = this.getTagHome(sProvider, username, accountId);
            if (!tagHome.hasNode(tag.getId())) {
                Node tagNode = tagHome.addNode(tag.getId(), Utils.EXO_MAILTAG);
                tagNode.setProperty(Utils.EXO_ID, tag.getId());
                tagNode.setProperty(Utils.EXO_NAME, tag.getName());
                tagNode.setProperty(Utils.EXO_DESCRIPTION, tag.getDescription());
                tagNode.setProperty(Utils.EXO_COLOR, tag.getColor());
                tagHome.save();
            }
        }
        finally {
            try {
                this.closeSessionProvider(sProvider);
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTag(String username, String accountId, List<Message> messages, List<Tag> tagList) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            HashMap<String, String> tagMap = new HashMap<String, String>();
            Node tagHome = this.getTagHome(sProvider, username, accountId);
            for (Tag tag : tagList) {
                if (!tagHome.hasNode(tag.getId())) {
                    Node tagNode = tagHome.addNode(tag.getId(), Utils.EXO_MAILTAG);
                    tagNode.setProperty(Utils.EXO_ID, tag.getId());
                    tagNode.setProperty(Utils.EXO_NAME, tag.getName());
                    tagNode.setProperty(Utils.EXO_DESCRIPTION, tag.getDescription());
                    tagNode.setProperty(Utils.EXO_COLOR, tag.getColor());
                }
                tagMap.put(tag.getId(), tag.getId());
            }
            tagHome.getSession().save();
            Node mailHome = this.getMailHomeNode(sProvider, username);
            for (Message message : messages) {
                HashMap<String, String> messageTagMap = new HashMap<String, String>();
                Node messageNode = (Node)mailHome.getSession().getItem(message.getPath());
                try {
                    Value[] values;
                    for (Value value : values = messageNode.getProperty(Utils.EXO_TAGS).getValues()) {
                        messageTagMap.put(value.getString(), value.getString());
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                messageTagMap.putAll(tagMap);
                messageNode.setProperty(Utils.EXO_TAGS, messageTagMap.values().toArray(new String[0]));
                messageNode.save();
            }
        }
        finally {
            try {
                this.closeSessionProvider(sProvider);
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Tag> getTags(String username, String accountId) throws Exception {
        SessionProvider sProvider = null;
        ArrayList<Tag> tags = new ArrayList<Tag>();
        try {
            sProvider = this.createSessionProvider();
            Node tagHomeNode = this.getTagHome(sProvider, username, accountId);
            NodeIterator iter = tagHomeNode.getNodes();
            while (iter.hasNext()) {
                Node tagNode = (Node)iter.next();
                Tag tag = this.getTag(tagNode);
                tags.add(tag);
            }
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
        return tags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tag getTag(String username, String accountId, String tagId) throws Exception {
        SessionProvider sProvider = null;
        Tag tag = null;
        try {
            sProvider = this.createSessionProvider();
            Node tagHomeNode = this.getTagHome(sProvider, username, accountId);
            NodeIterator iter = tagHomeNode.getNodes();
            while (iter.hasNext()) {
                Node tagNode = (Node)iter.next();
                if (!tagNode.getProperty(Utils.EXO_ID).getString().equals(tagId)) continue;
                tag = this.getTag(tagNode);
            }
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
        return tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTagsInMessages(String username, String accountId, List<Message> msgList, List<String> tagIds) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            Node mailHome = this.getMailHomeNode(sProvider, username);
            for (Message msg : msgList) {
                try {
                    Node msgNode = (Node)mailHome.getSession().getItem(msg.getPath());
                    try {
                        Value[] propTags = msgNode.getProperty(Utils.EXO_TAGS).getValues();
                        String[] oldTagIds = new String[propTags.length];
                        for (int i = 0; i < propTags.length; ++i) {
                            oldTagIds[i] = propTags[i].getString();
                        }
                        ArrayList<String> tagList = new ArrayList<String>(Arrays.asList(oldTagIds));
                        tagList.removeAll(tagIds);
                        String[] newTagIds = tagList.toArray(new String[tagList.size()]);
                        msgNode.setProperty(Utils.EXO_TAGS, newTagIds);
                        msgNode.save();
                    }
                    catch (Exception e) {
                    }
                }
                catch (PathNotFoundException e) {}
            }
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTag(String username, String accountId, String tagId) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            List<Message> listMessage = this.getMessageByTag(username, accountId, tagId);
            ArrayList<String> listTag = new ArrayList<String>();
            listTag.add(tagId);
            this.removeTagsInMessages(username, accountId, listMessage, listTag);
            Node tagHomeNode = this.getTagHome(sProvider, username, accountId);
            if (tagHomeNode.hasNode(tagId)) {
                tagHomeNode.getNode(tagId).remove();
            }
            tagHomeNode.getSession().save();
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTag(String username, String accountId, Tag tag) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            Node tagHome = this.getTagHome(sProvider, username, accountId);
            if (tagHome.hasNode(tag.getId())) {
                Node tagNode = tagHome.getNode(tag.getId());
                tagNode.setProperty(Utils.EXO_NAME, tag.getName());
                tagNode.setProperty(Utils.EXO_DESCRIPTION, tag.getDescription());
                tagNode.setProperty(Utils.EXO_COLOR, tag.getColor());
            }
            tagHome.save();
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Message> getMessageByTag(String username, String accountId, String tagId) throws Exception {
        SessionProvider sProvider = null;
        ArrayList<Message> messages = new ArrayList<Message>();
        try {
            sProvider = this.createSessionProvider();
            Node accountNode = this.getMailHomeNode(sProvider, username).getNode(accountId);
            QueryManager qm = this.getSession(sProvider).getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root" + accountNode.getPath() + "//element(*,exo:message)[@exo:tags='").append(tagId).append("']");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator it = result.getNodes();
            while (it.hasNext()) {
                Message message = this.getMessage(it.nextNode());
                messages.add(message);
            }
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
        return messages;
    }

    @Override
    public List<Node> getMessageNodeByFolder(SessionProvider sProvider, String username, String accountId, String folderId) throws Exception {
        ArrayList<Node> msgNodes = new ArrayList<Node>();
        Node accountNode = this.getMailHomeNode(sProvider, username).getNode(accountId);
        QueryManager qm = this.getSession(sProvider).getWorkspace().getQueryManager();
        StringBuffer queryString = new StringBuffer("/jcr:root" + accountNode.getPath() + "//element(*,exo:message)[@exo:folders='").append(folderId).append("']");
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator it = result.getNodes();
        while (it.hasNext()) {
            msgNodes.add(it.nextNode());
        }
        return msgNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getSpamFilterHome(String username, String accountId) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            Node accountHome = this.getMailHomeNode(sProvider, username).getNode(accountId);
            if (accountHome.hasNode(Utils.KEY_SPAM_FILTER)) {
                Node node = accountHome.getNode(Utils.KEY_SPAM_FILTER);
                return node;
            }
            Node node = accountHome.addNode(Utils.KEY_SPAM_FILTER, Utils.NT_UNSTRUCTURED);
            return node;
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    @Override
    public SpamFilter getSpamFilter(String username, String accountId) throws Exception {
        Node accountNode = this.getSpamFilterHome(username, accountId);
        NodeIterator it = accountNode.getNodes();
        Node spamFilterNode = null;
        while (it.hasNext()) {
            Node node = it.nextNode();
            if (!node.isNodeType(Utils.EXO_SPAM_FILTER)) continue;
            spamFilterNode = node;
            break;
        }
        SpamFilter spamFilter = new SpamFilter();
        if (spamFilterNode != null) {
            try {
                Value[] propFroms = spamFilterNode.getProperty(Utils.EXO_FROMS).getValues();
                String[] froms = new String[propFroms.length];
                for (int i = 0; i < propFroms.length; ++i) {
                    froms[i] = propFroms[i].getString();
                }
                spamFilter.setSenders(froms);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return spamFilter;
    }

    @Override
    public void saveSpamFilter(String username, String accountId, SpamFilter spamFilter) throws Exception {
        Node accountNode = this.getSpamFilterHome(username, accountId);
        Node spamFilterNode = null;
        spamFilterNode = accountNode.hasNode(Utils.EXO_SPAM_FILTER) ? accountNode.getNode(Utils.EXO_SPAM_FILTER) : accountNode.addNode(Utils.EXO_SPAM_FILTER, Utils.EXO_SPAM_FILTER);
        spamFilterNode.setProperty(Utils.EXO_FROMS, spamFilter.getSenders());
        accountNode.getSession().save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void toggleMessageProperty(String username, String accountId, List<Message> msgList, String property, boolean value) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            Node mailHome = this.getMailHomeNode(sProvider, username);
            for (Message msg : msgList) {
                Node msgNode = (Node)mailHome.getSession().getItem(msg.getPath());
                if (property.equals(Utils.EXO_STAR)) {
                    msgNode.setProperty(Utils.EXO_STAR, value);
                    msgNode.save();
                    continue;
                }
                if (property.equals(Utils.EXO_ISUNREAD)) {
                    msgNode.setProperty(Utils.EXO_ISUNREAD, value);
                    msgNode.save();
                    Node currentFolderNode = this.getFolderNodeById(sProvider, username, accountId, msgNode.getProperty(Utils.MSG_FOLDERS).getValues()[0].getString());
                    if (currentFolderNode == null) continue;
                    if (!value) {
                        currentFolderNode.setProperty(Utils.EXO_UNREADMESSAGES, currentFolderNode.getProperty(Utils.EXO_UNREADMESSAGES).getLong() - 1L);
                    } else {
                        currentFolderNode.setProperty(Utils.EXO_UNREADMESSAGES, currentFolderNode.getProperty(Utils.EXO_UNREADMESSAGES).getLong() + 1L);
                    }
                    currentFolderNode.save();
                    continue;
                }
                msgNode.setProperty(property, !msgNode.getProperty(property).getBoolean());
                msgNode.save();
            }
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getFolderHomePath(String username, String accountId) throws Exception {
        SessionProvider sProvider = null;
        sProvider = this.createSessionProvider();
        String string = this.getFolderHome(sProvider, username, accountId).getPath();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Folder> getSubFolders(String username, String accountId, String parentPath) throws Exception {
        SessionProvider sProvider = null;
        sProvider = this.createSessionProvider();
        Node home = this.getFolderHome(sProvider, username, accountId);
        Node parentNode = (Node)home.getSession().getItem(parentPath);
        ArrayList<Folder> childFolders = new ArrayList<Folder>();
        NodeIterator it = parentNode.getNodes();
        while (it.hasNext()) {
            Node node = it.nextNode();
            if (!node.isNodeType(Utils.EXO_FOLDER) || !node.hasProperty(Utils.EXO_PERSONAL) || !node.getProperty(Utils.EXO_PERSONAL).getBoolean()) continue;
            childFolders.add(this.getFolder(node));
        }
        ArrayList<Folder> arrayList = childFolders;
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execActionFilter(String username, String accountId, Calendar checkTime) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            List<MessageFilter> msgFilters = this.getFilters(username, accountId);
            Node homeMsg = this.getMessageHome(sProvider, username, accountId);
            if (homeMsg == null) {
                return;
            }
            Session sess = this.getSession(sProvider);
            QueryManager qm = sess.getWorkspace().getQueryManager();
            for (MessageFilter filter : msgFilters) {
                String applyFolder = filter.getApplyFolder();
                String applyTag = filter.getApplyTag();
                filter.setAccountPath(homeMsg.getPath());
                filter.setAccountId(accountId);
                filter.setFromDate(checkTime);
                String queryString = filter.getStatement();
                Query query = qm.createQuery(queryString, "xpath");
                QueryResult result = query.execute();
                NodeIterator it = result.getNodes();
                while (it.hasNext()) {
                    Tag tag;
                    Folder folder;
                    Message msg = this.getMessage(it.nextNode());
                    if (!Utils.isEmptyField(applyFolder) && this.getFolder(username, accountId, applyFolder) != null && (folder = this.getFolder(username, accountId, applyFolder)) != null) {
                        this.moveMessage(username, accountId, msg, msg.getFolders()[0], applyFolder, true);
                    }
                    if (Utils.isEmptyField(applyTag) || (tag = this.getTag(username, accountId, applyTag)) == null) continue;
                    ArrayList<Message> msgList = new ArrayList<Message>();
                    msgList.add(msg);
                    ArrayList<Tag> tagList = new ArrayList<Tag>();
                    tagList.add(tag);
                    this.addTag(username, accountId, msgList, tagList);
                }
            }
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    @Override
    public Node getDateStoreNode(SessionProvider sProvider, String username, String accountId, Date date) throws Exception {
        Node monthNode;
        Node yearNode;
        Node msgHome = this.getMessageHome(sProvider, username, accountId);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        String year = "Y" + String.valueOf(calendar.get(1));
        String month = "M" + String.valueOf(calendar.get(2) + 1);
        String day = "D" + String.valueOf(calendar.get(5));
        try {
            yearNode = msgHome.getNode(year);
        }
        catch (Exception e) {
            yearNode = msgHome.addNode(year, Utils.NT_UNSTRUCTURED);
            msgHome.save();
        }
        try {
            monthNode = yearNode.getNode(month);
        }
        catch (Exception e) {
            monthNode = yearNode.addNode(month, Utils.NT_UNSTRUCTURED);
            yearNode.save();
        }
        try {
            return monthNode.getNode(day);
        }
        catch (Exception e) {
            Node dayNode = monthNode.addNode(day, Utils.NT_UNSTRUCTURED);
            monthNode.save();
            return dayNode;
        }
    }

    @Override
    public List<Node> getMatchingThreadAfter(SessionProvider sProvider, String username, String accountId, Node msg) throws Exception {
        Node accountNode = this.getMailHomeNode(sProvider, username).getNode(accountId);
        ArrayList<Node> converNodes = new ArrayList<Node>();
        try {
            if (msg.getName().equals(msg.getProperty(Utils.EXO_IN_REPLY_TO_HEADER).getString())) {
                return null;
            }
            Session sess = this.getSession(sProvider);
            QueryManager qm = sess.getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root" + accountNode.getPath() + "//element(*,exo:message)[@exo:inReplyToHeader='").append(msg.getName()).append("']");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator it = result.getNodes();
            while (it.hasNext()) {
                converNodes.add(it.nextNode());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return converNodes;
    }

    @Override
    public Node getMatchingThreadBefore(SessionProvider sProvider, String username, String accountId, String inReplyToHeader, Node msg) throws Exception {
        Node accountNode = this.getMailHomeNode(sProvider, username).getNode(accountId);
        Node converNode = null;
        try {
            StringBuffer queryString;
            if (inReplyToHeader.equals(msg.getName())) {
                return null;
            }
            Session sess = this.getSession(sProvider);
            QueryManager qm = sess.getWorkspace().getQueryManager();
            Query query = qm.createQuery((queryString = new StringBuffer("/jcr:root" + accountNode.getPath() + "//element(*,exo:message)[@exo:id='").append(inReplyToHeader).append("']")).toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator it = result.getNodes();
            if (it.hasNext()) {
                converNode = it.nextNode();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return converNode;
    }

    @Override
    public void addMessageToThread(SessionProvider sProvider, String username, String accountId, String inReplyToHeader, Node msgNode) throws Exception {
        List<Node> converNodeChilds = this.getMatchingThreadAfter(sProvider, username, accountId, msgNode);
        try {
            msgNode.addMixin("mix:referenceable");
            if (converNodeChilds != null && converNodeChilds.size() > 0) {
                for (Node converChild : converNodeChilds) {
                    this.createReference(converChild, msgNode);
                    converChild = this.setIsRoot(accountId, converChild, msgNode);
                    msgNode.setProperty(Utils.EXO_IS_ROOT, true);
                    converChild.save();
                    msgNode.save();
                }
            } else {
                Node converNodeParent = this.getMatchingThreadBefore(sProvider, username, accountId, inReplyToHeader, msgNode);
                if (converNodeParent != null && converNodeParent.isNodeType("exo:message")) {
                    this.createReference(msgNode, converNodeParent);
                    msgNode = this.setIsRoot(accountId, msgNode, converNodeParent);
                    msgNode.save();
                    converNodeParent.save();
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTimeInMillis(msgNode.getProperty(Utils.EXO_LAST_UPDATE_TIME).getLong());
                    this.updateLastTimeToParent(username, accountId, msgNode, converNodeParent, cal);
                } else {
                    msgNode.setProperty(Utils.EXO_IS_ROOT, true);
                    msgNode.save();
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Override
    public void updateLastTimeToParent(String username, String accountId, Node node, Node parentNode, Calendar cal) throws Exception {
        Node grandParent = null;
        if (parentNode != null) {
            parentNode.setProperty(Utils.EXO_LAST_UPDATE_TIME, cal);
            grandParent = this.getReferentParent(username, accountId, parentNode);
            if (grandParent != null) {
                this.updateLastTimeToParent(username, accountId, parentNode, grandParent, cal);
            }
            parentNode.save();
        }
    }

    @Override
    public Node getReferentParent(String username, String accountId, Node node) throws Exception {
        Node parentNode = null;
        try {
            Value[] currentValues;
            if (node.hasProperty("exo:conversationId") && (currentValues = node.getProperty("exo:conversationId").getValues()).length > 0) {
                parentNode = node.getSession().getNodeByUUID(currentValues[0].getString());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return parentNode;
    }

    @Override
    public Node setIsRoot(String accountId, Node msgNode, Node converNode) throws Exception {
        boolean isRoot = true;
        try {
            int i;
            Value[] propFoldersMsgNode = msgNode.getProperty(Utils.MSG_FOLDERS).getValues();
            String[] foldersMsgNode = new String[propFoldersMsgNode.length];
            for (int i2 = 0; i2 < propFoldersMsgNode.length; ++i2) {
                foldersMsgNode[i2] = propFoldersMsgNode[i2].getString();
            }
            Value[] propFoldersConverNode = converNode.getProperty(Utils.MSG_FOLDERS).getValues();
            String[] foldersConverNode = new String[propFoldersConverNode.length];
            for (i = 0; i < propFoldersConverNode.length; ++i) {
                foldersConverNode[i] = propFoldersConverNode[i].getString();
            }
            for (i = 0; i < foldersMsgNode.length; ++i) {
                for (int j = 0; j < foldersConverNode.length; ++j) {
                    if (!foldersConverNode[j].equals(foldersMsgNode[i])) continue;
                    isRoot = false;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        msgNode.setProperty(Utils.EXO_IS_ROOT, isRoot);
        return msgNode;
    }

    @Override
    public Node setIsRoot(String accountId, Node msgNode) throws Exception {
        PropertyIterator iter = msgNode.getReferences();
        msgNode.setProperty(Utils.EXO_IS_ROOT, true);
        while (iter.hasNext()) {
            Node coverNode = iter.nextProperty().getParent();
            coverNode = this.setIsRoot(accountId, coverNode, msgNode);
            coverNode.save();
        }
        Value[] values = new Value[]{};
        if (msgNode.isNodeType("exo:messageMixin")) {
            values = msgNode.getProperty("exo:conversationId").getValues();
        }
        for (int i = 0; i < values.length; ++i) {
            Value value = values[i];
            String uuid = value.getString();
            Node refNode = null;
            try {
                refNode = msgNode.getSession().getNodeByUUID(uuid);
            }
            catch (ItemNotFoundException e) {
                // empty catch block
            }
            if (refNode == null || (msgNode = this.setIsRoot(accountId, msgNode, refNode)).getProperty(Utils.EXO_IS_ROOT).getBoolean()) continue;
            refNode.save();
            break;
        }
        return msgNode;
    }

    @Override
    public void createReference(Node msgNode, Node converNode) throws Exception {
        Value[] values = new Value[]{};
        if (msgNode.isNodeType("exo:messageMixin")) {
            values = msgNode.getProperty("exo:conversationId").getValues();
        } else {
            msgNode.addMixin("exo:messageMixin");
        }
        HashMap<String, Value> valueMap = new HashMap<String, Value>();
        for (Value value : values) {
            valueMap.put(value.getString(), value);
        }
        valueMap.put(converNode.getUUID(), msgNode.getSession().getValueFactory().createValue(converNode));
        ArrayList valueList = new ArrayList(valueMap.values());
        if (valueList.size() > 0) {
            msgNode.setProperty("exo:conversationId", valueList.toArray(new Value[valueList.size()]));
            msgNode.save();
        }
    }

    @Override
    public Node moveReference(String accountId, Node node) throws Exception {
        ArrayList<Value> valueList = new ArrayList<Value>();
        Value[] values = new Value[]{};
        PropertyIterator iter = node.getReferences();
        Node firstNode = null;
        if (iter != null) {
            while (iter.hasNext()) {
                Node msgNode = iter.nextProperty().getParent();
                if (!msgNode.isNodeType("exo:messageMixin")) continue;
                values = msgNode.getProperty("exo:conversationId").getValues();
                for (int i = 0; i < values.length; ++i) {
                    valueList.add(values[i]);
                }
                Node parentNode = null;
                try {
                    Value[] currentValues;
                    if (node.hasProperty("exo:conversationId") && (currentValues = node.getProperty("exo:conversationId").getValues()).length > 0) {
                        parentNode = node.getSession().getNodeByUUID(currentValues[0].getString());
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (parentNode != null) {
                    valueList.add(msgNode.getSession().getValueFactory().createValue(parentNode));
                } else if (firstNode != null) {
                    valueList.add(msgNode.getSession().getValueFactory().createValue(firstNode));
                }
                if (firstNode == null) {
                    firstNode = msgNode;
                }
                msgNode.setProperty("exo:conversationId", valueList.toArray(new Value[valueList.size()]));
                msgNode.save();
            }
            node = this.setIsRoot(accountId, node);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Message> getReferencedMessages(String username, String accountId, String msgPath) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            Node mailHome = this.getMailHomeNode(sProvider, username);
            ArrayList<Message> msgList = new ArrayList<Message>();
            Node converNode = (Node)mailHome.getSession().getItem(msgPath);
            PropertyIterator iter = converNode.getReferences();
            while (iter.hasNext()) {
                Node msgNode = iter.nextProperty().getParent();
                msgList.add(this.getMessage(msgNode));
            }
            ArrayList<Message> arrayList = msgList;
            return arrayList;
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    private Map<String, JCRMessageAttachment> getAttachments(Node messageNode) throws Exception {
        HashMap<String, JCRMessageAttachment> attachments = new HashMap<String, JCRMessageAttachment>();
        if (messageNode.hasNode(Utils.KEY_ATTACHMENT)) {
            NodeIterator msgAttachmentIt = messageNode.getNode(Utils.KEY_ATTACHMENT).getNodes();
            while (msgAttachmentIt.hasNext()) {
                Node node = msgAttachmentIt.nextNode();
                if (!node.isNodeType(Utils.EXO_MAIL_ATTACHMENT)) continue;
                JCRMessageAttachment file = Utils.getJCRMessageAttachment(node);
                attachments.put(file.getId(), file);
            }
        }
        return attachments;
    }

    private Message reCheckAttachment(Node messageNode, Message msg) throws Exception {
        String body = msg.getMessageBody();
        Node attNode = messageNode.getNode(Utils.KEY_ATTACHMENT);
        Map<String, JCRMessageAttachment> mapOfAtts = this.getAttachments(messageNode);
        if (!mapOfAtts.isEmpty()) {
            boolean attachedFile = false;
            for (String attId : mapOfAtts.keySet()) {
                if (body.indexOf("cid:" + attId.substring(attId.lastIndexOf("/") + 1)) >= 0) {
                    Node anAttNode = (Node)attNode.getSession().getItem(attId);
                    anAttNode.setProperty(Utils.ATT_IS_SHOWN_IN_BODY, true);
                    mapOfAtts.get(attId).setIsShowInBody(true);
                    continue;
                }
                attachedFile = true;
            }
            msg.setAttachements(new ArrayList<Attachment>(mapOfAtts.values()));
            if (!attachedFile) {
                messageNode.setProperty(Utils.EXO_HASATTACH, false);
                msg.setHasAttachment(false);
            } else {
                messageNode.setProperty(Utils.EXO_HASATTACH, true);
                msg.setHasAttachment(true);
            }
            messageNode.save();
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message loadTotalMessage(String username, String accountId, Message msg, javax.mail.Message message) throws Exception {
        SessionProvider sProvider = null;
        try {
            Node messageNode;
            block10: {
                sProvider = this.createSessionProvider();
                messageNode = this.getDateStoreNode(sProvider, username, accountId, msg.getReceivedDate()).getNode(msg.getId());
                Node attNode = null;
                try {
                    attNode = messageNode.getNode(Utils.KEY_ATTACHMENT);
                }
                catch (Exception ex) {
                    logger.trace((Object)"[EXO WARNING] Attachment is not existed, loading them from server mail", (Throwable)ex);
                }
                if (attNode != null) break block10;
                String body = this.getContent(messageNode, message);
                msg.setMessageBody(body);
                Message message2 = msg = this.reCheckAttachment(messageNode, msg);
                return message2;
            }
            try {
                Map<String, JCRMessageAttachment> mapOfAtt = this.getAttachments(messageNode);
                if (!mapOfAtt.isEmpty()) {
                    msg.setAttachements(new ArrayList<Attachment>(mapOfAtt.values()));
                }
            }
            catch (PathNotFoundException e) {
                logger.debug((Object)"[EXO WARNING] PathNotFoundException when load attachment");
            }
            Message message3 = msg;
            return message3;
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message loadTotalMessage(String username, String accountId, Message msg) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            Node messageNode = this.getDateStoreNode(sProvider, username, accountId, msg.getReceivedDate()).getNode(msg.getId());
            if (messageNode.hasNode(Utils.KEY_ATTACHMENT)) {
                NodeIterator msgAttachmentIt = messageNode.getNode(Utils.KEY_ATTACHMENT).getNodes();
                ArrayList<Attachment> attachments = new ArrayList<Attachment>();
                while (msgAttachmentIt.hasNext()) {
                    Node node = msgAttachmentIt.nextNode();
                    if (!node.isNodeType(Utils.EXO_MAIL_ATTACHMENT)) continue;
                    JCRMessageAttachment file = Utils.getJCRMessageAttachment(node);
                    attachments.add(file);
                }
                if (attachments.size() > 0) {
                    msg.setAttachements(attachments);
                }
            }
            msg.setMessageBody(messageNode.getProperty(Utils.EXO_BODY).getString());
        }
        catch (Exception e) {
            logger.trace((Object)"Can not load message body on Local", (Throwable)e);
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
        return msg;
    }

    @Override
    public byte checkDuplicateStatus(SessionProvider sProvider, String username, Node msgHomeNode, String accId, Node msgNode, String folderId) {
        int ret = 0;
        try {
            Value[] propFolders = msgNode.getProperty(Utils.MSG_FOLDERS).getValues();
            String[] folders = new String[propFolders.length + 1];
            folders[0] = folderId;
            for (int i = 0; i < propFolders.length; ++i) {
                if (propFolders[i].getString().indexOf(folderId) > -1) {
                    logger.debug((Object)"DUPLICATE MAIL ... removed");
                    return 1;
                }
                folders[i + 1] = propFolders[i].getString();
            }
            msgNode.setProperty(Utils.EXO_STAR, false);
            msgNode.setProperty(Utils.MSG_FOLDERS, folders);
            msgNode.save();
            this.increaseFolderItem(sProvider, username, accId, folderId, true);
            logger.warn((Object)"DUPLICATE MAIL IN ANOTHER FOLDER ... ");
            ret = 2;
        }
        catch (Exception e) {
            // empty catch block
        }
        return (byte)ret;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean savePOP3Message(String username, String accId, javax.mail.Message msg, String[] folderIds, List<String> tagList, SpamFilter spamFilter, Info infoObj, ContinuationService continuation, String currentUserName) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 15[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public SessionProvider createSessionProvider() {
        SessionProvider provider = Utils.createSystemProvider();
        return provider;
    }

    @Override
    public void closeSessionProvider(SessionProvider sessionProvider) {
        if (sessionProvider != null) {
            // empty if block
        }
    }

    @Override
    public SessionProvider createSystemProvider() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        SessionProviderService service = (SessionProviderService)container.getComponentInstanceOfType(SessionProviderService.class);
        return service.getSystemSessionProvider(null);
    }

    @Override
    public Node getNodeByPath(String nodePath, SessionProvider sessionProvider) throws Exception {
        return (Node)this.getSession(sessionProvider).getItem(nodePath);
    }

    @Override
    public Session getSession(SessionProvider sprovider) throws Exception {
        ManageableRepository currentRepo = this.repoService_.getCurrentRepository();
        return sprovider.getSession(currentRepo.getConfiguration().getDefaultWorkspaceName(), currentRepo);
    }

    @Override
    public BufferAttachment getAttachmentFromDMS(String userName, String relPath) throws Exception {
        SessionProvider sProvider = Utils.createSystemProvider();
        Node node = this.nodeHierarchyCreator_.getUserNode(sProvider, userName);
        Node fileNode = node.getNode(relPath);
        if (!fileNode.getPrimaryNodeType().getName().equals("nt:file")) {
            return null;
        }
        Node fileContentNode = fileNode.getNode(Utils.JCR_CONTENT);
        BufferAttachment attachFile = new BufferAttachment();
        attachFile.setId("Attachment" + IdGenerator.generate());
        String fileName = fileNode.getName();
        attachFile.setName(fileName);
        attachFile.setInputStream(fileContentNode.getProperty(Utils.JCR_DATA).getStream());
        attachFile.setMimeType(fileContentNode.getProperty(Utils.JCR_MIMETYPE).getString());
        return attachFile;
    }

    public String[] getDMSDataInfo(String userName) throws Exception {
        String[] arr = new String[3];
        RepositoryService service = (RepositoryService)PortalContainer.getInstance().getComponentInstanceOfType(RepositoryService.class);
        arr[0] = service.getCurrentRepository().getConfiguration().getName();
        SessionProvider sProvider = Utils.createSystemProvider();
        Node node = this.nodeHierarchyCreator_.getUserNode(sProvider, userName);
        arr[1] = node.getSession().getWorkspace().getName();
        arr[2] = node.getPath();
        return arr;
    }

    public Node getDMSSelectedNode(String userName, String relPath) throws Exception {
        SessionProvider sProvider = Utils.createSystemProvider();
        Node userNode = this.nodeHierarchyCreator_.getUserNode(sProvider, userName);
        try {
            Node folderNode = userNode.getNode(relPath);
            return folderNode;
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean hasContentId(Part part) throws MessagingException {
        return part.getHeader("Content-Id") != null;
    }

    private MessageFilter getFilter(Node filterNode, String username, String accountId) throws Exception {
        MessageFilter filter = new MessageFilter("");
        if (filterNode.hasProperty(Utils.EXO_ID)) {
            filter.setId(filterNode.getProperty(Utils.EXO_ID).getString());
        }
        if (filterNode.hasProperty(Utils.EXO_NAME)) {
            filter.setName(filterNode.getProperty(Utils.EXO_NAME).getString());
        }
        if (filterNode.hasProperty(Utils.EXO_FROM)) {
            filter.setFrom(filterNode.getProperty(Utils.EXO_FROM).getString());
        }
        if (filterNode.hasProperty(Utils.EXO_FROM_CONDITION)) {
            filter.setFromCondition((int)filterNode.getProperty(Utils.EXO_FROM_CONDITION).getLong());
        }
        if (filterNode.hasProperty(Utils.EXO_TO)) {
            filter.setTo(filterNode.getProperty(Utils.EXO_TO).getString());
        }
        if (filterNode.hasProperty(Utils.EXO_TO_CONDITION)) {
            filter.setToCondition((int)filterNode.getProperty(Utils.EXO_TO_CONDITION).getLong());
        }
        if (filterNode.hasProperty(Utils.EXO_SUBJECT)) {
            filter.setSubject(filterNode.getProperty(Utils.EXO_SUBJECT).getString());
        }
        if (filterNode.hasProperty(Utils.EXO_SUBJECT_CONDITION)) {
            filter.setSubjectCondition((int)filterNode.getProperty(Utils.EXO_SUBJECT_CONDITION).getLong());
        }
        if (filterNode.hasProperty(Utils.EXO_BODY)) {
            filter.setBody(filterNode.getProperty(Utils.EXO_BODY).getString());
        }
        if (filterNode.hasProperty(Utils.EXO_BODY_CONDITION)) {
            filter.setBodyCondition((int)filterNode.getProperty(Utils.EXO_BODY_CONDITION).getLong());
        }
        if (filterNode.hasProperty(Utils.EXO_APPLY_FOLDER)) {
            String folder = filterNode.getProperty(Utils.EXO_APPLY_FOLDER).getString();
            if (!Utils.isEmptyField(folder) && this.getFolder(username, accountId, folder) != null) {
                filter.setApplyFolder(folder);
            } else {
                filter.setApplyFolder(Utils.generateFID(accountId, Utils.FD_INBOX, false));
            }
        }
        if (filterNode.hasProperty(Utils.EXO_APPLY_TAG)) {
            filter.setApplyTag(filterNode.getProperty(Utils.EXO_APPLY_TAG).getString());
        }
        if (filterNode.hasProperty(Utils.EXO_KEEP_IN_INBOX)) {
            filter.setKeepInInbox(filterNode.getProperty(Utils.EXO_KEEP_IN_INBOX).getBoolean());
        }
        if (filterNode.hasProperty(Utils.EXO_APPLY_FOR_ALL)) {
            filter.setApplyForAll(filterNode.getProperty(Utils.EXO_APPLY_FOR_ALL).getBoolean());
        }
        return filter;
    }

    private void saveFolderNode(Node folderNode, Folder folder) throws Exception {
        folderNode.setProperty(Utils.EXO_ID, folder.getId());
        folderNode.setProperty(Utils.EXO_NAME, folder.getName());
        folderNode.setProperty(Utils.EXO_UNREADMESSAGES, folder.getNumberOfUnreadMessage());
        folderNode.setProperty(Utils.EXO_FOLDERTYPE, folder.getType());
        folderNode.setProperty(Utils.EXO_LABEL, folder.getURLName());
        folderNode.setProperty(Utils.EXO_TOTALMESSAGE, folder.getTotalMessage());
        folderNode.setProperty(Utils.EXO_PERSONAL, folder.isPersonalFolder());
        if (folder.getLastCheckedDate() != null) {
            folderNode.setProperty(Utils.EXO_LAST_CHECKED_TIME, folder.getLastCheckedDate().getTime());
        } else {
            folderNode.setProperty(Utils.EXO_LAST_CHECKED_TIME, (Value)null);
        }
        if (folder.getLastStartCheckingTime() != null) {
            folderNode.setProperty(Utils.EXO_LAST_START_CHECKING_TIME, folder.getLastStartCheckingTime().getTime());
        } else {
            folderNode.setProperty(Utils.EXO_LAST_START_CHECKING_TIME, (Value)null);
        }
        if (folder.getCheckFromDate() != null) {
            folderNode.setProperty(Utils.EXO_CHECK_FROM_DATE, folder.getCheckFromDate().getTime());
        } else {
            folderNode.setProperty(Utils.EXO_CHECK_FROM_DATE, (Value)null);
        }
        folderNode.save();
    }

    private void setCometdMessage(ContinuationService continuation, Info infoObj, String from, String msgId, boolean isReadMessage, String subject, String size, String accId, Calendar gc, Calendar sc, String currentUserName, String username) {
        infoObj.setFrom(from);
        infoObj.setMsgId(Utils.encodeMailId(msgId));
        infoObj.setIsRead(isReadMessage);
        infoObj.setSubject(subject);
        infoObj.setSize(size);
        infoObj.setAccountId(accId);
        if (gc != null) {
            infoObj.setDate(gc.getTime().toString());
        } else if (sc != null) {
            infoObj.setDate(sc.getTime().toString());
        } else {
            infoObj.setDate(new Date().toString());
        }
        JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
        JsonValue json = null;
        try {
            json = generatorImpl.createJsonObject((Object)infoObj);
        }
        catch (JsonException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Cannot create json object for cometd", (Throwable)e);
            }
            return;
        }
        if (!Utils.isEmptyField(currentUserName)) {
            continuation.sendMessage(currentUserName, "/eXo/Application/mail/messages", (Object)json);
        } else {
            continuation.sendMessage(username, "/eXo/Application/mail/messages", (Object)json);
        }
    }

    public Tag getTag(Node tagNode) throws Exception {
        Tag tag = new Tag();
        if (tagNode.hasProperty(Utils.EXO_ID)) {
            tag.setId(tagNode.getProperty(Utils.EXO_ID).getString());
        }
        if (tagNode.hasProperty(Utils.EXO_NAME)) {
            tag.setName(tagNode.getProperty(Utils.EXO_NAME).getString());
        }
        if (tagNode.hasProperty(Utils.EXO_DESCRIPTION)) {
            tag.setDescription(tagNode.getProperty(Utils.EXO_DESCRIPTION).getString());
        }
        if (tagNode.hasProperty(Utils.EXO_COLOR)) {
            tag.setColor(tagNode.getProperty(Utils.EXO_COLOR).getString());
        }
        return tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getListOfMessageIds(String username, MessageFilter filter) throws Exception {
        ArrayList<String> strList = new ArrayList<String>();
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            Node homeMsg = this.getMessageHome(sProvider, username, filter.getAccountId());
            if (homeMsg == null) {
                ArrayList<String> arrayList = strList;
                return arrayList;
            }
            filter.setAccountPath(homeMsg.getPath());
            filter.setReturnedProperties(new String[]{Utils.EXO_ID});
            QueryManager qm = this.getSession(sProvider).getWorkspace().getQueryManager();
            String queryString = filter.getStatement();
            Query query = qm.createQuery(queryString, "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                Node node = iter.nextNode();
                if (!node.hasProperty(Utils.EXO_ID)) continue;
                strList.add(node.getProperty(Utils.EXO_ID).getString());
            }
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
        return strList;
    }
}

