/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.lexer.escaping.Escaping;
import com.google.caja.parser.AbstractParseTreeNode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParserBase;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsPrettyPrinter;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Callback;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Identifier
extends AbstractParseTreeNode {
    private final String name;

    @ParseTreeNode.ReflectiveCtor
    public Identifier(FilePosition pos, String name, List<? extends ParseTreeNode> children) {
        this(pos, name);
        assert (children.isEmpty());
    }

    public Identifier(FilePosition pos, String name) {
        super(pos);
        if (name != null && !ParserBase.isQuasiIdentifier(name)) {
            throw new IllegalArgumentException("Invalid identifier " + name);
        }
        this.name = name;
    }

    @Override
    public String getValue() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void render(RenderContext r) {
        if (this.name != null) {
            StringBuilder escapedName = new StringBuilder();
            Escaping.escapeJsIdentifier((CharSequence)this.name, r.isAsciiOnly(), escapedName);
            r.getOut().mark(this.getFilePosition());
            r.getOut().consume(escapedName.toString());
        }
    }

    @Override
    public final TokenConsumer makeRenderer(Appendable out, Callback<IOException> exHandler) {
        return new JsPrettyPrinter(new Concatenator(out, exHandler));
    }
}

