/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.reporting;

import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.SimpleMessageQueue;
import java.util.ListResourceBundle;
import junit.framework.TestCase;

public class BuildInfoTest
extends TestCase {
    private BuildInfo getDefaultBuildInfo() {
        return new BuildInfo(new ListResourceBundle(){

            public Object[][] getContents() {
                return new Object[][]{{"svnVersion", "345M"}, {"timestamp", "January 1, 2007"}};
            }
        });
    }

    private Message getMessage(BuildInfo bi) {
        SimpleMessageQueue mq = new SimpleMessageQueue();
        bi.addBuildInfo(mq);
        BuildInfoTest.assertEquals((int)1, (int)mq.getMessages().size());
        return mq.getMessages().get(0);
    }

    public final void testNonemptyInfo() {
        Message m = this.getMessage(this.getDefaultBuildInfo());
        BuildInfoTest.assertEquals((Object)((Object)MessageLevel.LOG), (Object)((Object)m.getMessageLevel()));
        String s = m.format(new MessageContext());
        BuildInfoTest.assertTrue((boolean)s.contains("345M"));
        BuildInfoTest.assertTrue((boolean)s.contains("January 1, 2007"));
    }

    public final void testEmptyInfo() {
        Message m = this.getMessage(new BuildInfo(null));
        BuildInfoTest.assertEquals((Object)((Object)MessageLevel.LOG), (Object)((Object)m.getMessageLevel()));
    }
}

