/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.ext.common;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.ks.common.user.CommonContact;
import org.exoplatform.ks.common.user.ContactProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;

public class SocialContactProvider
implements ContactProvider {
    private static final Log LOG = ExoLogger.getLogger(SocialContactProvider.class);

    public CommonContact getCommonContact(String userId) {
        CommonContact contact;
        block8: {
            contact = new CommonContact();
            try {
                IdentityManager identityM = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
                Identity userIdentity = identityM.getIdentity("organization", userId, true);
                Profile profile = userIdentity.getProfile();
                if (profile.contains("email")) {
                    contact.setEmailAddress(profile.getProperty("email").toString());
                }
                if (profile.contains("firstName")) {
                    contact.setFirstName(profile.getProperty("firstName").toString());
                }
                if (profile.contains("lastName")) {
                    contact.setLastName(profile.getProperty("lastName").toString());
                }
                contact.setAvatarUrl(profile.getAvatarUrl());
                if (profile.contains("gender")) {
                    contact.setGender(profile.getProperty("gender").toString());
                }
                if (profile.contains("phones")) {
                    contact.setPhone(profile.getProperty("phones").toString());
                }
                if (profile.contains("Url")) {
                    contact.setWebSite(profile.getProperty("Url").toString());
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block8;
                LOG.error((Object)String.format("can not load contact from eXo Social Profile with user [%s]", userId), (Throwable)e);
            }
        }
        return contact;
    }
}

