/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.TimeZone;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.WeekDay;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VFreeBusy;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.parameter.Encoding;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.parameter.XParameter;
import net.fortuna.ical4j.model.property.Action;
import net.fortuna.ical4j.model.property.Attach;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Categories;
import net.fortuna.ical4j.model.property.Clazz;
import net.fortuna.ical4j.model.property.Completed;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Due;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.ExDate;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Priority;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.model.property.RecurrenceId;
import net.fortuna.ical4j.model.property.Repeat;
import net.fortuna.ical4j.model.property.Status;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Version;
import net.fortuna.ical4j.model.property.XProperty;
import net.fortuna.ical4j.util.CompatibilityHints;
import org.exoplatform.calendar.service.Attachment;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarCategory;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarImportExport;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.Reminder;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.service.impl.JCRDataStorage;
import org.exoplatform.calendar.service.impl.RemoteCalendarServiceImpl;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ICalendarImportExport
implements CalendarImportExport {
    private static final String PRIVATE_TYPE = String.valueOf(0);
    private static final String SHARED_TYPE = String.valueOf(1);
    private static final String PUBLIC_TYPE = String.valueOf(2);
    private JCRDataStorage storage_;
    private static final Log logger = ExoLogger.getLogger(ICalendarImportExport.class);

    public ICalendarImportExport(JCRDataStorage storage) throws Exception {
        this.storage_ = storage;
    }

    public net.fortuna.ical4j.model.Calendar getCalendarComponent(net.fortuna.ical4j.model.Calendar calendar, CalendarEvent exoEvent, String componentType) throws Exception {
        Uid id = new Uid(exoEvent.getId());
        long start = exoEvent.getFromDateTime().getTime();
        long end = exoEvent.getToDateTime().getTime();
        String summary = exoEvent.getSummary();
        VEvent event = null;
        if (end > 0L) {
            if ("VEVENT".equals(componentType)) {
                event = new VEvent((Date)new DateTime(start), (Date)new DateTime(end), summary);
            } else if ("VTODO".equals(componentType)) {
                event = new VToDo((Date)new DateTime(start), (Date)new DateTime(end), summary);
            }
        } else if ("VEVENT".equals(componentType)) {
            event = new VEvent((Date)new DateTime(start), summary);
        } else if ("VTODO".equals(componentType)) {
            event = new VToDo((Date)new DateTime(start), summary);
        }
        if (event == null) {
            return null;
        }
        event.getProperties().getProperty("DTSTART").getParameters().add((Parameter)Value.DATE_TIME);
        event.getProperties().add((Property)new Description(exoEvent.getDescription()));
        event.getProperties().getProperty("DESCRIPTION").getParameters().add((Parameter)Value.TEXT);
        event.getProperties().add((Property)new Location(exoEvent.getLocation()));
        event.getProperties().getProperty("LOCATION").getParameters().add((Parameter)Value.TEXT);
        if (exoEvent.getEventCategoryName() != null) {
            event.getProperties().add((Property)new Categories(exoEvent.getEventCategoryName()));
            event.getProperties().getProperty("CATEGORIES").getParameters().add((Parameter)Value.TEXT);
        }
        if (exoEvent.getPriority() != null) {
            for (int i = 0; i < CalendarEvent.PRIORITY.length; ++i) {
                if (!exoEvent.getPriority().equalsIgnoreCase(CalendarEvent.PRIORITY[i])) continue;
                event.getProperties().add((Property)new Priority(i));
                event.getProperties().getProperty("PRIORITY").getParameters().add((Parameter)Value.INTEGER);
                break;
            }
        }
        if ("VTODO".equals(componentType)) {
            if (exoEvent.getCompletedDateTime() != null) {
                long completed = exoEvent.getCompletedDateTime().getTime();
                event.getProperties().add((Property)new Completed(new DateTime(completed)));
                event.getProperties().getProperty("COMPLETED").getParameters().add((Parameter)Value.DATE_TIME);
            }
            event.getProperties().add((Property)new Due((Date)new DateTime(end)));
            event.getProperties().getProperty("DUE").getParameters().add((Parameter)Value.DATE_TIME);
            if (!Utils.isEmpty(exoEvent.getStatus())) {
                event.getProperties().add((Property)new Status(exoEvent.getStatus()));
                event.getProperties().getProperty("STATUS").getParameters().add((Parameter)Value.TEXT);
            }
        }
        if (exoEvent.getAttachment() != null && !exoEvent.getAttachment().isEmpty()) {
            for (Attachment att : exoEvent.getAttachment()) {
                byte[] bytes = new byte[att.getInputStream().available()];
                att.getInputStream().read(bytes);
                ParameterList plist = new ParameterList();
                plist.add((Parameter)new XParameter("CN", att.getName()));
                plist.add((Parameter)new XParameter("FMTTYPE", att.getMimeType()));
                plist.add((Parameter)Encoding.BASE64);
                plist.add((Parameter)Value.BINARY);
                Attach attach = new Attach(plist, bytes);
                event.getProperties().add((Property)attach);
            }
        }
        if (exoEvent.getReminders() != null && !exoEvent.getReminders().isEmpty()) {
            for (Reminder r : exoEvent.getReminders()) {
                Attendee a;
                VAlarm reminder = new VAlarm(new DateTime(r.getFromDateTime()));
                Long times = new Long(1L);
                if (r.isRepeat()) {
                    times = r.getAlarmBefore() / r.getRepeatInterval();
                }
                reminder.getProperties().add((Property)new Repeat(times.intValue()));
                reminder.getProperties().add((Property)new Duration(new Dur(new Long(r.getAlarmBefore()).intValue())));
                if (Reminder.TYPE_POPUP.equals(r.getReminderType())) {
                    for (String n : r.getReminderOwner().split(Utils.COMMA)) {
                        a = new Attendee(n);
                        reminder.getProperties().add((Property)a);
                    }
                    reminder.getProperties().add((Property)Action.DISPLAY);
                } else {
                    for (String m : r.getEmailAddress().split(Utils.COMMA)) {
                        a = new Attendee(m);
                        reminder.getProperties().add((Property)a);
                    }
                    reminder.getProperties().add((Property)Action.EMAIL);
                }
                reminder.getProperties().add((Property)new Summary(exoEvent.getSummary()));
                reminder.getProperties().add((Property)new Description(r.getDescription()));
                reminder.getProperties().add((Property)id);
                calendar.getComponents().add((Component)reminder);
            }
        }
        if (exoEvent.isPrivate()) {
            event.getProperties().add((Property)new Clazz(Clazz.PRIVATE.getValue()));
        } else {
            event.getProperties().add((Property)new Clazz(Clazz.PUBLIC.getValue()));
        }
        event.getProperties().getProperty("CLASS").getParameters().add((Parameter)Value.TEXT);
        String[] attendees = exoEvent.getInvitation();
        if (attendees != null && attendees.length > 0) {
            for (int i = 0; i < attendees.length; ++i) {
                if (attendees[i] == null) continue;
                event.getProperties().add((Property)new Attendee(attendees[i]));
            }
            event.getProperties().getProperty("ATTENDEE").getParameters().add((Parameter)Value.TEXT);
        }
        if (!Utils.isEmpty(exoEvent.getRepeatType())) {
            Recur rc = null;
            if (!CalendarEvent.RP_NOREPEAT.equalsIgnoreCase(exoEvent.getRepeatType())) {
                if (CalendarEvent.RP_WEEKEND.equalsIgnoreCase(exoEvent.getRepeatType())) {
                    rc = new Recur("WEEKLY", 1);
                    rc.getDayList().add(WeekDay.SU);
                    rc.getDayList().add(WeekDay.SA);
                    rc.setInterval(1);
                } else if (CalendarEvent.RP_WORKINGDAYS.equalsIgnoreCase(exoEvent.getRepeatType())) {
                    rc = new Recur("WEEKLY", 1);
                    rc.getDayList().add(WeekDay.MO);
                    rc.getDayList().add(WeekDay.TU);
                    rc.getDayList().add(WeekDay.WE);
                    rc.getDayList().add(WeekDay.TH);
                    rc.getDayList().add(WeekDay.FR);
                    rc.setInterval(1);
                } else if (CalendarEvent.RP_WEEKLY.equalsIgnoreCase(exoEvent.getRepeatType())) {
                    rc = new Recur("WEEKLY", 1);
                    rc.getDayList().add(WeekDay.SU);
                    rc.getDayList().add(WeekDay.MO);
                    rc.getDayList().add(WeekDay.TU);
                    rc.getDayList().add(WeekDay.WE);
                    rc.getDayList().add(WeekDay.TH);
                    rc.getDayList().add(WeekDay.FR);
                    rc.getDayList().add(WeekDay.SA);
                    rc.setInterval(1);
                } else {
                    rc = new Recur(exoEvent.getRepeatType().toUpperCase(), 1);
                    rc.setInterval(1);
                }
            }
            if (rc != null) {
                rc.setWeekStartDay(WeekDay.SU.getDay());
                RRule r = new RRule(rc);
                event.getProperties().add((Property)r);
            }
        }
        if (!Utils.isEmpty(exoEvent.getEventState())) {
            XProperty xProperty = new XProperty(Utils.X_STATUS, exoEvent.getEventState());
            event.getProperties().add((Property)xProperty);
        }
        event.getProperties().add((Property)id);
        calendar.getComponents().add((Component)event);
        return calendar;
    }

    @Override
    public OutputStream exportCalendar(String username, List<String> calendarIds, String type, int limited) throws Exception {
        List<Object> events = new ArrayList();
        if (type.equals(PRIVATE_TYPE)) {
            if (limited > 0) {
                EventQuery eventQuery = new EventQuery();
                eventQuery.setCalendarId(calendarIds.toArray(new String[0]));
                eventQuery.setOrderBy(new String[]{"jcr:lastModified"});
                eventQuery.setLimitedItems(limited);
                events = this.storage_.getEvents(username, eventQuery, null);
            } else {
                events = this.storage_.getUserEventByCalendar(username, calendarIds);
            }
        } else if (type.equals(SHARED_TYPE)) {
            events = this.storage_.getSharedEventByCalendars(username, calendarIds);
        } else if (type.equals(PUBLIC_TYPE)) {
            events = this.storage_.getGroupEventByCalendar(calendarIds);
        }
        if (events.isEmpty()) {
            return null;
        }
        net.fortuna.ical4j.model.Calendar calendar = new net.fortuna.ical4j.model.Calendar();
        calendar.getProperties().add((Property)new ProdId("-//Ben Fortuna//iCal4j 1.0//EN"));
        calendar.getProperties().add((Property)Version.VERSION_2_0);
        calendar.getProperties().add((Property)CalScale.GREGORIAN);
        for (CalendarEvent calendarEvent : events) {
            if (calendarEvent.getEventType().equals(CalendarEvent.TYPE_EVENT)) {
                calendar = this.getCalendarComponent(calendar, calendarEvent, "VEVENT");
                continue;
            }
            calendar = this.getCalendarComponent(calendar, calendarEvent, "VTODO");
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        CalendarOutputter calendarOutputter = new CalendarOutputter();
        try {
            calendarOutputter.output(calendar, (OutputStream)bout);
        }
        catch (ValidationException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Validate error", (Throwable)e);
            }
            return null;
        }
        return bout;
    }

    @Override
    public OutputStream exportEventCalendar(String username, String calendarId, String type, String eventId) throws Exception {
        List<Object> events = new ArrayList();
        List<String> calendarIds = Arrays.asList(calendarId);
        if (type.equals(PRIVATE_TYPE)) {
            events = this.storage_.getUserEventByCalendar(username, calendarIds);
        } else if (type.equals(SHARED_TYPE)) {
            events = this.storage_.getSharedEventByCalendars(username, calendarIds);
        } else if (type.equals(PUBLIC_TYPE)) {
            events = this.storage_.getGroupEventByCalendar(calendarIds);
        }
        net.fortuna.ical4j.model.Calendar calendar = new net.fortuna.ical4j.model.Calendar();
        calendar.getProperties().add((Property)new ProdId("-//Ben Fortuna//iCal4j 1.0//EN"));
        calendar.getProperties().add((Property)Version.VERSION_2_0);
        calendar.getProperties().add((Property)CalScale.GREGORIAN);
        for (CalendarEvent calendarEvent : events) {
            if (!calendarEvent.getId().equals(eventId)) continue;
            if (calendarEvent.getEventType().equals(CalendarEvent.TYPE_EVENT)) {
                calendar = this.getCalendarComponent(calendar, calendarEvent, "VEVENT");
                break;
            }
            calendar = this.getCalendarComponent(calendar, calendarEvent, "VTODO");
            break;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        CalendarOutputter calendarOutputter = new CalendarOutputter();
        try {
            calendarOutputter.output(calendar, (OutputStream)bout);
        }
        catch (ValidationException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Validate error", (Throwable)e);
            }
            return null;
        }
        return bout;
    }

    @Override
    public List<CalendarEvent> getEventObjects(InputStream icalInputStream) throws Exception {
        CalendarBuilder calendarBuilder = new CalendarBuilder();
        net.fortuna.ical4j.model.Calendar iCalendar = calendarBuilder.build(icalInputStream);
        ComponentList componentList = iCalendar.getComponents();
        ArrayList<CalendarEvent> eventList = new ArrayList<CalendarEvent>();
        for (Object obj : componentList) {
            VEvent event;
            CalendarEvent exoEvent;
            block25: {
                block24: {
                    if (!(obj instanceof VEvent)) continue;
                    exoEvent = new CalendarEvent();
                    event = (VEvent)obj;
                    if (event.getProperty("UID") != null) {
                        exoEvent.setId(event.getProperty("UID").getValue());
                    }
                    if (event.getProperty("CATEGORIES") != null) {
                        exoEvent.setEventCategoryName(event.getProperty("CATEGORIES").getValue().trim());
                    }
                    if (event.getSummary() != null) {
                        exoEvent.setSummary(event.getSummary().getValue());
                    }
                    if (event.getDescription() != null) {
                        exoEvent.setDescription(event.getDescription().getValue());
                    }
                    if (event.getStatus() != null) {
                        exoEvent.setStatus(event.getStatus().getValue());
                    }
                    exoEvent.setEventType(CalendarEvent.TYPE_EVENT);
                    if (event.getStartDate() != null) {
                        exoEvent.setFromDateTime((java.util.Date)event.getStartDate().getDate());
                    }
                    if (event.getEndDate() != null) {
                        exoEvent.setToDateTime((java.util.Date)event.getEndDate().getDate());
                    }
                    if (event.getLocation() != null) {
                        exoEvent.setLocation(event.getLocation().getValue());
                    }
                    if (event.getPriority() != null) {
                        try {
                            exoEvent.setPriority(CalendarEvent.PRIORITY[Integer.parseInt(event.getPriority().getValue())]);
                        }
                        catch (Exception e) {
                            if (!logger.isDebugEnabled()) break block24;
                            logger.debug((Object)"Fail to setPriority to exoEvent", (Throwable)e);
                        }
                    }
                }
                try {
                    RRule r = (RRule)event.getProperty("RRULE");
                    if (r != null && r.getRecur() != null) {
                        Recur rc = r.getRecur();
                        rc.getFrequency();
                        if ("WEEKLY".equalsIgnoreCase(rc.getFrequency())) {
                            if (rc.getDayList().size() == 2) {
                                exoEvent.setRepeatType(CalendarEvent.RP_WEEKEND);
                            } else if (rc.getDayList().size() == 5) {
                                exoEvent.setRepeatType(CalendarEvent.RP_WORKINGDAYS);
                            }
                            if (rc.getDayList().size() == 7) {
                                exoEvent.setRepeatType(CalendarEvent.RP_WEEKLY);
                            }
                        } else {
                            exoEvent.setRepeatType(rc.getFrequency().toLowerCase());
                        }
                    }
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block25;
                    logger.debug((Object)"Exception in method getEventObjects", (Throwable)e);
                }
            }
            exoEvent.setPrivate(true);
            PropertyList attendees = event.getProperties("ATTENDEE");
            if (attendees.size() < 1) {
                exoEvent.setInvitation(new String[0]);
            } else {
                String[] invitation = new String[attendees.size()];
                for (int i = 0; i < attendees.size(); ++i) {
                    invitation[i] = ((Attendee)attendees.get(i)).getValue();
                }
                exoEvent.setInvitation(invitation);
            }
            eventList.add(exoEvent);
        }
        return eventList;
    }

    @Override
    public boolean isValidate(InputStream icalInputStream) {
        block4: {
            try {
                CalendarBuilder calendarBuilder = new CalendarBuilder();
                calendarBuilder.build(icalInputStream);
                return true;
            }
            catch (ParserException pe) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Can not parsing input stream to calendar under ICal format", (Throwable)pe);
                }
            }
            catch (IOException ioe) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug((Object)"IO Error occurs when parsing input stream to calendar under ICal format", (Throwable)ioe);
            }
        }
        return false;
    }

    @Override
    public void importCalendar(String username, InputStream icalInputStream, String calendarId, String calendarName, java.util.Calendar from, java.util.Calendar to, boolean isNew) throws Exception {
        net.fortuna.ical4j.model.Calendar iCalendar;
        CalendarBuilder calendarBuilder = new CalendarBuilder();
        CompatibilityHints.setHintEnabled((String)"ical4j.unfolding.relaxed", (boolean)true);
        try {
            iCalendar = calendarBuilder.build(icalInputStream);
        }
        catch (ParserException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"ParserException occurs when building iCalendar object", (Throwable)e);
            }
            throw new ParserException("Cannot parsed the input stream to iCalendar object", e.getLineNo());
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"IOException occurs when building iCalendar object", (Throwable)e);
            }
            throw new IOException("IOException when parsing input stream to iCalendar object");
        }
        finally {
            icalInputStream.close();
        }
        CalendarService calService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
        if (isNew) {
            String categoryId;
            NodeIterator iter = this.storage_.getCalendarCategoryHome(username).getNodes();
            Node cat = null;
            boolean isExists = false;
            while (iter.hasNext()) {
                cat = iter.nextNode();
                if (!cat.getProperty(Utils.EXO_NAME).getString().equals("Imported")) continue;
                isExists = true;
                break;
            }
            if (!isExists) {
                CalendarCategory calendarCate = new CalendarCategory();
                calendarCate.setDescription("Imported icalendar category");
                calendarCate.setName("Imported");
                categoryId = calendarCate.getId();
                calService.saveCalendarCategory(username, calendarCate, true);
            } else {
                categoryId = cat.getProperty(Utils.EXO_ID).getString();
            }
            Calendar exoCalendar = new Calendar();
            exoCalendar.setName(calendarName);
            exoCalendar.setCalendarColor(Calendar.COLORS[new Random().nextInt(Calendar.COLORS.length - 1)]);
            exoCalendar.setDescription(iCalendar.getProductId().getValue());
            exoCalendar.setCategoryId(categoryId);
            exoCalendar.setPublic(false);
            exoCalendar.setCalendarOwner(username);
            calService.saveUserCalendar(username, exoCalendar, true);
            calendarId = exoCalendar.getId();
        }
        ComponentList componentList = iCalendar.getComponents();
        HashMap<String, VFreeBusy> vFreeBusyData = new HashMap<String, VFreeBusy>();
        HashMap<String, VAlarm> vAlarmData = new HashMap<String, VAlarm>();
        HashMap<String, String> originalRecurrenceEvents = new HashMap<String, String>();
        HashMap exceptionOccurrences = new HashMap();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        int calType = this.storage_.getTypeOfCalendar(username, calendarId);
        for (Object obj : componentList) {
            VEvent v;
            if (obj instanceof VEvent && !(v = (VEvent)obj).getAlarms().isEmpty()) {
                for (Object o : v.getAlarms()) {
                    if (!(o instanceof VAlarm)) continue;
                    VAlarm va = (VAlarm)o;
                    vAlarmData.put(v.getUid().getValue() + ":" + va.getProperty("ACTION").getName(), va);
                }
            }
            if (!(obj instanceof VFreeBusy)) continue;
            vFreeBusyData.put(((VFreeBusy)obj).getUid().getValue(), (VFreeBusy)obj);
        }
        for (Object obj : componentList) {
            CalendarEvent exoEvent;
            VEvent event;
            if (obj instanceof VEvent) {
                event = (VEvent)obj;
                exoEvent = new CalendarEvent();
                try {
                    List exceptions;
                    String uuid;
                    exoEvent = RemoteCalendarServiceImpl.generateEvent(event, exoEvent, username, calendarId);
                    String sValue = Utils.EMPTY_STR;
                    String eValue = Utils.EMPTY_STR;
                    if (event.getStartDate() != null) {
                        if (to != null && event.getStartDate().getDate().getTime() > to.getTimeInMillis()) continue;
                        sValue = event.getStartDate().getValue();
                        exoEvent.setFromDateTime((java.util.Date)event.getStartDate().getDate());
                    }
                    if (event.getEndDate() != null) {
                        if (from != null && event.getEndDate().getDate().getTime() < from.getTimeInMillis()) continue;
                        eValue = event.getEndDate().getValue();
                        exoEvent.setToDateTime((java.util.Date)event.getEndDate().getDate());
                    }
                    if (sValue.length() == 8 && eValue.length() == 8) {
                        exoEvent.setToDateTime(new java.util.Date(event.getEndDate().getDate().getTime() - 1L));
                    }
                    if (vFreeBusyData.get(event.getUid().getValue()) != null) {
                        exoEvent.setEventState(CalendarEvent.ST_BUSY);
                    }
                    exoEvent = RemoteCalendarServiceImpl.setEventAttachment(event, exoEvent, eValue, sValue);
                    if (event.getProperty("RECURRENCE-ID") != null) {
                        RecurrenceId recurId = (RecurrenceId)event.getProperty("RECURRENCE-ID");
                        exoEvent.setRecurrenceId(format.format(new java.util.Date(recurId.getDate().getTime())));
                        String originalId = (String)originalRecurrenceEvents.get(event.getUid().getValue());
                        if (originalId != null) {
                            Node originalNode = this.storage_.getCalendarEventNode(username, String.valueOf(calType), calendarId, originalId);
                            CalendarEvent original = this.storage_.getEvent(originalNode);
                            uuid = originalNode.getUUID();
                            exoEvent.setOriginalReference(uuid);
                            ArrayList<Object> excludeId = original.getExcludeId() != null && original.getExcludeId().length > 0 ? new ArrayList<String>(Arrays.asList(original.getExcludeId())) : new ArrayList<String>();
                            excludeId.add(exoEvent.getRecurrenceId());
                            original.setExcludeId(excludeId.toArray(new String[0]));
                            if (calType == 0) {
                                this.storage_.saveUserEvent(username, calendarId, original, false);
                            } else if (calType == 2) {
                                this.storage_.savePublicEvent(calendarId, original, false);
                            } else if (calType == 1) {
                                this.storage_.saveEventToSharedCalendar(username, calendarId, original, false);
                            }
                        } else if (exceptionOccurrences.get(event.getUid().getValue()) == null) {
                            exceptions = new ArrayList<CalendarEvent>();
                            exceptions.add(exoEvent);
                            exceptionOccurrences.put(event.getUid().getValue(), exceptions);
                        } else {
                            ((List)exceptionOccurrences.get(event.getUid().getValue())).add(exoEvent);
                        }
                        this.storage_.saveOccurrenceEvent(username, calendarId, exoEvent, true);
                        continue;
                    }
                    if (event.getProperty("RRULE") != null && event.getProperty("RECURRENCE-ID") == null) {
                        exoEvent = RemoteCalendarServiceImpl.calculateEvent(event, exoEvent);
                        originalRecurrenceEvents.put(event.getUid().getValue(), exoEvent.getId());
                        ArrayList<String> excludeIds = new ArrayList<String>();
                        PropertyList exdates = event.getProperties("EXDATE");
                        if (exdates != null && exdates.size() > 0) {
                            for (Object exdate : exdates) {
                                for (Object date : ((ExDate)exdate).getDates()) {
                                    excludeIds.add(format.format(new java.util.Date(((DateTime)date).getTime())));
                                }
                            }
                        }
                        if ((exceptions = (List)exceptionOccurrences.get(event.getUid().getValue())) != null && exceptions.size() > 0) {
                            for (CalendarEvent exception : exceptions) {
                                excludeIds.add(exception.getRecurrenceId());
                            }
                        }
                        exoEvent.setExcludeId(excludeIds.toArray(new String[0]));
                        if (calType == 0) {
                            this.storage_.saveUserEvent(username, calendarId, exoEvent, true);
                        } else if (calType == 1) {
                            this.storage_.saveEventToSharedCalendar(username, calendarId, exoEvent, true);
                        } else if (calType == 2) {
                            this.storage_.savePublicEvent(calendarId, exoEvent, true);
                        }
                        Node originalNode = this.storage_.getCalendarEventNode(username, String.valueOf(calType), calendarId, exoEvent.getId());
                        uuid = originalNode.getUUID();
                        if (exceptions == null || exceptions.size() <= 0) continue;
                        for (CalendarEvent exception : exceptions) {
                            exception.setOriginalReference(uuid);
                            this.storage_.saveOccurrenceEvent(username, calendarId, exception, false);
                        }
                        continue;
                    }
                    if (calType == 0) {
                        this.storage_.saveUserEvent(username, calendarId, exoEvent, true);
                        continue;
                    }
                    if (calType == 1) {
                        this.storage_.saveEventToSharedCalendar(username, calendarId, exoEvent, true);
                        continue;
                    }
                    if (calType != 2) continue;
                    this.storage_.savePublicEvent(calendarId, exoEvent, true);
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Exception occurs when importing iCalendar component: " + event.getUid().getValue() + ". Skip this component."), (Throwable)e);
                }
                continue;
            }
            if (!(obj instanceof VToDo)) continue;
            event = (VToDo)obj;
            exoEvent = new CalendarEvent();
            try {
                exoEvent = RemoteCalendarServiceImpl.setTaskAttachment((VToDo)event, exoEvent, username, calendarId, vFreeBusyData);
                switch (this.storage_.getTypeOfCalendar(username, calendarId)) {
                    case 0: {
                        calService.saveUserEvent(username, calendarId, exoEvent, true);
                        break;
                    }
                    case 1: {
                        calService.saveEventToSharedCalendar(username, calendarId, exoEvent, true);
                        break;
                    }
                    case 2: {
                        calService.savePublicEvent(calendarId, exoEvent, true);
                    }
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Exception occurs when importing iCalendar VTODO component: " + event.getUid().getValue() + ". Skip this component."), (Throwable)e);
            }
        }
    }

    @Override
    public ByteArrayOutputStream exportEventCalendar(CalendarEvent exoEvent) throws Exception {
        net.fortuna.ical4j.model.Calendar calendar = new net.fortuna.ical4j.model.Calendar();
        calendar.getProperties().add((Property)new ProdId("-//Ben Fortuna//iCal4j 1.0//EN"));
        calendar.getProperties().add((Property)Version.VERSION_2_0);
        calendar.getProperties().add((Property)CalScale.GREGORIAN);
        calendar = exoEvent.getEventType().equals(CalendarEvent.TYPE_EVENT) ? this.getCalendarComponent(calendar, exoEvent, "VEVENT") : this.getCalendarComponent(calendar, exoEvent, "VTODO");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        CalendarOutputter output = new CalendarOutputter();
        try {
            output.output(calendar, (OutputStream)bout);
        }
        catch (ValidationException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Validate error", (Throwable)e);
            }
            return null;
        }
        return bout;
    }
}

