/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest.api_v1alpha1;

import java.util.HashMap;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.StorageException;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.service.rest.SecurityManager;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.social.service.rest.api_v1alpha1.models.Activity;
import org.exoplatform.social.service.rest.api_v1alpha1.models.ActivityStream;
import org.exoplatform.social.service.rest.api_v1alpha1.models.Comment;
import org.exoplatform.social.service.rest.api_v1alpha1.models.Identity;

@Path(value="api/social/v1-alpha1/{portalContainerName}/")
public class ActivityResources
implements ResourceContainer {
    private static final String[] SUPPORTED_FORMAT = new String[]{"json"};
    private ActivityManager activityManager;
    private IdentityManager identityManager;

    @GET
    @Path(value="activity/{activityId}.{format}")
    public Response getActivityById(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="activityId") String activityId, @PathParam(value="format") String format, @QueryParam(value="poster_identity") String showPosterIdentity, @QueryParam(value="number_of_comments") String numberOfComments, @QueryParam(value="activity_stream") String showActivityStream) {
        MediaType mediaType = Util.getMediaType(format, SUPPORTED_FORMAT);
        if (activityId != null && !activityId.equals("")) {
            PortalContainer portalContainer = this.getPortalContainer(portalContainerName);
            this.activityManager = Util.getActivityManager();
            this.identityManager = Util.getIdentityManager();
            if (this.isAuthenticated()) {
                try {
                    ActivityManager manager = Util.getActivityManager();
                    ExoSocialActivity activity = manager.getActivity(activityId);
                    if (!activity.isComment()) {
                        if (SecurityManager.canAccessActivity(portalContainer, ConversationState.getCurrent().getIdentity().getUserId(), activity)) {
                            Activity model = new Activity(activity);
                            if (this.isPassed(showPosterIdentity)) {
                                model.setPosterIdentity(new Identity(this.identityManager.getIdentity(activity.getUserId(), false)));
                            }
                            if (this.isPassed(showActivityStream)) {
                                model.setActivityStream(new ActivityStream(activity.getActivityStream()));
                            }
                            if (numberOfComments != null) {
                                int commentNumber = activity.getReplyToId().length;
                                int number = Integer.parseInt(numberOfComments);
                                if (number > 100) {
                                    number = 100;
                                }
                                if (number > commentNumber) {
                                    number = commentNumber;
                                }
                                RealtimeListAccess comments = this.activityManager.getCommentsWithListAccess(activity);
                                ExoSocialActivity[] commentsLimited = (ExoSocialActivity[])comments.load(0, number);
                                Comment[] commentWrapers = new Comment[number];
                                for (int i = 0; i < number; ++i) {
                                    commentWrapers[i] = new Comment(commentsLimited[i]);
                                }
                                model.setComments(commentWrapers);
                                model.setComments(commentWrapers);
                            }
                            model.setTotalNumberOfComments(activity.getReplyToId().length);
                            if (this.isLikedByIdentity(this.authenticatedUserIdentity().getId(), activity)) {
                                model.setLiked(true);
                            } else {
                                model.setLiked(false);
                            }
                            return Util.getResponse(model, uriInfo, mediaType, Response.Status.OK);
                        }
                        throw new WebApplicationException(Response.Status.UNAUTHORIZED);
                    }
                    throw new WebApplicationException(Response.Status.NOT_FOUND);
                }
                catch (Exception e) {
                    throw new WebApplicationException(Response.Status.NOT_FOUND);
                }
            }
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        throw new WebApplicationException(Response.Status.BAD_REQUEST);
    }

    @POST
    @Path(value="activity.{format}")
    public Response createNewActivity(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="format") String format, @QueryParam(value="identity_id") String identityIdStream, Activity newActivity) {
        MediaType mediaType = Util.getMediaType(format, SUPPORTED_FORMAT);
        if (newActivity != null && newActivity.getTitle() != null && !newActivity.getTitle().equals("")) {
            try {
                org.exoplatform.social.core.identity.model.Identity postToIdentity;
                ActivityManager activityManager = Util.getActivityManager();
                IdentityManager identityManager = Util.getIdentityManager();
                PortalContainer portalContainer = this.getPortalContainer(portalContainerName);
                org.exoplatform.social.core.identity.model.Identity authenticatedIdentity = this.authenticatedUserIdentity();
                if (identityIdStream != null && !identityIdStream.equals("")) {
                    postToIdentity = identityManager.getIdentity(identityIdStream, false);
                    if (postToIdentity == null) {
                        throw new WebApplicationException(Response.Status.BAD_REQUEST);
                    }
                } else {
                    postToIdentity = authenticatedIdentity;
                }
                if (authenticatedIdentity != null && SecurityManager.canPostActivity(portalContainer, authenticatedIdentity, postToIdentity)) {
                    ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
                    activity.setId(newActivity.getId());
                    activity.setTitle(newActivity.getTitle());
                    activity.setType(newActivity.getType());
                    activity.setPriority(newActivity.getPriority());
                    activity.setTitleId(newActivity.getTitleId());
                    activity.setTemplateParams(newActivity.getTemplateParams());
                    newActivity.setIdentityId(authenticatedIdentity.getId());
                    activityManager.saveActivityNoReturn(postToIdentity, (ExoSocialActivity)activity);
                    Activity model = new Activity((ExoSocialActivity)activity);
                    model.setIdentityId(postToIdentity.getId());
                    return Util.getResponse(model, uriInfo, mediaType, Response.Status.OK);
                }
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            catch (StorageException e) {
                throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
            }
        }
        throw new WebApplicationException(Response.Status.BAD_REQUEST);
    }

    @DELETE
    @Path(value="activity/{activityId}.{format}")
    public Response deleteExistingActivityById(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="activityId") String activityId, @PathParam(value="format") String format) {
        MediaType mediaType = Util.getMediaType(format, SUPPORTED_FORMAT);
        if (activityId != null && portalContainerName != null) {
            this.activityManager = Util.getActivityManager();
            this.identityManager = Util.getIdentityManager();
            PortalContainer portalContainer = this.getPortalContainer(portalContainerName);
            ExoSocialActivity existingActivity = this.activityManager.getActivity(activityId);
            org.exoplatform.social.core.identity.model.Identity authenticatedIdentity = this.authenticatedUserIdentity();
            if (authenticatedIdentity != null) {
                if (SecurityManager.canDeleteActivity(portalContainer, authenticatedIdentity, existingActivity)) {
                    this.activityManager.deleteActivity(existingActivity);
                    Activity model = new Activity(existingActivity);
                    return Util.getResponse(model, uriInfo, mediaType, Response.Status.OK);
                }
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        throw new WebApplicationException(Response.Status.BAD_REQUEST);
    }

    @POST
    @Path(value="activity/destroy/{activityId}.{format}")
    public Response postToDeleteActivityById(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="activityId") String activityId, @PathParam(value="format") String format) {
        return this.deleteExistingActivityById(uriInfo, portalContainerName, activityId, format);
    }

    @GET
    @Path(value="activity/{activityId}/comments.{format}")
    public Response getCommentsByActivityById(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="activityId") String activityId, @PathParam(value="format") String format) {
        MediaType mediaType = Util.getMediaType(format, SUPPORTED_FORMAT);
        if (activityId != null && !activityId.equals("")) {
            PortalContainer portalContainer = this.getPortalContainer(portalContainerName);
            this.activityManager = Util.getActivityManager();
            this.identityManager = Util.getIdentityManager();
            org.exoplatform.social.core.identity.model.Identity authenticatedUserIdentity = this.authenticatedUserIdentity();
            ExoSocialActivity activity = this.activityManager.getActivity(activityId);
            if (authenticatedUserIdentity != null) {
                if (SecurityManager.canAccessActivity(portalContainer, authenticatedUserIdentity, activity)) {
                    Comment[] commentWrapers = null;
                    try {
                        RealtimeListAccess comments = this.activityManager.getCommentsWithListAccess(activity);
                        int total = comments.getSize();
                        ExoSocialActivity[] commentsLimited = (ExoSocialActivity[])comments.load(0, total);
                        commentWrapers = new Comment[total];
                        for (int i = 0; i < total; ++i) {
                            commentWrapers[i] = new Comment(commentsLimited[i]);
                        }
                    }
                    catch (Exception e) {
                        throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
                    }
                    HashMap<String, Object> resultJson = new HashMap<String, Object>();
                    resultJson.put("total", commentWrapers.length);
                    resultJson.put("comments", commentWrapers);
                    return Util.getResponse(resultJson, uriInfo, mediaType, Response.Status.OK);
                }
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        throw new WebApplicationException(Response.Status.BAD_REQUEST);
    }

    @POST
    @Path(value="activity/{activityId}/comment.{format}")
    public Response createCommentActivityById(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="activityId") String activityId, @PathParam(value="format") String format, Comment comment) {
        MediaType mediaType = Util.getMediaType(format, SUPPORTED_FORMAT);
        if (comment != null && comment.getText() != null && !comment.getText().equals("")) {
            PortalContainer portalContainer = this.getPortalContainer(portalContainerName);
            this.activityManager = Util.getActivityManager();
            this.identityManager = Util.getIdentityManager();
            org.exoplatform.social.core.identity.model.Identity authenticatedUserIdentity = this.authenticatedUserIdentity();
            ExoSocialActivity activity = this.activityManager.getActivity(activityId);
            if (authenticatedUserIdentity != null) {
                if (SecurityManager.canCommentToActivity(portalContainer, authenticatedUserIdentity, activity)) {
                    ExoSocialActivityImpl commentActivity = new ExoSocialActivityImpl();
                    commentActivity.setTitle(comment.getText());
                    commentActivity.setUserId(authenticatedUserIdentity.getId());
                    this.activityManager.saveComment(activity, (ExoSocialActivity)commentActivity);
                    comment = new Comment((ExoSocialActivity)commentActivity);
                    return Util.getResponse(comment, uriInfo, mediaType, Response.Status.OK);
                }
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        throw new WebApplicationException(Response.Status.BAD_REQUEST);
    }

    @DELETE
    @Path(value="activity/{activityId}/comment/{commentId}.{format}")
    public Response deleteCommentById(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="activityId") String activityId, @PathParam(value="format") String format, @PathParam(value="commentId") String commentId) {
        MediaType mediaType = Util.getMediaType(format, SUPPORTED_FORMAT);
        if (commentId != null && !commentId.equals("")) {
            PortalContainer portalContainer = this.getPortalContainer(portalContainerName);
            this.activityManager = Util.getActivityManager();
            this.identityManager = Util.getIdentityManager();
            org.exoplatform.social.core.identity.model.Identity authenticatedUserIdentity = this.authenticatedUserIdentity();
            ExoSocialActivity commentActivity = this.activityManager.getActivity(commentId);
            ExoSocialActivity activity = this.activityManager.getActivity(activityId);
            if (commentActivity.isComment()) {
                if (authenticatedUserIdentity != null) {
                    if (SecurityManager.canDeleteActivity(portalContainer, authenticatedUserIdentity, commentActivity)) {
                        this.activityManager.deleteComment(activity, commentActivity);
                        Comment resultComment = new Comment(commentActivity);
                        return Util.getResponse(resultComment, uriInfo, mediaType, Response.Status.OK);
                    }
                    throw new WebApplicationException(Response.Status.FORBIDDEN);
                }
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        throw new WebApplicationException(Response.Status.BAD_REQUEST);
    }

    @POST
    @Path(value="activity/{activityId}/comment/destroy/{commentId}.{format}")
    public Response postDeleteCommentById(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="activityId") String activityId, @PathParam(value="format") String format, @PathParam(value="commentId") String commentId) {
        return this.deleteCommentById(uriInfo, portalContainerName, activityId, format, commentId);
    }

    @POST
    @Path(value="activity/{activityId}/like.{format}")
    public Response createLikeActivityById(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="activityId") String activityId, @PathParam(value="format") String format) {
        MediaType mediaType = Util.getMediaType(format, SUPPORTED_FORMAT);
        if (activityId != null && !activityId.equals("")) {
            PortalContainer portalContainer = this.getPortalContainer(portalContainerName);
            this.activityManager = Util.getActivityManager();
            this.identityManager = Util.getIdentityManager();
            org.exoplatform.social.core.identity.model.Identity authenticatedUserIdentity = this.authenticatedUserIdentity();
            ExoSocialActivity activity = this.activityManager.getActivity(activityId);
            if (authenticatedUserIdentity != null) {
                if (SecurityManager.canCommentToActivity(portalContainer, authenticatedUserIdentity, activity)) {
                    this.activityManager.saveLike(activity, this.authenticatedUserIdentity());
                    HashMap<String, Boolean> resultJson = new HashMap<String, Boolean>();
                    resultJson.put("like", true);
                    return Util.getResponse(resultJson, uriInfo, mediaType, Response.Status.OK);
                }
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        throw new WebApplicationException(Response.Status.BAD_REQUEST);
    }

    @DELETE
    @Path(value="activity/{activityId}/like.{format}")
    public Response deleteLikeActivityById(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="activityId") String activityId, @PathParam(value="format") String format) {
        MediaType mediaType = Util.getMediaType(format, SUPPORTED_FORMAT);
        if (activityId != null && !activityId.equals("")) {
            PortalContainer portalContainer = this.getPortalContainer(portalContainerName);
            this.activityManager = Util.getActivityManager();
            this.identityManager = Util.getIdentityManager();
            org.exoplatform.social.core.identity.model.Identity authenticatedUserIdentity = this.authenticatedUserIdentity();
            ExoSocialActivity activity = this.activityManager.getActivity(activityId);
            if (authenticatedUserIdentity != null) {
                if (SecurityManager.canCommentToActivity(portalContainer, authenticatedUserIdentity, activity)) {
                    this.activityManager.deleteLike(activity, this.authenticatedUserIdentity());
                    HashMap<String, Boolean> resultJson = new HashMap<String, Boolean>();
                    resultJson.put("like", false);
                    return Util.getResponse(resultJson, uriInfo, mediaType, Response.Status.OK);
                }
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        throw new WebApplicationException(Response.Status.BAD_REQUEST);
    }

    @POST
    @Path(value="activity/{activityId}/like/destroy.{format}")
    public Response postDeleteLikeActivityById(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="activityId") String activityId, @PathParam(value="format") String format) {
        return this.deleteLikeActivityById(uriInfo, portalContainerName, activityId, format);
    }

    private boolean isLikedByIdentity(String identityID, ExoSocialActivity activity) {
        String[] likedIdentityIds = activity.getLikeIdentityIds();
        if (activity.getLikeIdentityIds() != null && likedIdentityIds.length > 0) {
            for (int i = 0; i < likedIdentityIds.length; ++i) {
                if (!identityID.equals(likedIdentityIds[i])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAuthenticated() {
        return ConversationState.getCurrent() != null && ConversationState.getCurrent().getIdentity() != null && ConversationState.getCurrent().getIdentity().getUserId() != null;
    }

    private org.exoplatform.social.core.identity.model.Identity authenticatedUserIdentity() {
        if (ConversationState.getCurrent() != null && ConversationState.getCurrent().getIdentity() != null && ConversationState.getCurrent().getIdentity().getUserId() != null) {
            IdentityManager identityManager = Util.getIdentityManager();
            String authenticatedUserRemoteID = ConversationState.getCurrent().getIdentity().getUserId();
            return identityManager.getOrCreateIdentity("organization", authenticatedUserRemoteID, false);
        }
        return null;
    }

    private boolean isPassed(String value) {
        return value != null && ("true".equals(value) || "t".equals(value) || "1".equals(value));
    }

    private PortalContainer getPortalContainer(String name) {
        return (PortalContainer)ExoContainerContext.getContainerByName((String)name);
    }
}

