/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.upload;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Iterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.fileupload.FileItem;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.CountingInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.SecureContentHandler;
import org.exoplatform.ide.upload.UploadServiceException;
import org.exoplatform.ide.zip.ZipUtils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

@Path(value="/ide/upload")
public class UploadService {
    private static final String WEBDAV_CONTEXT = "jcr";
    static final String ERROR_OPEN = "<error>";
    static final String ERROR_CLOSE = "</error>";
    private static Log log = ExoLogger.getLogger(UploadService.class);
    private final RepositoryService repositoryService;
    private final ThreadLocalSessionProviderService sessionProviderService;

    public UploadService(RepositoryService repositoryService, ThreadLocalSessionProviderService sessionProviderService) {
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
    }

    @POST
    @Consumes(value={"multipart/*"})
    @Path(value="/folder")
    @Produces(value={"text/html"})
    public Response uploadFolder(Iterator<FileItem> iterator, @Context UriInfo uriInfo) throws UploadServiceException {
        HashMap<String, FileItem> requestItems = this.getRequestItems(iterator);
        if (requestItems.get("file") == null) {
            throw new UploadServiceException(500, "<error>Can't find input file</error>");
        }
        FileItem fileItem = requestItems.get("file");
        try {
            InputStream inStream = fileItem.getInputStream();
            this.checkForZipBomb(inStream);
            String location = this.getLocation(requestItems, uriInfo);
            if (location == null) {
                throw new UploadServiceException(500, "<error>Invalid path, where to upload file</error>");
            }
            String repositoryName = location.substring(0, location.indexOf("/"));
            String repoPath = location.substring(location.indexOf("/") + 1);
            Session session = null;
            session = this.getSession(repositoryName, repoPath);
            ZipUtils.unzip(session, fileItem.getInputStream(), this.getResourcePath(repoPath));
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new UploadServiceException(500, e.getMessage());
        }
        catch (IllegalArgumentException e) {
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new UploadServiceException(500, e.getMessage());
        }
        catch (SAXException e) {
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new UploadServiceException(500, e.getMessage());
        }
        catch (TikaException e) {
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new UploadServiceException(500, e.getMessage());
        }
        catch (RepositoryException e) {
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new UploadServiceException(500, e.getMessage());
        }
        catch (RepositoryConfigurationException e) {
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new UploadServiceException(500, e.getMessage());
        }
        return Response.ok().type("text/html").build();
    }

    @POST
    @Consumes(value={"multipart/*"})
    @Produces(value={"text/html"})
    public Response uploadFile(Iterator<FileItem> iterator, @Context UriInfo uriInfo) throws UploadServiceException {
        HashMap<String, FileItem> requestItems = this.getRequestItems(iterator);
        if (requestItems.get("file") == null) {
            throw new UploadServiceException(500, "<error>Can't find input file</error>");
        }
        try {
            FileItem fileItem = requestItems.get("file");
            InputStream inputStream = fileItem.getInputStream();
            String location = this.getLocation(requestItems, uriInfo);
            if (location == null) {
                throw new UploadServiceException("<error>Invalid path, where to upload file</error>");
            }
            String repositoryName = location.substring(0, location.indexOf("/"));
            String repoPath = location.substring(location.indexOf("/") + 1);
            String mimeType = requestItems.get("mimeType").getString();
            String nodeType = null;
            if (requestItems.get("nodeType") != null && "".equals(nodeType = requestItems.get("nodeType").getString())) {
                nodeType = null;
            }
            String jcrContentNodeType = null;
            if (requestItems.get("jcrContentNodeType") != null && "".equals(jcrContentNodeType = requestItems.get("jcrContentNodeType").getString())) {
                jcrContentNodeType = null;
            }
            Session session = null;
            session = this.getSession(repositoryName, repoPath);
            ZipUtils.putFile(session, this.getResourcePath(repoPath), this.getFileName(repoPath), inputStream, mimeType, nodeType, jcrContentNodeType);
            session.save();
            return Response.status((int)201).type("text/html").build();
        }
        catch (PathNotFoundException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UploadServiceException(500, e.getMessage());
        }
        catch (RepositoryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UploadServiceException(500, e.getMessage());
        }
        catch (RepositoryConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UploadServiceException(500, e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UploadServiceException(500, e.getMessage());
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UploadServiceException(500, e.getMessage());
        }
    }

    private void checkForZipBomb(InputStream inputStream) throws IOException, SAXException, TikaException {
        InputStream is = inputStream;
        CountingInputStream count = new CountingInputStream(is);
        BodyContentHandler handler = new BodyContentHandler();
        SecureContentHandler secure = new SecureContentHandler((ContentHandler)handler, count);
        Metadata metadata = new Metadata();
        AutoDetectParser parser = new AutoDetectParser();
        parser.parse((InputStream)count, (ContentHandler)secure, metadata);
        if (count != null) {
            count.close();
        }
        if (is != null) {
            is.close();
        }
    }

    private Session getSession(String repoName, String repoPath) throws RepositoryException, RepositoryConfigurationException {
        ManageableRepository repo = this.repositoryService.getRepository(repoName);
        SessionProvider sp = this.sessionProviderService.getSessionProvider(null);
        if (sp == null) {
            throw new RepositoryException("SessionProvider is not properly set. Make the application callsSessionProviderService.setSessionProvider(..) somewhere before (for instance in Servlet Filter for WEB application)");
        }
        if (repoPath.length() > 0 && repoPath.startsWith("/")) {
            repoPath = repoPath.substring(1);
        }
        String workspace = repoPath;
        if (repoPath.contains("/")) {
            workspace = repoPath.split("/")[0];
        }
        return sp.getSession(workspace, repo);
    }

    private String getResourcePath(String repoPath) {
        String resourcePath;
        if (repoPath.startsWith("/")) {
            repoPath = repoPath.substring(1);
        }
        resourcePath = (resourcePath = repoPath.substring(repoPath.indexOf("/") + 1)).contains("/") ? resourcePath.substring(0, resourcePath.lastIndexOf("/")) : null;
        return resourcePath;
    }

    private String getFileName(String repoPath) {
        return repoPath.substring(repoPath.lastIndexOf("/") + 1);
    }

    private HashMap<String, FileItem> getRequestItems(Iterator<FileItem> iterator) {
        HashMap<String, FileItem> requestItems = new HashMap<String, FileItem>();
        while (iterator.hasNext()) {
            FileItem item = iterator.next();
            String fieldName = item.getFieldName();
            requestItems.put(fieldName, item);
        }
        return requestItems;
    }

    private String getLocation(HashMap<String, FileItem> requestItems, UriInfo uriInfo) throws UnsupportedEncodingException {
        String location = requestItems.get("location").getString();
        location = URLDecoder.decode(location, "UTF-8");
        String prefix = uriInfo.getBaseUriBuilder().segment(new String[]{WEBDAV_CONTEXT, "/"}).build(new Object[0]).toString();
        if (!location.startsWith(prefix)) {
            return null;
        }
        location = location.substring(prefix.length());
        return location;
    }

    static interface FormFields {
        public static final String FILE = "file";
        public static final String LOCATION = "location";
        public static final String MIME_TYPE = "mimeType";
        public static final String NODE_TYPE = "nodeType";
        public static final String JCR_CONTENT_NODE_TYPE = "jcrContentNodeType";
    }
}

