/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.database.impl;

import java.io.Serializable;
import java.net.URL;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.Property;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.database.HibernateService;
import org.exoplatform.services.database.ObjectQuery;
import org.exoplatform.services.database.impl.AddHibernateMappingPlugin;
import org.exoplatform.services.database.impl.ExoCacheProvider;
import org.exoplatform.services.database.impl.HibernateConfigurationImpl;
import org.exoplatform.services.database.impl.HibernateSettingsFactory;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.resolver.DialectFactory;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;

public class HibernateServiceImpl
implements HibernateService,
ComponentRequestLifecycle {
    public static final String AUTO_DIALECT = "AUTO";
    private ThreadLocal<Session> threadLocal_;
    private static Log log_ = ExoLogger.getLogger((String)"exo.core.component.database.HibernateServiceImpl");
    private HibernateConfigurationImpl conf_;
    private SessionFactory sessionFactory_;
    private HashSet<String> mappings_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HibernateServiceImpl(InitParams initParams, CacheService cacheService) {
        block25: {
            String dialect;
            this.mappings_ = new HashSet();
            this.threadLocal_ = new ThreadLocal();
            PropertiesParam param = initParams.getPropertiesParam("hibernate.properties");
            final HibernateSettingsFactory settingsFactory = new HibernateSettingsFactory(new ExoCacheProvider(cacheService));
            this.conf_ = (HibernateConfigurationImpl)((Object)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<HibernateConfigurationImpl>(){

                @Override
                public HibernateConfigurationImpl run() {
                    return new HibernateConfigurationImpl(settingsFactory);
                }
            }));
            Iterator properties = param.getPropertyIterator();
            while (properties.hasNext()) {
                Property p = (Property)properties.next();
                String name = p.getName();
                String value = p.getValue();
                if (name.equals("hibernate.dialect") && !value.equalsIgnoreCase(AUTO_DIALECT)) {
                    Package pkg = Dialect.class.getPackage();
                    String dialect2 = value.substring(22);
                    value = pkg.getName() + "." + dialect2;
                    log_.info((Object)("Using dialect " + dialect2));
                }
                this.conf_.setProperty(name, value);
            }
            String connectionURL = this.conf_.getProperty("hibernate.connection.url");
            if (connectionURL != null) {
                connectionURL = connectionURL.replace("${java.io.tmpdir}", PrivilegedSystemHelper.getProperty((String)"java.io.tmpdir"));
                this.conf_.setProperty("hibernate.connection.url", connectionURL);
            }
            if ((dialect = this.conf_.getProperty("hibernate.dialect")) == null || dialect.equalsIgnoreCase(AUTO_DIALECT)) {
                Connection connection = null;
                try {
                    String dataSourceName = this.conf_.getProperty("hibernate.connection.datasource");
                    if (dataSourceName != null) {
                        try {
                            DataSource dataSource = (DataSource)new InitialContext().lookup(dataSourceName);
                            if (dataSource == null) {
                                log_.error((Object)"DataSource is configured but not finded.", (Throwable)new Exception());
                                break block25;
                            }
                            connection = dataSource.getConnection();
                            Dialect d = DialectFactory.buildDialect((Properties)new Properties(), (Connection)connection);
                            this.conf_.setProperty("hibernate.dialect", d.getClass().getName());
                        }
                        catch (NamingException e) {
                            log_.error((Object)e.getMessage(), (Throwable)e);
                        }
                        break block25;
                    }
                    String url = this.conf_.getProperty("hibernate.connection.url");
                    if (url != null) {
                        try {
                            Class.forName(this.conf_.getProperty("hibernate.connection.driver_class")).newInstance();
                        }
                        catch (InstantiationException e) {
                            log_.error((Object)e.getMessage(), (Throwable)e);
                        }
                        catch (IllegalAccessException e) {
                            log_.error((Object)e.getMessage(), (Throwable)e);
                        }
                        catch (ClassNotFoundException e) {
                            log_.error((Object)e.getMessage(), (Throwable)e);
                        }
                        String dbUserName = this.conf_.getProperty("hibernate.connection.username");
                        String dbPassword = this.conf_.getProperty("hibernate.connection.password");
                        connection = dbUserName != null ? DriverManager.getConnection(url, dbUserName, dbPassword) : DriverManager.getConnection(url);
                        Dialect d = DialectFactory.buildDialect((Properties)new Properties(), (Connection)connection);
                        this.conf_.setProperty("hibernate.dialect", d.getClass().getName());
                        break block25;
                    }
                    Exception e = new Exception("Any data source is not configured!");
                    log_.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (SQLException e) {
                    log_.error((Object)e.getMessage(), (Throwable)e);
                }
                finally {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException e) {
                            log_.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    public void addPlugin(ComponentPlugin plugin) {
        if (plugin instanceof AddHibernateMappingPlugin) {
            AddHibernateMappingPlugin impl = (AddHibernateMappingPlugin)plugin;
            try {
                List<String> annotations;
                List path = impl.getMapping();
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (path != null) {
                    for (int i = 0; i < path.size(); ++i) {
                        String relativePath = (String)path.get(i);
                        if (this.mappings_.contains(relativePath)) continue;
                        this.mappings_.add(relativePath);
                        URL url = cl.getResource(relativePath);
                        log_.info((Object)("Adding  Hibernate Mapping: " + relativePath));
                        this.conf_.addURL(url);
                    }
                }
                if ((annotations = impl.getAnnotations()) != null) {
                    for (String annotation : annotations) {
                        Class<?> clazz = cl.loadClass(annotation);
                        this.conf_.addAnnotatedClass(clazz);
                    }
                }
            }
            catch (Exception ex) {
                log_.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
    }

    public ComponentPlugin removePlugin(String name) {
        return null;
    }

    public Collection getPlugins() {
        return null;
    }

    public Configuration getHibernateConfiguration() {
        return this.conf_;
    }

    public SessionFactory getSessionFactory() {
        if (this.sessionFactory_ == null) {
            this.sessionFactory_ = (SessionFactory)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<SessionFactory>(){

                @Override
                public SessionFactory run() {
                    SessionFactory factory = HibernateServiceImpl.this.conf_.buildSessionFactory();
                    new SchemaUpdate((Configuration)HibernateServiceImpl.this.conf_).execute(false, true);
                    return factory;
                }
            });
        }
        return this.sessionFactory_;
    }

    public Session openSession() {
        Session currentSession = this.threadLocal_.get();
        if (currentSession == null) {
            if (log_.isDebugEnabled()) {
                log_.debug((Object)"open new hibernate session in openSession()");
            }
            currentSession = this.getSessionFactory().openSession();
            this.threadLocal_.set(currentSession);
        }
        return currentSession;
    }

    public Session openNewSession() {
        Session currentSession = this.threadLocal_.get();
        if (currentSession != null) {
            this.closeSession(currentSession);
        }
        currentSession = this.getSessionFactory().openSession();
        this.threadLocal_.set(currentSession);
        return currentSession;
    }

    public void closeSession(Session session) {
        if (session == null) {
            return;
        }
        try {
            session.close();
            if (log_.isDebugEnabled()) {
                log_.debug((Object)"close hibernate session in openSession(Session session)");
            }
        }
        catch (Throwable t) {
            log_.error((Object)("Error closing hibernate session : " + t.getMessage()), t);
        }
        this.threadLocal_.set(null);
    }

    public final void closeSession() {
        Session s = this.threadLocal_.get();
        if (s != null) {
            s.close();
        }
        this.threadLocal_.set(null);
    }

    public Object findExactOne(Session session, String query, String id) throws Exception {
        Object res = session.createQuery(query).setString(0, id).uniqueResult();
        if (res == null) {
            throw new ObjectNotFoundException("Cannot find the object with id: " + id);
        }
        return res;
    }

    public Object findOne(Session session, String query, String id) throws Exception {
        List l = session.createQuery(query).setString(0, id).list();
        if (l.size() == 0) {
            return null;
        }
        if (l.size() > 1) {
            throw new Exception("Expect only one object but found" + l.size());
        }
        return l.get(0);
    }

    public Object findOne(Class clazz, Serializable id) throws Exception {
        Session session = this.openSession();
        Object obj = session.get(clazz, id);
        return obj;
    }

    public Object findOne(ObjectQuery q) throws Exception {
        Session session = this.openSession();
        List l = session.createQuery(q.getHibernateQuery()).list();
        if (l.size() == 0) {
            return null;
        }
        if (l.size() > 1) {
            throw new Exception("Expect only one object but found" + l.size());
        }
        return l.get(0);
    }

    public Object create(Object obj) throws Exception {
        Session session = this.openSession();
        session.save(obj);
        session.flush();
        return obj;
    }

    public Object update(Object obj) throws Exception {
        Session session = this.openSession();
        session.update(obj);
        session.flush();
        return obj;
    }

    public Object save(Object obj) throws Exception {
        Session session = this.openSession();
        session.merge(obj);
        session.flush();
        return obj;
    }

    public Object remove(Object obj) throws Exception {
        Session session = this.openSession();
        session.delete(obj);
        session.flush();
        return obj;
    }

    public Object remove(Class clazz, Serializable id) throws Exception {
        Session session = this.openSession();
        Object obj = session.get(clazz, id);
        session.delete(obj);
        session.flush();
        return obj;
    }

    public Object remove(Session session, Class clazz, Serializable id) throws Exception {
        Object obj = session.get(clazz, id);
        session.delete(obj);
        return obj;
    }

    public void startRequest(ExoContainer container) {
    }

    public void endRequest(ExoContainer container) {
        this.closeSession();
    }
}

