/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.control;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.InvalidQueryException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.jcr.SimpleSearchValidator;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentContainer;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentWorkspace;
import org.exoplatform.ecm.webui.component.explorer.UIDrivesArea;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.UIActionBar;
import org.exoplatform.ecm.webui.component.explorer.control.UIControl;
import org.exoplatform.ecm.webui.component.explorer.search.UISearchResult;
import org.exoplatform.services.cms.link.LinkUtils;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/explorer/control/UIAddressBar.gtmpl", events={@EventConfig(listeners={ChangeNodeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={BackActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={HistoryActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangeViewActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SimpleSearchActionListener.class}), @EventConfig(listeners={RefreshSessionActionListener.class}, phase=Event.Phase.DECODE)})
public class UIAddressBar
extends UIForm {
    public static final Pattern FILE_EXPLORER_URL_SYNTAX = Pattern.compile("([^:/]+):(.*)");
    public static final String WS_NAME = "workspaceName";
    public static final String FIELD_ADDRESS = "address";
    public static final String ACTION_TAXONOMY = "exo:taxonomyAction";
    public static final String EXO_TARGETPATH = "exo:targetPath";
    public static final String EXO_TARGETWORKSPACE = "exo:targetWorkspace";
    private String selectedViewName_;
    private String[] arrView_ = new String[0];
    private static final String MESSAGE_NOT_SUPPORT_KEYWORD = "UIAddressBar.msg.keyword-not-support".intern();
    private static final String FIELD_SIMPLE_SEARCH = "simpleSearch";
    private static final String ROOT_SQL_QUERY = "select * from nt:base where (jcr:primaryType like 'exo:symlink' or jcr:primaryType like 'exo:taxonomyLink') OR ( contains(*, '$1') or lower(exo:name) like '%$2%') order by exo:title ASC";
    private static final String SQL_QUERY = "select * from nt:base where jcr:path like '$0/%' AND ( (jcr:primaryType like 'exo:symlink' or jcr:primaryType like 'exo:taxonomyLink') OR ( contains(*, '$1') or lower(exo:name) like '%$2%') ) order by exo:title ASC";

    public UIAddressBar() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_ADDRESS, FIELD_ADDRESS, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_SIMPLE_SEARCH, FIELD_SIMPLE_SEARCH, null).addValidator(SimpleSearchValidator.class, new Object[0]));
    }

    public void setViewList(List<String> viewList) {
        Collections.sort(viewList);
        this.arrView_ = viewList.toArray(new String[viewList.size()]);
    }

    public String[] getViewList() {
        return this.arrView_;
    }

    public void setSelectedViewName(String viewName) {
        this.selectedViewName_ = viewName;
    }

    public boolean isSelectedView(String viewName) {
        return this.selectedViewName_ != null && this.selectedViewName_.equals(viewName);
    }

    public String getSelectedViewName() {
        return this.selectedViewName_;
    }

    @Deprecated
    public Set<String> getHistory() {
        UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        return uiJCRExplorer.getAddressPath();
    }

    public Collection<UIJCRExplorer.HistoryEntry> getFullHistory() {
        UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        return uiJCRExplorer.getHistory();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RefreshSessionActionListener
    extends EventListener<UIAddressBar> {
        public void execute(Event<UIAddressBar> event) throws Exception {
            UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)((UIAddressBar)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            uiJCRExplorer.getSession().refresh(false);
            uiJCRExplorer.refreshExplorer();
            UIControl uiControl = (UIControl)((UIAddressBar)((Object)event.getSource())).getParent();
            UIActionBar uiActionBar = (UIActionBar)uiControl.getChild(UIActionBar.class);
            uiActionBar.setTabOptions(((UIAddressBar)((Object)event.getSource())).getSelectedViewName());
            UIApplication uiApp = (UIApplication)uiJCRExplorer.getAncestorOfType(UIApplication.class);
            String mess = "UIJCRExplorer.msg.refresh-session-success";
            uiApp.addMessage(new ApplicationMessage(mess, null, 2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleSearchActionListener
    extends EventListener<UIAddressBar> {
        public void execute(Event<UIAddressBar> event) throws Exception {
            UIAddressBar uiAddressBar = (UIAddressBar)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)uiAddressBar.getAncestorOfType(UIApplication.class);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiAddressBar.getAncestorOfType(UIJCRExplorer.class);
            String text = (String)uiAddressBar.getUIStringInput(UIAddressBar.FIELD_SIMPLE_SEARCH).getValue();
            Node currentNode = uiExplorer.getCurrentNode();
            String queryStatement = null;
            queryStatement = "/".equals(currentNode.getPath()) ? UIAddressBar.ROOT_SQL_QUERY : StringUtils.replace((String)UIAddressBar.SQL_QUERY, (String)"$0", (String)currentNode.getPath());
            queryStatement = StringUtils.replace((String)queryStatement, (String)"$1", (String)text.replaceAll("'", "''"));
            queryStatement = StringUtils.replace((String)queryStatement, (String)"$2", (String)text.replaceAll("'", "''").toLowerCase());
            uiExplorer.removeChildById("ViewSearch");
            UIWorkingArea uiWorkingArea = (UIWorkingArea)uiExplorer.getChild(UIWorkingArea.class);
            UIDocumentWorkspace uiDocumentWorkspace = (UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class);
            if (!uiDocumentWorkspace.isRendered()) {
                ((UIDrivesArea)uiWorkingArea.getChild(UIDrivesArea.class)).setRendered(false);
                ((UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class)).setRendered(true);
            }
            SessionProvider sessionProvider = new SessionProvider(ConversationState.getCurrent());
            Session session = sessionProvider.getSession(currentNode.getSession().getWorkspace().getName(), (ManageableRepository)currentNode.getSession().getRepository());
            UISearchResult uiSearchResult = (UISearchResult)uiDocumentWorkspace.getChildById(UIDocumentWorkspace.SIMPLE_SEARCH_RESULT);
            long startTime = System.currentTimeMillis();
            uiSearchResult.setQuery(queryStatement, session.getWorkspace().getName(), "sql", IdentityConstants.SYSTEM.equals(session.getUserID()), text);
            try {
                uiSearchResult.updateGrid();
            }
            catch (InvalidQueryException invalidEx) {
                uiApp.addMessage(new ApplicationMessage(MESSAGE_NOT_SUPPORT_KEYWORD, null, 1));
                return;
            }
            catch (RepositoryException reEx) {
                uiApp.addMessage(new ApplicationMessage(MESSAGE_NOT_SUPPORT_KEYWORD, null, 1));
                return;
            }
            long time = System.currentTimeMillis() - startTime;
            uiSearchResult.setSearchTime(time);
            uiDocumentWorkspace.setRenderedChild(UISearchResult.class);
            if (!uiDocumentWorkspace.isRendered()) {
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDocumentWorkspace);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeViewActionListener
    extends EventListener<UIAddressBar> {
        public void execute(Event<UIAddressBar> event) throws Exception {
            UIAddressBar uiAddressBar = (UIAddressBar)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiAddressBar.getAncestorOfType(UIJCRExplorer.class);
            UIWorkingArea uiWorkingArea = (UIWorkingArea)uiExplorer.getChild(UIWorkingArea.class);
            UIDocumentWorkspace uiDocumentWorkspace = (UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class);
            if (!uiDocumentWorkspace.isRendered()) {
                ((UIDrivesArea)uiWorkingArea.getChild(UIDrivesArea.class)).setRendered(false);
                ((UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class)).setRendered(true);
            }
            String viewName = event.getRequestContext().getRequestParameter("objectId");
            uiAddressBar.setSelectedViewName(viewName);
            UIControl uiControl = (UIControl)uiAddressBar.getParent();
            UIActionBar uiActionBar = (UIActionBar)uiControl.getChild(UIActionBar.class);
            uiActionBar.setTabOptions(viewName);
            uiExplorer.updateAjax(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HistoryActionListener
    extends EventListener<UIAddressBar> {
        public void execute(Event<UIAddressBar> event) throws Exception {
            UIAddressBar uiAddressBar = (UIAddressBar)((Object)event.getSource());
            String fullPath = event.getRequestContext().getRequestParameter("objectId");
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiAddressBar.getAncestorOfType(UIJCRExplorer.class);
            String workspace = null;
            String path = null;
            try {
                Matcher matcher = FILE_EXPLORER_URL_SYNTAX.matcher(fullPath);
                if (matcher.find()) {
                    workspace = matcher.group(1);
                    path = matcher.group(2);
                }
                uiExplorer.setSelectNode(workspace, path);
                uiExplorer.refreshExplorer();
            }
            catch (AccessDeniedException ade) {
                UIApplication uiApp = (UIApplication)uiAddressBar.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIAddressBar.msg.access-denied", null, 1));
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeNodeActionListener
    extends EventListener<UIAddressBar> {
        public void execute(Event<UIAddressBar> event) throws Exception {
            UIAddressBar uiAddress = (UIAddressBar)((Object)event.getSource());
            String path = Text.escapeIllegalJcrChars((String)((String)uiAddress.getUIStringInput(UIAddressBar.FIELD_ADDRESS).getValue()));
            if (path == null || path.trim().length() == 0) {
                path = "/";
            }
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiAddress.getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.setIsViewTag(false);
            try {
                String prefix = uiExplorer.getRootPath();
                String nodePath = LinkUtils.evaluatePath((String)LinkUtils.createPath((String)prefix, (String)path));
                uiExplorer.setSelectNode(nodePath);
                uiExplorer.setCurrentStatePath(nodePath);
                UIWorkingArea uiWorkingArea = (UIWorkingArea)uiExplorer.getChild(UIWorkingArea.class);
                UIDocumentWorkspace uiDocumentWorkspace = (UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class);
                if (!uiDocumentWorkspace.isRendered()) {
                    uiDocumentWorkspace.setRendered(true);
                } else {
                    uiDocumentWorkspace.setRenderedChild(UIDocumentContainer.class);
                }
            }
            catch (Exception e) {
                UIApplication uiApp = (UIApplication)uiAddress.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIAddressBar.msg.path-not-found", null, 1));
                return;
            }
            uiExplorer.updateAjax(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BackActionListener
    extends EventListener<UIAddressBar> {
        public void execute(Event<UIAddressBar> event) throws Exception {
            UIAddressBar uiAddressBar = (UIAddressBar)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiAddressBar.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
            try {
                UIWorkingArea uiWorkingArea = (UIWorkingArea)uiExplorer.getChild(UIWorkingArea.class);
                UIDocumentWorkspace uiDocumentWorkspace = (UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class);
                if (!uiDocumentWorkspace.isRendered()) {
                    ((UIDrivesArea)uiWorkingArea.getChild(UIDrivesArea.class)).setRendered(false);
                    ((UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class)).setRendered(true);
                    uiDocumentWorkspace.setRenderedChild(UIDocumentContainer.class);
                }
                if (uiExplorer.isViewTag() && !uiExplorer.getCurrentNode().equals(uiExplorer.getRootNode())) {
                    uiExplorer.setSelectRootNode();
                    uiExplorer.setIsViewTag(true);
                } else if (uiExplorer.isViewTag() && uiExplorer.getCurrentStateNode() != null) {
                    uiExplorer.setIsViewTag(false);
                    uiExplorer.setSelectNode(uiExplorer.getCurrentStatePath());
                } else {
                    String previousNodePath = uiExplorer.rewind();
                    String previousWs = uiExplorer.previousWsName();
                    uiExplorer.setBackNodePath(previousWs, previousNodePath);
                }
                uiExplorer.updateAjax(event);
            }
            catch (AccessDeniedException ade) {
                uiApp.addMessage(new ApplicationMessage("UIAddressBar.msg.access-denied", null, 1));
                return;
            }
            catch (Exception e) {
                uiApp.addMessage(new ApplicationMessage("UIJCRExplorer.msg.no-node-history", null, 1));
                return;
            }
        }
    }
}

