/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.core;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.core.security.JCRRuntimePermissions;
import org.exoplatform.services.jcr.impl.ReadOnlySupport;
import org.exoplatform.services.jcr.impl.WorkspaceContainer;
import org.exoplatform.services.jcr.impl.backup.ResumeException;
import org.exoplatform.services.jcr.impl.backup.SuspendException;
import org.exoplatform.services.jcr.impl.backup.Suspendable;

public final class WorkspaceContainerFacade {
    private final String workspaceName;
    private final WorkspaceContainer container;

    public WorkspaceContainerFacade(String workspaceName, WorkspaceContainer container) {
        this.workspaceName = workspaceName;
        this.container = container;
    }

    public final String getWorkspaceName() {
        return this.workspaceName;
    }

    public List getComponentInstancesOfType(Class componentType) {
        return this.container.getComponentInstancesOfType(componentType);
    }

    public Object getComponent(Object key) {
        if (key instanceof Class) {
            return this.container.getComponentInstanceOfType((Class)key);
        }
        return this.container.getComponentInstance(key);
    }

    public void addComponent(Object component) {
        if (component instanceof Class) {
            this.container.registerComponentImplementation((Class)component);
        } else {
            this.container.registerComponentInstance(component);
        }
    }

    public void addComponent(Object key, Object component) {
        this.container.registerComponentInstance(key, component);
    }

    public int getState() {
        boolean hasROComponents = false;
        boolean hasRWComponents = false;
        List readOnlyComponents = this.getComponentInstancesOfType(ReadOnlySupport.class);
        for (ReadOnlySupport component : readOnlyComponents) {
            if (component.isReadOnly()) {
                hasROComponents = true;
                continue;
            }
            hasRWComponents = true;
        }
        boolean hasSuspendedComponents = false;
        boolean hasResumedComponents = false;
        List suspendableComponents = this.getComponentInstancesOfType(Suspendable.class);
        for (Suspendable component : suspendableComponents) {
            if (component.isSuspended()) {
                hasSuspendedComponents = true;
                continue;
            }
            hasResumedComponents = true;
        }
        if (hasSuspendedComponents && !hasResumedComponents && !hasROComponents) {
            return 3;
        }
        if (hasROComponents && !hasRWComponents && !hasSuspendedComponents) {
            return 2;
        }
        if (!hasSuspendedComponents && !hasROComponents) {
            return 1;
        }
        return 4;
    }

    public void setState(final int state) throws RepositoryException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(JCRRuntimePermissions.MANAGE_REPOSITORY_PERMISSION);
        }
        try {
            SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws RepositoryException {
                    switch (state) {
                        case 1: {
                            WorkspaceContainerFacade.this.setOnline();
                            break;
                        }
                        case 0: {
                            break;
                        }
                        case 2: {
                            WorkspaceContainerFacade.this.setReadOnly(true);
                            break;
                        }
                        case 3: {
                            WorkspaceContainerFacade.this.suspend();
                            break;
                        }
                        default: {
                            return null;
                        }
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RepositoryException) {
                throw new RepositoryException(cause);
            }
            throw new RuntimeException(cause);
        }
    }

    private void setReadOnly(boolean readOnly) {
        List components = this.getComponentInstancesOfType(ReadOnlySupport.class);
        for (ReadOnlySupport component : components) {
            component.setReadOnly(readOnly);
        }
    }

    private void suspend() throws RepositoryException {
        List components = this.getComponentInstancesOfType(Suspendable.class);
        for (Suspendable component : components) {
            try {
                component.suspend();
            }
            catch (SuspendException e) {
                throw new RepositoryException("Can't suspend component", (Throwable)e);
            }
        }
    }

    private void resume() throws RepositoryException {
        List components = this.getComponentInstancesOfType(Suspendable.class);
        Collections.reverse(components);
        for (Suspendable component : components) {
            try {
                if (!component.isSuspended()) continue;
                component.resume();
            }
            catch (ResumeException e) {
                throw new RepositoryException("Can't resume component", (Throwable)e);
            }
        }
    }

    private void setOnline() throws RepositoryException {
        this.setReadOnly(false);
        this.resume();
    }
}

