/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import java.util.List;
import java.util.regex.Pattern;
import org.exoplatform.web.controller.router.PathParam;
import org.exoplatform.web.controller.router.PercentEncoding;
import org.exoplatform.web.controller.router.Route;
import org.exoplatform.web.controller.router.Router;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PatternRoute
extends Route {
    final Pattern pattern;
    final PathParam[] params;
    final String[] chunks;
    final String[] encodedChunks;

    PatternRoute(Router router, Pattern pattern, List<PathParam> params, List<String> chunks) {
        super(router);
        if (chunks.size() != params.size() + 1) {
            throw new AssertionError((Object)("Was expecting chunk size " + chunks.size() + " to be equals to " + params.size() + 1));
        }
        String[] encodedChunks = new String[chunks.size()];
        for (int i = 0; i < chunks.size(); ++i) {
            encodedChunks[i] = PercentEncoding.PATH_SEGMENT.encode(chunks.get(i));
        }
        this.pattern = pattern;
        this.params = params.toArray(new PathParam[params.size()]);
        this.chunks = chunks.toArray(new String[chunks.size()]);
        this.encodedChunks = encodedChunks;
    }
}

