/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import java.util.regex.Pattern;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.metadata.RequestParamDescriptor;
import org.exoplatform.web.controller.router.ControlMode;
import org.exoplatform.web.controller.router.Param;
import org.exoplatform.web.controller.router.PatternBuilder;
import org.exoplatform.web.controller.router.ValueMapping;
import org.exoplatform.web.controller.router.ValueType;

class RequestParam
extends Param {
    final QualifiedName name;
    final String matchName;
    final Pattern matchPattern;
    final ControlMode controlMode;
    final ValueMapping valueMapping;

    static RequestParam create(RequestParamDescriptor descriptor) {
        if (descriptor == null) {
            throw new NullPointerException("No null descriptor accepted");
        }
        Pattern matchValue = null;
        if (descriptor.getValue() != null) {
            PatternBuilder matchValueBuilder = new PatternBuilder();
            matchValueBuilder.expr("^");
            if (descriptor.getValueType() == ValueType.PATTERN) {
                matchValueBuilder.expr(descriptor.getValue());
            } else {
                matchValueBuilder.literal(descriptor.getValue());
            }
            matchValueBuilder.expr("$");
            matchValue = matchValueBuilder.build();
        }
        return new RequestParam(descriptor.getQualifiedName(), descriptor.getName(), matchValue, descriptor.getControlMode(), descriptor.getValueMapping());
    }

    RequestParam(QualifiedName name, String matchName, Pattern matchPattern, ControlMode controlMode, ValueMapping valueMapping) {
        super(name);
        if (matchName == null) {
            throw new NullPointerException("No null match name accepted");
        }
        if (controlMode == null) {
            throw new NullPointerException("No null control mode accepted");
        }
        if (valueMapping == null) {
            throw new NullPointerException("No null value mapping accepted");
        }
        this.name = name;
        this.matchName = matchName;
        this.matchPattern = matchPattern;
        this.controlMode = controlMode;
        this.valueMapping = valueMapping;
    }

    boolean matchValue(String value) {
        return this.matchPattern == null || this.matchPattern.matcher(value).matches();
    }
}

