/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.xmlprocessor.filters;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.exoplatform.social.common.xmlprocessor.BaseXMLFilterPlugin;
import org.exoplatform.social.common.xmlprocessor.filters.Util;
import org.exoplatform.social.common.xmlprocessor.model.Attributes;
import org.exoplatform.social.common.xmlprocessor.model.Node;
import org.exoplatform.social.common.xmlprocessor.model.XMLTagFilterPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMXMLTagFilterPlugin
extends BaseXMLFilterPlugin {
    private LinkedHashMap<String, Attributes> allowedTags = new LinkedHashMap();

    public LinkedHashMap<String, Attributes> getAllowedTags() {
        return this.allowedTags;
    }

    public void setAllowedTags(LinkedHashMap<String, Attributes> allowedTags) {
        this.allowedTags = allowedTags;
    }

    public DOMXMLTagFilterPlugin(XMLTagFilterPolicy tagFilterPolicy) {
        this.allowedTags = Util.getAllowedTagsFromTagFilterPolicy(tagFilterPolicy);
    }

    @Override
    public Object doFilter(Object input) {
        if (input instanceof Node) {
            this.nodeFilter((Node)input);
        }
        return input;
    }

    private Node nodeFilter(Node currentNode) {
        LinkedList<Node> currentChildNode = currentNode.getChildNodes();
        if (!currentNode.getTitle().isEmpty()) {
            String tag = currentNode.getTitle();
            if (this.allowedTags.containsKey(tag)) {
                Attributes currentAttributes = currentNode.getAttributes();
                Attributes validatedAttributes = new Attributes();
                Iterator<String> iterator = currentAttributes.getKeyIterator();
                while (iterator.hasNext()) {
                    String key = iterator.next();
                    if (!this.allowedTags.get(tag).hasKey(key)) continue;
                    validatedAttributes.put(key, currentAttributes.get(key));
                }
                currentNode.setAttributes(validatedAttributes);
            } else {
                currentNode.convertToContent();
            }
        }
        for (int i = 0; i < currentChildNode.size(); ++i) {
            this.nodeFilter(currentChildNode.get(i));
        }
        return currentNode;
    }
}

