/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.repository;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.portlet.PortletPreferences;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.monitor.jvm.J2EEServerInfo;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.repository.UIRepositoryFormContainer;
import org.exoplatform.ecm.webui.component.admin.repository.UIRepositoryList;
import org.exoplatform.ecm.webui.component.admin.repository.UIRepositorySelectForm;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/admin/UIRepositoryControl.gtmpl", events={@EventConfig(listeners={EditRepositoryActionListener.class}), @EventConfig(listeners={RemoveRepositoryActionListener.class}), @EventConfig(listeners={AddRepositoryActionListener.class})})
public class UIRepositoryControl
extends UIContainer {
    private ConfigurationManager configurationManager;
    private static final Log LOG = ExoLogger.getLogger((String)"admin.UIRepositoryControl");

    public UIRepositoryControl() throws Exception {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences pref = pcontext.getRequest().getPreferences();
        String repository = pref.getValue(Utils.REPOSITORY, "");
        RepositoryService rservice = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        UIRepositorySelectForm uiSelectForm = (UIRepositorySelectForm)this.createUIComponent(UIRepositorySelectForm.class, null, null);
        try {
            rservice.getCurrentRepository();
            uiSelectForm.setOptionValue(this.getRepoItem(true, rservice));
            uiSelectForm.setSelectedValue(repository);
        }
        catch (Exception e) {
            uiSelectForm.setOptionValue(this.getRepoItem(false, rservice));
            uiSelectForm.setSelectedValue("");
        }
        uiSelectForm.setActionEvent();
        this.addChild((UIComponent)uiSelectForm);
    }

    protected List<SelectItemOption<String>> getRepoItem(boolean isExists, RepositoryService rservice) {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        if (!isExists) {
            options.add(new SelectItemOption("", (Object)""));
        }
        RepositoryEntry repo = null;
        try {
            repo = rservice.getCurrentRepository().getConfiguration();
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        options.add(new SelectItemOption(repo.getName(), (Object)repo.getName()));
        try {
            this.removeElement(options);
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
        }
        return options;
    }

    private void removeElement(List<SelectItemOption<String>> options) throws Exception {
        try {
            File dir;
            J2EEServerInfo jServerInfo = new J2EEServerInfo();
            String configDir = jServerInfo.getExoConfigurationDirectory();
            String commonExtPath = configDir + "/dms-common-extend-configuration.xml";
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(commonExtPath);
            Element root = doc.getRootElement();
            List listExternal = root.getChildren("external-component-plugins");
            for (SelectItemOption<String> option : options) {
                String repoName = (String)option.getValue();
                for (int i = 0; i < listExternal.size(); ++i) {
                    Element external = (Element)listExternal.get(i);
                    Element initParams = external.getChild("component-plugin").getChild("init-params");
                    List valueParams = initParams.getChildren("value-param");
                    Element valueParamRepo = (Element)valueParams.get(0);
                    if (!valueParamRepo.getChildText("value").trim().equals(repoName)) continue;
                    root.removeContent((Content)external);
                }
            }
            if (root.getChildren("external-component-plugins").size() > 0 && (dir = new File(configDir)).isDirectory()) {
                String[] children = dir.list();
                for (int i = 0; i < children.length; ++i) {
                    File file = new File(dir, children[i]);
                    if (file.getName().trim().equals("dms-common-extend-configuration.xml")) {
                        file.delete();
                    }
                    if (!file.getName().trim().equals("configuration.xml")) continue;
                    SAXBuilder builder1 = new SAXBuilder();
                    Document docConfiguration = builder1.build(configDir + "/configuration.xml");
                    Element rootConfiguration = docConfiguration.getRootElement();
                    List importElements = rootConfiguration.getChildren("import");
                    if (importElements.size() > 0) {
                        for (int j = 0; j < importElements.size(); ++j) {
                            Element importElement = (Element)importElements.get(j);
                            if (!importElement.getValue().equals("dms-common-extend-configuration.xml")) continue;
                            rootConfiguration.removeContent((Content)importElement);
                        }
                    }
                    XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());
                    xmlOutputter.output(docConfiguration, (Writer)new FileWriter(configDir + "/configuration.xml"));
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    protected String getSelectedRepo() {
        return ((UIRepositorySelectForm)this.getChild(UIRepositorySelectForm.class)).getSelectedValue();
    }

    protected boolean isDefaultRepo(String repoName) {
        RepositoryService rservice = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rservice.getConfig().getDefaultRepositoryName().equals(repoName);
    }

    protected void reloadValue(boolean isExists, RepositoryService rservice) {
        ((UIRepositorySelectForm)this.getChild(UIRepositorySelectForm.class)).setOptionValue(this.getRepoItem(isExists, rservice));
        if (isExists) {
            PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            PortletPreferences pref = pcontext.getRequest().getPreferences();
            String repository = pref.getValue(Utils.REPOSITORY, "");
            ((UIRepositorySelectForm)this.getChild(UIRepositorySelectForm.class)).setSelectedValue(repository);
        } else {
            ((UIRepositorySelectForm)this.getChild(UIRepositorySelectForm.class)).setSelectedValue("");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddRepositoryActionListener
    extends EventListener<UIRepositoryControl> {
        public void execute(Event<UIRepositoryControl> event) throws Exception {
            UIRepositoryControl uiControl = (UIRepositoryControl)((Object)event.getSource());
            UIECMAdminPortlet ecmPortlet = (UIECMAdminPortlet)uiControl.getAncestorOfType(UIECMAdminPortlet.class);
            UIPopupContainer uiPopupAction = (UIPopupContainer)ecmPortlet.getChild(UIPopupContainer.class);
            UIRepositoryFormContainer uiForm = (UIRepositoryFormContainer)uiPopupAction.activate(UIRepositoryFormContainer.class, 600);
            RepositoryService rService = (RepositoryService)uiControl.getApplicationComponent(RepositoryService.class);
            uiForm.refresh(true, rService.getCurrentRepository().getConfiguration());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupAction);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveRepositoryActionListener
    extends EventListener<UIRepositoryControl> {
        public void execute(Event<UIRepositoryControl> event) throws Exception {
            UIRepositoryControl uiControl = (UIRepositoryControl)((Object)event.getSource());
            UIECMAdminPortlet ecmPortlet = (UIECMAdminPortlet)uiControl.getAncestorOfType(UIECMAdminPortlet.class);
            UIPopupContainer uiPopupAction = (UIPopupContainer)ecmPortlet.getChild(UIPopupContainer.class);
            UIRepositoryList uiList = (UIRepositoryList)uiPopupAction.activate(UIRepositoryList.class, 600);
            uiList.updateGrid();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupAction);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditRepositoryActionListener
    extends EventListener<UIRepositoryControl> {
        public void execute(Event<UIRepositoryControl> event) throws Exception {
            UIRepositoryControl uiControl = (UIRepositoryControl)((Object)event.getSource());
            UIECMAdminPortlet ecmPortlet = (UIECMAdminPortlet)uiControl.getAncestorOfType(UIECMAdminPortlet.class);
            UIPopupContainer uiPopupAction = (UIPopupContainer)ecmPortlet.getChild(UIPopupContainer.class);
            UIRepositoryFormContainer uiForm = (UIRepositoryFormContainer)uiPopupAction.activate(UIRepositoryFormContainer.class, 600);
            RepositoryService rservice = (RepositoryService)uiControl.getApplicationComponent(RepositoryService.class);
            ManageableRepository repo = rservice.getCurrentRepository();
            uiForm.refresh(false, repo.getConfiguration());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupAction);
        }
    }
}

