/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.script;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.script.UICBScripts;
import org.exoplatform.ecm.webui.component.admin.script.UIECMFilterForm;
import org.exoplatform.ecm.webui.component.admin.script.UIECMScripts;
import org.exoplatform.ecm.webui.component.admin.script.UIScriptForm;
import org.exoplatform.ecm.webui.component.admin.script.UIScriptManager;
import org.exoplatform.services.cms.scripts.ScriptService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIComponentDecorator;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.exception.MessageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/admin/script/UIScriptList.gtmpl", events={@EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UIScriptList.msg.confirm-delete"), @EventConfig(listeners={AddNewActionListener.class})})
public class UIScriptList
extends UIComponentDecorator {
    private UIPageIterator uiPageIterator_ = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "ScriptListIterator");
    public static final String ECMScript_EDIT = "ECMScriptPopupWindow";
    public static final String CBScript_EDIT = "BCScriptPopupWindow";

    public UIScriptList() throws Exception {
        this.setUIComponent((UIComponent)this.uiPageIterator_);
    }

    public void updateGrid(List<ScriptData> scriptData, int currentPage) throws Exception {
        Collections.sort(scriptData, new ScriptComparator());
        ListAccessImpl scriptList = new ListAccessImpl(ScriptData.class, scriptData);
        LazyPageList dataPageList = new LazyPageList((ListAccess)scriptList, 10);
        this.uiPageIterator_.setPageList((PageList)dataPageList);
        if (currentPage > this.uiPageIterator_.getAvailablePage()) {
            this.uiPageIterator_.setCurrentPage(this.uiPageIterator_.getAvailablePage());
        } else {
            this.uiPageIterator_.setCurrentPage(currentPage);
        }
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public List getScriptList() throws Exception {
        return this.uiPageIterator_.getCurrentPageData();
    }

    public String getScriptCategory() throws Exception {
        UIComponent parent = this.getParent();
        ScriptService scriptService = (ScriptService)this.getApplicationComponent(ScriptService.class);
        Node script = null;
        if (parent instanceof UIECMScripts) {
            UIECMFilterForm filterForm = (UIECMFilterForm)parent.findFirstComponentOfType(UIECMFilterForm.class);
            String categoryName = (String)filterForm.getUIFormSelectBox("selectScript").getValue();
            script = scriptService.getECMScriptHome(WCMCoreUtils.getSystemSessionProvider()).getNode(categoryName);
        } else {
            script = scriptService.getCBScriptHome(WCMCoreUtils.getSystemSessionProvider());
        }
        String basePath = scriptService.getBaseScriptPath() + "/";
        return script.getPath().substring(basePath.length());
    }

    public void refresh(int currentPage) throws Exception {
        UIScriptManager sManager = (UIScriptManager)this.getAncestorOfType(UIScriptManager.class);
        UIComponent parent = this.getParent();
        if (parent instanceof UICBScripts) {
            ((UICBScripts)sManager.getChild(UICBScripts.class)).refresh(currentPage);
        } else {
            ((UIECMScripts)sManager.getChild(UIECMScripts.class)).refresh(currentPage);
        }
    }

    public String[] getActions() {
        return new String[]{"AddNew"};
    }

    public Node getScriptNode(String nodeName) throws Exception {
        UIComponent parent = this.getParent();
        ScriptService scriptService = (ScriptService)this.getApplicationComponent(ScriptService.class);
        Node script = null;
        if (parent instanceof UIECMScripts) {
            UIECMFilterForm filterForm = (UIECMFilterForm)parent.findFirstComponentOfType(UIECMFilterForm.class);
            String categoryName = (String)filterForm.getUIFormSelectBox("selectScript").getValue();
            Node category = scriptService.getECMScriptHome(WCMCoreUtils.getUserSessionProvider()).getNode(categoryName);
            script = category.getNode(nodeName);
        } else {
            Node cbScript = scriptService.getCBScriptHome(WCMCoreUtils.getSystemSessionProvider());
            script = cbScript.getNode(nodeName);
        }
        return script;
    }

    public static class ScriptData {
        private String name;
        private String path;
        private String baseVersion;

        public ScriptData(String scriptName, String scriptParth, String version) {
            this.name = scriptName;
            this.path = scriptParth;
            this.baseVersion = version;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public String getBaseVersion() {
            return this.baseVersion;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends EventListener<UIScriptList> {
        public void execute(Event<UIScriptList> event) throws Exception {
            UIScriptList uiScriptList = (UIScriptList)((Object)event.getSource());
            ScriptService scriptService = (ScriptService)uiScriptList.getApplicationComponent(ScriptService.class);
            String scriptName = event.getRequestContext().getRequestParameter("objectId");
            String namePrefix = uiScriptList.getScriptCategory();
            try {
                scriptService.removeScript(namePrefix + "/" + scriptName, WCMCoreUtils.getUserSessionProvider());
            }
            catch (AccessDeniedException ace) {
                throw new MessageException(new ApplicationMessage("UIECMAdminControlPanel.msg.access-denied", null, 1));
            }
            uiScriptList.refresh(uiScriptList.uiPageIterator_.getCurrentPage());
            UIScriptManager uiManager = (UIScriptManager)uiScriptList.getAncestorOfType(UIScriptManager.class);
            if (uiScriptList.getParent() instanceof UIECMScripts) {
                uiManager.setRenderedChild(UIECMScripts.class);
            } else if (uiScriptList.getParent() instanceof UICBScripts) {
                uiManager.setRenderedChild(UICBScripts.class);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(uiScriptList.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditActionListener
    extends EventListener<UIScriptList> {
        public void execute(Event<UIScriptList> event) throws Exception {
            UIScriptList uiScriptList = (UIScriptList)((Object)event.getSource());
            String scriptName = event.getRequestContext().getRequestParameter("objectId");
            UIScriptManager uiManager = (UIScriptManager)uiScriptList.getAncestorOfType(UIScriptManager.class);
            if (uiScriptList.getId().equals(UIECMScripts.SCRIPTLIST_NAME)) {
                ((UIECMScripts)uiScriptList.getAncestorOfType(UIECMScripts.class)).initFormPopup(UIScriptList.ECMScript_EDIT);
                UIScriptForm uiForm = (UIScriptForm)uiManager.findFirstComponentOfType(UIScriptForm.class);
                uiForm.setId(UIECMScripts.SCRIPTFORM_NAME);
                uiForm.update(uiScriptList.getScriptNode(scriptName), false);
                uiManager.setRenderedChild(UIECMScripts.class);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
            } else if (uiScriptList.getId().equals(UICBScripts.SCRIPTLIST_NAME)) {
                ((UICBScripts)uiScriptList.getAncestorOfType(UICBScripts.class)).initFormPopup(UIScriptList.CBScript_EDIT);
                UIScriptForm uiForm = (UIScriptForm)uiManager.findFirstComponentOfType(UIScriptForm.class);
                uiForm.setId(UICBScripts.SCRIPTFORM_NAME);
                uiForm.update(uiScriptList.getScriptNode(scriptName), false);
                uiManager.setRenderedChild(UICBScripts.class);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddNewActionListener
    extends EventListener<UIScriptList> {
        public void execute(Event<UIScriptList> event) throws Exception {
            UIScriptList uiScriptList = (UIScriptList)((Object)event.getSource());
            UIScriptManager uiManager = (UIScriptManager)uiScriptList.getAncestorOfType(UIScriptManager.class);
            if (uiScriptList.getId().equals(UIECMScripts.SCRIPTLIST_NAME)) {
                ((UIECMScripts)uiScriptList.getAncestorOfType(UIECMScripts.class)).initFormPopup(UIScriptList.ECMScript_EDIT);
                UIScriptForm uiForm = (UIScriptForm)uiManager.findFirstComponentOfType(UIScriptForm.class);
                uiForm.setId(UIECMScripts.SCRIPTFORM_NAME);
                uiForm.update(null, true);
                uiManager.setRenderedChild(UIECMScripts.class);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
            } else if (uiScriptList.getId().equals(UICBScripts.SCRIPTLIST_NAME)) {
                ((UICBScripts)uiScriptList.getAncestorOfType(UICBScripts.class)).initFormPopup(UIScriptList.CBScript_EDIT);
                UIScriptForm uiForm = (UIScriptForm)uiManager.findFirstComponentOfType(UIScriptForm.class);
                uiForm.setId(UICBScripts.SCRIPTFORM_NAME);
                uiForm.update(null, true);
                uiManager.setRenderedChild(UICBScripts.class);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
            }
        }
    }

    public static class ScriptComparator
    implements Comparator {
        public int compare(Object o1, Object o2) throws ClassCastException {
            String name1 = ((ScriptData)o1).getName();
            String name2 = ((ScriptData)o2).getName();
            return name1.compareToIgnoreCase(name2);
        }
    }
}

