/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.shindig;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import sun.misc.BASE64Encoder;

public class KeyCreator {
    public static Log log = ExoLogger.getLogger((String)"org.exoplatform.ide.shindig.KeyCreator");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createKeyFile() {
        File keyFile = new File(KeyCreator.getKeyFilePath());
        if (!keyFile.exists()) {
            File fic = keyFile.getAbsoluteFile();
            log.debug((Object)("No key file found at path " + fic + " generating a new key and saving it"));
            String key = KeyCreator.generateKey();
            FileWriter out = null;
            try {
                out = new FileWriter(keyFile);
                out.write(key);
                ((Writer)out).write(10);
                ((Writer)out).flush();
                log.info((Object)("Generated key file " + fic + " for eXo Gadgets"));
            }
            catch (IOException e) {
                log.error((Object)("Coult not create key file " + fic), (Throwable)e);
            }
            finally {
                try {
                    ((Writer)out).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else if (!keyFile.isFile()) {
            log.debug((Object)("Found key file " + keyFile.getAbsolutePath() + " but it's not a file"));
        } else {
            log.info((Object)("Found key file " + keyFile.getAbsolutePath() + " for gadgets security"));
        }
    }

    public static String getKeyFilePath() {
        String keyPath = PropertyManager.getProperty((String)"gatein.gadgets.securityTokenKeyFile");
        if (keyPath == null) {
            log.warn((Object)"The gadgets token key is not configured. The default key.txt file in /bin will be used");
            keyPath = "key.txt";
        }
        return keyPath;
    }

    private static String generateKey() {
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.setSeed(System.currentTimeMillis());
            byte[] bytes = new byte[32];
            random.nextBytes(bytes);
            BASE64Encoder encoder = new BASE64Encoder();
            return encoder.encode(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }
}

