/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.auth;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.jgroups.Message;
import org.jgroups.auth.AuthToken;
import org.jgroups.util.Util;

public class SimpleToken
extends AuthToken {
    public static final String TOKEN_ATTR = "auth_value";
    private String token = null;
    private static final long serialVersionUID = -6889408182212567295L;

    public SimpleToken() {
    }

    public SimpleToken(String token) {
        this.token = token;
    }

    @Override
    public void setValue(Properties properties) {
        this.token = (String)properties.get(TOKEN_ATTR);
        properties.remove(TOKEN_ATTR);
    }

    @Override
    public String getName() {
        return "org.jgroups.auth.SimpleToken";
    }

    @Override
    public boolean authenticate(AuthToken token, Message msg) {
        if (token != null && token instanceof SimpleToken) {
            SimpleToken serverToken = (SimpleToken)token;
            if (this.token != null && serverToken.token != null && this.token.equalsIgnoreCase(serverToken.token)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"SimpleToken match");
                }
                return true;
            }
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)"Authentication failed on SimpleToken");
            }
            return false;
        }
        if (this.log.isWarnEnabled()) {
            this.log.warn((Object)"Invalid AuthToken instance - wrong type or null");
        }
        return false;
    }

    @Override
    public void writeTo(DataOutputStream out) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"SimpleToken writeTo()");
        }
        Util.writeString(this.token, out);
    }

    @Override
    public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"SimpleToken readFrom()");
        }
        this.token = Util.readString(in);
    }
}

