/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WidgetIterators {
    private static Widget[] copyWidgetArray(Widget[] widgets) {
        Widget[] clone = new Widget[widgets.length];
        for (int i = 0; i < widgets.length; ++i) {
            clone[i] = widgets[i];
        }
        return clone;
    }

    static final Iterator<Widget> createWidgetIterator(final HasWidgets container, final Widget[] contained) {
        return new Iterator<Widget>(){
            int index = -1;
            int last = -1;
            boolean widgetsWasCopied = false;
            Widget[] widgets = contained;
            {
                this.gotoNextIndex();
            }

            private void gotoNextIndex() {
                ++this.index;
                while (this.index < contained.length) {
                    if (contained[this.index] != null) {
                        return;
                    }
                    ++this.index;
                }
            }

            @Override
            public boolean hasNext() {
                return this.index < contained.length;
            }

            @Override
            public Widget next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.index;
                Widget w = contained[this.index];
                this.gotoNextIndex();
                return w;
            }

            @Override
            public void remove() {
                if (this.last < 0) {
                    throw new IllegalStateException();
                }
                if (!this.widgetsWasCopied) {
                    this.widgets = WidgetIterators.copyWidgetArray(this.widgets);
                    this.widgetsWasCopied = true;
                }
                container.remove(contained[this.last]);
                this.last = -1;
            }
        };
    }

    private WidgetIterators() {
    }
}

