/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.xml;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.common.util.HierarchicalProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyWriteUtil {
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("%[0-9a-fA-F]{2}");

    public static void writePropStats(XMLStreamWriter xmlStreamWriter, Map<String, Set<HierarchicalProperty>> propStatuses) throws XMLStreamException {
        for (Map.Entry<String, Set<HierarchicalProperty>> stat : propStatuses.entrySet()) {
            xmlStreamWriter.writeStartElement("DAV:", "propstat");
            xmlStreamWriter.writeStartElement("DAV:", "prop");
            for (HierarchicalProperty prop : propStatuses.get(stat.getKey())) {
                PropertyWriteUtil.writeProperty(xmlStreamWriter, prop);
            }
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeStartElement("DAV:", "status");
            xmlStreamWriter.writeCharacters(stat.getKey());
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndElement();
        }
    }

    public static void writeProperty(XMLStreamWriter xmlStreamWriter, HierarchicalProperty prop) throws XMLStreamException {
        String uri = prop.getName().getNamespaceURI();
        String prefix = xmlStreamWriter.getNamespaceContext().getPrefix(uri);
        if (prefix == null) {
            prefix = "";
        }
        String local = prop.getName().getLocalPart();
        if (prop.getValue() == null) {
            if (prop.getChildren().size() != 0) {
                xmlStreamWriter.writeStartElement(prefix, local, uri);
                if (!uri.equalsIgnoreCase("DAV:")) {
                    xmlStreamWriter.writeNamespace(prefix, uri);
                }
                PropertyWriteUtil.writeAttributes(xmlStreamWriter, prop);
                for (int i = 0; i < prop.getChildren().size(); ++i) {
                    HierarchicalProperty property = (HierarchicalProperty)prop.getChildren().get(i);
                    PropertyWriteUtil.writeProperty(xmlStreamWriter, property);
                }
                xmlStreamWriter.writeEndElement();
            } else {
                xmlStreamWriter.writeEmptyElement(prefix, local, uri);
                if (!uri.equalsIgnoreCase("DAV:")) {
                    xmlStreamWriter.writeNamespace(prefix, uri);
                }
                PropertyWriteUtil.writeAttributes(xmlStreamWriter, prop);
            }
        } else {
            xmlStreamWriter.writeStartElement(prefix, local, uri);
            if (!uri.equalsIgnoreCase("DAV:")) {
                xmlStreamWriter.writeNamespace(prefix, uri);
            }
            PropertyWriteUtil.writeAttributes(xmlStreamWriter, prop);
            xmlStreamWriter.writeCharacters(prop.getValue());
            xmlStreamWriter.writeEndElement();
        }
    }

    public static void writeAttributes(XMLStreamWriter xmlStreamWriter, HierarchicalProperty property) throws XMLStreamException {
        HashMap attributes = property.getAttributes();
        for (String attrName : attributes.keySet()) {
            String attrValue = (String)attributes.get(attrName);
            xmlStreamWriter.writeAttribute(attrName, attrValue);
        }
    }

    private static boolean containsEncodedChar(String str) {
        Matcher matcher = ESCAPE_PATTERN.matcher(str);
        return matcher.find();
    }
}

