/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.Util;

public class SecurityManager {
    private static Log LOG = ExoLogger.getLogger(SecurityManager.class);

    public static boolean canAccessActivity(PortalContainer portalContainer, String userIdentityId, ExoSocialActivity existingActivity) {
        SpaceService spaceService = (SpaceService)portalContainer.getComponentInstanceOfType(SpaceService.class);
        IdentityManager identityManager = (IdentityManager)portalContainer.getComponentInstanceOfType(IdentityManager.class);
        RelationshipManager relationshipManager = (RelationshipManager)portalContainer.getComponentInstanceOfType(RelationshipManager.class);
        Identity authenticateIdentity = identityManager.getOrCreateIdentity("organization", userIdentityId, false);
        if (authenticateIdentity == null || existingActivity == null) {
            return false;
        }
        ActivityStream activityStream = existingActivity.getActivityStream();
        if (activityStream.getType().equals((Object)ActivityStream.Type.SPACE)) {
            String[] memberRemoteIds;
            Space spaceOfActivity = spaceService.getSpaceByPrettyName(existingActivity.getStreamOwner());
            for (String memberRemoteId : memberRemoteIds = spaceOfActivity.getMembers()) {
                Identity identity = identityManager.getOrCreateIdentity("organization", memberRemoteId, false);
                if (!identity.getId().equals(existingActivity.getId())) continue;
                return true;
            }
        } else if (activityStream.getType().equals((Object)ActivityStream.Type.USER)) {
            return true;
        }
        return false;
    }

    public static boolean canAccessActivity(PortalContainer portalContainer, Identity authenticatedIdentity, ExoSocialActivity existingActivity) {
        SpaceService spaceService = (SpaceService)portalContainer.getComponentInstanceOfType(SpaceService.class);
        IdentityManager identityManager = (IdentityManager)portalContainer.getComponentInstanceOfType(IdentityManager.class);
        RelationshipManager relationshipManager = (RelationshipManager)portalContainer.getComponentInstanceOfType(RelationshipManager.class);
        if (authenticatedIdentity == null || existingActivity == null) {
            return false;
        }
        ActivityStream activityStream = existingActivity.getActivityStream();
        if (activityStream.getType().equals((Object)ActivityStream.Type.SPACE)) {
            Space spaceOfActivity = spaceService.getSpaceByPrettyName(existingActivity.getStreamOwner());
            return spaceService.isMember(spaceOfActivity, authenticatedIdentity.getRemoteId()) || spaceService.isManager(spaceOfActivity, authenticatedIdentity.getRemoteId());
        }
        return activityStream.getType().equals((Object)ActivityStream.Type.USER);
    }

    public static boolean canPostActivity(PortalContainer portalContainer, Identity authenticatedIdentity, Identity ownerIdentityStream) {
        Relationship relationship;
        Space space;
        SpaceService spaceService = (SpaceService)portalContainer.getComponentInstanceOfType(SpaceService.class);
        RelationshipManager relationshipManager = (RelationshipManager)portalContainer.getComponentInstanceOfType(RelationshipManager.class);
        String posterID = authenticatedIdentity.getId();
        String ownerID = ownerIdentityStream.getId();
        if (ownerID.equals(posterID)) {
            return true;
        }
        return ownerIdentityStream.getProviderId().equals("space") ? spaceService.isMember(space = spaceService.getSpaceByPrettyName(ownerIdentityStream.getRemoteId()), authenticatedIdentity.getRemoteId()) : (relationship = relationshipManager.get(authenticatedIdentity, ownerIdentityStream)) != null && Relationship.Type.CONFIRMED.equals((Object)relationship.getStatus());
    }

    public static boolean canDeleteActivity(PortalContainer portalContainer, Identity authenticatedIdentity, ExoSocialActivity existingActivity) {
        String ownerId;
        SpaceService spaceService = (SpaceService)portalContainer.getComponentInstanceOfType(SpaceService.class);
        IdentityManager identityManager = (IdentityManager)portalContainer.getComponentInstanceOfType(IdentityManager.class);
        String removerUserId = authenticatedIdentity.getId();
        if (removerUserId.equals(ownerId = existingActivity.getUserId())) {
            return true;
        }
        String streamOwnerRemoteID = existingActivity.getStreamOwner();
        Identity streamOwnerIdentity = identityManager.getOrCreateIdentity("organization", streamOwnerRemoteID, false);
        String streamOwnerId = null;
        if (streamOwnerIdentity != null) {
            streamOwnerId = streamOwnerIdentity.getId();
        }
        if (removerUserId.equals(streamOwnerId)) {
            return true;
        }
        Space spaceOfActivity = spaceService.getSpaceByPrettyName(existingActivity.getActivityStream().getPrettyId());
        if (spaceOfActivity != null) {
            String[] adminsOfSpaceArray = spaceOfActivity.getManagers();
            for (int i = 0; i < adminsOfSpaceArray.length; ++i) {
                if (!adminsOfSpaceArray[i].equals(authenticatedIdentity.getRemoteId())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canCommentToActivity(PortalContainer portalContainer, Identity authenticatedIdentity, ExoSocialActivity existingActivity) {
        IdentityManager identityManager = (IdentityManager)portalContainer.getComponentInstanceOfType(IdentityManager.class);
        Identity ownerIdentityStream = identityManager.getIdentity(existingActivity.getUserId(), false);
        return SecurityManager.canPostActivity(portalContainer, authenticatedIdentity, ownerIdentityStream);
    }

    public static boolean canDeleteComment(PortalContainer portalContainer, Identity authenticatedIdentity, ExoSocialActivity existingComment) {
        return SecurityManager.canDeleteActivity(portalContainer, authenticatedIdentity, existingComment);
    }

    public static Identity getAuthenticatedUserIdentity() {
        if (ConversationState.getCurrent() != null && ConversationState.getCurrent().getIdentity() != null && ConversationState.getCurrent().getIdentity().getUserId() != null) {
            IdentityManager identityManager = Util.getIdentityManager();
            String authenticatedUserRemoteId = ConversationState.getCurrent().getIdentity().getUserId();
            return identityManager.getOrCreateIdentity("organization", authenticatedUserRemoteId, false);
        }
        return null;
    }

    public static boolean canAccessActivityStream(PortalContainer portalContainer, Identity authenticatedIdentity, Identity ownerStream) {
        if (ownerStream.getProviderId().equals("space")) {
            SpaceService spaceService = (SpaceService)portalContainer.getComponentInstanceOfType(SpaceService.class);
            Space targetSpace = spaceService.getSpaceByPrettyName(ownerStream.getRemoteId());
            if (targetSpace == null) {
                LOG.warn((Object)("targetSpace is null with prettyName: " + ownerStream.getRemoteId()));
                return true;
            }
            return spaceService.isMember(targetSpace, authenticatedIdentity.getRemoteId()) || spaceService.isManager(targetSpace, authenticatedIdentity.getRemoteId());
        }
        return true;
    }
}

