/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc.pool;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import org.hsqldb.jdbc.Util;
import org.hsqldb.jdbc.pool.ConnectionDefaults;
import org.hsqldb.jdbc.pool.JDBCConnectionPoolDataSource;
import org.hsqldb.jdbc.pool.SessionConnectionWrapper;

public class ManagedPoolDataSource
implements DataSource,
ConnectionEventListener {
    private static final int DEFAULT_MAX_POOL_SIZE = 8;
    private boolean isPoolClosed = false;
    private int sessionTimeout = 0;
    private JDBCConnectionPoolDataSource connectionPoolDataSource = null;
    private Set connectionsInUse = new HashSet();
    private List connectionsInactive = new ArrayList();
    private Map sessionConnectionWrappers = new HashMap();
    private int maxPoolSize = 8;
    private ConnectionDefaults connectionDefaults = null;
    private boolean initialized = false;
    private int initialSize = 0;
    boolean doResetAutoCommit = false;
    boolean doResetReadOnly = false;
    boolean doResetTransactionIsolation = false;
    boolean doResetCatalog = false;
    boolean isAutoCommit = true;
    boolean isReadOnly = false;
    int transactionIsolation = 2;
    String catalog = null;
    private String validationQuery = null;

    public ManagedPoolDataSource() {
        this.connectionPoolDataSource = new JDBCConnectionPoolDataSource();
    }

    public ManagedPoolDataSource(String string, String string2, String string3, int n, ConnectionDefaults connectionDefaults) throws SQLException {
        this.connectionPoolDataSource = new JDBCConnectionPoolDataSource(string, string2, string3, connectionDefaults);
        this.maxPoolSize = n;
    }

    public ManagedPoolDataSource(String string, String string2, String string3) throws SQLException {
        this(string, string2, string3, 8, null);
    }

    public ManagedPoolDataSource(String string, String string2, String string3, ConnectionDefaults connectionDefaults) throws SQLException {
        this(string, string2, string3, 8, connectionDefaults);
    }

    public ManagedPoolDataSource(String string, String string2, String string3, int n) throws SQLException {
        this(string, string2, string3, n, null);
    }

    public ConnectionDefaults getConnectionDefaults() {
        return this.connectionDefaults;
    }

    public synchronized String getUrl() {
        return this.connectionPoolDataSource.getUrl();
    }

    public synchronized void setUrl(String string) {
        this.connectionPoolDataSource.setUrl(string);
    }

    public synchronized String getUser() {
        return this.connectionPoolDataSource.getUser();
    }

    public synchronized void setUser(String string) {
        this.connectionPoolDataSource.setUser(string);
    }

    public synchronized String getPassword() {
        return this.connectionPoolDataSource.getPassword();
    }

    public synchronized void setPassword(String string) {
        this.connectionPoolDataSource.setPassword(string);
    }

    public synchronized int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public synchronized void setSessionTimeout(int n) {
        this.sessionTimeout = n;
    }

    public synchronized int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public synchronized void setMaxPoolSize(int n) {
        this.maxPoolSize = n;
    }

    @Override
    public synchronized int getLoginTimeout() throws SQLException {
        return this.connectionPoolDataSource.getLoginTimeout();
    }

    @Override
    public synchronized void setLoginTimeout(int n) throws SQLException {
        this.connectionPoolDataSource.setLoginTimeout(n);
    }

    @Override
    public synchronized PrintWriter getLogWriter() throws SQLException {
        return this.connectionPoolDataSource.getLogWriter();
    }

    @Override
    public synchronized void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.connectionPoolDataSource.setLogWriter(printWriter);
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        String string3 = this.getPassword();
        String string4 = this.getUsername();
        if (string == null && string4 != null || string != null && string4 == null || string != null && !string.equals(string4) || string2 == null && string3 != null || string2 != null && string3 == null || string2 != null && !string2.equals(string3)) {
            throw new SQLException("Connection pool manager user/password validation failed");
        }
        return this.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        PooledConnection pooledConnection = null;
        ManagedPoolDataSource managedPoolDataSource = this;
        synchronized (managedPoolDataSource) {
            if (!this.initialized) {
                if (this.initialSize > this.maxPoolSize) {
                    throw new SQLException("Initial size of " + this.initialSize + " exceeds max. pool size of " + this.maxPoolSize);
                }
                this.logInfo("Pre-initializing " + this.initialSize + " physical connections");
                for (int i = 0; i < this.initialSize; ++i) {
                    this.connectionsInactive.add(this.createNewConnection());
                }
                this.initialized = true;
            }
            long l = this.calculateLoginTimeoutExpiration();
            while (pooledConnection == null) {
                if (this.isPoolClosed) {
                    throw new SQLException("The pool is closed. You cannot get anymore connections from it.");
                }
                pooledConnection = this.dequeueFirstIfAny();
                if (pooledConnection != null) {
                    return this.wrapConnectionAndMarkAsInUse(pooledConnection);
                }
                if (this.poolHasSpaceForNewConnections()) {
                    pooledConnection = this.createNewConnection();
                    return this.wrapConnectionAndMarkAsInUse(pooledConnection);
                }
                if (this.sessionTimeout > 0) {
                    this.reclaimAbandonedConnections();
                    pooledConnection = this.dequeueFirstIfAny();
                    if (pooledConnection != null) {
                        return this.wrapConnectionAndMarkAsInUse(pooledConnection);
                    }
                }
                this.doWait(l);
            }
            return this.wrapConnectionAndMarkAsInUse(pooledConnection);
        }
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (this.isWrapperFor(clazz)) {
            return (T)this;
        }
        throw Util.invalidArgument("iface: " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doWait(long l) throws SQLException {
        try {
            if (l > 0L) {
                long l2 = l - System.currentTimeMillis();
                if (l2 <= 0L) throw new SQLException("No connections available within the given login timeout: " + this.getLoginTimeout());
                this.wait(l2);
                return;
            } else {
                this.wait();
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            throw new SQLException("Thread was interrupted while waiting for available connection");
        }
    }

    private PooledConnection createNewConnection() throws SQLException {
        this.logInfo("Connection created since no connections available and pool has space for more connections. Pool size: " + this.size());
        PooledConnection pooledConnection = this.connectionPoolDataSource.getPooledConnection();
        pooledConnection.addConnectionEventListener(this);
        return pooledConnection;
    }

    private void reclaimAbandonedConnections() {
        long l = System.currentTimeMillis();
        long l2 = (long)this.sessionTimeout * 1000L;
        Iterator iterator = this.connectionsInUse.iterator();
        ArrayList<SessionConnectionWrapper> arrayList = new ArrayList<SessionConnectionWrapper>();
        while (iterator.hasNext()) {
            PooledConnection object = (PooledConnection)iterator.next();
            SessionConnectionWrapper sessionConnectionWrapper = (SessionConnectionWrapper)this.sessionConnectionWrappers.get(object);
            if (!this.isSessionTimedOut(l, sessionConnectionWrapper, l2)) continue;
            arrayList.add(sessionConnectionWrapper);
        }
        for (SessionConnectionWrapper sessionConnectionWrapper : arrayList) {
            this.closeSessionWrapper(sessionConnectionWrapper, "Error closing abandoned session connection wrapper.");
        }
        if (arrayList.size() > 1) {
            arrayList.clear();
            this.notifyAll();
        }
    }

    private void closeSessionWrapper(SessionConnectionWrapper sessionConnectionWrapper, String string) {
        try {
            sessionConnectionWrapper.close();
        }
        catch (SQLException sQLException) {
            this.logInfo(string, sQLException);
        }
    }

    private long calculateLoginTimeoutExpiration() throws SQLException {
        long l = 0L;
        if (this.getLoginTimeout() > 0) {
            l = 1000L * (long)this.getLoginTimeout();
        }
        return l;
    }

    private void enqueue(PooledConnection pooledConnection) {
        this.connectionsInactive.add(pooledConnection);
        this.notifyAll();
    }

    private PooledConnection dequeueFirstIfAny() {
        if (this.connectionsInactive.size() <= 0) {
            return null;
        }
        return (PooledConnection)this.connectionsInactive.remove(0);
    }

    public synchronized int size() {
        return this.connectionsInUse.size() + this.connectionsInactive.size();
    }

    private Connection wrapConnectionAndMarkAsInUse(PooledConnection pooledConnection) throws SQLException {
        AutoCloseable autoCloseable;
        pooledConnection = this.assureValidConnection(pooledConnection);
        Connection connection = pooledConnection.getConnection();
        if (this.doResetAutoCommit) {
            connection.setAutoCommit(this.isAutoCommit);
        }
        if (this.doResetReadOnly) {
            connection.setReadOnly(this.isReadOnly);
        }
        if (this.doResetTransactionIsolation) {
            connection.setTransactionIsolation(this.transactionIsolation);
        }
        if (this.doResetCatalog) {
            connection.setCatalog(this.catalog);
        }
        if (this.validationQuery != null) {
            autoCloseable = null;
            try {
                autoCloseable = connection.createStatement().executeQuery(this.validationQuery);
                if (!autoCloseable.next()) {
                    throw new SQLException("0 rows returned");
                }
            }
            catch (SQLException sQLException) {
                this.closePhysically(pooledConnection, "Closing non-validating pooledConnection.");
                throw new SQLException("Validation query failed: " + sQLException.getMessage());
            }
            finally {
                if (autoCloseable != null) {
                    autoCloseable.close();
                }
            }
        }
        this.connectionsInUse.add(pooledConnection);
        autoCloseable = new SessionConnectionWrapper(pooledConnection.getConnection());
        this.sessionConnectionWrappers.put(pooledConnection, autoCloseable);
        return autoCloseable;
    }

    private PooledConnection assureValidConnection(PooledConnection pooledConnection) throws SQLException {
        if (this.isInvalid(pooledConnection)) {
            this.closePhysically(pooledConnection, "closing invalid pooledConnection.");
            return this.connectionPoolDataSource.getPooledConnection();
        }
        return pooledConnection;
    }

    private boolean isInvalid(PooledConnection pooledConnection) {
        try {
            return pooledConnection.getConnection().isClosed();
        }
        catch (SQLException sQLException) {
            this.logInfo("Error calling pooledConnection.getConnection().isClosed(). Connection will be removed from pool.", sQLException);
            return false;
        }
    }

    private boolean isSessionTimedOut(long l, SessionConnectionWrapper sessionConnectionWrapper, long l2) {
        return l - sessionConnectionWrapper.getLatestActivityTime() >= l2;
    }

    private boolean poolHasSpaceForNewConnections() {
        return this.maxPoolSize > this.size();
    }

    @Override
    public synchronized void connectionClosed(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        this.connectionsInUse.remove(pooledConnection);
        this.sessionConnectionWrappers.remove(pooledConnection);
        if (!this.isPoolClosed) {
            this.enqueue(pooledConnection);
            this.logInfo("Connection returned to pool.");
        } else {
            this.closePhysically(pooledConnection, "closing returned connection.");
            this.logInfo("Connection returned to pool was closed because pool is closed.");
            this.notifyAll();
        }
    }

    @Override
    public synchronized void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        pooledConnection.removeConnectionEventListener(this);
        this.connectionsInUse.remove(pooledConnection);
        this.sessionConnectionWrappers.remove(pooledConnection);
        this.logInfo("Fatal exception occurred on pooled connection. Connection is removed from pool: ");
        this.logInfo(connectionEvent.getSQLException());
        this.closePhysically(pooledConnection, "closing invalid, removed connection.");
        this.notifyAll();
    }

    public synchronized void close() {
        this.isPoolClosed = true;
        while (this.connectionsInactive.size() > 0) {
            PooledConnection pooledConnection = this.dequeueFirstIfAny();
            if (pooledConnection == null) continue;
            this.closePhysically(pooledConnection, "closing inactive connection when connection pool was closed.");
        }
    }

    public synchronized void closeAndWait() throws InterruptedException {
        this.close();
        while (this.size() > 0) {
            this.wait();
        }
    }

    public synchronized void closeImmediatedly() {
        this.close();
        for (PooledConnection pooledConnection : this.connectionsInUse) {
            SessionConnectionWrapper sessionConnectionWrapper = (SessionConnectionWrapper)this.sessionConnectionWrappers.get(pooledConnection);
            this.closeSessionWrapper(sessionConnectionWrapper, "Error closing session wrapper. Connection pool was shutdown immediatedly.");
        }
    }

    private void closePhysically(PooledConnection pooledConnection, String string) {
        try {
            pooledConnection.close();
        }
        catch (SQLException sQLException) {
            this.logInfo("Error " + string, sQLException);
        }
    }

    private void logInfo(String string) {
        this.connectionPoolDataSource.logInfo(string);
    }

    private void logInfo(Throwable throwable) {
        this.connectionPoolDataSource.logInfo(throwable);
    }

    private void logInfo(String string, Throwable throwable) {
        this.connectionPoolDataSource.logInfo(string, throwable);
    }

    public void setDefaultAutoCommit(boolean bl) {
        this.isAutoCommit = bl;
        this.doResetAutoCommit = true;
    }

    public void setDefaultReadOnly(boolean bl) {
        this.isReadOnly = bl;
        this.doResetReadOnly = true;
    }

    public void setDefaultTransactionIsolation(int n) {
        this.transactionIsolation = n;
        this.doResetTransactionIsolation = true;
    }

    public void setDefaultCatalog(String string) {
        this.catalog = string;
        this.doResetCatalog = true;
    }

    public boolean getDefaultAutoCommit() {
        this.doResetAutoCommit = true;
        return this.isAutoCommit;
    }

    public String getDefaultCatalog() {
        this.doResetCatalog = true;
        return this.catalog;
    }

    public boolean getDefaultReadOnly() {
        this.doResetReadOnly = true;
        return this.isReadOnly;
    }

    public int getDefaultTransactionIsolation() {
        this.doResetTransactionIsolation = true;
        return this.transactionIsolation;
    }

    public void setDriverClassName(String string) {
        if (string.equals("org.hsqldb.jdbc.JDBCDriver")) {
            return;
        }
        throw new RuntimeException("This class only supports JDBC driver 'org.hsqldb.jdbc.JDBCDriver'");
    }

    public String getDriverClassName() {
        return "org.hsqldb.jdbc.JDBCDriver";
    }

    public void setInitialSize(int n) {
        this.initialSize = n;
    }

    public int getInitialPoolSize() {
        return this.getInitialSize();
    }

    public void setInitialPoolSize(int n) {
        this.setInitialSize(n);
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public int getNumActive() {
        return this.connectionsInUse.size();
    }

    public int getNumIdle() {
        return this.connectionsInactive.size();
    }

    public void setUsername(String string) {
        this.setUser(string);
    }

    public String getUsername() {
        return this.getUser();
    }

    public void setMaxActive(int n) {
        this.setMaxPoolSize(n);
    }

    public int getMaxActive() {
        return this.getMaxPoolSize();
    }

    public void setValidationQuery(String string) {
        this.validationQuery = string;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void addConnectionProperty(String string, String string2) {
        this.connectionPoolDataSource.setConnectionProperty(string, string2);
    }

    public void removeConnectionProperty(String string) {
        this.connectionPoolDataSource.removeConnectionProperty(string);
    }

    public Properties getConnectionProperties() {
        return this.connectionPoolDataSource.getConnectionProperties();
    }

    public String toString() throws RuntimeException {
        int n = 0;
        try {
            n = this.getLoginTimeout();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("Failed to retrieve the Login Timeout value");
        }
        StringBuffer stringBuffer = new StringBuffer(ManagedPoolDataSource.class.getName() + " instance:\n    User:  " + this.getUsername() + "\n    Url:  " + this.getUrl() + "\n    Login Timeout:  " + n + "\n    Num ACTIVE:  " + this.getNumActive() + "\n    Num IDLE:  " + this.getNumIdle());
        if (this.doResetAutoCommit) {
            stringBuffer.append("\n    Default auto-commit: " + this.getDefaultAutoCommit());
        }
        if (this.doResetReadOnly) {
            stringBuffer.append("\n    Default read-only: " + this.getDefaultReadOnly());
        }
        if (this.doResetTransactionIsolation) {
            stringBuffer.append("\n    Default trans. lvl.: " + this.getDefaultTransactionIsolation());
        }
        if (this.doResetCatalog) {
            stringBuffer.append("\n    Default catalog: " + this.getDefaultCatalog());
        }
        return stringBuffer.toString() + "\n    Max Active: " + this.getMaxActive() + "\n    Init Size: " + this.getInitialSize() + "\n    Conn Props: " + this.getConnectionProperties() + "\n    Validation Query: " + this.validationQuery + '\n';
    }
}

