/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class ProxyInputStream
extends FilterInputStream {
    public ProxyInputStream(InputStream proxy) {
        super(proxy);
    }

    public int read() throws IOException {
        try {
            return this.in.read();
        }
        catch (IOException e) {
            this.handleIOException(e);
            return -1;
        }
    }

    public int read(byte[] bts) throws IOException {
        try {
            return this.in.read(bts);
        }
        catch (IOException e) {
            this.handleIOException(e);
            return -1;
        }
    }

    public int read(byte[] bts, int off, int len) throws IOException {
        try {
            return this.in.read(bts, off, len);
        }
        catch (IOException e) {
            this.handleIOException(e);
            return -1;
        }
    }

    public long skip(long ln) throws IOException {
        try {
            return this.in.skip(ln);
        }
        catch (IOException e) {
            this.handleIOException(e);
            return 0L;
        }
    }

    public int available() throws IOException {
        try {
            return super.available();
        }
        catch (IOException e) {
            this.handleIOException(e);
            return 0;
        }
    }

    public void close() throws IOException {
        try {
            this.in.close();
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    public synchronized void reset() throws IOException {
        try {
            this.in.reset();
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    protected void handleIOException(IOException e) throws IOException {
        throw e;
    }
}

