/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import java.util.Locale;
import java.util.Map;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.spec.MessageBundle;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LocaleSpec {
    private final Locale locale;
    private final String languageDirection;
    private final Uri messages;
    private final MessageBundle messageBundle;

    public LocaleSpec(Element element, Uri specUrl) throws SpecParserException {
        String language = XmlUtil.getAttribute((Node)element, (String)"lang", (String)"all").toLowerCase();
        String country = XmlUtil.getAttribute((Node)element, (String)"country", (String)"ALL").toUpperCase();
        this.locale = new Locale(language, country);
        this.languageDirection = XmlUtil.getAttribute((Node)element, (String)"language_direction", (String)"ltr");
        if (!"ltr".equals(this.languageDirection) && !"rtl".equals(this.languageDirection)) {
            throw new SpecParserException("Locale/@language_direction must be ltr or rtl");
        }
        String messagesString = XmlUtil.getAttribute((Node)element, (String)"messages");
        if (messagesString == null) {
            this.messages = Uri.parse((String)"");
        } else {
            try {
                this.messages = specUrl.resolve(Uri.parse((String)messagesString));
            }
            catch (IllegalArgumentException e) {
                throw new SpecParserException("Locale@messages url is invalid.");
            }
        }
        this.messageBundle = new MessageBundle(element);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getLanguage() {
        return this.locale.getLanguage();
    }

    public String getCountry() {
        return this.locale.getCountry();
    }

    public String getLanguageDirection() {
        return this.languageDirection;
    }

    public Uri getMessages() {
        return this.messages;
    }

    public MessageBundle getMessageBundle() {
        return this.messageBundle;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("<Locale").append(" lang='").append(this.getLanguage()).append('\'').append(" country='").append(this.getCountry()).append('\'').append(" language_direction='").append(this.languageDirection).append('\'').append(" messages='").append(this.messages).append("'>\n");
        for (Map.Entry<String, String> entry : this.messageBundle.getMessages().entrySet()) {
            buf.append("<msg name='").append(entry.getKey()).append("'>").append(entry.getValue()).append("</msg>\n");
        }
        buf.append("</Locale>");
        return buf.toString();
    }
}

