/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.python.core.ArgParser;
import org.python.core.MakeProxies;
import org.python.core.Py;
import org.python.core.PyBaseString;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyClass;
import org.python.core.PyDataDescr;
import org.python.core.PyDictProxy;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFrame;
import org.python.core.PyFunction;
import org.python.core.PyJavaType;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyMethodDescr;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyProxy;
import org.python.core.PySlot;
import org.python.core.PyStaticMethod;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;
import org.python.core.PyType$PyExposer;
import org.python.core.PyTypeDerived;
import org.python.core.PyUnicode;
import org.python.core.imp;
import org.python.expose.ExposeAsSuperclass;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.expose.TypeBuilder;
import org.python.google.common.collect.MapMaker;
import org.python.modules._weakref.WeakrefModule;
import org.python.util.Generic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExposedType(name="type", doc="type(object) -> the object's type\ntype(name, bases, dict) -> a new type")
public class PyType
extends PyObject
implements Serializable {
    public static PyType TYPE;
    protected String name;
    protected PyType base;
    protected PyObject[] bases = new PyObject[0];
    protected PyObject dict;
    protected PyObject[] mro;
    private long tp_flags;
    protected Class<?> underlying_class;
    protected boolean builtin;
    protected boolean instantiable = true;
    boolean hasGet;
    boolean hasSet;
    boolean hasDelete;
    private boolean isBaseType = true;
    protected boolean needs_userdict;
    protected boolean needs_weakref;
    private boolean needs_finalizer;
    private volatile boolean usesObjectGetattribute;
    private volatile Object versionTag = new Object();
    private int numSlots;
    private ReferenceQueue<PyType> subclasses_refq = new ReferenceQueue();
    private Set<WeakReference<PyType>> subclasses = Generic.set();
    private static final MethodCache methodCache;
    private static Map<Class<?>, PyType> class_to_type;
    private static Set<PyType> exposedTypes;
    private static Map<Class<?>, TypeBuilder> classToBuilder;

    protected PyType(PyType subtype) {
        super(subtype);
    }

    private PyType() {
    }

    private PyType(boolean ignored) {
        super(ignored);
    }

    @ExposedNew
    public static PyObject type___new__(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        if (args.length == 1 && keywords.length == 0) {
            PyType psmType;
            PyObject obj = args[0];
            PyType objType = obj.getType();
            if (objType == (psmType = PyType.fromClass(PyStringMap.class))) {
                return PyDictionary.TYPE;
            }
            return objType;
        }
        if (args.length + keywords.length != 3) {
            throw Py.TypeError("type() takes 1 or 3 arguments");
        }
        ArgParser ap = new ArgParser("type()", args, keywords, "name", "bases", "dict");
        String name = ap.getString(0);
        PyTuple bases = (PyTuple)ap.getPyObjectByType(1, PyTuple.TYPE);
        PyObject dict = ap.getPyObject(2);
        if (!(dict instanceof PyDictionary) && !(dict instanceof PyStringMap)) {
            throw Py.TypeError("type(): argument 3 must be dict, not " + dict.getType());
        }
        return PyType.newType(new_, subtype, name, bases, dict);
    }

    public static PyObject newType(PyNewWrapper new_, PyType metatype, String name, PyTuple bases, PyObject dict) {
        PyObject[] pyObjectArray;
        PyObject[] tmpBases = bases.getArray();
        PyType winner = PyType.findMostDerivedMetatype(tmpBases, metatype);
        if (winner != metatype) {
            PyObject winnerNew = winner.lookup("__new__");
            if (winnerNew != null && winnerNew != new_) {
                return PyType.invokeNew(winnerNew, winner, false, new PyObject[]{new PyString(name), bases, dict}, Py.NoKeywords);
            }
            metatype = winner;
        }
        if (metatype == PyType.fromClass(Class.class)) {
            metatype = TYPE;
        }
        PyType type = new_.for_type == metatype ? new PyType() : new PyTypeDerived(metatype);
        dict = dict instanceof PyStringMap ? ((PyStringMap)dict).copy() : ((PyDictionary)dict).copy();
        type.name = name;
        if (tmpBases.length == 0) {
            PyObject[] pyObjectArray2 = new PyObject[1];
            pyObjectArray = pyObjectArray2;
            pyObjectArray2[0] = PyObject.TYPE;
        } else {
            pyObjectArray = tmpBases;
        }
        type.bases = pyObjectArray;
        type.dict = dict;
        type.tp_flags = Py.TPFLAGS_HEAPTYPE | Py.TPFLAGS_BASETYPE;
        List<Class<?>> interfaces = Generic.list();
        Class<?> baseProxyClass = PyType.getJavaLayout(type.bases, interfaces);
        type.setupProxy(baseProxyClass, interfaces);
        PyType base = type.base = PyType.best_base(type.bases);
        if (!base.isBaseType) {
            throw Py.TypeError(String.format("type '%.100s' is not an acceptable base type", base.name));
        }
        type.createAllSlots(!base.needs_userdict, !base.needs_weakref);
        type.ensureAttributes();
        type.invalidateMethodCache();
        for (PyObject cur : type.bases) {
            if (!(cur instanceof PyType)) continue;
            ((PyType)cur).attachSubclass(type);
        }
        return type;
    }

    private void createAllSlots(boolean mayAddDict, boolean mayAddWeak) {
        this.numSlots = this.base.numSlots;
        boolean wantDict = false;
        boolean wantWeak = false;
        PyObject slots = this.dict.__finditem__("__slots__");
        if (slots == null) {
            wantDict = mayAddDict;
            wantWeak = mayAddWeak;
        } else {
            if (slots instanceof PyString) {
                slots = new PyTuple(slots);
            }
            for (PyObject slot : slots.asIterable()) {
                String slotName = PyType.confirmIdentifier(slot);
                if (slotName.equals("__dict__")) {
                    if (!mayAddDict || wantDict) {
                        throw Py.TypeError("__dict__ slot disallowed: we already got one");
                    }
                    wantDict = true;
                    continue;
                }
                if (slotName.equals("__weakref__")) {
                    if (!mayAddWeak || wantWeak) {
                        throw Py.TypeError("__weakref__ slot disallowed: we already got one");
                    }
                    wantWeak = true;
                    continue;
                }
                if (this.dict.__finditem__(slotName = PyType.mangleName(this.name, slotName)) != null) continue;
                this.dict.__setitem__(slotName, (PyObject)new PySlot(this, slotName, this.numSlots++));
            }
            if (this.bases.length > 1 && (mayAddDict && !wantDict || mayAddWeak && !wantWeak)) {
                for (PyObject base : this.bases) {
                    if (base == this.base) continue;
                    if (base instanceof PyClass) {
                        if (mayAddDict && !wantDict) {
                            wantDict = true;
                        }
                        if (!mayAddWeak || wantWeak) break;
                        wantWeak = true;
                        break;
                    }
                    PyType baseType = (PyType)base;
                    if (mayAddDict && !wantDict && baseType.needs_userdict) {
                        wantDict = true;
                    }
                    if (mayAddWeak && !wantWeak && baseType.needs_weakref) {
                        wantWeak = true;
                    }
                    if (!(mayAddDict && !wantDict || mayAddWeak && !wantWeak)) break;
                }
            }
        }
        if (wantDict) {
            this.createDictSlot();
        }
        if (wantWeak) {
            this.createWeakrefSlot();
        }
        this.needs_finalizer = this.lookup_mro("__del__") != null;
    }

    private void createDictSlot() {
        String doc = "dictionary for instance variables (if defined)";
        this.dict.__setitem__("__dict__", (PyObject)new PyDataDescr(this, "__dict__", PyObject.class, doc){

            public boolean implementsDescrGet() {
                return true;
            }

            public Object invokeGet(PyObject obj) {
                return obj.getDict();
            }

            public boolean implementsDescrSet() {
                return true;
            }

            public void invokeSet(PyObject obj, Object value) {
                obj.setDict((PyObject)value);
            }

            public boolean implementsDescrDelete() {
                return true;
            }

            public void invokeDelete(PyObject obj) {
                obj.delDict();
            }
        });
        this.needs_userdict = true;
    }

    private void createWeakrefSlot() {
        String doc = "list of weak references to the object (if defined)";
        this.dict.__setitem__("__weakref__", (PyObject)new PyDataDescr(this, "__weakref__", PyObject.class, doc){
            private static final String writeMsg = "attribute '%s' of '%s' objects is not writable";

            private void notWritable(PyObject obj) {
                throw Py.AttributeError(String.format(writeMsg, "__weakref__", obj.getType().fastGetName()));
            }

            public boolean implementsDescrGet() {
                return true;
            }

            public Object invokeGet(PyObject obj) {
                PyList weakrefs = WeakrefModule.getweakrefs(obj);
                switch (weakrefs.size()) {
                    case 0: {
                        return Py.None;
                    }
                    case 1: {
                        return weakrefs.pyget(0);
                    }
                }
                return weakrefs;
            }

            public boolean implementsDescrSet() {
                return true;
            }

            public void invokeSet(PyObject obj, Object value) {
                this.notWritable(obj);
            }

            public boolean implementsDescrDelete() {
                return true;
            }

            public void invokeDelete(PyObject obj) {
                this.notWritable(obj);
            }
        });
        this.needs_weakref = true;
    }

    private void ensureAttributes() {
        this.inheritSpecial();
        PyObject new_ = this.dict.__finditem__("__new__");
        if (new_ != null && new_ instanceof PyFunction) {
            this.dict.__setitem__("__new__", (PyObject)new PyStaticMethod(new_));
        }
        PyType.ensureDoc(this.dict);
        PyType.ensureModule(this.dict);
        this.mro_internal();
        this.cacheDescrBinds();
    }

    private void inheritSpecial() {
        if (!this.needs_userdict && this.base.needs_userdict) {
            this.needs_userdict = true;
        }
        if (!this.needs_weakref && this.base.needs_weakref) {
            this.needs_weakref = true;
        }
    }

    public static void ensureDoc(PyObject dict) {
        if (dict.__finditem__("__doc__") == null) {
            dict.__setitem__("__doc__", Py.None);
        }
    }

    public static void ensureModule(PyObject dict) {
        if (dict.__finditem__("__module__") != null) {
            return;
        }
        PyFrame frame = Py.getFrame();
        if (frame == null) {
            return;
        }
        PyObject name = frame.f_globals.__finditem__("__name__");
        if (name != null) {
            dict.__setitem__("__module__", name);
        }
    }

    private static PyObject invokeNew(PyObject new_, PyType type, boolean init, PyObject[] args, String[] keywords) {
        PyObject obj;
        if (new_ instanceof PyNewWrapper) {
            obj = ((PyNewWrapper)new_).new_impl(init, type, args, keywords);
        } else {
            int n = args.length;
            PyObject[] typePrepended = new PyObject[n + 1];
            System.arraycopy(args, 0, typePrepended, 1, n);
            typePrepended[0] = type;
            obj = new_.__get__(null, type).__call__(typePrepended, keywords);
        }
        return obj;
    }

    protected void init(Class<?> forClass, Set<PyJavaType> needsInners) {
        this.underlying_class = forClass;
        if (this.underlying_class == PyObject.class) {
            this.mro = new PyType[]{this};
        } else {
            Class<?> baseClass = !Py.BOOTSTRAP_TYPES.contains(this.underlying_class) ? classToBuilder.get(this.underlying_class).getBase() : PyObject.class;
            if (baseClass == Object.class) {
                baseClass = this.underlying_class.getSuperclass();
            }
            this.computeLinearMro(baseClass);
        }
        if (Py.BOOTSTRAP_TYPES.contains(this.underlying_class)) {
            return;
        }
        TypeBuilder builder = classToBuilder.get(this.underlying_class);
        this.name = builder.getName();
        this.dict = builder.getDict(this);
        String doc = builder.getDoc();
        if (this.dict.__finditem__("__doc__") == null && forClass != PyBaseString.class && forClass != PyString.class) {
            PyObject docObj = doc != null ? new PyString(doc) : (Py.None == null ? new PyString() : Py.None);
            this.dict.__setitem__("__doc__", docObj);
        }
        this.setIsBaseType(builder.getIsBaseType());
        this.needs_userdict = this.dict.__finditem__("__dict__") != null;
        this.instantiable = this.dict.__finditem__("__new__") != null;
        this.cacheDescrBinds();
    }

    protected void computeLinearMro(Class<?> baseClass) {
        this.base = PyType.fromClass(baseClass, false);
        this.mro = new PyType[this.base.mro.length + 1];
        System.arraycopy(this.base.mro, 0, this.mro, 1, this.base.mro.length);
        this.mro[0] = this;
        this.bases = new PyObject[]{this.base};
    }

    private void cacheDescrBinds() {
        this.hasGet = this.lookup_mro("__get__") != null;
        this.hasSet = this.lookup_mro("__set__") != null;
        this.hasDelete = this.lookup_mro("__delete__") != null;
    }

    public PyObject getStatic() {
        PyType cur = this;
        while (cur.underlying_class == null) {
            cur = cur.base;
        }
        return cur;
    }

    public void compatibleForAssignment(PyType other, String attribute) {
        if (!this.getLayout().equals(other.getLayout()) || this.needs_userdict != other.needs_userdict || this.needs_finalizer != other.needs_finalizer) {
            throw Py.TypeError(String.format("%s assignment: '%s' object layout differs from '%s'", attribute, other.fastGetName(), this.fastGetName()));
        }
    }

    private PyType getLayout() {
        if (this.underlying_class != null) {
            return this;
        }
        if (this.numSlots != this.base.numSlots) {
            return this;
        }
        return this.base.getLayout();
    }

    private static Class<?> getJavaLayout(PyObject[] bases, List<Class<?>> interfaces) {
        Class<?> baseProxy = null;
        for (PyObject base : bases) {
            Class<?> proxy;
            if (!(base instanceof PyType) || (proxy = ((PyType)base).getProxyType()) == null) continue;
            if (proxy.isInterface()) {
                interfaces.add(proxy);
                continue;
            }
            if (baseProxy != null) {
                String msg = "no multiple inheritance for Java classes: %s and %s";
                throw Py.TypeError(String.format(msg, proxy.getName(), baseProxy.getName()));
            }
            baseProxy = proxy;
        }
        return baseProxy;
    }

    private void setupProxy(Class<?> baseProxyClass, List<Class<?>> interfaces) {
        Class<?> proxyClass;
        if (baseProxyClass == null && interfaces.size() == 0) {
            return;
        }
        String proxyName = this.name;
        PyObject module = this.dict.__finditem__("__module__");
        if (module != null) {
            proxyName = module.toString() + "$" + proxyName;
        }
        this.javaProxy = proxyClass = MakeProxies.makeProxy(baseProxyClass, interfaces, this.name, proxyName, this.dict);
        PyType proxyType = PyType.fromClass(proxyClass, false);
        List<PyObject> cleanedBases = Generic.list();
        boolean addedProxyType = false;
        for (PyObject base : this.bases) {
            if (!(base instanceof PyType)) {
                cleanedBases.add(base);
                continue;
            }
            Class<?> proxy = ((PyType)base).getProxyType();
            if (proxy == null) {
                cleanedBases.add(base);
                continue;
            }
            if (!(base instanceof PyJavaType)) {
                cleanedBases.add(base);
                continue;
            }
            if (addedProxyType) continue;
            cleanedBases.add(proxyType);
            addedProxyType = true;
        }
        this.bases = cleanedBases.toArray(new PyObject[cleanedBases.size()]);
    }

    public PyObject getBase() {
        if (this.base == null) {
            return Py.None;
        }
        return this.base;
    }

    public PyObject getBases() {
        return new PyTuple(this.bases);
    }

    public void delBases() {
        throw Py.TypeError("Can't delete __bases__ attribute");
    }

    public void setBases(PyObject newBasesTuple) {
        if (!(newBasesTuple instanceof PyTuple)) {
            throw Py.TypeError("bases must be a tuple");
        }
        PyObject[] newBases = ((PyTuple)newBasesTuple).getArray();
        if (newBases.length == 0) {
            throw Py.TypeError("can only assign non-empty tuple to __bases__, not " + newBasesTuple);
        }
        for (int i = 0; i < newBases.length; ++i) {
            if (!(newBases[i] instanceof PyType)) {
                if (newBases[i] instanceof PyClass) continue;
                throw Py.TypeError(this.name + ".__bases__ must be a tuple of old- or new-style " + "classes, not " + newBases[i]);
            }
            if (!((PyType)newBases[i]).isSubType(this)) continue;
            throw Py.TypeError("a __bases__ item causes an inheritance cycle");
        }
        PyType newBase = PyType.best_base(newBases);
        this.base.compatibleForAssignment(newBase, "__bases__");
        PyObject[] savedBases = this.bases;
        PyType savedBase = this.base;
        PyObject[] savedMro = this.mro;
        List<Object> savedSubMros = Generic.list();
        try {
            this.bases = newBases;
            this.base = newBase;
            this.mro_internal();
            this.mro_subclasses(savedSubMros);
            for (PyObject saved : savedBases) {
                if (!(saved instanceof PyType)) continue;
                ((PyType)saved).detachSubclass(this);
            }
            for (PyObject newb : newBases) {
                if (!(newb instanceof PyType)) continue;
                ((PyType)newb).attachSubclass(this);
            }
        }
        catch (PyException t) {
            Iterator it = savedSubMros.iterator();
            while (it.hasNext()) {
                PyType subtype = (PyType)it.next();
                PyObject[] subtypeSavedMro = (PyObject[])it.next();
                subtype.mro = subtypeSavedMro;
            }
            this.bases = savedBases;
            this.base = savedBase;
            this.mro = savedMro;
            throw t;
        }
        this.postSetattr("__getattribute__");
    }

    private void setIsBaseType(boolean isBaseType) {
        this.isBaseType = isBaseType;
        this.tp_flags = isBaseType ? this.tp_flags | Py.TPFLAGS_BASETYPE : this.tp_flags & (Py.TPFLAGS_BASETYPE ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private void mro_internal() {
        if (this.getType() == TYPE) {
            this.mro = this.computeMro();
        } else {
            PyObject mroDescr = this.getType().lookup("mro");
            if (mroDescr == null) {
                throw Py.AttributeError("mro");
            }
            PyObject[] result = Py.make_array(mroDescr.__get__(null, this.getType()).__call__(this));
            PyType solid = PyType.solid_base(this);
            for (PyObject cls : result) {
                if (cls instanceof PyClass) continue;
                if (!(cls instanceof PyType)) {
                    throw Py.TypeError(String.format("mro() returned a non-class ('%.500s')", cls.getType().fastGetName()));
                }
                PyType t = (PyType)cls;
                if (solid.isSubType(PyType.solid_base(t))) continue;
                throw Py.TypeError(String.format("mro() returned base with unsuitable layout ('%.500s')", t.fastGetName()));
            }
            this.mro = result;
        }
    }

    private void mro_subclasses(List<Object> mroCollector) {
        for (WeakReference<PyType> ref : this.subclasses) {
            PyType subtype = (PyType)ref.get();
            if (subtype == null) continue;
            mroCollector.add(subtype);
            mroCollector.add(subtype.mro);
            subtype.mro_internal();
            subtype.mro_subclasses(mroCollector);
        }
    }

    public PyObject instDict() {
        if (this.needs_userdict) {
            return new PyStringMap();
        }
        return null;
    }

    private void cleanup_subclasses() {
        Reference<PyType> ref;
        while ((ref = this.subclasses_refq.poll()) != null) {
            this.subclasses.remove(ref);
        }
    }

    public PyTuple getMro() {
        return this.mro == null ? Py.EmptyTuple : new PyTuple(this.mro);
    }

    public PyLong getFlags() {
        return new PyLong(this.tp_flags);
    }

    public final synchronized PyObject type___subclasses__() {
        PyList result = new PyList();
        this.cleanup_subclasses();
        for (WeakReference<PyType> ref : this.subclasses) {
            PyType subtype = (PyType)ref.get();
            if (subtype == null) continue;
            result.append(subtype);
        }
        return result;
    }

    public Class<?> getProxyType() {
        return (Class)this.javaProxy;
    }

    private synchronized void attachSubclass(PyType subtype) {
        this.cleanup_subclasses();
        this.subclasses.add(new WeakReference<PyType>(subtype, this.subclasses_refq));
    }

    private synchronized void detachSubclass(PyType subtype) {
        this.cleanup_subclasses();
        for (WeakReference<PyType> ref : this.subclasses) {
            if (ref.get() != subtype) continue;
            this.subclasses.remove(ref);
            break;
        }
    }

    private synchronized void traverse_hierarchy(boolean top, OnType behavior) {
        boolean stop = false;
        if (!top) {
            stop = behavior.onType(this);
        }
        if (stop) {
            return;
        }
        for (WeakReference<PyType> ref : this.subclasses) {
            PyType subtype = (PyType)ref.get();
            if (subtype == null) continue;
            subtype.traverse_hierarchy(false, behavior);
        }
    }

    private static void fill_classic_mro(List<PyObject> acc, PyClass classic_cl) {
        PyObject[] bases;
        if (!acc.contains(classic_cl)) {
            acc.add(classic_cl);
        }
        for (PyObject base : bases = classic_cl.__bases__.getArray()) {
            PyType.fill_classic_mro(acc, (PyClass)base);
        }
    }

    private static PyObject[] classic_mro(PyClass classic_cl) {
        List<PyObject> acc = Generic.list();
        PyType.fill_classic_mro(acc, classic_cl);
        return acc.toArray(new PyObject[acc.size()]);
    }

    final PyList type_mro(PyObject o) {
        if (o == null) {
            return new PyList(this.computeMro());
        }
        return new PyList(((PyType)o).computeMro());
    }

    PyObject[] computeMro() {
        for (int i = 0; i < this.bases.length; ++i) {
            PyObject cur = this.bases[i];
            for (int j = i + 1; j < this.bases.length; ++j) {
                if (this.bases[j] != cur) continue;
                PyObject name = cur.__findattr__("__name__");
                throw Py.TypeError("duplicate base class " + (name == null ? "?" : name.toString()));
            }
        }
        MROMergeState[] toMerge = new MROMergeState[this.bases.length + 1];
        for (int i = 0; i < this.bases.length; ++i) {
            toMerge[i] = new MROMergeState();
            if (this.bases[i] instanceof PyType) {
                toMerge[i].mro = ((PyType)this.bases[i]).mro;
                continue;
            }
            if (!(this.bases[i] instanceof PyClass)) continue;
            toMerge[i].mro = PyType.classic_mro((PyClass)this.bases[i]);
        }
        toMerge[this.bases.length] = new MROMergeState();
        toMerge[this.bases.length].mro = this.bases;
        List<PyObject> mro = Generic.list();
        mro.add(this);
        return this.computeMro(toMerge, mro);
    }

    PyObject[] computeMro(MROMergeState[] toMerge, List<PyObject> mro) {
        boolean addedProxy = false;
        PyType proxyAsType = this.javaProxy == null ? null : PyType.fromClass((Class)this.javaProxy, false);
        block0: for (int i = 0; i < toMerge.length; ++i) {
            if (toMerge[i].isMerged()) continue;
            PyObject candidate = toMerge[i].getCandidate();
            for (MROMergeState mergee : toMerge) {
                if (mergee.pastnextContains(candidate)) continue block0;
            }
            if (!addedProxy && !(this instanceof PyJavaType) && candidate instanceof PyJavaType && candidate.javaProxy != null && PyProxy.class.isAssignableFrom((Class)candidate.javaProxy) && candidate.javaProxy != this.javaProxy) {
                mro.add(proxyAsType);
                addedProxy = true;
            }
            mro.add(candidate);
            addedProxy |= candidate == proxyAsType;
            for (MROMergeState element : toMerge) {
                element.noteMerged(candidate);
            }
            i = -1;
        }
        for (MROMergeState mergee : toMerge) {
            if (mergee.isMerged()) continue;
            this.handleMroError(toMerge, mro);
        }
        return mro.toArray(new PyObject[mro.size()]);
    }

    void handleMroError(MROMergeState[] toMerge, List<PyObject> mro) {
        StringBuilder msg = new StringBuilder("Cannot create a consistent method resolution\norder (MRO) for bases ");
        Set<PyObject> set = Generic.set();
        for (MROMergeState mergee : toMerge) {
            if (mergee.isMerged()) continue;
            set.add(mergee.mro[0]);
        }
        boolean first = true;
        for (PyObject unmerged : set) {
            PyObject name = unmerged.__findattr__("__name__");
            if (first) {
                first = false;
            } else {
                msg.append(", ");
            }
            msg.append(name == null ? "?" : name.toString() + new PyList(((PyType)unmerged).bases));
        }
        throw Py.TypeError(msg.toString());
    }

    private static PyType solid_base(PyType type) {
        do {
            if (!PyType.isSolidBase(type)) continue;
            return type;
        } while ((type = type.base) != null);
        return PyObject.TYPE;
    }

    private static boolean isSolidBase(PyType type) {
        return type.underlying_class != null || type.numSlots != 0 && !type.needs_userdict;
    }

    private static PyType best_base(PyObject[] bases) {
        PyType winner = null;
        PyType candidate = null;
        PyType best = null;
        for (PyObject base : bases) {
            if (base instanceof PyClass) continue;
            if (!(base instanceof PyType)) {
                throw Py.TypeError("bases must be types");
            }
            candidate = PyType.solid_base((PyType)base);
            if (winner == null) {
                winner = candidate;
                best = (PyType)base;
                continue;
            }
            if (winner.isSubType(candidate)) continue;
            if (candidate.isSubType(winner)) {
                winner = candidate;
                best = (PyType)base;
                continue;
            }
            throw Py.TypeError("multiple bases have instance lay-out conflict");
        }
        if (best == null) {
            throw Py.TypeError("a new-style class can't have only classic bases");
        }
        return best;
    }

    private static PyType findMostDerivedMetatype(PyObject[] bases_list, PyType initialMetatype) {
        PyType winner = initialMetatype;
        for (PyObject base : bases_list) {
            PyType curtype;
            if (base instanceof PyClass || winner.isSubType(curtype = base.getType())) continue;
            if (curtype.isSubType(winner)) {
                winner = curtype;
                continue;
            }
            throw Py.TypeError("metaclass conflict: the metaclass of a derived class must be a (non-strict) subclass of the metaclasses of all its bases");
        }
        return winner;
    }

    public boolean isSubType(PyType supertype) {
        if (this.mro != null) {
            for (PyObject base : this.mro) {
                if (base != supertype) continue;
                return true;
            }
            return false;
        }
        PyType type = this;
        do {
            if (type != supertype) continue;
            return true;
        } while ((type = type.base) != null);
        return supertype == PyObject.TYPE;
    }

    public PyObject lookup(String name) {
        return this.lookup_where(name, null);
    }

    protected PyObject lookup_mro(String name) {
        return this.lookup_where_mro(name, null);
    }

    public PyObject lookup_where(String name, PyObject[] where) {
        return methodCache.lookup_where(this, name, where);
    }

    protected PyObject lookup_where_mro(String name, PyObject[] where) {
        PyObject[] mro = this.mro;
        if (mro == null) {
            return null;
        }
        for (PyObject t : mro) {
            PyObject obj;
            PyObject dict = t.fastGetDict();
            if (dict == null || (obj = dict.__finditem__(name)) == null) continue;
            if (where != null) {
                where[0] = t;
            }
            return obj;
        }
        return null;
    }

    public PyObject super_lookup(PyType ref, String name) {
        int i;
        PyObject[] mro = this.mro;
        if (mro == null) {
            return null;
        }
        for (i = 0; i < mro.length && mro[i] != ref; ++i) {
        }
        ++i;
        while (i < mro.length) {
            PyObject obj;
            PyObject dict = mro[i].fastGetDict();
            if (dict != null && (obj = dict.__finditem__(name)) != null) {
                return obj;
            }
            ++i;
        }
        return null;
    }

    public static synchronized void addBuilder(Class<?> forClass, TypeBuilder builder) {
        if (classToBuilder == null) {
            classToBuilder = Generic.map();
        }
        classToBuilder.put(forClass, builder);
        if (class_to_type.containsKey(forClass)) {
            if (!Py.BOOTSTRAP_TYPES.remove(forClass)) {
                Py.writeWarning("init", "Bootstrapping class not in Py.BOOTSTRAP_TYPES[class=" + forClass + "]");
            }
            PyType.fromClass(builder.getTypeClass()).init(builder.getTypeClass(), null);
        }
    }

    private static synchronized PyType addFromClass(Class<?> c, Set<PyJavaType> needsInners) {
        if (ExposeAsSuperclass.class.isAssignableFrom(c)) {
            PyType exposedAs = PyType.fromClass(c.getSuperclass(), false);
            class_to_type.put(c, exposedAs);
            return exposedAs;
        }
        return PyType.createType(c, needsInners);
    }

    private static TypeBuilder getBuilder(Class<?> c) {
        if (classToBuilder == null) {
            return null;
        }
        if (c.isPrimitive() || !PyObject.class.isAssignableFrom(c)) {
            return null;
        }
        SecurityException exc = null;
        try {
            Class.forName(c.getName(), true, c.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Got ClassNotFound calling Class.forName on an already  found class.", e);
        }
        catch (ExceptionInInitializerError e) {
            throw Py.JavaError(e);
        }
        catch (SecurityException e) {
            exc = e;
        }
        TypeBuilder builder = classToBuilder.get(c);
        if (builder == null && exc != null) {
            Py.writeComment("type", "Unable to initialize " + c.getName() + ", a PyObject subclass, due to a " + "security exception, and no type builder could be found for it. If it's an " + "exposed type, it may not work properly.  Security exception: " + exc.getMessage());
        }
        return builder;
    }

    private static synchronized PyType createType(Class<?> c, Set<PyJavaType> needsInners) {
        PyType newtype = c == PyType.class ? new PyType(false) : (Py.BOOTSTRAP_TYPES.contains(c) || PyType.getBuilder(c) != null ? new PyType() : new PyJavaType());
        PyType type = class_to_type.get(c);
        if (type != null) {
            return type;
        }
        class_to_type.put(c, newtype);
        newtype.builtin = true;
        newtype.init(c, needsInners);
        newtype.invalidateMethodCache();
        return newtype;
    }

    public static synchronized PyType fromClass(Class<?> c) {
        return PyType.fromClass(c, true);
    }

    public static synchronized PyType fromClass(Class<?> c, boolean hardRef) {
        PyType type;
        if (class_to_type == null) {
            class_to_type = new MapMaker().weakKeys().weakValues().makeMap();
            PyType.addFromClass(PyType.class, null);
        }
        if ((type = class_to_type.get(c)) != null) {
            return type;
        }
        Set<PyJavaType> needsInners = Generic.set();
        PyType result = PyType.addFromClass(c, needsInners);
        for (PyJavaType javaType : needsInners) {
            Class<?> forClass = javaType.getProxyType();
            if (forClass == null) continue;
            for (Class<?> inner : forClass.getClasses()) {
                if (inner.getDeclaringClass() != forClass || javaType.dict.__finditem__(inner.getSimpleName()) != null) continue;
                if (inner.getAnnotation(ExposedType.class) != null || ExposeAsSuperclass.class.isAssignableFrom(inner)) {
                    Py.BOOTSTRAP_TYPES.add(inner);
                }
                javaType.dict.__setitem__(inner.getSimpleName(), (PyObject)PyType.fromClass(inner, hardRef));
            }
        }
        if (hardRef && result != null) {
            if (exposedTypes == null) {
                exposedTypes = Generic.set();
            }
            exposedTypes.add(result);
        }
        return result;
    }

    static PyType fromClassSkippingInners(Class<?> c, Set<PyJavaType> needsInners) {
        PyType type = class_to_type.get(c);
        if (type != null) {
            return type;
        }
        return PyType.addFromClass(c, needsInners);
    }

    final PyObject type___getattribute__(PyObject name) {
        String n = PyType.asName(name);
        PyObject ret = this.type___findattr_ex__(n);
        if (ret == null) {
            this.noAttributeError(n);
        }
        return ret;
    }

    @Override
    public PyObject __findattr_ex__(String name) {
        return this.type___findattr_ex__(name);
    }

    final PyObject type___findattr_ex__(String name) {
        PyObject res;
        PyObject attr;
        PyType metatype = this.getType();
        PyObject metaattr = metatype.lookup(name);
        boolean get = false;
        if (metaattr != null) {
            PyObject res2;
            get = metaattr.implementsDescrGet();
            if (this.useMetatypeFirst(metaattr) && get && metaattr.isDataDescr() && (res2 = metaattr.__get__(this, metatype)) != null) {
                return res2;
            }
        }
        if ((attr = this.lookup(name)) != null && (res = attr.__get__(null, this)) != null) {
            return res;
        }
        if (get) {
            return metaattr.__get__(this, metatype);
        }
        if (metaattr != null) {
            return metaattr;
        }
        return null;
    }

    protected boolean useMetatypeFirst(PyObject attr) {
        return true;
    }

    final void type___setattr__(PyObject name, PyObject value) {
        this.type___setattr__(PyType.asName(name), value);
    }

    @Override
    public void __setattr__(String name, PyObject value) {
        this.type___setattr__(name, value);
    }

    public void addMethod(PyBuiltinMethod meth) {
        PyMethodDescr pmd = meth.makeDescriptor(this);
        this.__setattr__(pmd.getName(), (PyObject)pmd);
    }

    public void removeMethod(PyBuiltinMethod meth) {
        this.__delattr__(meth.info.getName());
    }

    void type___setattr__(String name, PyObject value) {
        if (this.builtin) {
            throw Py.TypeError(String.format("can't set attributes of built-in/extension type '%s'", this.name));
        }
        super.__setattr__(name, value);
        this.postSetattr(name);
    }

    void postSetattr(String name) {
        this.invalidateMethodCache();
        if (name == "__get__") {
            if (!this.hasGet && this.lookup("__get__") != null) {
                this.traverse_hierarchy(false, new OnType(){

                    public boolean onType(PyType type) {
                        boolean old = type.hasGet;
                        type.hasGet = true;
                        return old;
                    }
                });
            }
        } else if (name == "__set__") {
            if (!this.hasSet && this.lookup("__set__") != null) {
                this.traverse_hierarchy(false, new OnType(){

                    public boolean onType(PyType type) {
                        boolean old = type.hasSet;
                        type.hasSet = true;
                        return old;
                    }
                });
            }
        } else if (name == "__delete__") {
            if (!this.hasDelete && this.lookup("__delete__") != null) {
                this.traverse_hierarchy(false, new OnType(){

                    public boolean onType(PyType type) {
                        boolean old = type.hasDelete;
                        type.hasDelete = true;
                        return old;
                    }
                });
            }
        } else if (name == "__getattribute__") {
            this.traverse_hierarchy(false, new OnType(){

                public boolean onType(PyType type) {
                    return type.usesObjectGetattribute = false;
                }
            });
        }
    }

    @Override
    public void __delattr__(String name) {
        this.type___delattr__(name);
    }

    final void type___delattr__(PyObject name) {
        this.type___delattr__(PyType.asName(name));
    }

    protected void checkDelattr() {
    }

    void type___delattr__(String name) {
        if (this.builtin) {
            throw Py.TypeError(String.format("can't set attributes of built-in/extension type '%s'", this.name));
        }
        super.__delattr__(name);
        this.postDelattr(name);
    }

    void postDelattr(String name) {
        this.invalidateMethodCache();
        if (name == "__get__") {
            if (this.hasGet && this.lookup("__get__") == null) {
                this.traverse_hierarchy(false, new OnType(){

                    public boolean onType(PyType type) {
                        boolean absent;
                        boolean bl = absent = type.getDict().__finditem__("__get__") == null;
                        if (absent) {
                            type.hasGet = false;
                            return false;
                        }
                        return true;
                    }
                });
            }
        } else if (name == "__set__") {
            if (this.hasSet && this.lookup("__set__") == null) {
                this.traverse_hierarchy(false, new OnType(){

                    public boolean onType(PyType type) {
                        boolean absent;
                        boolean bl = absent = type.getDict().__finditem__("__set__") == null;
                        if (absent) {
                            type.hasSet = false;
                            return false;
                        }
                        return true;
                    }
                });
            }
        } else if (name == "__delete__") {
            if (this.hasDelete && this.lookup("__delete__") == null) {
                this.traverse_hierarchy(false, new OnType(){

                    public boolean onType(PyType type) {
                        boolean absent;
                        boolean bl = absent = type.getDict().__finditem__("__delete__") == null;
                        if (absent) {
                            type.hasDelete = false;
                            return false;
                        }
                        return true;
                    }
                });
            }
        } else if (name == "__getattribute__") {
            this.traverse_hierarchy(false, new OnType(){

                public boolean onType(PyType type) {
                    return type.usesObjectGetattribute = false;
                }
            });
        }
    }

    protected void invalidateMethodCache() {
        this.traverse_hierarchy(false, new OnType(){

            public boolean onType(PyType type) {
                type.versionTag = new Object();
                return false;
            }
        });
    }

    @Override
    public PyObject __call__(PyObject[] args, String[] keywords) {
        return this.type___call__(args, keywords);
    }

    final PyObject type___call__(PyObject[] args, String[] keywords) {
        PyObject new_ = this.lookup("__new__");
        if (!this.instantiable || new_ == null) {
            throw Py.TypeError(String.format("cannot create '%.100s' instances", this.name));
        }
        PyObject obj = PyType.invokeNew(new_, this, true, args, keywords);
        if (this == TYPE && args.length == 1 && keywords.length == 0 || !obj.getType().isSubType(this)) {
            return obj;
        }
        obj.dispatch__init__(args, keywords);
        return obj;
    }

    @Override
    protected void __rawdir__(PyDictionary accum) {
        this.mergeClassDict(accum, this);
    }

    public String fastGetName() {
        return this.name;
    }

    public PyObject pyGetName() {
        return Py.newString(this.getName());
    }

    public String getName() {
        if (!this.builtin) {
            return this.name;
        }
        int lastDot = this.name.lastIndexOf(46);
        if (lastDot != -1) {
            return this.name.substring(lastDot + 1);
        }
        return this.name;
    }

    public void pySetName(PyObject name) {
        if (!(name instanceof PyString)) {
            throw Py.TypeError(String.format("can only assign string to %s.__name__, not '%s'", this.name, name.getType().fastGetName()));
        }
        String nameStr = name.toString();
        if (nameStr.indexOf(0) > -1) {
            throw Py.ValueError("__name__ must not contain null bytes");
        }
        this.setName(nameStr);
        this.invalidateMethodCache();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void pyDelName() {
        throw Py.TypeError(String.format("can't delete %s.__name__", this.name));
    }

    @Override
    public PyObject fastGetDict() {
        return this.dict;
    }

    @Override
    public PyObject getDict() {
        return new PyDictProxy(this.dict);
    }

    @Override
    public void setDict(PyObject newDict) {
        throw Py.AttributeError(String.format("attribute '__dict__' of '%s' objects is not writable", this.getType().fastGetName()));
    }

    @Override
    public void delDict() {
        this.setDict(null);
    }

    public PyObject getDoc() {
        PyObject doc = this.dict.__finditem__("__doc__");
        if (doc == null) {
            return Py.None;
        }
        return doc.__get__(null, this);
    }

    boolean getUsesObjectGetattribute() {
        return this.usesObjectGetattribute;
    }

    void setUsesObjectGetattribute(boolean usesObjectGetattribute) {
        this.usesObjectGetattribute = usesObjectGetattribute;
    }

    @Override
    public Object __tojava__(Class<?> c) {
        if (this.underlying_class != null && (c == Object.class || c == Class.class || c == Serializable.class)) {
            return this.underlying_class;
        }
        return super.__tojava__(c);
    }

    public PyObject getModule() {
        if (!this.builtin) {
            return this.dict.__finditem__("__module__");
        }
        int lastDot = this.name.lastIndexOf(46);
        if (lastDot != -1) {
            return Py.newString(this.name.substring(0, lastDot));
        }
        return Py.newString("__builtin__");
    }

    public void delModule() {
        throw Py.TypeError(String.format("can't delete %s.__module__", this.name));
    }

    public int getNumSlots() {
        return this.numSlots;
    }

    final String type_toString() {
        String kind = !this.builtin ? "class" : "type";
        PyObject module = this.getModule();
        if (module instanceof PyString && !module.toString().equals("__builtin__")) {
            return String.format("<%s '%s.%s'>", kind, module.toString(), this.getName());
        }
        return String.format("<%s '%s'>", kind, this.getName());
    }

    @Override
    public String toString() {
        return this.type_toString();
    }

    @Override
    public void noAttributeError(String name) {
        throw Py.AttributeError(String.format("type object '%.50s' has no attribute '%.400s'", this.fastGetName(), name));
    }

    private static String confirmIdentifier(PyObject obj) {
        if (!(obj instanceof PyString)) {
            throw Py.TypeError(String.format("__slots__ items must be strings, not '%.200s'", obj.getType().fastGetName()));
        }
        String identifier = obj instanceof PyUnicode ? ((PyUnicode)obj).encode() : obj.toString();
        String msg = "__slots__ must be identifiers";
        if (identifier.length() == 0 || !Character.isLetter(identifier.charAt(0)) && identifier.charAt(0) != '_') {
            throw Py.TypeError(msg);
        }
        for (char c : identifier.toCharArray()) {
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            throw Py.TypeError(msg);
        }
        return identifier;
    }

    private static String mangleName(String classname, String methodname) {
        if (classname != null && methodname.startsWith("__") && !methodname.endsWith("__")) {
            int i = 0;
            while (classname.charAt(i) == '_') {
                ++i;
            }
            return ("_" + classname.substring(i) + methodname).intern();
        }
        return methodname;
    }

    protected Object writeReplace() {
        return new TypeResolver(this.underlying_class, this.getModule().toString(), this.getName());
    }

    static {
        PyType.addBuilder(PyType.class, new PyType$PyExposer());
        TYPE = PyType.fromClass(PyType.class);
        methodCache = new MethodCache();
    }

    static class MethodCache {
        private final AtomicReferenceArray<MethodCacheEntry> table = new AtomicReferenceArray(2048);
        public static final int SIZE_EXP = 11;

        public MethodCache() {
            this.clear();
        }

        public void clear() {
            int length = this.table.length();
            for (int i = 0; i < length; ++i) {
                this.table.set(i, MethodCacheEntry.EMPTY);
            }
        }

        public PyObject lookup_where(PyType type, String name, PyObject[] where) {
            Object versionTag = type.versionTag;
            int index = MethodCache.indexFor(versionTag, name);
            MethodCacheEntry entry = this.table.get(index);
            if (entry.isValid(versionTag, name)) {
                return entry.get(where);
            }
            if (where == null) {
                where = new PyObject[1];
            }
            PyObject value = type.lookup_where_mro(name, where);
            if (MethodCache.isCacheableName(name)) {
                this.table.compareAndSet(index, entry, new MethodCacheEntry(versionTag, name, where[0], value));
            }
            return value;
        }

        private static int indexFor(Object version, String name) {
            return version.hashCode() * name.hashCode() >>> 21;
        }

        private static boolean isCacheableName(String name) {
            return name.length() <= 100;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class MethodCacheEntry
        extends WeakReference<PyObject> {
            private final Object version;
            private final String name;
            private final WeakReference<PyObject> where;
            static final MethodCacheEntry EMPTY = new MethodCacheEntry();

            private MethodCacheEntry() {
                this(null, null, null, null);
            }

            public MethodCacheEntry(Object version, String name, PyObject where, PyObject value) {
                super(value);
                this.version = version;
                this.name = name;
                this.where = new WeakReference<PyObject>(where);
            }

            public boolean isValid(Object version, String name) {
                return this.version == version && this.name == name;
            }

            public PyObject get(PyObject[] where) {
                if (where != null) {
                    where[0] = (PyObject)this.where.get();
                }
                return (PyObject)this.get();
            }
        }
    }

    static class MROMergeState {
        public PyObject[] mro;
        public int next;

        MROMergeState() {
        }

        public boolean isMerged() {
            return this.mro.length == this.next;
        }

        public PyObject getCandidate() {
            return this.mro[this.next];
        }

        public void noteMerged(PyObject candidate) {
            if (!this.isMerged() && this.getCandidate() == candidate) {
                ++this.next;
            }
        }

        public boolean pastnextContains(PyObject candidate) {
            for (int i = this.next + 1; i < this.mro.length; ++i) {
                if (this.mro[i] != candidate) continue;
                return true;
            }
            return false;
        }

        public void removeFromUnmerged(PyJavaType winner) {
            if (this.isMerged()) {
                return;
            }
            List<PyObject> newMro = Generic.list();
            for (PyObject mroEntry : this.mro) {
                if (mroEntry == winner) continue;
                newMro.add(mroEntry);
            }
            this.mro = newMro.toArray(new PyObject[newMro.size()]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TypeResolver
    implements Serializable {
        private Class<?> underlying_class;
        String module;
        private String name;

        TypeResolver(Class<?> underlying_class, String module, String name) {
            if (underlying_class != null && !PyProxy.class.isAssignableFrom(underlying_class)) {
                this.underlying_class = underlying_class;
            }
            this.module = module;
            this.name = name;
        }

        private Object readResolve() {
            if (this.underlying_class != null) {
                return PyType.fromClass(this.underlying_class, false);
            }
            PyObject mod2 = imp.importName(this.module.intern(), false);
            PyObject pytyp = mod2.__getattr__(this.name.intern());
            if (!(pytyp instanceof PyType)) {
                throw Py.TypeError(this.module + "." + this.name + " must be a type for deserialization");
            }
            return pytyp;
        }
    }

    private static interface OnType {
        public boolean onType(PyType var1);
    }
}

