/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.common.jcr;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyReader {
    Node node = null;

    public PropertyReader(Node node) {
        this.node = node;
    }

    public Double d(String name) {
        try {
            return this.node.getProperty(name).getDouble();
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public long l(String name) {
        return this.l(name, 0L);
    }

    public long l(String name, long l) {
        try {
            return this.node.getProperty(name).getLong();
        }
        catch (Exception e) {
            return l;
        }
    }

    public String string(String name, String defaultValue) {
        try {
            return this.node.getProperty(name).getString();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String string(String name) {
        return this.string(name, null);
    }

    public Date date(String name) {
        return this.date(name, null);
    }

    public Date date(String name, Date defaultValue) {
        try {
            return this.node.getProperty(name).getDate().getTime();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public Boolean bool(String name) {
        return this.bool(name, false);
    }

    public Boolean bool(String name, boolean defaultValue) {
        try {
            return this.node.getProperty(name).getBoolean();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String[] strings(String name) {
        return this.strings(name, null);
    }

    public String[] strings(String name, String[] defaultValue) {
        try {
            return PropertyReader.valuesToArray(this.node.getProperty(name).getValues());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public List<String> list(String name) {
        return this.list(name, null);
    }

    public List<String> list(String name, List<String> defaultValue) {
        try {
            Value[] values = this.node.getProperty(name).getValues();
            return PropertyReader.valuesToList(values);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public Set<String> set(String name) {
        return this.set(name, null);
    }

    public Set<String> set(String name, Set<String> defaultValue) {
        try {
            Value[] values = this.node.getProperty(name).getValues();
            HashSet<String> result = new HashSet<String>();
            result.addAll(PropertyReader.valuesToList(values));
            return result;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String[] valuesToArray(Value[] Val) throws Exception {
        if (Val.length < 1) {
            return new String[0];
        }
        List<String> list = PropertyReader.valuesToList(Val);
        return list.toArray(new String[list.size()]);
    }

    public static List<String> valuesToList(Value[] values) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (values.length < 1) {
            return list;
        }
        for (int i = 0; i < values.length; ++i) {
            String s = values[i].getString();
            if (s == null || s.trim().length() <= 0) continue;
            list.add(s);
        }
        return list;
    }
}

