/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.dashboard.webui.component;

import org.exoplatform.application.gadget.Gadget;
import org.exoplatform.application.gadget.GadgetRegistryService;
import org.exoplatform.dashboard.webui.component.UIDashboard;
import org.exoplatform.dashboard.webui.component.UIDashboardContainer;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.webui.application.GadgetUtil;
import org.exoplatform.portal.webui.application.UIGadget;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/dashboard/webui/component/UIAddGadgetForm.gtmpl", events={@EventConfig(listeners={AddGadgetByUrlActionListener.class})})
public class UIAddGadgetForm
extends UIForm {
    public static String FIELD_URL = "url";

    public UIAddGadgetForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_URL, FIELD_URL, null));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddGadgetByUrlActionListener
    extends EventListener<UIAddGadgetForm> {
        public void execute(Event<UIAddGadgetForm> event) throws Exception {
            UIGadget uiGadget;
            WebuiRequestContext context = event.getRequestContext();
            UIAddGadgetForm uiForm = (UIAddGadgetForm)((Object)event.getSource());
            UIDashboard uiDashboard = (UIDashboard)uiForm.getAncestorOfType(UIDashboard.class);
            UIDashboardContainer uiContainer = (UIDashboardContainer)uiDashboard.getChild(UIDashboardContainer.class);
            GadgetRegistryService service = (GadgetRegistryService)uiForm.getApplicationComponent(GadgetRegistryService.class);
            String url = (String)uiForm.getUIStringInput(FIELD_URL).getValue();
            UIApplication uiApplication = context.getUIApplication();
            if (url == null || url.trim().length() == 0) {
                uiApplication.addMessage(new ApplicationMessage("UIDashboard.msg.required", null));
                return;
            }
            if (!(url = url.trim()).matches("^((ht|f)tp(s?)://)(\\w+(:\\w+)?@)?((((((25[0-5])|(2[0-4][0-9])|([01]?[0-9]?[0-9]))\\.){3}((25[0-4])|(2[0-4][0-9])|((1?[1-9]?[1-9])|([1-9]0))))|(0\\.){3}0)|([0-9a-z_!~*'()-]+\\.)*([0-9a-z][0-9a-z-]{0,61})?[0-9a-z]\\.[a-z]{2,6}|([a-zA-Z][-a-zA-Z0-9]+))(:[0-9]{1,5})?((/?)|(/[0-9a-zA-Z_!~*'().;?:@&=+$,%#-]+)+/?)$")) {
                uiApplication.addMessage(new ApplicationMessage("UIDashboard.msg.notUrl", null));
                return;
            }
            try {
                String name = "gadget" + url.hashCode();
                Gadget gadget = GadgetUtil.toGadget((String)name, (String)url, (boolean)false);
                service.saveGadget(gadget);
                uiGadget = (UIGadget)uiForm.createUIComponent(context, UIGadget.class, null, null);
                uiGadget.setState((ApplicationState)new TransientApplicationState(gadget.getName()));
            }
            catch (Exception e) {
                String aggregatorId = uiDashboard.getAggregatorId();
                Gadget gadget = service.getGadget(aggregatorId);
                uiGadget = (UIGadget)uiForm.createUIComponent(context, UIGadget.class, null, null);
                org.exoplatform.portal.pom.spi.gadget.Gadget contentState = new org.exoplatform.portal.pom.spi.gadget.Gadget();
                contentState.addUserPref("{'rssurl':'" + url + "'}");
                TransientApplicationState applicationState = new TransientApplicationState(gadget.getName(), (Object)contentState);
                uiGadget.setState((ApplicationState)applicationState);
            }
            uiContainer.addUIGadget(uiGadget, 0, 0);
            uiContainer.save();
            uiForm.reset();
            context.addUIComponentToUpdateByAjax((UIComponent)uiForm);
            context.addUIComponentToUpdateByAjax((UIComponent)uiContainer);
        }
    }
}

