/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.portal;

import java.util.List;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.StaleModelException;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageForm;
import org.exoplatform.portal.webui.page.UISiteBody;
import org.exoplatform.portal.webui.portal.PageNodeEvent;
import org.exoplatform.portal.webui.portal.UIApplicationList;
import org.exoplatform.portal.webui.portal.UIContainerList;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.portal.UIPortalForm;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIEditInlineWorkspace;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIPortalToolPanel;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.web.login.LogoutControl;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UITabPane;
import org.exoplatform.webui.core.UIWizard;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfigs(value={@ComponentConfig(template="app:/groovy/portal/webui/portal/UIPortalComposer.gtmpl", events={@EventConfig(name="ViewProperties", listeners={ViewSitePropertiesActionListener.class}), @EventConfig(listeners={CloseComposerActionListener.class}), @EventConfig(name="Abort", listeners={AbortSiteEditionActionListener.class}), @EventConfig(name="Finish", listeners={FinishSiteEditionActionListener.class}), @EventConfig(listeners={SwitchModeActionListener.class}), @EventConfig(listeners={ChangeEdittedStateActionListener.class}), @EventConfig(listeners={ToggleActionListener.class})}), @ComponentConfig(id="UIPageEditor", template="app:/groovy/portal/webui/portal/UIPortalComposer.gtmpl", events={@EventConfig(name="ViewProperties", listeners={ViewPagePropertiesActionListener.class}), @EventConfig(listeners={CloseComposerActionListener.class}), @EventConfig(name="Abort", listeners={AbortPageEditionActionListener.class}), @EventConfig(name="Finish", listeners={FinishPageEditionActionListener.class}), @EventConfig(name="Back", listeners={BackActionListener.class}), @EventConfig(listeners={SwitchModeActionListener.class}), @EventConfig(listeners={ChangeEdittedStateActionListener.class}), @EventConfig(listeners={ToggleActionListener.class})}), @ComponentConfig(id="UIPortalComposerTab", type=UITabPane.class, template="app:/groovy/portal/webui/portal/UIPortalComposerContent.gtmpl", events={@EventConfig(listeners={SelectTabActionListener.class})})})
public class UIPortalComposer
extends org.exoplatform.webui.core.UIContainer {
    public static final String UIPORTAL_COMPOSER = "UIPortalComposer";
    public static final String UIPAGE_EDITOR = "UIPageEditor";
    private boolean isEditted = false;
    private boolean isCollapsed = false;
    private boolean isShowControl = true;

    public UIPortalComposer() throws Exception {
        UITabPane uiTabPane = (UITabPane)this.addChild(UITabPane.class, "UIPortalComposerTab", null);
        ((UIApplicationList)uiTabPane.addChild(UIApplicationList.class, null, null)).setRendered(true);
        uiTabPane.addChild(UIContainerList.class, null, null);
        uiTabPane.setSelectedTab(1);
    }

    public int getPortalMode() {
        return ((UIPortalApplication)this.getAncestorOfType(UIPortalApplication.class)).getModeState();
    }

    public boolean isEditted() {
        return this.isEditted;
    }

    public void setEditted(boolean b) {
        this.isEditted = b;
    }

    public boolean isCollapse() {
        return this.isCollapsed;
    }

    public void setCollapse(boolean isCollapse) {
        this.isCollapsed = isCollapse;
    }

    public boolean isShowControl() {
        return this.isShowControl;
    }

    public void setShowControl(boolean state) {
        this.isShowControl = state;
    }

    private boolean isUsedInWizard() {
        UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)this.getAncestorOfType(UIWorkingWorkspace.class);
        UIPortalToolPanel uiToolPanel = (UIPortalToolPanel)uiWorkingWS.findFirstComponentOfType(UIPortalToolPanel.class);
        UIComponent uicomponent = uiToolPanel.getUIComponent();
        return uicomponent != null && uicomponent instanceof UIWizard;
    }

    private void save() throws Exception {
        PortalRequestContext prContext = Util.getPortalRequestContext();
        UIPortalApplication uiPortalApp = (UIPortalApplication)prContext.getUIApplication();
        UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.findFirstComponentOfType(UIWorkingWorkspace.class);
        UIEditInlineWorkspace uiEditWS = (UIEditInlineWorkspace)uiWorkingWS.getChild(UIEditInlineWorkspace.class);
        UIPortal editPortal = (UIPortal)uiEditWS.getUIComponent();
        UIPortal uiPortal = Util.getUIPortal();
        String remoteUser = prContext.getRemoteUser();
        String portalName = prContext.getPortalOwner();
        PortalConfig portalConfig = (PortalConfig)PortalDataMapper.buildModelObject((UIComponent)editPortal);
        DataStorage dataStorage = (DataStorage)this.getApplicationComponent(DataStorage.class);
        UserACL acl = (UserACL)this.getApplicationComponent(UserACL.class);
        if (!this.isPortalExist(editPortal)) {
            return;
        }
        SkinService skinService = (SkinService)this.getApplicationComponent(SkinService.class);
        skinService.invalidatePortalSkinCache(editPortal.getName(), editPortal.getSkin());
        try {
            dataStorage.save(portalConfig);
        }
        catch (StaleModelException ex) {
            this.rebuildUIPortal(uiPortalApp, editPortal, dataStorage);
        }
        prContext.getUserPortalConfig().setPortalConfig(portalConfig);
        PortalConfig pConfig = dataStorage.getPortalConfig(portalName);
        if (pConfig != null) {
            editPortal.setModifiable(acl.hasEditPermission(pConfig));
        } else {
            editPortal.setModifiable(false);
        }
        LocaleConfigService localeConfigService = (LocaleConfigService)uiPortalApp.getApplicationComponent(LocaleConfigService.class);
        LocaleConfig localeConfig = localeConfigService.getLocaleConfig(portalConfig.getLocale());
        if (localeConfig == null) {
            localeConfig = localeConfigService.getDefaultLocaleConfig();
        }
        String portalAppLanguage = prContext.getLocale().getLanguage();
        OrganizationService orgService = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        UserProfile userProfile = orgService.getUserProfileHandler().findUserProfileByName(remoteUser);
        String userLanguage = (String)userProfile.getUserInfoMap().get("user.language");
        String browserLanguage = prContext.getRequest().getLocale().getLanguage();
        if (uiPortal == null) {
            if (!portalAppLanguage.equals(userLanguage) && !portalAppLanguage.equals(browserLanguage)) {
                prContext.setLocale(localeConfig.getLocale());
            }
            uiPortalApp.setSkin(editPortal.getSkin());
        }
        prContext.refreshResourceBundle();
    }

    private void rebuildUIPortal(UIPortalApplication uiPortalApp, UIPortal uiPortal, DataStorage storage) throws Exception {
        PortalConfig portalConfig = storage.getPortalConfig(uiPortal.getSiteType().getName(), uiPortal.getName());
        UserPortalConfig userPortalConfig = Util.getPortalRequestContext().getUserPortalConfig();
        userPortalConfig.setPortalConfig(portalConfig);
        uiPortal.getChildren().clear();
        PortalDataMapper.toUIPortal(uiPortal, userPortalConfig.getPortalConfig());
        uiPortalApp.putCachedUIPortal(uiPortal);
    }

    private boolean isPortalExist(UIPortal editPortal) throws Exception {
        String remoteUser = Util.getPortalRequestContext().getRemoteUser();
        String portalOwner = null;
        portalOwner = editPortal.getSiteType().equals((Object)SiteType.PORTAL) ? editPortal.getName() : Util.getPortalRequestContext().getPortalOwner();
        UserPortalConfigService configService = (UserPortalConfigService)this.getApplicationComponent(UserPortalConfigService.class);
        return configService.getUserPortalConfig(portalOwner, remoteUser) != null;
    }

    public void updateWorkspaceComponent() throws Exception {
        UIPortalApplication uiApp = Util.getUIPortalApplication();
        WebuiRequestContext rcontext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        UIEditInlineWorkspace uiEditWS = (UIEditInlineWorkspace)uiApp.findFirstComponentOfType(UIEditInlineWorkspace.class);
        List children = uiEditWS.getChildren();
        for (UIComponent child : children) {
            if (!child.isRendered() || child.getClass().equals(UIPortalComposer.class)) continue;
            rcontext.addUIComponentToUpdateByAjax(child);
        }
        int portalMode = uiApp.getModeState();
        if (portalMode != 0) {
            switch (portalMode) {
                case 1: 
                case 3: {
                    Util.showComponentLayoutMode(UIPortlet.class);
                    break;
                }
                case 2: 
                case 4: {
                    Util.showComponentEditInViewMode(UIPortlet.class);
                }
            }
        }
        JavascriptManager jsManager = Util.getPortalRequestContext().getJavascriptManager();
        jsManager.addJavascript((CharSequence)("eXo.portal.portalMode=" + portalMode + ";"));
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        UIPortalApplication uiPortalApp = Util.getUIPortalApplication();
        int portalMode = uiPortalApp.getModeState();
        if (portalMode != 0) {
            UITabPane uiTabPane = (UITabPane)this.getChild(UITabPane.class);
            UIComponent uiComponent = uiTabPane.getChildById(uiTabPane.getSelectedTabId());
            if (uiComponent instanceof UIApplicationList) {
                if (portalMode == 2) {
                    Util.showComponentEditInViewMode(UIPortlet.class);
                } else {
                    uiPortalApp.setModeState(1);
                    Util.showComponentLayoutMode(UIPortlet.class);
                }
            } else if (uiComponent instanceof UIContainerList) {
                if (portalMode == 4) {
                    Util.showComponentEditInViewMode(UIContainer.class);
                } else {
                    uiPortalApp.setModeState(3);
                    Util.showComponentLayoutMode(UIContainer.class);
                }
            }
        }
        super.processRender(context);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BackActionListener
    extends EventListener<UIPortalComposer> {
        public void execute(Event<UIPortalComposer> event) throws Exception {
            UIPortalComposer composer = (UIPortalComposer)((Object)event.getSource());
            if (composer.isUsedInWizard()) {
                UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)composer.getAncestorOfType(UIWorkingWorkspace.class);
                UIPortalToolPanel uiToolPanel = (UIPortalToolPanel)uiWorkingWS.findFirstComponentOfType(UIPortalToolPanel.class);
                UIWizard wizard = (UIWizard)uiToolPanel.getUIComponent();
                int step = wizard.getCurrentStep();
                Event uiEvent = wizard.createEvent("ViewStep" + --step, Event.Phase.PROCESS, event.getRequestContext());
                uiEvent.broadcast();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FinishPageEditionActionListener
    extends EventListener<UIPortalComposer> {
        public void execute(Event<UIPortalComposer> event) throws Exception {
            UIPortalApplication uiPortalApp = Util.getUIPortalApplication();
            UIPortal uiPortal = uiPortalApp.getCurrentSite();
            UIEditInlineWorkspace editInlineWS = (UIEditInlineWorkspace)((UIPortalComposer)((Object)event.getSource())).getParent();
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)editInlineWS.getParent();
            UIPortalToolPanel uiToolPanel = (UIPortalToolPanel)uiWorkingWS.findFirstComponentOfType(UIPortalToolPanel.class);
            Util.getPortalRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
            UIPage uiPage = (UIPage)uiToolPanel.findFirstComponentOfType(UIPage.class);
            Page page = (Page)PortalDataMapper.buildModelObject((UIComponent)uiPage);
            String pageId = page.getPageId();
            UserPortalConfigService portalConfigService = (UserPortalConfigService)uiWorkingWS.getApplicationComponent(UserPortalConfigService.class);
            PortalRequestContext pContext = Util.getPortalRequestContext();
            if (page.getStorageId() != null && portalConfigService.getPage(pageId) == null) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageBrowser.msg.PageNotExist", (Object[])new String[]{pageId}, 1));
                uiPortalApp.setModeState(0);
                uiWorkingWS.setRenderedChild("UIViewWS");
                pContext.ignoreAJAXUpdateOnPortlets(true);
                UserNode currentNode = uiPortal.getSelectedUserNode();
                SiteKey siteKey = currentNode.getNavigation().getKey();
                PageNodeEvent<UIPortalApplication> pnevent = new PageNodeEvent<UIPortalApplication>(uiPortalApp, "ChangeNode", siteKey, currentNode.getURI());
                uiPortalApp.broadcast(pnevent, Event.Phase.PROCESS);
                JavascriptManager jsManager = event.getRequestContext().getJavascriptManager();
                jsManager.addJavascript((CharSequence)"eXo.portal.portalMode=0;");
                return;
            }
            UIPortalComposer composer = (UIPortalComposer)((UIPortalComposer)uiWorkingWS.findFirstComponentOfType(UIPortalComposer.class)).setRendered(false);
            composer.setEditted(false);
            if (composer.isUsedInWizard()) {
                UIWizard wizard = (UIWizard)uiToolPanel.getUIComponent();
                int step = wizard.getCurrentStep();
                Event uiEvent = wizard.createEvent("ViewStep" + ++step, Event.Phase.PROCESS, event.getRequestContext());
                uiEvent.broadcast();
                return;
            }
            DataStorage dataService = (DataStorage)uiWorkingWS.getApplicationComponent(DataStorage.class);
            try {
                dataService.save(page);
            }
            catch (StaleModelException ex) {
                // empty catch block
            }
            uiToolPanel.setUIComponent(null);
            page = dataService.getPage(page.getPageId());
            uiPage.getChildren().clear();
            PortalDataMapper.toUIPage(uiPage, page);
            uiPortal.setUIPage(pageId, uiPage);
            uiPortal.refreshUIPage();
            if ("always".equals(uiPortal.getSessionAlive())) {
                uiPortalApp.setSessionOpen(true);
            } else {
                uiPortalApp.setSessionOpen(false);
            }
            uiPortalApp.setModeState(0);
            uiWorkingWS.setRenderedChild("UIViewWS");
            pContext.ignoreAJAXUpdateOnPortlets(true);
            UserNode currentNode = uiPortal.getSelectedUserNode();
            SiteKey siteKey = currentNode.getNavigation().getKey();
            PageNodeEvent<UIPortalApplication> pnevent = new PageNodeEvent<UIPortalApplication>(uiPortalApp, "ChangeNode", siteKey, currentNode.getURI());
            uiPortalApp.broadcast(pnevent, Event.Phase.PROCESS);
            JavascriptManager jsManager = event.getRequestContext().getJavascriptManager();
            jsManager.addJavascript((CharSequence)"eXo.portal.portalMode=0;");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AbortPageEditionActionListener
    extends EventListener<UIPortalComposer> {
        public void execute(Event<UIPortalComposer> event) throws Exception {
            UIEditInlineWorkspace editInlineWS = (UIEditInlineWorkspace)((UIPortalComposer)((Object)event.getSource())).getParent();
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)editInlineWS.getParent();
            UIPortalToolPanel uiToolPanel = (UIPortalToolPanel)uiWorkingWS.findFirstComponentOfType(UIPortalToolPanel.class);
            uiToolPanel.setUIComponent(null);
            UIPortalApplication uiPortalApp = Util.getUIPortalApplication();
            uiPortalApp.setModeState(0);
            uiWorkingWS.setRenderedChild("UIViewWS");
            PortalRequestContext prContext = Util.getPortalRequestContext();
            prContext.ignoreAJAXUpdateOnPortlets(true);
            UIPortal uiPortal = uiPortalApp.getCurrentSite();
            uiPortal.setRenderSibling(UIPortal.class);
            UIPortalComposer composer = (UIPortalComposer)((UIPortalComposer)uiWorkingWS.findFirstComponentOfType(UIPortalComposer.class)).setRendered(false);
            composer.setEditted(false);
            uiPortal.refreshUIPage();
            UserNode currentNode = uiPortal.getSelectedUserNode();
            SiteKey siteKey = currentNode.getNavigation().getKey();
            PageNodeEvent<UIPortalApplication> pnevent = new PageNodeEvent<UIPortalApplication>(uiPortalApp, "ChangeNode", siteKey, currentNode.getURI());
            uiPortalApp.broadcast(pnevent, Event.Phase.PROCESS);
            prContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
            JavascriptManager jsManager = event.getRequestContext().getJavascriptManager();
            jsManager.addJavascript((CharSequence)"eXo.portal.portalMode=0;");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CloseComposerActionListener
    extends EventListener<UIPortalComposer> {
        public void execute(Event<UIPortalComposer> event) throws Exception {
            UIPortalComposer uiPortalComposer = (UIPortalComposer)((Object)event.getSource());
            UIEditInlineWorkspace uiEditInlineWorkspace = (UIEditInlineWorkspace)uiPortalComposer.getAncestorOfType(UIEditInlineWorkspace.class);
            if (uiPortalComposer.isEditted()) {
                ResourceBundle resourceBundle = event.getRequestContext().getApplicationResourceBundle();
                String closeMessage = resourceBundle.getString("UIEditInlineWorkspace.confirm.close");
                uiEditInlineWorkspace.showConfirmWindow(closeMessage);
            } else {
                Event abortEvent = uiPortalComposer.createEvent("Abort", event.getExecutionPhase(), event.getRequestContext());
                abortEvent.broadcast();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewPagePropertiesActionListener
    extends EventListener<UIPortalComposer> {
        public void execute(Event<UIPortalComposer> event) throws Exception {
            UIEditInlineWorkspace editInlineWS = (UIEditInlineWorkspace)((UIPortalComposer)((Object)event.getSource())).getParent();
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)editInlineWS.getParent();
            UIPortalToolPanel uiToolPanel = (UIPortalToolPanel)uiWorkingWS.findFirstComponentOfType(UIPortalToolPanel.class);
            UIPortalApplication uiPortalApp = Util.getUIPortalApplication();
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiPortalApp.getChildById("UIMaskWorkspace");
            UIPageForm uiPageForm = (UIPageForm)uiPortalApp.createUIComponent(UIPageForm.class, null, null);
            UIPage uiPage = (UIPage)uiToolPanel.findFirstComponentOfType(UIPage.class);
            uiPageForm.buildForm(uiPage);
            uiMaskWS.setUIComponent((UIComponent)uiPageForm);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ToggleActionListener
    extends EventListener<UIPortalComposer> {
        public void execute(Event<UIPortalComposer> event) throws Exception {
            UIPortalComposer uiComposer;
            uiComposer.setCollapse(!(uiComposer = (UIPortalComposer)((Object)event.getSource())).isCollapse());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiComposer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeEdittedStateActionListener
    extends EventListener<UIPortalComposer> {
        public void execute(Event<UIPortalComposer> event) {
            UIPortalComposer uiComposer = (UIPortalComposer)((Object)event.getSource());
            uiComposer.setEditted(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SwitchModeActionListener
    extends EventListener<UIPortalComposer> {
        public void execute(Event<UIPortalComposer> event) throws Exception {
            UIPortalApplication uiPortalApp = Util.getUIPortalApplication();
            int portalMode = uiPortalApp.getModeState();
            switch (portalMode) {
                case 1: {
                    uiPortalApp.setModeState(2);
                    break;
                }
                case 2: {
                    uiPortalApp.setModeState(1);
                    break;
                }
                case 3: {
                    uiPortalApp.setModeState(4);
                    break;
                }
                case 4: {
                    uiPortalApp.setModeState(3);
                    break;
                }
                default: {
                    uiPortalApp.setModeState(0);
                    return;
                }
            }
            ((UIPortalComposer)((Object)event.getSource())).updateWorkspaceComponent();
            Util.getPortalRequestContext().ignoreAJAXUpdateOnPortlets(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectTabActionListener
    extends UITabPane.SelectTabActionListener {
        public void execute(Event<UITabPane> event) throws Exception {
            super.execute(event);
            UITabPane uiTabPane = (UITabPane)event.getSource();
            UIComponent uiComponent = uiTabPane.getChildById(uiTabPane.getSelectedTabId());
            UIPortalApplication uiPortalApp = Util.getUIPortalApplication();
            int portalMode = uiPortalApp.getModeState();
            if (uiComponent instanceof UIApplicationList) {
                if (portalMode % 2 == 0) {
                    uiPortalApp.setModeState(2);
                } else {
                    uiPortalApp.setModeState(1);
                }
            } else if (uiComponent instanceof UIContainerList) {
                if (portalMode % 2 == 0) {
                    uiPortalApp.setModeState(4);
                } else {
                    uiPortalApp.setModeState(3);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FinishSiteEditionActionListener
    extends EventListener<UIPortalComposer> {
        public void execute(Event<UIPortalComposer> event) throws Exception {
            UIPortalComposer uiComposer = (UIPortalComposer)((Object)event.getSource());
            uiComposer.save();
            uiComposer.setEditted(false);
            PortalRequestContext prContext = Util.getPortalRequestContext();
            UIPortalApplication uiPortalApp = (UIPortalApplication)prContext.getUIApplication();
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
            UIEditInlineWorkspace uiEditWS = (UIEditInlineWorkspace)uiWorkingWS.getChild(UIEditInlineWorkspace.class);
            UIPortal editPortal = (UIPortal)uiEditWS.getUIComponent();
            UISiteBody siteBody = (UISiteBody)uiWorkingWS.findFirstComponentOfType(UISiteBody.class);
            UIPortal uiPortal = (UIPortal)siteBody.getUIComponent();
            if (uiPortal == null) {
                siteBody.setUIComponent((UIComponent)editPortal);
            }
            uiEditWS.setRendered(false);
            uiPortal = (UIPortal)siteBody.getUIComponent();
            uiPortalApp.setSessionOpen("always".equals(uiPortal.getSessionAlive()));
            uiPortalApp.setModeState(0);
            uiWorkingWS.setRenderedChild("UIViewWS");
            prContext.ignoreAJAXUpdateOnPortlets(true);
            if (uiComposer.isPortalExist(editPortal)) {
                DataStorage storage = (DataStorage)uiPortalApp.getApplicationComponent(DataStorage.class);
                PortalConfig pConfig = storage.getPortalConfig(uiPortal.getSiteKey().getTypeName(), uiPortal.getSiteKey().getName());
                if (pConfig != null) {
                    prContext.getUserPortalConfig().setPortalConfig(pConfig);
                }
                uiPortal.getChildren().clear();
                PortalDataMapper.toUIPortal(uiPortal, prContext.getUserPortalConfig().getPortalConfig());
                uiPortalApp.putCachedUIPortal(uiPortal);
                uiPortalApp.setCurrentSite(uiPortal);
                uiPortal.refreshUIPage();
                UserNode currentNode = uiPortal.getSelectedUserNode();
                SiteKey siteKey = currentNode.getNavigation().getKey();
                PageNodeEvent<UIPortalApplication> pnevent = new PageNodeEvent<UIPortalApplication>(uiPortalApp, "ChangeNode", siteKey, currentNode.getURI());
                uiPortalApp.broadcast(pnevent, Event.Phase.PROCESS);
                prContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
                JavascriptManager jsManager = prContext.getJavascriptManager();
                jsManager.addJavascript((CharSequence)"eXo.portal.portalMode=0;");
            } else {
                if (editPortal.getName().equals(prContext.getPortalOwner())) {
                    HttpServletRequest request = prContext.getRequest();
                    LogoutControl.wantLogout();
                    prContext.setResponseComplete(true);
                    prContext.getResponse().sendRedirect(request.getContextPath());
                    return;
                }
                UIApplication uiApp = prContext.getUIApplication();
                uiApp.addMessage(new ApplicationMessage("UIPortalForm.msg.notExistAnymore", null));
                prContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AbortSiteEditionActionListener
    extends EventListener<UIPortalComposer> {
        public void execute(Event<UIPortalComposer> event) throws Exception {
            PortalRequestContext prContext = Util.getPortalRequestContext();
            UIPortalApplication uiPortalApp = (UIPortalApplication)prContext.getUIApplication();
            uiPortalApp.setModeState(0);
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
            UIEditInlineWorkspace uiEditWS = (UIEditInlineWorkspace)uiWorkingWS.getChild(UIEditInlineWorkspace.class);
            uiEditWS.getComposer().setEditted(false);
            uiEditWS.setRendered(false);
            uiWorkingWS.setRenderedChild("UIViewWS");
            UISiteBody siteBody = (UISiteBody)uiWorkingWS.findFirstComponentOfType(UISiteBody.class);
            UIPortal uiPortal = uiWorkingWS.getBackupUIPortal();
            siteBody.setUIComponent((UIComponent)uiPortal);
            UserNode currentNode = uiPortal.getSelectedUserNode();
            SiteKey siteKey = currentNode.getNavigation().getKey();
            PageNodeEvent<UIPortalApplication> pnevent = new PageNodeEvent<UIPortalApplication>(uiPortalApp, "ChangeNode", siteKey, currentNode.getURI());
            uiPortalApp.broadcast(pnevent, Event.Phase.PROCESS);
            prContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
            JavascriptManager jsManager = prContext.getJavascriptManager();
            jsManager.addJavascript((CharSequence)"eXo.portal.portalMode=0;");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewSitePropertiesActionListener
    extends EventListener<UIPortalComposer> {
        public void execute(Event<UIPortalComposer> event) throws Exception {
            UIComponent temp = null;
            UIPortal uiPortal = null;
            String portalOwner = null;
            UIEditInlineWorkspace uiEditWS = (UIEditInlineWorkspace)((UIPortalComposer)((Object)event.getSource())).getAncestorOfType(UIEditInlineWorkspace.class);
            temp = uiEditWS.getUIComponent();
            if (temp != null && temp instanceof UIPortal) {
                uiPortal = (UIPortal)temp;
                portalOwner = uiPortal.getSiteType().equals((Object)SiteType.PORTAL) ? uiPortal.getName() : Util.getPortalRequestContext().getPortalOwner();
            } else {
                uiPortal = Util.getUIPortal();
                portalOwner = Util.getPortalRequestContext().getPortalOwner();
            }
            UIPortalApplication uiApp = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            UIPortalForm portalForm = uiMaskWS.createUIComponent(UIPortalForm.class, null, "UIPortalForm");
            portalForm.setPortalOwner(portalOwner);
            portalForm.setBindingBean();
            if (SiteType.USER.equals((Object)uiPortal.getSiteType())) {
                portalForm.removeChildById("PermissionSetting");
            }
            uiMaskWS.setWindowSize(700, -1);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
        }
    }
}

