/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.render.confluence;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.wiki.rendering.render.confluence.ConfluenceSyntaxEscapeWikiPrinter;
import org.exoplatform.wiki.rendering.render.confluence.ConfluenceSyntaxImageRenderer;
import org.exoplatform.wiki.rendering.render.confluence.ConfluenceSyntaxLinkRenderer;
import org.exoplatform.wiki.rendering.render.confluence.ConfluenceSyntaxListenerChain;
import org.exoplatform.wiki.rendering.render.confluence.ConfluenceSyntaxMacroRenderer;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.listener.HeaderLevel;
import org.xwiki.rendering.listener.ListType;
import org.xwiki.rendering.listener.chaining.BlockStateChainingListener;
import org.xwiki.rendering.listener.chaining.ListenerChain;
import org.xwiki.rendering.listener.chaining.StackableChainingListener;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.renderer.AbstractChainingPrintRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.VoidWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.renderer.reference.ResourceReferenceSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfluenceSyntaxChainingRenderer
extends AbstractChainingPrintRenderer
implements StackableChainingListener {
    private ConfluenceSyntaxLinkRenderer linkRenderer;
    private ConfluenceSyntaxImageRenderer imageRenderer;
    private ConfluenceSyntaxMacroRenderer macroPrinter;
    private ResourceReferenceSerializer linkReferenceSerializer;
    private boolean isFirstElementRendered = false;
    private StringBuffer listStyle = new StringBuffer();
    private Map<String, String> previousFormatParameters;

    public ConfluenceSyntaxChainingRenderer(ListenerChain listenerChain, ResourceReferenceSerializer linkReferenceSerializer) {
        this.setListenerChain(listenerChain);
        this.linkReferenceSerializer = linkReferenceSerializer;
        this.linkRenderer = new ConfluenceSyntaxLinkRenderer(this.getConfluenceSyntaxListenerChain(), linkReferenceSerializer);
        this.imageRenderer = new ConfluenceSyntaxImageRenderer();
        this.macroPrinter = new ConfluenceSyntaxMacroRenderer();
    }

    private BlockStateChainingListener getBlockState() {
        return this.getConfluenceSyntaxListenerChain().getBlockStateChainingListener();
    }

    public StackableChainingListener createChainingListenerInstance() {
        ConfluenceSyntaxChainingRenderer renderer = new ConfluenceSyntaxChainingRenderer(this.getListenerChain(), this.linkReferenceSerializer);
        renderer.setPrinter(this.getPrinter());
        return renderer;
    }

    private ConfluenceSyntaxListenerChain getConfluenceSyntaxListenerChain() {
        return (ConfluenceSyntaxListenerChain)this.getListenerChain();
    }

    private ConfluenceSyntaxLinkRenderer getLinkRenderer() {
        return this.linkRenderer;
    }

    private ConfluenceSyntaxImageRenderer getImageRenderer() {
        return this.imageRenderer;
    }

    private ConfluenceSyntaxMacroRenderer getMacroPrinter() {
        return this.macroPrinter;
    }

    public void beginGroup(Map<String, String> parameters) {
        if (!this.getBlockState().isInLine()) {
            this.printEmptyLine();
        }
        if (parameters.size() > 0) {
            this.printParameters(parameters, true);
        }
        this.print("{group}");
        this.getListenerChain().pushAllStackableListeners();
    }

    public void endDocument(Map<String, String> parameters) {
        this.getConfluencePrinter().flush();
    }

    public void endGroup(Map<String, String> parameters) {
        this.print("{group}");
        this.getListenerChain().popAllStackableListeners();
    }

    public void beginLink(ResourceReference link, boolean isFreeStandingURI, Map<String, String> parameters) {
        this.getConfluencePrinter().setBeforeLink(true);
        if (this.getLinkRenderer().forceFullSyntax(this.getConfluencePrinter(), isFreeStandingURI, parameters) && this.getConfluencePrinter().getBuffer().length() > 0 && this.getConfluencePrinter().getBuffer().charAt(this.getConfluencePrinter().getBuffer().length() - 1) == '[') {
            this.getConfluencePrinter().setEscapeLastChar(true);
        }
        this.getConfluencePrinter().flush();
        this.getConfluencePrinter().setBeforeLink(false);
        int linkDepth = this.getBlockState().getLinkDepth();
        if (linkDepth < 2) {
            this.getLinkRenderer().beginRenderLink(this.getConfluencePrinter(), link, isFreeStandingURI, parameters);
            ConfluenceSyntaxEscapeWikiPrinter linkLabelPrinter = new ConfluenceSyntaxEscapeWikiPrinter((WikiPrinter)new DefaultWikiPrinter(), this.getConfluenceSyntaxListenerChain());
            linkLabelPrinter.setOnNewLine(this.getConfluencePrinter().isOnNewLine());
            this.pushPrinter((WikiPrinter)linkLabelPrinter);
        } else if (isFreeStandingURI) {
            this.print(this.getLinkRenderer().serialize(link));
        }
    }

    public void endLink(ResourceReference link, boolean isFreeStandingURI, Map<String, String> parameters) {
        if (this.getBlockState().getLinkDepth() == 1) {
            ConfluenceSyntaxEscapeWikiPrinter linkBlocksPrinter = this.getConfluencePrinter();
            linkBlocksPrinter.flush();
            String content = linkBlocksPrinter.toString();
            this.popPrinter();
            this.getLinkRenderer().renderLinkContent(this.getConfluencePrinter(), content);
            this.getLinkRenderer().endRenderLink(this.getConfluencePrinter(), link, isFreeStandingURI, parameters);
        }
    }

    public void beginFormat(Format format, Map<String, String> parameters) {
        if (this.previousFormatParameters != null) {
            if (!parameters.isEmpty()) {
                if (!((Object)this.previousFormatParameters).equals(parameters)) {
                    this.previousFormatParameters = null;
                    this.printParameters(parameters, false);
                } else {
                    this.previousFormatParameters = null;
                }
            }
        } else if (this.previousFormatParameters == null) {
            this.printParameters(parameters, false);
        }
        switch (format) {
            case BOLD: {
                if (this.previousFormatParameters != null) {
                    this.getPrinter().print("(%%)");
                    this.previousFormatParameters = null;
                }
                this.getConfluencePrinter().printBeginBold();
                break;
            }
            case ITALIC: {
                if (this.previousFormatParameters != null) {
                    this.getPrinter().print("(%%)");
                    this.previousFormatParameters = null;
                }
                this.getConfluencePrinter().printBeginItalic();
                break;
            }
            case STRIKEDOUT: {
                this.print("-");
                break;
            }
            case UNDERLINED: {
                this.print("+");
                break;
            }
            case SUPERSCRIPT: {
                this.print("^");
                break;
            }
            case SUBSCRIPT: {
                this.print("~");
                break;
            }
            case MONOSPACE: {
                this.print("{{");
            }
        }
    }

    public void endFormat(Format format, Map<String, String> parameters) {
        switch (format) {
            case BOLD: {
                this.print("*");
                break;
            }
            case ITALIC: {
                this.getConfluencePrinter().printEndItalic();
                break;
            }
            case STRIKEDOUT: {
                this.print("-");
                break;
            }
            case UNDERLINED: {
                this.print("+");
                break;
            }
            case SUPERSCRIPT: {
                this.print("^");
                break;
            }
            case SUBSCRIPT: {
                this.print("~");
                break;
            }
            case MONOSPACE: {
                this.print("}}");
            }
        }
        StringBuffer parametersStr = new StringBuffer();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String value = entry.getValue();
            String key = entry.getKey();
            if (key == null || value == null || !"style".equals(key)) continue;
            parametersStr.append("{span}");
        }
        this.print(parametersStr.toString());
        if (!parameters.isEmpty()) {
            this.previousFormatParameters = parameters;
        }
    }

    public void beginParagraph(Map<String, String> parameters) {
        this.printEmptyLine();
        this.printParameters(parameters);
    }

    public void endParagraph(Map<String, String> parameters) {
        this.previousFormatParameters = null;
        StringBuffer parametersStr = new StringBuffer();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String value = entry.getValue();
            String key = entry.getKey();
            if (key == null || value == null || !"style".equals(key)) continue;
            parametersStr.append("{div}");
        }
        this.print(parametersStr.toString());
        this.getConfluencePrinter().flush();
    }

    public void onNewLine() {
        if (this.getBlockState().isInLine()) {
            if (this.getBlockState().isInTableCell()) {
                this.print("\\\\");
            } else if (this.getConfluenceSyntaxListenerChain().getConsecutiveNewLineStateChainingListener().getNewLineCount() > 1) {
                this.print("\\\\");
            } else if (this.getConfluenceSyntaxListenerChain().getLookaheadChainingListener().getNextEvent().eventType.isInlineEnd()) {
                this.print("\\\\");
            } else {
                this.print("\n");
            }
        } else {
            this.print("\n");
        }
    }

    public void onMacro(String id, Map<String, String> parameters, String content, boolean isInline) {
        if (!isInline) {
            this.printEmptyLine();
            this.print(this.getMacroPrinter().renderMacro(id, parameters, content, isInline));
        } else {
            this.getConfluencePrinter().printInlineMacro(this.getMacroPrinter().renderMacro(id, parameters, content, isInline));
        }
    }

    public void beginHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        this.printEmptyLine();
        this.printParameters(parameters);
        this.print("h" + level.getAsInt() + ". ");
    }

    public void endHeader(HeaderLevel level, String id, Map<String, String> parameters) {
    }

    public void onWord(String word) {
        this.printDelayed(word);
    }

    public void onSpace() {
        this.printDelayed(" ");
    }

    public void onSpecialSymbol(char symbol) {
        this.printDelayed("" + symbol);
    }

    public void beginList(ListType listType, Map<String, String> parameters) {
        if (this.getBlockState().getListDepth() == 1) {
            this.printEmptyLine();
        } else {
            this.getPrinter().print("\n");
        }
        if (listType == ListType.BULLETED) {
            this.listStyle.append("*");
        } else {
            this.listStyle.append("#");
        }
        this.printParameters(parameters);
    }

    public void beginListItem() {
        if (this.getBlockState().getListItemIndex() > 0) {
            this.getPrinter().print("\n");
        }
        this.print(this.listStyle.toString());
        if (StringUtils.contains((String)this.listStyle.toString(), (char)'#')) {
            // empty if block
        }
        this.print(" ");
    }

    public void endList(ListType listType, Map<String, String> parameters) {
        this.listStyle.setLength(this.listStyle.length() - 1);
        this.getConfluencePrinter().flush();
    }

    public void endListItem() {
        this.previousFormatParameters = null;
    }

    public void beginMacroMarker(String name, Map<String, String> parameters, String content, boolean isInline) {
        if (!isInline) {
            this.printEmptyLine();
        }
        this.pushPrinter((WikiPrinter)new ConfluenceSyntaxEscapeWikiPrinter((WikiPrinter)VoidWikiPrinter.VOIDWIKIPRINTER, this.getConfluenceSyntaxListenerChain()));
    }

    public void endMacroMarker(String name, Map<String, String> parameters, String content, boolean isInline) {
        this.previousFormatParameters = null;
        this.popPrinter();
        this.print(this.getMacroPrinter().renderMacro(name, parameters, content, isInline));
    }

    public void onId(String name) {
        this.print("{{id name=\"" + name + "\"}}");
    }

    public void onHorizontalLine(Map<String, String> parameters) {
        this.printEmptyLine();
        this.printParameters(parameters);
        this.print("----");
    }

    public void onVerbatim(String protectedString, boolean isInline, Map<String, String> parameters) {
        if (!isInline) {
            this.printEmptyLine();
        }
        this.printParameters(parameters);
        this.print("{{{");
        this.getConfluencePrinter().printVerbatimContent(protectedString);
        this.print("}}}");
    }

    public void onEmptyLines(int count) {
        this.print(StringUtils.repeat((String)"\n", (int)count));
    }

    public void beginDefinitionList(Map<String, String> parameters) {
        if (this.getBlockState().getDefinitionListDepth() == 1 && !this.getBlockState().isInList()) {
            this.printEmptyLine();
        } else {
            this.print("\n");
        }
        this.printParameters(parameters);
    }

    public void beginDefinitionTerm() {
        if (this.getBlockState().getDefinitionListItemIndex() > 0) {
            this.getPrinter().print("\n");
        }
        if (this.listStyle.length() > 0) {
            this.print(this.listStyle.toString());
            if (this.listStyle.charAt(0) == '#') {
                // empty if block
            }
        }
        this.print(StringUtils.repeat((String)":", (int)(this.getBlockState().getDefinitionListDepth() - 1)));
        this.print("; ");
    }

    public void beginDefinitionDescription() {
        if (this.getBlockState().getDefinitionListItemIndex() > 0) {
            this.getPrinter().print("\n");
        }
        if (this.listStyle.length() > 0) {
            this.print(this.listStyle.toString());
            if (this.listStyle.charAt(0) == '#') {
                // empty if block
            }
        }
        this.print(StringUtils.repeat((String)":", (int)(this.getBlockState().getDefinitionListDepth() - 1)));
        this.print(": ");
    }

    public void endDefinitionDescription() {
        this.previousFormatParameters = null;
        this.getConfluencePrinter().flush();
    }

    public void endDefinitionTerm() {
        this.previousFormatParameters = null;
        this.getConfluencePrinter().flush();
    }

    public void beginQuotation(Map<String, String> parameters) {
        if (!this.getBlockState().isInQuotationLine()) {
            this.printEmptyLine();
        }
        if (!parameters.isEmpty()) {
            this.printParameters(parameters);
        }
    }

    public void beginQuotationLine() {
        if (this.getBlockState().getQuotationLineIndex() > 0) {
            this.getPrinter().print("\n");
        }
        this.print("bq. ");
    }

    public void endQuotationLine() {
        this.previousFormatParameters = null;
        this.getConfluencePrinter().flush();
    }

    public void beginTable(Map<String, String> parameters) {
        this.printEmptyLine();
        if (!parameters.isEmpty()) {
            this.printParameters(parameters);
        }
    }

    public void beginTableCell(Map<String, String> parameters) {
        this.print("|");
        this.printParameters(parameters, false);
    }

    public void beginTableHeadCell(Map<String, String> parameters) {
        this.print("||");
        this.printParameters(parameters, false);
    }

    public void beginTableRow(Map<String, String> parameters) {
        if (this.getBlockState().getCellRow() > 0) {
            this.print("\n");
        }
        this.printParameters(parameters, false);
    }

    public void endTableCell(Map<String, String> parameters) {
        this.previousFormatParameters = null;
        this.getConfluencePrinter().flush();
    }

    public void endTableHeadCell(Map<String, String> parameters) {
        this.previousFormatParameters = null;
    }

    public void onImage(ResourceReference image, boolean isFreeStandingURI, Map<String, String> parameters) {
        this.getImageRenderer().beginRenderImage(this.getConfluencePrinter());
        this.getImageRenderer().renderImageContent(this.getConfluencePrinter(), this.getImageRenderer().renderImage(image));
        this.getImageRenderer().endRenderImage(this.getConfluencePrinter(), parameters);
    }

    protected void printParameters(Map<String, String> parameters) {
        this.printParameters(parameters, true);
    }

    protected void printParameters(Map<String, String> parameters, boolean newLine) {
        StringBuffer parametersStr = new StringBuffer();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String value = entry.getValue();
            String key = entry.getKey();
            if (key == null || value == null || !"style".equals(key)) continue;
            if (!newLine) {
                parametersStr.append("{span:").append("style=\"").append(value).append("\"}");
                continue;
            }
            parametersStr.append("{div:").append("style=\"").append(value).append("\"}");
        }
        this.print(parametersStr.toString());
    }

    private void printDelayed(String text) {
        this.print(text, true);
    }

    private void print(String text) {
        this.print(text, false);
    }

    private void print(String text, boolean isDelayed) {
        if (this.previousFormatParameters != null) {
            this.previousFormatParameters = null;
        }
        if (isDelayed) {
            this.getConfluencePrinter().printDelayed(text);
        } else {
            this.getPrinter().print(text);
        }
    }

    private void printEmptyLine() {
        if (this.isFirstElementRendered) {
            this.print("\n\n");
        } else {
            this.isFirstElementRendered = true;
        }
    }

    public void setPrinter(WikiPrinter printer) {
        if (printer instanceof ConfluenceSyntaxEscapeWikiPrinter) {
            super.setPrinter(printer);
        } else {
            super.setPrinter((WikiPrinter)new ConfluenceSyntaxEscapeWikiPrinter(printer, (ConfluenceSyntaxListenerChain)this.getListenerChain()));
        }
    }

    public ConfluenceSyntaxEscapeWikiPrinter getConfluencePrinter() {
        return (ConfluenceSyntaxEscapeWikiPrinter)super.getPrinter();
    }

    protected void popPrinter() {
        this.getConfluencePrinter().flush();
        super.popPrinter();
    }
}

