/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.annotation.XmlRootElement;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.storage.ActivityStorageException;
import org.exoplatform.social.service.rest.Like;
import org.exoplatform.social.service.rest.RestChecker;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.social.service.rest.api.models.ActivityRestOut;
import org.exoplatform.social.service.rest.api.models.ActivityStreamRestOut;
import org.exoplatform.social.service.rest.api.models.CommentRestOut;
import org.exoplatform.social.service.rest.api.models.IdentityRestOut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="{portalName}/social/activities")
public class ActivitiesRestService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(ActivitiesRestService.class);
    private ActivityManager _activityManager;
    private IdentityManager _identityManager;
    private String portalName_;

    private ExoSocialActivity destroyActivity(String activityId) {
        this._activityManager = this.getActivityManager();
        ExoSocialActivity activity = null;
        try {
            activity = this._activityManager.getActivity(activityId);
        }
        catch (ActivityStorageException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (activity == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        try {
            this._activityManager.deleteActivity(activityId);
        }
        catch (Exception ex) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        return activity;
    }

    @POST
    @Path(value="destroy/{activityId}.{format}")
    public Response destroyActivity(@Context UriInfo uriInfo, @PathParam(value="portalName") String portalName, @PathParam(value="activityId") String activityId, @PathParam(value="format") String format) throws Exception {
        MediaType mediaType = Util.getMediaType(format);
        this.portalName_ = portalName;
        ExoSocialActivity activity = this.destroyActivity(activityId);
        return Util.getResponse(activity, uriInfo, mediaType, Response.Status.OK);
    }

    private LikeList showLikes(String activityId) {
        LikeList likeList = new LikeList();
        likeList.setActivityId(activityId);
        this._activityManager = this.getActivityManager();
        ExoSocialActivity activity = null;
        try {
            activity = this._activityManager.getActivity(activityId);
        }
        catch (ActivityStorageException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (activity == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        String[] identityIds = activity.getLikeIdentityIds();
        if (identityIds == null) {
            likeList.setLikes(new ArrayList<Like>());
        } else {
            likeList.setLikes(this.getLikes(identityIds));
        }
        return likeList;
    }

    private LikeList updateLike(String activityId, Like like) throws Exception {
        LikeList likeList = new LikeList();
        likeList.setActivityId(activityId);
        this._activityManager = this.getActivityManager();
        ExoSocialActivity activity = this._activityManager.getActivity(activityId);
        if (activity == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        String[] identityIds = activity.getLikeIdentityIds();
        String identityId = like.getIdentityId();
        boolean alreadyLiked = false;
        if (identityId == null) {
            throw new WebApplicationException(Response.Status.NOT_ACCEPTABLE);
        }
        if (identityIds != null) {
            for (String id : identityIds) {
                if (!id.equals(identityId)) continue;
                alreadyLiked = true;
            }
        }
        if (!alreadyLiked) {
            identityIds = this.addItemToArray(identityIds, identityId);
            activity.setLikeIdentityIds(identityIds);
            try {
                Identity user = this.getIdentityManager().getIdentity(activity.getUserId());
                this._activityManager.saveActivity(user, activity);
            }
            catch (Exception ex) {
                throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
            }
        }
        likeList.setLikes(this.getLikes(identityIds));
        return likeList;
    }

    private LikeList destroyLike(String activityId, String identityId) {
        LikeList likeList = new LikeList();
        likeList.setActivityId(activityId);
        this._activityManager = this.getActivityManager();
        ExoSocialActivity activity = null;
        try {
            activity = this._activityManager.getActivity(activityId);
        }
        catch (ActivityStorageException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (activity == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        String[] identityIds = activity.getLikeIdentityIds();
        if (identityIds.length == 0) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        boolean alreadyLiked = true;
        for (String id : identityIds) {
            if (!id.equals(identityId)) continue;
            if ((identityIds = this.removeItemFromArray(identityIds, identityId)) == null) {
                identityIds = new String[]{};
            }
            activity.setLikeIdentityIds(identityIds);
            try {
                Identity user = this.getIdentityManager().getIdentity(activity.getUserId());
                this._activityManager.saveActivity(user, activity);
            }
            catch (Exception ex) {
                throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
            }
            alreadyLiked = false;
        }
        if (alreadyLiked) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (identityIds == null) {
            likeList.setLikes(new ArrayList<Like>());
        } else {
            likeList.setLikes(this.getLikes(identityIds));
        }
        return likeList;
    }

    @GET
    @Path(value="{activityId}/likes/show.{format}")
    public Response showLikes(@Context UriInfo uriInfo, @PathParam(value="portalName") String portalName, @PathParam(value="activityId") String activityId, @PathParam(value="format") String format) throws Exception {
        MediaType mediaType = Util.getMediaType(format);
        this.portalName_ = portalName;
        LikeList likeList = null;
        likeList = this.showLikes(activityId);
        return Util.getResponse(likeList, uriInfo, mediaType, Response.Status.OK);
    }

    @POST
    @Path(value="{activityId}/likes/update.{format}")
    @Consumes(value={"application/json", "application/xml"})
    public Response updateLike(@Context UriInfo uriInfo, @PathParam(value="portalName") String portalName, @PathParam(value="activityId") String activityId, @PathParam(value="format") String format, Like like) throws Exception {
        MediaType mediaType = Util.getMediaType(format);
        this.portalName_ = portalName;
        LikeList likeList = null;
        likeList = this.updateLike(activityId, like);
        return Util.getResponse(likeList, uriInfo, mediaType, Response.Status.OK);
    }

    @POST
    @Path(value="{activityId}/likes/destroy/{identityId}.{format}")
    public Response destroyLike(@Context UriInfo uriInfo, @PathParam(value="portalName") String portalName, @PathParam(value="activityId") String activityId, @PathParam(value="identityId") String identityId, @PathParam(value="format") String format) throws Exception {
        MediaType mediaType = Util.getMediaType(format);
        this.portalName_ = portalName;
        LikeList likeList = null;
        likeList = this.destroyLike(activityId, identityId);
        return Util.getResponse(likeList, uriInfo, mediaType, Response.Status.OK);
    }

    private CommentList showComments(String activityId) {
        CommentList commentList = new CommentList();
        commentList.setActivityId(activityId);
        this._activityManager = this.getActivityManager();
        ExoSocialActivity activity = null;
        try {
            activity = this._activityManager.getActivity(activityId);
            if (activity == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            String[] commentIds = activity.getReplyToId();
            if (commentIds == null) {
                commentList.setComments(new ArrayList<ExoSocialActivity>());
            } else {
                for (String commentId : commentIds) {
                    if (commentId.length() <= 0) continue;
                    commentList.addComment(this._activityManager.getActivity(commentId));
                }
            }
        }
        catch (ActivityStorageException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return commentList;
    }

    private CommentList updateComment(String activityId, ExoSocialActivity comment, UriInfo uriInfo, String portalName) {
        CommentList commentList = new CommentList();
        commentList.setActivityId(activityId);
        ExoSocialActivity activity = null;
        try {
            activity = this._activityManager.getActivity(activityId);
        }
        catch (ActivityStorageException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (activity == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        this._activityManager = this.getActivityManager();
        ConversationState state = ConversationState.getCurrent();
        String userId = null;
        if (state != null) {
            userId = state.getIdentity().getUserId();
        } else {
            try {
                userId = Util.getViewerId(uriInfo);
            }
            catch (Exception e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        Identity identity = null;
        try {
            identity = this.getIdentityManager(portalName).getOrCreateIdentity("organization", userId);
        }
        catch (Exception e1) {
            LOG.warn((Object)e1.getMessage(), (Throwable)e1);
        }
        if (identity == null) {
            identity = this.getIdentityManager(portalName).getOrCreateIdentity("organization", Util.getViewerId(uriInfo), false);
        }
        if (comment.getUserId() == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        comment.setUserId(identity.getId());
        try {
            this._activityManager.saveComment(activity, comment);
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        commentList.addComment(comment);
        return commentList;
    }

    private IdentityManager getIdentityManager(String portalName) {
        if (this._identityManager == null) {
            PortalContainer portalContainer = (PortalContainer)ExoContainerContext.getContainerByName((String)portalName);
            this._identityManager = (IdentityManager)portalContainer.getComponentInstanceOfType(IdentityManager.class);
        }
        return this._identityManager;
    }

    private CommentList destroyComment(String activityId, String commentId) {
        CommentList commentList = new CommentList();
        commentList.setActivityId(activityId);
        this._activityManager = this.getActivityManager();
        ExoSocialActivity activity = null;
        try {
            activity = this._activityManager.getActivity(activityId);
            ExoSocialActivity comment = this._activityManager.getActivity(commentId);
            if (activity == null || comment == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            commentList.addComment(comment);
            this._activityManager.deleteComment(activityId, commentId);
        }
        catch (ActivityStorageException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return commentList;
    }

    @GET
    @Path(value="{activityId}/comments/show.{format}")
    public Response showComments(@Context UriInfo uriInfo, @PathParam(value="portalName") String portalName, @PathParam(value="activityId") String activityId, @PathParam(value="format") String format) throws Exception {
        MediaType mediaType = Util.getMediaType(format);
        this.portalName_ = portalName;
        CommentList commentList = null;
        commentList = this.showComments(activityId);
        return Util.getResponse(commentList, uriInfo, mediaType, Response.Status.OK);
    }

    @GET
    @Path(value="{activityId}/comments.{format}")
    public Response showComments(@Context UriInfo uriInfo, @PathParam(value="portalName") String portalName, @PathParam(value="activityId") String activityId, @PathParam(value="format") String format, @QueryParam(value="offset") Integer offset, @QueryParam(value="limit") Integer limit) throws Exception {
        PortalContainer portalContainer = RestChecker.checkValidPortalContainerName(portalName);
        MediaType mediaType = RestChecker.checkSupportedFormat(format, new String[]{"json"});
        ActivityManager activityManager = Util.getActivityManager(portalName);
        if (offset == null || limit == null) {
            offset = 0;
            limit = 10;
        }
        if (offset < 0 || limit < 0) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        ExoSocialActivity activity = null;
        try {
            activity = activityManager.getActivity(activityId);
            ArrayList<CommentRestOut> commentWrapers = null;
            RealtimeListAccess comments = activityManager.getCommentsWithListAccess(activity);
            if (offset > comments.getSize()) {
                offset = 0;
                limit = 0;
            } else if (offset + limit > comments.getSize()) {
                limit = comments.getSize() - offset;
            }
            int total = limit;
            ExoSocialActivity[] commentsLimited = (ExoSocialActivity[])comments.load(offset.intValue(), total);
            commentWrapers = new ArrayList<CommentRestOut>(total);
            for (int i = 0; i < total; ++i) {
                CommentRestOut commentRestOut = new CommentRestOut(commentsLimited[i], portalName);
                commentRestOut.setPosterIdentity(commentsLimited[i], portalName);
                commentWrapers.add(commentRestOut);
            }
            HashMap<String, Serializable> resultJson = new HashMap<String, Serializable>();
            resultJson.put("totalNumberOfComments", Integer.valueOf(commentWrapers.size()));
            resultJson.put("comments", commentWrapers);
            return Util.getResponse(resultJson, uriInfo, mediaType, Response.Status.OK);
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            if (undeclaredThrowableException.getCause() instanceof ActivityStorageException) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="{activityId}.{format}")
    public Response getActivityById(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="activityId") String activityId, @PathParam(value="format") String format, @QueryParam(value="poster_identity") String showPosterIdentity, @QueryParam(value="number_of_comments") int numberOfComments, @QueryParam(value="activity_stream") String showActivityStream, @QueryParam(value="number_of_likes") int numberOfLikes) {
        RestChecker.checkAuthenticatedRequest();
        PortalContainer portalContainer = RestChecker.checkValidPortalContainerName(portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat(format, new String[]{"json"});
        Identity authenticatedIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        ActivityManager activityManager = Util.getActivityManager(portalContainerName);
        IdentityManager identityManager = Util.getIdentityManager(portalContainerName);
        ExoSocialActivity activity = null;
        try {
            activity = activityManager.getActivity(activityId);
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            if (undeclaredThrowableException.getCause() instanceof ActivityStorageException) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (activity.isComment()) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        ActivityRestOut model = new ActivityRestOut(activity, portalContainerName);
        model.setNumberOfLikes(numberOfLikes, activity, portalContainerName);
        if (this.isPassed(showPosterIdentity)) {
            model.setPosterIdentity(new IdentityRestOut(identityManager.getIdentity(activity.getUserId(), false)));
        }
        if (this.isPassed(showActivityStream)) {
            model.setActivityStream(new ActivityStreamRestOut(activity.getActivityStream()));
        }
        model.setNumberOfComments(numberOfComments, activity, portalContainerName);
        return Util.getResponse(model, uriInfo, mediaType, Response.Status.OK);
    }

    @POST
    @Path(value="{activityId}/comments/update.{format}")
    @Consumes(value={"application/json", "application/xml"})
    public Response updateComment(@Context UriInfo uriInfo, @PathParam(value="portalName") String portalName, @PathParam(value="activityId") String activityId, @PathParam(value="format") String format, ExoSocialActivityImpl comment) throws Exception {
        MediaType mediaType = Util.getMediaType(format);
        this.portalName_ = portalName;
        CommentList commentList = null;
        commentList = this.updateComment(activityId, (ExoSocialActivity)comment, uriInfo, portalName);
        return Util.getResponse(commentList, uriInfo, mediaType, Response.Status.OK);
    }

    @POST
    @Path(value="{activityId}/comments/destroy/{commentId}.{format}")
    public Response destroyComment(@Context UriInfo uriInfo, @PathParam(value="portalName") String portalName, @PathParam(value="activityId") String activityId, @PathParam(value="commentId") String commentId, @PathParam(value="format") String format) throws Exception {
        MediaType mediaType = Util.getMediaType(format);
        this.portalName_ = portalName;
        CommentList commentList = null;
        commentList = this.destroyComment(activityId, commentId);
        return Util.getResponse(commentList, uriInfo, mediaType, Response.Status.OK);
    }

    private ActivityManager getActivityManager() {
        if (this._activityManager == null) {
            PortalContainer portalContainer = (PortalContainer)ExoContainerContext.getContainerByName((String)this.portalName_);
            if (portalContainer == null) {
                throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
            }
            this._activityManager = (ActivityManager)portalContainer.getComponentInstanceOfType(ActivityManager.class);
        }
        return this._activityManager;
    }

    private IdentityManager getIdentityManager() {
        if (this._identityManager == null) {
            PortalContainer portalContainer = (PortalContainer)ExoContainerContext.getContainerByName((String)this.portalName_);
            if (portalContainer == null) {
                throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
            }
            this._identityManager = (IdentityManager)portalContainer.getComponentInstanceOfType(IdentityManager.class);
        }
        return this._identityManager;
    }

    private List<Like> getLikes(String[] identityIds) {
        ArrayList<Like> likes = new ArrayList<Like>();
        this._identityManager = this.getIdentityManager();
        try {
            for (String identityId : identityIds) {
                Identity identity = this._identityManager.getIdentity(identityId);
                Profile profile = identity.getProfile();
                String username = (String)profile.getProperty("username");
                String fullName = profile.getFullName();
                String thumbnail = profile.getAvatarUrl();
                Like like = new Like();
                like.setIdentityId(identityId);
                like.setUsername(username);
                like.setFullName(fullName);
                like.setThumbnail(thumbnail);
                likes.add(like);
            }
        }
        catch (Exception ex) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        return likes;
    }

    private String[] removeItemFromArray(String[] arrays, String str) {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(arrays));
        list.remove(str);
        if (list.size() > 0) {
            return list.toArray(new String[list.size()]);
        }
        return null;
    }

    private String[] addItemToArray(String[] array, String str) {
        ArrayList<String> list = new ArrayList<String>();
        if (array != null && array.length > 0) {
            list.addAll(Arrays.asList(array));
            list.add(str);
            return list.toArray(new String[list.size()]);
        }
        return new String[]{str};
    }

    private boolean isPassed(String value) {
        return value != null && ("true".equals(value) || "t".equals(value) || "1".equals(value));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @XmlRootElement
    public static class CommentList {
        private String _activityId;
        private List<ExoSocialActivity> _comments;

        public void setActivityId(String activityId) {
            this._activityId = activityId;
        }

        public String getActivityId() {
            return this._activityId;
        }

        public void setComments(List<ExoSocialActivity> comments) {
            this._comments = comments;
        }

        public List<ExoSocialActivity> getComments() {
            return this._comments;
        }

        public void addComment(ExoSocialActivity activity) {
            if (this._comments == null) {
                this._comments = new ArrayList<ExoSocialActivity>();
            }
            this._comments.add(activity);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @XmlRootElement
    public static class LikeList {
        private String _activityId;
        private List<Like> _likes;

        public void setActivityId(String activityId) {
            this._activityId = activityId;
        }

        public String getActivityId() {
            return this._activityId;
        }

        public void setLikes(List<Like> likes) {
            this._likes = likes;
        }

        public List<Like> getLikes() {
            return this._likes;
        }

        public void addLike(Like like) {
            if (this._likes == null) {
                this._likes = new ArrayList<Like>();
            }
            this._likes.add(like);
        }
    }
}

