/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.macro.excerpt;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.wiki.rendering.macro.MacroUtils;
import org.exoplatform.wiki.rendering.macro.excerpt.ExcerptMacroParameters;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.transformation.MacroTransformationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="excerpt")
public class ExcerptMacro
extends AbstractMacro<ExcerptMacroParameters> {
    private static final String DESCRIPTION = "Marks part of the page's content for use by other macros";
    private static final String CONTENT_DESCRIPTION = "Text or macro are allowed";
    public static final String EXCERPT_CLASS = "ExcerptClass";
    public static final String MACRO_ID = "excerpt";
    @Requirement
    private ComponentManager componentManager;

    public ExcerptMacro() {
        super("Excerpt", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(CONTENT_DESCRIPTION), ExcerptMacroParameters.class);
        this.setDefaultCategory("Content");
    }

    public List<Block> execute(ExcerptMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        try {
            boolean isHidden = parameters.isHidden();
            String styleProps = "display: " + (isHidden ? "none" : "block");
            HashMap<String, String> blockParams = new HashMap<String, String>();
            blockParams.put("class", EXCERPT_CLASS);
            blockParams.put("style", styleProps);
            List<Block> contentBlocks = MacroUtils.parseSourceSyntax(this.componentManager, content, context);
            GroupBlock result = new GroupBlock(contentBlocks, blockParams);
            return Collections.singletonList(result);
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public boolean supportsInlineMode() {
        return true;
    }

    public ComponentManager getComponentManager() {
        return this.componentManager;
    }
}

